<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Authentication Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines are used during authentication for various
    | messages that we need to display to the user. You are free to modify
    | these language lines according to your application's requirements.
    |
    */
    /** dashboard */
    'welcome' => 'به داشبورد حضور و غیاب خوش آمدید',
    'total_employees' => 'کل کارمندان',
    'total_departments' => 'کل بخش‌ها',
    'total_holidays' => 'کل تعطیلات',
    'paid_leaves' => 'مرخصی‌های با حقوق',
    'on_leave_today' => 'امروز در مرخصی',
    'pending_leave_requests' => 'درخواست‌های مرخصی معلق',
    'total_check_in_today' => 'کل چک‌این‌های امروز',
    'total_check_out_today' => 'کل چک‌اوت‌های امروز',
    'projects_detail' => 'جزئیات پروژه',
    'total_projects' => 'کل پروژه‌ها',
    'pending_projects' => 'پروژه‌های معلق',
    'on_hold_projects' => 'پروژه‌های در انتظار',
    'in_progress_projects' => 'پروژه‌های در حال پیشرفت',
    'finished_projects' => 'پروژه‌های تمام شده',
    'cancelled_projects' => 'پروژه‌های لغو شده',
    'top_clients' => 'بهترین مشتریان',
    'task_details' => 'جزئیات وظیفه',
    'recent_projects' => 'پروژه‌های اخیر',
    'title' => 'عنوان',
    'date_start' => 'تاریخ شروع',
    'deadline' => 'مهلت',
    'leader' => 'رهبر پروژه',
    'completion' => 'تکمیل',
    'priority' => 'اولویت',
    'check_in_at' => 'ورود در ساعت',
    'check_out_at' => 'خروج در ساعت',
    'punch_in' => 'ورود',
    'punch_out' => 'خروج',
    'no_records_found' => 'هیچ رکوردی یافت نشد!',
    'project_management' => 'مدیریت پروژه',
    'view_all_clients' => 'مشاهده همه مشتریان',
    'view_all_projects' => 'مشاهده همه پروژه‌ها',
    'error_message' => 'خطا: درخواست قابل پردازش نیست.',
    'success_message' => 'موفقیت: عملیات با موفقیت انجام شد.',
    'name' => 'نام',
    'email' => 'ایمیل',
    'contact' => 'تماس',
    'project' => 'پروژه',
    'pending' => 'معلق',
    'on_hold' => 'در انتظار',
    'in_progress' => 'در حال انجام',
    'completed' => 'تکمیل شده',
    'cancelled' => 'لغو شده',
    'search_menu' => 'منوی جستجو',


    /** nav */
    'latest_notifications' => 'جدیدترین اعلان‌ها',
    'view_all' => 'مشاهده همه',
    'profile' => 'پروفایل',
    'edit_profile' => 'ویرایش پروفایل',
    'request_leave' => 'درخواست مرخصی',
    'log_out' => 'خروج',
    'light_mode' => 'حالت روشن',
    'dark_mode' => 'حالت تاریک',


    /** menu */
    'dashboard' => 'داشبورد',
    'company_management' => 'مدیریت شرکت',
    'company' => 'شرکت',
    'branch' => 'شعبه',
    'department' => 'بخش',
    'post' => 'پست',
    'employee_management' => 'مدیریت کارمندان',
    'employees' => 'کارمندان',
    'logout_requests' => 'درخواست‌های خروج',
    'attendance_section' => 'بخش حضور و غیاب',
    'clients' => 'مشتریان',
    'task_management' => 'مدیریت وظیفه',
    'holidays' => 'تعطیلات',
    'notice' => 'اطلاعیه',
    'payroll_management' => 'مدیریت حقوق و دستمزد',
    'payroll' => 'حقوق و دستمزد',
    'payroll_setting' => 'تنظیمات حقوق و دستمزد',
    'advance_salary' => 'حقوق پیشرفته',
    'employee_salary' => 'حقوق کارمند',
    'leave' => 'مرخصی',
    'team_meeting' => 'جلسه تیم',
    'tada' => 'تادا',
    'shift_management' => 'مدیریت شیفت',
    'office_time' => 'زمان دفتر',
    'award_management' => 'مدیریت جوایز',
    'award_types' => 'انواع جوایز',
    'awards' => 'جوایز',
    'asset_management' => 'مدیریت دارایی',
    'asset_types' => 'انواع دارایی',
    'assets' => 'دارایی‌ها',
    'content_management' => 'مدیریت محتوا',
    'support' => 'پشتیبانی',
    'attendance_methods' => 'روش‌های حضور و غیاب',
    'routers' => 'روترها',
    'qr' => 'کیو آر',
    'nfc' => 'ان اف سی',
    'settings' => 'تنظیمات',
    'roles_permissions' => 'نقش‌ها و مجوزها',
    'general_settings' => 'تنظیمات عمومی',
    'app_settings' => 'تنظیمات اپلیکیشن',
    'notifications' => 'اعلان‌ها',
    'payment_currency' => 'واحد پول پرداخت',
    'feature_control' => 'کنترل ویژگی‌ها',
    'salary_component' => 'جزء حقوق',
    'salary_group' => 'گروه حقوق',
    'salary_tds' => 'مالیات بر درآمد حقوق',
    'overtime' => 'اضافه کاری',
    'undertime' => 'کاهش کار',
    'payment_method' => 'روش پرداخت',
    'leave_types' => 'انواع مرخصی',
    'leave_request' => 'درخواست مرخصی',
    'time_leave_request' => 'درخواست مرخصی زمانی',

    /** company */
    'company_profile' => 'پروفایل شرکت',
    'update_company' => 'بروزرسانی شرکت',
    'create_company' => 'ایجاد شرکت',
    'company_name' => 'نام شرکت',
    'company_owner' => 'مالک شرکت',
    'address' => 'آدرس',
    'email_address' => 'آدرس ایمیل',
    'phone_no' => 'شماره تلفن',
    'website_url' => 'آدرس وب سایت',
    'check_office_off_days' => 'بررسی روزهای تعطیل دفتر',
    'upload_logo' => 'بارگذاری لوگو',
    'update' => 'بروزرسانی',
    'save' => 'ذخیره',

    /** Branch */
    'title_branch' => 'شاخه',
    'branch_section' => 'بخش شاخه',
    'branches' => 'شاخه‌ها',
    'add_branch' => 'افزودن شاخه',
    'branch_lists' => 'لیست شاخه‌ها',
    'search_by_branch_name' => 'جستجو بر اساس نام شاخه',
    'filter' => 'فیلتر',
    'reset' => 'بازنشانی',
    'phone' => 'تلفن',
    'total_employee' => 'کل کارمندان',
    'action' => 'عملیات',
    'are_you_sure_change_status' => 'آیا مطمئن هستید که می‌خواهید وضعیت را تغییر دهید؟',
    'are_you_sure_delete_branch' => 'آیا مطمئن هستید که می‌خواهید شاخه را حذف کنید؟',
    'branch_create' => 'ایجاد شاخه',
    'branch_update' => 'بروزرسانی شاخه',
    'branch_name' => 'نام شعبه',
    'required_field' => 'فیلد الزامی',
    'branch_head' => 'رئیس شعبه',
    'select_branch_head' => 'انتخاب رئیس شعبه',
    'phone_number' => 'شماره تلفن',
    'branch_location_latitude' => 'عرض جغرافیایی مکان شعبه',
    'enter_branch_location_latitude' => 'عرض جغرافیایی مکان شعبه را وارد کنید',
    'branch_location_longitude' => 'طول جغرافیایی مکان شعبه',
    'enter_branch_location_longitude' => 'طول جغرافیایی مکان شعبه را وارد کنید',
    'status' => 'وضعیت',
    'select_status' => 'انتخاب وضعیت',
    'active' => 'فعال',
    'inactive' => 'غیرفعال',
    'create' => 'ایجاد',

    /** Department */
    'department_section' => 'بخش بخش',
    'departments' => 'بخش‌ها',
    'add_department' => 'افزودن بخش',
    'department_lists' => 'لیست بخش‌ها',
    'search_by_department_name' => 'جستجو بر اساس نام بخش',
    'select_branch' => 'انتخاب شعبه',
    'edit' => 'ویرایش',
    'delete' => 'حذف',
    'are_you_sure_delete_department' => 'آیا مطمئن هستید که می‌خواهید این بخش را حذف کنید؟',
    'edit_department' => 'ویرایش دپارتمان',
    'button_back' => 'بازگشت',
    'breadcrumb' => 'ناوبری',
    'update_department' => 'به روزرسانی دپارتمان',
    'create_department' => 'ایجاد دپارتمان',
    'department_name' => 'نام دپارتمان',
    'department_head' => 'سرپرست دپارتمان',
    'select_department_head' => 'انتخاب سرپرست دپارتمان',
    'create_update_department' => 'ایجاد/بروزرسانی دپارتمان',

    /** Post */
    'post_section' => 'بخش پست‌ها',
    'posts' => 'پست‌ها',
    'add_post' => 'افزودن پست',
    'search_by_department' => 'جستجو بر اساس دپارتمان',
    'search_by_post_name' => 'جستجو بر اساس نام پست',
    'post_name' => 'نام پست',
    'post_empty' => 'پست خالی است',
    'edit_post_title' => 'ویرایش پست',
    'create_post_title' => 'ایجاد پست',
    'department_label' => 'بخش',
    'post_name_label' => 'نام پست',
    'status_label' => 'وضعیت',
    'select_department' => 'انتخاب بخش',
    'active_option' => 'فعال',
    'inactive_option' => 'غیرفعال',
    'update_post_button' => 'به‌روزرسانی پست',
    'change_status_confirmation' => 'آیا از تغییر وضعیت مطمئن هستید؟',
    'delete_post_confirmation' => 'آیا از حذف پست مطمئن هستید؟',
    'employee_list_title' => 'لیست کارمندان',

    /** employees */
    'employees_title' => 'کارمندان',
    'employees_action' => 'لیست‌ها',
    'add_employee' => 'افزودن کارمند',
    'employee_section' => 'بخش کارمندان',
    'employee_create' => 'ایجاد کارمند',
    'employee_name' => 'نام کارمند',
    'employee_email' => 'ایمیل کارمند',
    'employee_phone' => 'شماره تلفن کارمند',
    'full_name' => 'نام کامل',
    'designation' => 'سمت',
    'role' => 'نقش',
    'shift' => 'شیفت',
    'workplace' => 'محل کار',
    'is_active' => 'فعال است',
    'edit_detail' => 'ویرایش جزئیات',
    'delete_user' => 'حذف کاربر',
    'change_password' => 'تغییر رمز عبور',
    'force_logout' => 'خروج اجباری',
    'all_fields_required' => 'تمامی (<span style="color: red">*</span>) فیلدها الزامی هستند',
    'personal_detail' => 'جزئیات شخصی',
    'employee_code' => 'کد کارمند',
    'enter_name'=>'نام را وارد کنید',
    'enter_employee_address'=>'آدرس کارمند را وارد کنید',
    'enter_email'=>'ایمیل را وارد کنید',
    'dob' => 'تاریخ تولد',
    'gender' => 'جنسیت',
    'select_gender' => 'انتخاب جنسیت',
    'marital_status' => 'وضعیت تاهل',
    'choose_marital_status' => 'انتخاب وضعیت تاهل',
    'upload_avatar' => 'بارگذاری آواتار',
    'description' => 'توضیحات',
    'username' => 'نام کاربری',
    'enter_username' => 'نام کاربری را وارد کنید',
    'password' => 'رمز عبور',
    'enter_password' => 'رمز عبور را وارد کنید',
    'select_role' => 'انتخاب نقش',
    'company_detail' => 'جزئیات شرکت',
    'supervisor' => 'سرپرست',
    'employment_type' => 'نوع استخدام',
    'select_employment_type' => 'انتخاب نوع استخدام',
    'joining_date' => 'تاریخ پیوستن',
    'enter_joining_date' => 'تاریخ عضویت را وارد کنید',
    'workspace' => 'محل کار',
    'select_workspace' => 'انتخاب محل کار',
    'field' => 'میدان',
    'office' => 'دفتر',
    'leave_detail' => 'جزئیات مرخصی',
    'leave_allocated' => 'مرخصی اختصاص یافته',
    'assigned_leaves' => 'مرخصی‌های اختصاص داده شده',
    'no_of_days' => 'تعداد روزها',
    'total_leave_days'=>'مجموع روزهای مرخصی',
    'bank_detail' => 'جزئیات بانک',
    'bank_name' => 'نام بانک',
    'bank_account_number' => 'شماره حساب بانکی',
    'account_holder_name' => 'نام دارنده حساب',
    'bank_account_type' => 'نوع حساب بانکی',
    'select_account_type' => 'انتخاب نوع حساب',
    'create_user' => 'ایجاد کاربر',
    'update_user' => 'بروزرسانی کاربر',
    'new_password' => 'رمز عبور جدید',
    'enter_new_password' => 'رمز عبور جدید را وارد کنید',
    'confirm_password' => 'تأیید رمز عبور',
    'confirm_password_placeholder' => 'تأیید رمز عبور',
    'submit' => 'ارسال',
    'user_change_password' => 'تغییر رمز عبور کاربر',
    'confirm_delete_employee' => 'آیا مطمئن هستید که می‌خواهید کارمند را حذف کنید؟',
    'confirm_force_logout' => 'آیا مطمئن هستید که می‌خواهید کاربر را مجبور به خروج کنید؟',
    'confirm_change_workplace' => 'آیا مطمئن هستید که می‌خواهید محل کار را تغییر دهید؟',
    'select_supervisor' => 'انتخاب ناظر',
    'select_office_time' => 'انتخاب زمان کاری',
    'select_option' => 'انتخاب گزینه',
    'enter_address' => 'لطفاً آدرس را وارد کنید.',
    'enter_valid_email' => 'لطفاً یک ایمیل معتبر وارد کنید.',
    'enter_phone_number' => 'لطفاً شماره تلفن را وارد کنید.',
    'create_employee' => 'ایجاد کارمند',
    'add' => 'افزودن',
    'back' => 'بازگشت',
    'edit_user_detail' => 'ویرایش جزئیات کاربر',
    'show_user_details' => 'نمایش جزئیات کاربر',
    'detail' => 'جزئیات',
    'user_detail' => 'جزئیات کاربر',
    'date_of_birth' => 'تاریخ تولد',
    'not_applicable' => 'نامشخص',
    'office_detail' => 'جزئیات دفتر',
    'home' => 'خانه',
    'account_detail' => 'جزئیات حساب',
    'account_number' => 'شماره حساب',
    'account_type' => 'نوع حساب',
    'account_holder' => 'صاحب حساب',
    'not_available' => 'ناموجود',

    /** logout requests */
    'logout_request_status' => 'وضعیت درخواست خروج',
    'take_action' => 'انجام دادن',
    'confirm_accept_logout_request' => 'آیا از قبول درخواست خروج اطمینان دارید؟',

    /** attendance */
    'attendance' => 'حضور و غیاب',
    'employee_attendance_lists' => 'لیست حضور و غیاب کارمندان',
    'attendance_of_the_day' => 'حضور و غیاب امروز',
    'date_placeholder_bs' => 'سال/ماه/روز',
    'csv_export' => 'خروجی CSV',
    'attendance_status' => 'وضعیت حضور و غیاب',
    'attendance_by' => 'ثبت حضور و غیاب توسط',
    'show_detail' => 'نمایش جزئیات',
    'show_checkin_location' => 'نمایش موقعیت ورود',
    'show_checkout_location' => 'نمایش موقعیت خروج',
    'checkin' => 'ورود',
    'checkout' => 'خروج',
    'approved' => 'تایید شده',
    'rejected' => 'رد شده',
    'self' => 'خودم',
    'admin' => 'مدیر',
    'edit_attendance_time' => 'ویرایش زمان حضور و غیاب',
    'employee_attendance_detail' => 'جزئیات حضور و غیاب کارمند',
    'attendance_of' => 'حضور و غیاب',
    'total_days_in_month' => 'کل روزهای ماه',
    'present_days' => 'روزهای حاضری',
    'absent_days' => 'روزهای غیبت',
    'weekend_days' => 'روزهای آخر هفته',
    'holiday_days' => 'روزهای تعطیل',
    'leave_days' => 'روزهای مرخصی',
    'working_hours' => 'ساعات کاری',
    'worked_hours' => 'ساعات کار شده',
    'attendance_details_of' => 'جزئیات حضور و غیاب ماه',
    'all_month' => 'تمام ماه',
    'worked_hour' => 'ساعت کارکرده',
    'add_attendance_time' => 'افزودن زمان حضور و غیاب',
    'confirm_change_attendance_status' => 'آیا از تغییر وضعیت حضور و غیاب اطمینان دارید؟',
    'check_in' => 'ورود',
    'check_out' => 'خروج',
    'attendance_title' => 'حضور و غیاب',
    'attendance_action' => 'جزئیات حضور و غیاب کارمند',
    'filter_placeholder' => 'سال حضور و غیاب به عنوان مثال: :min_year',
    'filter_button' => 'فیلتر',
    'csv_export_button' => 'خروجی CSV',
    'reset_button' => 'بازنشانی',
    'total_days' => 'کل روزهای ماه',
    'attendance_details' => 'جزئیات حضور و غیاب ماه :monthName',
    'date' => 'تاریخ',
    'change_attendance_status' => 'تغییر وضعیت حضور و غیاب',
    'create_attendance' => 'ایجاد حضوری',
    'admin_remark' => 'توضیحات مدیر',
    'edit_attendance' => 'ویرایش حضوری',
    'admin_edit_remark' => 'توضیحات مدیریت برای ویرایش',
    'confirm_check_in' => 'آیا مطمئن هستید که می خواهید ورود کارمند را ثبت کنید؟',
    'confirm_check_out' => 'آیا مطمئن هستید که می خواهید خروج کارمند را ثبت کنید؟',
    'edit_attendance_title' => 'ویرایش حضوری(:name) زمان :date',
    'create_attendance_title' => 'ایجاد حضوری(:name) زمان :date',
    'attendance_report' => 'گزارش حضور و غیاب',
    'total_worked_hours' => 'مجموع ساعات کارکرد',

    /** clients */
    'client_listing' => 'لیست مشتریان',
    'add_client' => 'افزودن مشتری',
    'client_name' => 'نام مشتری',
    'client_email' => 'ایمیل مشتری',
    'edit_client_detail' => 'ویرایش جزئیات مشتری',
    'show_client_detail' => 'نمایش جزئیات مشتری',
    'delete_client_detail' => 'حذف جزئیات مشتری',
    'client_invoices' => 'فاکتورهای مشتری',
    'client_detail' => 'جزئیات مشتری:',
    'client_project_lists' => 'لیست پروژه‌های مشتری:',
    'country' => 'کشور',
    'edit_client' => 'ویرایش مشتری',
    'create_client' => 'ایجاد مشتری',
    'client_section' => 'بخش مشتری',
    'client_contact' => 'شماره تماس مشتری',
    'client_address' => 'آدرس',
    'client_country' => 'کشور',
    'upload_profile' => 'بارگذاری پروفایل مشتری',
    'enter_client_name' => 'نام مشتری را وارد کنید',
    'enter_client_email' => 'ایمیل مشتری را وارد کنید',
    'enter_contact_number' => 'شماره تماس را وارد کنید',
    'enter_client_address' => 'آدرس مشتری را وارد کنید',
    'enter_country' => 'کشور را وارد کنید',
    'confirm_status_change' => 'آیا مطمئن هستید که می خواهید وضعیت را تغییر دهید؟',
    'confirm_delete_client' => 'آیا مطمئن هستید که می خواهید جزئیات مشتری را حذف کنید؟',

    /** Project management */
    'lists' => 'لیست‌ها',
    'create_project' => 'ایجاد پروژه',
    'project_filter' => 'فیلتر پروژه',
    'search_by_project' => 'جستجو بر اساس پروژه',
    'search_by_status' => 'جستجو بر اساس وضعیت',
    'search_by_priority' => 'جستجو بر اساس اولویت',
    'client' => 'مشتری',
    'all_tasks' => 'تمام وظایف',
    'completed_tasks' => 'وظایف تکمیل شده',
    'days_left' => 'روزهای باقیمانده',
    'team_member' => 'عضو تیم',
    'start_date' => 'تاریخ شروع',
    'due_date' => 'تاریخ موعد',
    'view' => 'مشاهده',
    'projects' => 'پروژه‌ها',
    'assign_employee' => 'اختصاص دادن کارمند',
    'client_contact_number' => 'شماره تماس مشتری',
    'upload_client_profile' => 'آپلود پروفایل مشتری',
    'project_name' => 'نام پروژه',
    'project_start_date' => 'تاریخ شروع پروژه',
    'project_deadline' => 'مهلت پروژه',
    'project_status' => 'وضعیت پروژه',
    'select_project_status' => 'انتخاب وضعیت پروژه',
    'project_cost' => 'هزینه پروژه',
    'select_priority' => 'انتخاب اولویت',
    'estimated_hours' => 'ساعات تخمینی',
    'select_client' => 'انتخاب مشتری',
    'upload_project_logo' => 'آپلود لوگوی پروژه',
    'uploaded_files_images' => 'فایل‌ها و تصاویر آپلود شده',
    'no_project_file_uploaded' => 'هیچ فایل پروژه‌ای آپلود نشده است',
    'update_project' => 'به‌روزرسانی پروژه',
    'project_leader' => 'رهبر پروژه',
    'assign_member' => 'اختصاص دادن عضو',
    'edit_project' => 'ویرایش پروژه',
    'project_document' => 'سند پروژه',
    'upload_documents' => 'آپلود اسناد',
    'upload_project_attachments' => 'آپلود پیوست‌های پروژه',
    'show_project_detail' => 'نمایش جزئیات پروژه',
    'upload_attachments' => 'آپلود پیوست',
    'project_attachments' => 'پیوست‌های پروژه',
    'uploaded_image_files' => 'فایل‌های تصویر آپلود شده',
    'no_project_image_found' => 'هیچ تصویر پروژه‌ای یافت نشد',
    'uploaded_files' => 'فایل‌های آپلود شده',
    'no_project_files_found' => 'هیچ فایل پروژه‌ای یافت نشد',
    'project_tasks_lists' => 'لیست وظایف پروژه',
    'project_summary' => 'خلاصه پروژه',
    'cost' => 'هزینه:',
    'total_hours' => 'مجموع ساعات:',
    'created' => 'ایجاد شده:',
    'remaining_days' => 'روزهای باقی‌مانده:',
    'project_leaders' => 'رهبران پروژه',
    'update_leader' => 'به‌روزرسانی رهبر',
    'project_members' => 'اعضای پروژه',
    'update_member' => 'به‌روزرسانی عضو',
    'project_client_detail' => 'جزئیات مشتری پروژه',
    'delete_project_detail' => 'آیا از حذف جزئیات پروژه اطمینان دارید؟',
    'delete_project_document' => 'آیا از حذف سند پروژه اطمینان دارید؟',
    'search_by_member' => 'جستجو بر اساس عضو',
    'add_employee_to_project' => 'افزودن کارمند به پروژه',

    /** Task management */
    'tasks' => 'وظایف',
    'task_filter' => 'فیلتر وظایف',
    'search_by_task_name' => 'جستجو بر اساس نام وظیفه',
    'not_started' => 'شروع نشده',
    'create_tasks' => 'ایجاد وظایف',
    'end_date' => 'تاریخ پایان',
    'task_name' => 'نام وظیفه',
    'enter_task_name' => 'نام وظیفه را وارد کنید',
    'select_project' => 'انتخاب پروژه',
    'task_start_date' => 'تاریخ شروع وظیفه',
    'task_start_time' => 'زمان شروع وظیفه',
    'task_end_date' => 'تاریخ پایان وظیفه',
    'task_end_time' => 'زمان پایان وظیفه',
    'task_status' => 'وضعیت وظیفه',
    'select_task_status' => 'انتخاب وضعیت وظیفه',
    'uploaded_files_and_images' => 'فایل‌ها و تصاویر آپلود شده',
    'task_attachments' => 'پیوست‌های وظیفه',
    'update_task' => 'به‌روزرسانی وظیفه',
    'create_task' => 'ایجاد وظیفه',
    'mention' => 'ارجاع',
    'comment' => 'نظر',
    'close' => 'بستن',
    'write_comment' => 'نوشتن یک نظر',
    'reply' => 'پاسخ',
    'delete_confirm' => 'آیا مطمئن هستید که می‌خواهید ":title" را حذف کنید؟',
    'task_member_placeholder' => 'تخصیص عضو به وظیفه',
    'project_placeholder' => 'انتخاب پروژه',
    'project_filter_placeholder' => 'جستجو بر اساس پروژه',
    'task_name_placeholder' => 'جستجو بر اساس نام وظیفه',
    'change_task_status_confirm' => 'آیا مطمئن هستید که می‌خواهید وضعیت وظیفه را تغییر دهید؟',
    'change_status_confirm' => 'آیا مطمئن هستید که می‌خواهید وضعیت را تغییر دهید؟',
    'delete_task_detail_confirm' => 'آیا مطمئن هستید که می‌خواهید جزئیات وظیفه را حذف کنید؟',
    'create_checklist_text' => 'ایجاد لیست کنترل',
    'close_checklist_text' => 'بستن',
    'remove_checklist_text' => 'حذف',
    'remove_checklist_title' => 'حذف لیست کنترل',
    'view_all_comments' => 'مشاهده تمام نظرات',
    'comments' => 'نظرات',
    'edit_task' => 'ویرایش وظیفه',
    'edit_task_detail' => 'ویرایش جزئیات وظیفه',
    'show_task_detail' => 'نمایش جزئیات وظیفه',
    'task_edit' => 'ویرایش وظیفه',
    'create_checklist' => 'ایجاد لیست کنترل',
    'upload_attachment' => 'آپلود پیوست',
    'total_checklist' => 'مجموع لیست‌های کنترل',
    'completed_checklist' => 'لیست‌های کنترل تکمیل شده',
    'task_checklist_lists' => 'لیست‌های کنترل وظایف',
    'assigned_to' => 'واگذار شده به',
    'create_task_checklist' => 'ایجاد لیست کنترل وظیفه',
    'enter_checklist_title' => 'وارد کردن عنوان لیست کنترل',
    'select_member' => 'انتخاب عضو',
    'add_more_checklist' => 'افزودن لیست کنترل بیشتر',
    'image' => 'تصویر',
    'file' => 'فایل',
    'edit_checklist' => 'ویرایش لیست کنترل',
    'delete_checklist' => 'حذف لیست کنترل',
    'checklist' => 'لیست کنترل',
    'edit_task_checklist' => 'ویرایش لیست کنترل وظیفه',
    'checklist_name' => 'نام لیست کنترل',
    'assign_task_checklist' => 'واگذاری لیست کنترل وظیفه',
    'task_summary' => 'خلاصه وظیفه',
    'task_members' => 'اعضای وظیفه',
    'task_attachment_title' => 'پیوست‌های وظیفه',
    'upload_attachment_action' => 'آپلود پیوست',
    'upload_task_attachments' => 'آپلود پیوست‌های وظیفه',
    'upload_task_attachments_text' => 'آپلود پیوست‌های وظیفه',
    'choose_file_text' => 'انتخاب فایل',

    /** Holiday */
    'holiday_section' => 'بخش تعطیلات',
    'event' => 'رویداد',
    'event_date' => 'تاریخ رویداد',
    'is_public_holiday' => 'آیا این روز تعطیل عمومی است؟',
    'confirm_delete_holiday' => 'آیا از حذف جزئیات تعطیلات مطمئن هستید؟',
    'holiday_detail_title' => 'جزئیات تعطیلات',
    'holiday' => 'تعطیلات',
    'csv_import' => 'وارد کردن CSV',
    'import' => 'وارد کردن',
    'holiday_detail_csv' => 'جزئیات تعطیلات به صورت CSV',
    'holiday_csv_example' => 'مثال CSV تعطیلات',
    'add_holiday' => 'افزودن تعطیلات',
    'import_holiday_csv' => 'وارد کردن CSV تعطیلات',
    'holiday_filter' => 'فیلتر تعطیلات',
    'event_name' => 'نام رویداد',
    'leave_requested_year' => 'سال درخواست مرخصی',
    'holiday_detail' => 'جزئیات تعطیلات',

    /** Notice */
    'notices_section' => 'بخش اعلانات',
    'notice_title' => 'عنوان اعلان',
    'notice_description' => 'توضیحات اعلان',
    'notice_receiver' => 'گیرنده اعلان',
    'send_notice' => 'ارسال اعلان',
    'all_employees' => 'همه کارمندان',
    'create_notice' => 'ایجاد اعلان',
    'edit_notice' => 'ویرایش اعلان',
    'notices' => 'اعلانات',
    'receiver' => 'گیرنده',
    'published_from' => 'انتشار از',
    'publish_to' => 'انتشار تا',
    'publish_date' => 'تاریخ انتشار',
    'show_notice_content' => 'نمایش محتوای اعلان',
    'delete_notice_detail' => 'حذف جزئیات اعلان',
    'notice_lists' => 'لیست اعلانات',
    'confirm_change_notice_status' => 'آیا مطمئن هستید که می‌خواهید وضعیت اعلان را تغییر دهید؟',
    'confirm_delete_notice' => 'آیا مطمئن هستید که می‌خواهید اعلان را حذف کنید؟',
    'confirm_send_notice' => 'آیا مطمئن هستید که می‌خواهید اعلان را ارسال کنید؟',
    'notice_detail_modal_title' => 'جزئیات اعلان :title',


    /** payroll */
    'employee_payroll'=>'حقوق و دستمزد کارمند',
    'payroll_generate'=>'تولید حقوق و دستمزد',
    'payroll_create'=>'ایجاد حقوق و دستمزد',
    'payroll_edit'=>'ویرایش حقوق و دستمزد',
    'select_year' => 'انتخاب سال',
    'salary_cycle' => 'دوره حقوق',
    'salary_month' => 'ماه حقوق',
    'salary_week' => 'هفته حقوق',
    'select_week' => 'انتخاب هفته',
    'include_tada' => 'شامل TADA',
    'include_advance_salary' => 'شامل حقوق پیش‌پرداخت',
    'use_attendance' => 'استفاده از حضور و غیاب',
    'generate' => 'تولید',
    'clear' => 'پاک کردن',
    'report' => 'گزارش:',
    'duration' => 'مدت زمان',
    'payroll_summary' => 'خلاصه حقوق و دستمزد',
    'total_basic_salary' => 'مجموع حقوق پایه:',
    'total_net_salary' => 'مجموع حقوق خالص:',
    'total_allowance' => 'مجموع مزایا:',
    'total_deduction' => 'مجموع کسر:',
    'total_overtime' => 'مجموع اضافه‌کاری:',
    'total_undertime' => 'مجموع کم‌کاری:',
    'paid_by'=>'پرداخت شده توسط',
    'net_salary'=>'حقوق خالص',
    'paid_on'=>'پرداخت شده در',
    'pay_button' => 'پرداخت',
    'select_payment_method.'=>'لطفاً روش پرداخت را انتخاب کنید.',
    'confirm_delete_payroll'=>'آیا مطمئن هستید که می‌خواهید حقوق و دستمزد کارمند را حذف کنید؟',
    'confirm_generate_payroll'=>'آیا مطمئن هستید که می‌خواهید حقوق و دستمزد را تولید کنید؟',
    'confirm_change_cycle'=>'آیا مطمئن هستید که می‌خواهید دوره حقوق را تغییر دهید؟',
    'payment_title' => 'انجام پرداخت',
    'payment_method_placeholder' => 'روش پرداخت را انتخاب کنید',
    'payment_date' => 'تاریخ پرداخت',
    'hourly_rate' => 'نرخ ساعتی',
    'hourly' => 'ساعتی',
    'working_hours_in_week' => 'ساعات کاری در هفته',
    'annual_salary' => 'حقوق سالانه (CTC)',
    'annual' => 'سالانه',
    'basic_salary' => 'حقوق پایه',
    'fixed_allowance' => 'مزایای ثابت',
    'total' => 'مجموع',
    'net_total' => 'مجموع خالص',
    'earnings' => 'درآمد',
    'deductions' => 'کسرها',
    'create_salary'=>'ایجاد حقوق',
    'edit_salary'=>'ویرایش حقوق',
    'add_salary'=>'افزودن حقوق',
    'calculation_type'=>'نوع محاسبه',
    'monthly_amount'=>'مقدار ماهانه',
    'annual_amount'=>'مقدار سالانه',
    'salary_slip' => 'فیش حقوقی',
    'edit_salary_slip' => 'ویرایش فیش حقوقی',
    'payslip' => 'فیش حقوقی',
    'for_the_month_of' => 'برای ماه',
    'from'=>'از',
    'to'=>'به',
    'employee_id'=>'شناسه کارمند',
    'earning' => 'درآمد',
    'deduction' => 'کسر',
    'actual_salary' => 'حقوق واقعی',
    'total_earning'=>'کل درآمد',
    'actual_salary_formula' => '(کل درآمد - کل کسرها)',
    'bonus' => 'پاداش',
    'taxable_salary' => 'حقوق قابل مالیات',
    'taxable_salary_formula' => '(حقوق واقعی + پاداش)',
    'tax' => 'مالیات',
    'salary_after_tax' => 'حقوق بعد از مالیات',
    'expenses_claim' => 'مطالبات هزینه (TADA)',
    'absent' => 'غایب',
    'absent_deduction_formula' => '((حقوق ناخالص / تعداد روزهای کل) * تعداد روزهای غیاب)',
    'net_salary_formula' => 'حقوق خالص = (حقوق واقعی - حقوق پیش‌پرداخت + TADA)',
    'monthly' => 'ماهانه',
    'weekly' => 'هفتگی',
    'salary_increment' => 'افزایش حقوق',
    'increment' => 'افزایش',
    'current_salary' => 'حقوق فعلی',
    'annual_increment_percent' => 'درصد افزایش سالانه',
    'annual_increment_amount' => 'مقدار افزایش سالانه',
    'revised_salary_label' => 'حقوق اصلاح‌شده',
    'fiscal_year_label' => 'افزایش برای سال مالی',
    'applicable_from_label' => 'قابل اجرا از (تاریخ)',
    'applicable_to_label' => 'قابل اجرا تا (تاریخ)',
    'remark' => 'توضیح',
    'fiscal_year' => 'سال مالی',
    'select_fiscal_year' => 'انتخاب سال مالی',
    'list'=>'لیست',
    'employee_salary_filter'=>'فیلتر حقوق کارمند',
    'salary_review_history'=>'سابقه بازبینی حقوق',
    'increase_salary'=>'افزایش حقوق',
    'all'=>'همه',
    'employee_payslip'=>'فیش حقوقی کارمند',
    'salary_from'=>'حقوق از',
    'salary_to'=>'حقوق تا',
    'unpaid_leave'=>'مرخصی بدون حقوق',
    'paid_leave'=>'مرخصی با حقوق',
    'employee_gross_salary'=>'حقوق ناخالص کارمند',
    'salary_increment_log'=>'سابقه افزایش حقوق',
    'log'=>'سابقه',
    'salary_revised_on'=>'حقوق اصلاح‌شده در',
    'increment_by'=>'افزایش توسط',
    'increment_value'=>'مقدار افزایش',
    'old_salary'=>'حقوق قدیمی',
    'new_salary'=>'حقوق جدید',
    'date_to'=>'تاریخ تا',
    'date_from'=>'تاریخ از',
    'salary_increment_remark'=>'توضیح افزایش حقوق',
    'advance_salary_requests'=>'درخواست‌های حقوق پیش‌پرداخت',
    'advance_salary_request_filter'=>'فیلتر درخواست‌های حقوق پیش‌پرداخت',
    'delete_confirmation'=>'آیا مطمئن هستید که می‌خواهید حذف کنید؟',
    'payslip_for_the_month_of'=>'فیش حقوقی برای ماه',
    'absent_deduction'=>'کسر غیاب',


    /** Advance Salary */
    'is_paid' => 'پرداخت شده است؟',
    'released_on' => 'تاریخ انتشار',
    'requested_on' => 'تاریخ درخواست',
    'released_amount' => 'مقدار منتشر شده',
    'requested_amount' => 'مقدار درخواست شده',
    'search_by_month' => 'جستجو بر اساس ماه',
    'search_by_employee_name' => 'جستجو بر اساس نام کارمند',
    'advance_salary_detail' => 'جزئیات حقوق پیش پرداخت',
    'is_settled' => 'تسویه شده است',
    'verified_by' => 'تایید شده توسط',
    'amount_released_date' => 'تاریخ انتشار مقدار',
    'advance_requested_date' => 'تاریخ درخواست پیش پرداخت',
    'total_released_amount' => 'مجموع مبلغ منتشر شده',
    'total_request_amount' => 'مجموع مبلغ درخواست شده',
    'employee' => 'کارمند',
    'select_employee' => 'انتخاب کارمند',
    'advance_salary_request_detail' => 'جزئیات درخواست حقوق پیش پرداخت',
    'proof_of_advance_salary_payment' => 'مدرک پرداخت حقوق پیش پرداخت',
    'attachments' => 'پیوست‌ها',
    'processing' => 'در حال پردازش',

    /** Tax report */
    'tax_report' => 'گزارش مالیات',
    'employee_tax_report' => 'گزارش مالیات کارکنان',
    'tax_report_edit' => 'ویرایش گزارش مالیات',
    'tax_report_detail_of' => 'جزئیات گزارش مالیات از',
    'tax_report_detail' => 'جزئیات گزارش مالیات',
    'salary_sheet' => 'برگه حقوق',
    'particular' => 'جزئیات',
    'income' => 'درآمد',
    'tax_data_not_available' => 'اطلاعات مالیاتی برای وضعیت تاهل فعلی در دسترس نیست',
    'remain_tds_formula' => '(کل TDS معوقه / تعداد ماه‌های باقی‌مانده)',
    'remaining_month' => 'ماه باقی‌مانده',
    'tds_calculation_msg' => 'محاسبه TDS برای ماه جاری (ماه محاسبه)',
    'total_due_tds' => 'کل TDS معوقه',
    'total_paid_tds' => 'کل TDS پرداخت شده',
    'total_payable_tds' => 'کل TDS قابل پرداخت',
    'other_discount' => 'تخفیف دیگر',
    'female_discount' => 'تخفیف زنان',
    'medical_claim' => 'ادعای پزشکی',
    'less' => 'کمتر',
    'less_tax_deduction' => 'کمتر: کسر مالیات',
    'tax_amount' => 'مقدار مالیات',
    'percent' => 'درصد',
    'tax_calculation_on_taxable_income' => 'محاسبه مالیات بر درآمد مشمول مالیات',
    'taxable_income' => 'درآمد مشمول مالیات',
    'ssf_contribution' => 'مشارکت SSF',
    'ssf_contribution_salary' => 'مشارکت SSF در حقوق',
    'total_retirement_contribution_allowed' => 'کل مشارکت بازنشستگی مجاز',
    'total_income' => 'کل درآمد',
    'amount' => 'مقدار',
    'additional_information' => 'اطلاعات اضافی',
    'total_payable' => 'مجموع قابل پرداخت',
    'tds_paid' => 'TDS پرداخت شده',
    'ssf_deduction' => 'کسر SSF',
    'tax_report_generate' => 'تولید گزارش مالیات',
    'print' => 'چاپ',
    'gross_earnings' => 'درآمد ناخالص',

    /** Payroll Setting  */
    'advance_salary_limit' => 'حد اعتبار حقوق پیش‌پرداخت',
    'select_month' => 'انتخاب ماه',
    'applicable_month' => 'ماه قابل اجرا',
    'value' => 'مقدار',
    'value_type' => 'نوع مقدار',
    'enter_bonus_type' => 'نوع پاداش را وارد کنید',
    'salary_components' => 'اجزای حقوق',
    'add_bonus' => 'اضافه کردن پاداش',
    'max_daily_ot' => 'حداکثر اضافه‌کاری روزانه',
    'assign_overtime_to_employee' => 'اختصاص اضافه‌کاری به کارمند',
    'overtime_pay_rate' => 'میزان پرداخت اضافه‌کاری (در هر ساعت)',
    'overtime_rate_percent' => 'درصد نرخ اضافه‌کاری (در هر ساعت)',
    'placeholder_overtime_pay_rate' => 'میزان پرداخت اضافه‌کاری را وارد کنید',
    'placeholder_overtime_rate_percent' => 'درصد نرخ اضافه‌کاری را وارد کنید',
    'rate_type' => 'نوع نرخ',
    'select_rate_type' => 'نوع نرخ را انتخاب کنید',
    'ot_valid_after_hour' => 'اضافه‌کاری معتبر پس از؟ ساعت',
    'placeholder_ot_valid_after_hour' => 'ساعت‌هایی را وارد کنید که بعد از آن اضافه‌کاری معتبر است',
    'monthly_ot' => 'حداکثر اضافه‌کاری ماهانه',
    'placeholder_monthly_ot' => 'حداکثر اضافه‌کاری ماهانه را وارد کنید',
    'weekly_ot' => 'حداکثر اضافه‌کاری هفتگی',
    'placeholder_weekly_ot' => 'حداکثر اضافه‌کاری هفتگی را وارد کنید',
    'daily_ot' => 'حداکثر اضافه‌کاری روزانه',
    'placeholder_daily_ot' => 'حداکثر اضافه‌کاری روزانه را وارد کنید',
    'pay_percent' => 'درصد/نرخ پرداخت',
    'employee_count' => 'تعداد کارمندان',
    'hour' => 'ساعت',
    'currency_setting' => 'تنظیمات ارز',
    'payroll_currency' => 'واحد پول حقوق',
    'choose_payroll_currency' => 'واحد پول حقوق را انتخاب کنید',
    'add_payment_method' => 'روش پرداخت را اضافه کنید',
    'payment_method_name' => 'نام روش پرداخت',
    'update_payment_method' => 'به‌روزرسانی روش پرداخت',
    'component_value' => 'مقدار جزء',
    'component_type' => 'نوع جزء',
    'add_salary_component' => 'اضافه کردن جزء حقوق',
    'apply_for_all' => 'اعمال برای همه',
    'component_value_annual' => 'مقدار جزء (سالانه)',
    'select_value_type' => 'نوع مقدار را انتخاب کنید',
    'select_component_type' => 'نوع جزء را انتخاب کنید',
    'enter_salary_component_name' => 'نام جزء حقوق را وارد کنید',
    'add_salary_group' => 'اضافه کردن گروه حقوق',
    'delete_confirm_salary_group' => 'آیا مطمئنید که می‌خواهید جزئیات گروه را حذف کنید؟',
    'assign_employee_to_group' => 'اختصاص کارمند به گروه',
    'choose_salary_component' => 'جزء حقوق را انتخاب کنید',
    'assign_salary_components' => 'اختصاص اجزای حقوق',
    'enter_salary_group_name' => 'نام گروه حقوق را وارد کنید',
    'add_more_tds_detail' => 'جزئیات TDS بیشتری اضافه کنید',
    'enter_tds_in_percent' => 'درصد TDS را وارد کنید',
    'enter_annual_salary_to' => 'حقوق سالانه تا را وارد کنید',
    'enter_annual_salary_from' => 'حقوق سالانه از را وارد کنید',
    'select_marital_status' => 'وضعیت تاهل را انتخاب کنید',
    'create_salary_tds' => 'ایجاد TDS حقوق',
    'update_salary_tds' => 'به‌روزرسانی TDS حقوق',
    'salary_tds_detail_for_single' => 'جزئیات TDS حقوق برای مجردها',
    'add_salary_tds' => 'اضافه کردن TDS حقوق',
    'annual_salary_to' => 'حقوق سالانه تا',
    'annual_salary_from' => 'حقوق سالانه از',
    'tds' => 'TDS (%)',
    'salary_tds_detail_for_married' => 'جزئیات TDS حقوق برای متأهلین',
    'ssf' => 'SSF',
    'employee_contribution' => 'مشارکت کارمند',
    'office_contribution' => 'مشارکت دفتر',
    'assign_undertime_to_employee' => 'اختصاص زمان کم به کارمند',
    'enter_title' => 'عنوان را وارد کنید',
    'undertime_after_minute' => 'دقایق پس از آنکه زمان کم اعمال می‌شود',
    'placeholder_ut_after' => 'ساعت‌هایی را وارد کنید که بعد از آن زمان کم اعمال می‌شود',
    'penalty_type' => 'نوع جریمه',
    'select_penalty_type' => 'نوع جریمه را انتخاب کنید',
    'penalty_percent' => 'درصد جریمه (در هر ساعت)',
    'penalty_percent_placeholder' => 'درصد جریمه زمان کم را وارد کنید',
    'penalty_rate' => 'نرخ جریمه (در هر ساعت)',
    'penalty_rate_placeholder' => 'نرخ جریمه زمان کم را وارد کنید',
    'tax_payable' => 'مالیات پرداختی',

    /** Leave */
    'leave_type_section' => 'بخش نوع مرخصی',
    'select_leave_type' => 'نوع مرخصی را انتخاب کنید',
    'leave_type' => 'نوع مرخصی',
    'leave_allocated_days' => 'روزهای مرخصی تخصیص یافته',
    'allocated_days' => 'روزهای تخصیص یافته',
    'is_paid_leave' => 'آیا مرخصی با حقوق است',
    'leave_type_name' => 'نام نوع مرخصی',
    'leave_type_placeholder' => 'نوع مرخصی را وارد کنید',
    'add_leave_type' => 'افزودن نوع مرخصی',
    'type' => 'نوع',
    'edit_leave_type_detail' => 'ویرایش جزئیات نوع مرخصی',
    'delete_leave_type' => 'حذف نوع مرخصی',
    'delete_leave_confirmation' => 'آیا مطمئن هستید که می‌خواهید نوع مرخصی را حذف کنید؟',
    'leave_request_section' => 'بخش درخواست مرخصی',
    'approve' => 'تأیید',
    'reject' => 'رد',
    'from_date' => 'از تاریخ',
    'to_date' => 'تا تاریخ',
    'start_time' => 'زمان شروع',
    'end_time' => 'زمان پایان',
    'reason' => 'دلیل',
    'requested_for' => 'درخواست شده برای',
    'requested_by' => 'درخواست شده توسط',
    'requested_days' => 'روزهای درخواست شده',
    'requested_date' => 'تاریخ درخواست',
    'all_status' => 'همه وضعیت‌ها',
    'all_leave_type' => 'تمام انواع مرخصی',
    'leave_request_filter' => 'فیلتر درخواست مرخصی',
    'create_leave_request' => 'ایجاد درخواست مرخصی',
    'leave_reason' => 'دلیل مرخصی',
    'referred_by' => 'ارجاع شده توسط',
    'leave_date' => 'تاریخ مرخصی',
    'time_leave_request_filter' => 'فیلتر درخواست مرخصی بر اساس زمان',
    'create_time_leave_request' => 'ایجاد درخواست مرخصی بر اساس زمان',
    'time_leave_request_section' => 'بخش درخواست مرخصی بر اساس زمان',
    'time_leave_status_update' => 'به‌روزرسانی وضعیت مرخصی بر اساس زمان',

    /** Team Meeting */
    'team_meeting_section' => 'بخش جلسه تیم',
    'update_and' => 'به‌روزرسانی و',
    'create_and' => 'ایجاد و',
    'send' => 'ارسال',
    'meeting_participator' => 'شرکت‌کننده جلسه',
    'image_hint' => 'توصیه می‌شود تصویر به صورت افقی باشد',
    'meeting_description' => 'توضیحات جلسه',
    'upload_image' => 'بارگذاری تصویر',
    'meeting_start_time' => 'زمان شروع جلسه',
    'meeting_date' => 'تاریخ جلسه',
    'meeting_venue' => 'مکان جلسه',
    'enter_venue_name' => 'نام مکان را وارد کنید',
    'enter_content_title' => 'عنوان محتوا را وارد کنید',
    'meeting_title' => 'عنوان جلسه',
    'delete_team_meeting_confirmation' => 'آیا مطمئن هستید که می‌خواهید جلسه تیم را حذف کنید؟',
    'image_delete_confirmation' => 'آیا مطمئن هستید که می‌خواهید تصویر را حذف کنید؟',
    'create_team_meeting' => 'ایجاد جلسه تیم',
    'delete_team_meeting' => 'حذف جزئیات جلسه تیم',
    'edit_meeting_detail' => 'ویرایش جزئیات جلسه',
    'show_team_meeting' => 'نمایش محتوای جلسه تیم',
    'participators' => 'شرکت‌کنندگان',
    'participator' => 'شرکت‌کننده',
    'team_meeting_filter' => 'فیلتر جلسه تیم',
    'agenda' => 'دستور جلسه',
    'creator' => 'سازنده',

    /** Tada */
    'tada_attachment' => 'پیوست تادا',
    'upload_tada_attachment' => 'بارگذاری پیوست تادا',
    'accepted' => 'پذیرفته شده',
    'tada_status_change' => 'آیا مطمئن هستید که می‌خواهید وضعیت تسویه تادا را تغییر دهید؟',
    'delete_tada_confirm' => 'آیا مطمئن هستید که می‌خواهید :title را حذف کنید؟',
    'uploaded_attachment' => 'پیوست بارگذاری شده',
    'no_attachment_file' => 'هیچ فایل پیوست وجود ندارد',
    'total_expense' => 'کل هزینه',
    'create_tada' => 'ایجاد تادا',
    'edit_tada' => 'ویرایش تادا',
    'tada_listing' => 'فهرست تادا',
    'tada_filter' => 'فیلتر تادا',
    'submitted_date' => 'تاریخ ارسال',
    'expense' => 'هزینه',
    'tada_detail' => 'جزئیات تادا',
    'verified_date' => 'تاریخ تأیید',
    'tada_summary' => 'خلاصه تادا',
    'update_status' => 'به‌روزرسانی وضعیت',
    'category' => 'دسته‌بندی',
    'select_category' => 'انتخاب دسته‌بندی',
    'opening_time' => 'ساعت شروع',
    'closing_time' => 'ساعت پایان',
    'checkin_checkout_rule' => 'قانون ورود/خروج',
    'early_check_in' => 'ورود زودهنگام',
    'check_in_before' => 'می‌توانید قبل از (به دقیقه) ورود کنید',
    'checkin_before' => 'ورود قبل',
    'enter_check_in_before' => 'وارد کنید که می‌توانید قبل از (به دقیقه) ورود کنید',
    'early_check_out' => 'خروج زودهنگام',
    'check_out_before' => 'می‌توانید قبل از (به دقیقه) خروج کنید',
    'checkout_before' => 'خروج قبل',
    'enter_check_out_before' => 'وارد کنید که می‌توانید قبل از (به دقیقه) خروج کنید',
    'late_check_in' => 'ورود دیرهنگام',
    'check_in_after' => 'می‌توانید بعد از (به دقیقه) ورود کنید',
    'checkin_after' => 'ورود بعد',
    'enter_check_in_after' => 'وارد کنید که می‌توانید بعد از (به دقیقه) ورود کنید',
    'late_check_out' => 'خروج دیرهنگام',
    'checkout_after' => 'خروج بعد',
    'check_out_after' => 'می‌توانید بعد از (به دقیقه) خروج کنید',
    'enter_check_out_after' => 'وارد کنید که می‌توانید بعد از (به دقیقه) خروج کنید',
    'enter_shift_name' => 'نام شیفت را وارد کنید',
    'select_shift' => 'انتخاب شیفت',
    'delete_office_time_confirm' => 'آیا مطمئن هستید که می‌خواهید برنامه دفتر را حذف کنید؟',
    'office_time_detail' => 'جزئیات زمان دفتر',
    'office_schedule' => 'برنامه دفتر',
    'add_office_time' => 'اضافه کردن زمان دفتر',

    /** Award Types */
    'award_distributed' => 'جوایز توزیع شده',
    'add_award_types' => 'افزودن انواع جوایز',
    'gift_item' => 'آیتم هدیه',
    'awarded_date' => 'تاریخ اعطای جایزه',

    /** Award */
    'award' => 'جایزه',
    'award_name' => 'نام جایزه',
    'select_award_type' => 'انتخاب نوع جایزه',
    'enter_gift_item' => 'وارد کردن آیتم هدیه',
    'award_base' => 'پایه جایزه',
    'select_award_base' => 'انتخاب پایه جایزه',
    'awarded_by' => 'اعطا شده توسط',
    'enter_awarded_by' => 'وارد کردن اعطا شده توسط',
    'award_description' => 'توضیحات جایزه',
    'gift_description' => 'توضیحات هدیه',
    'reward_code' => 'کد پاداش',
    'enter_reward_code' => 'وارد کردن کد پاداش',
    'add_award' => 'افزودن جایزه',
    'attachment' => 'پیوست',
    'award_lists' => 'فهرست جوایز',

    /** Asset Types */
    'add_asset_types' => 'افزودن انواع دارایی',
    'asset_item_count' => 'تعداد اقلام دارایی',
    'asset_type' => 'نوع دارایی',
    'asset_name' => 'نام دارایی',
    'purchased_date' => 'تاریخ خرید',
    'is_working' => 'در حال کار',
    'is_available' => 'موجود است',
    'asset' => 'دارایی',

    /** Assets */
    'select_asset_type' => 'انتخاب نوع دارایی',
    'assigned_date' => 'تاریخ تخصیص',
    'is_available_for_employee' => 'برای کارمند در دسترس است',
    'select_availability' => 'انتخاب موجودیت',
    'warranty_end_date' => 'تاریخ پایان گارانتی',
    'warranty_available' => 'گارانتی موجود است',
    'select_warranty_availability' => 'انتخاب موجودیت گارانتی',
    'asset_serial_number' => 'شماره سریال دارایی',
    'enter_asset_serial_number' => 'وارد کردن شماره سریال دارایی',
    'asset_code' => 'کد دارایی',
    'enter_asset_code' => 'وارد کردن کد دارایی',
    'change_availability_status' => 'آیا مطمئن هستید که می‌خواهید وضعیت موجودیت را تغییر دهید؟',
    'delete_asset_confirm' => 'آیا مطمئن هستید که می‌خواهید :title را حذف کنید؟',
    'add_asset' => 'افزودن دارایی',
    'asset_image' => 'تصویر دارایی',
    'asset_assigned_employee' => 'کارمند تخصیص یافته به دارایی',
    'assets_filter' => 'فیلتر دارایی',
    'working_status' => 'وضعیت کار',
    'availability_status' => 'وضعیت موجودیت',
    'yes_available' => 'بله، موجود است',
    'notavailable' => 'موجود نیست',
    'purchased_from' => 'خریداری شده از',
    'purchased_to' => 'خریداری شده به',

    /** Content Management */
    'content_section' => 'بخش محتوا',
    'content' => 'محتوا',
    'content_type' => 'نوع محتوا',
    'content_title' => 'عنوان محتوا',
    'select_content_type' => 'انتخاب نوع محتوا',
    'delete_content_confirm' => 'آیا مطمئن هستید که می‌خواهید محتوای صفحه ثابت را حذف کنید؟',
    'company_static_content' => 'محتوای ثابت شرکت',
    'add_content' => 'افزودن محتوا',

    /** Support */
    'delete_support_confirm' => 'آیا مطمئن هستید که می‌خواهید :title را حذف کنید؟',
    'ticket_lists' => 'فهرست بلیط‌ها',
    'query_by' => 'پرسش توسط',
    'concerned_department' => 'دپارتمان مربوطه',
    'unseen' => 'ندیده شده',
    'read_status' => 'وضعیت خواندن',
    'seen' => 'دیده شده',
    'query_status' => 'وضعیت پرسش',
    'support_filter' => 'فیلتر پشتیبانی',
    'query_lists' => 'فهرست پرسش‌ها',
    'department_support_requested_from' => 'پشتیبانی درخواست شده از دپارتمان',
    'department_support_requested_to' => 'پشتیبانی درخواست شده به دپارتمان',
    'change_query_status' => 'تغییر وضعیت پرسش',

    /** Router */
    'router_section' => 'بخش روتر',
    'router_bssid' => 'BSSID روتر',
    'router' => 'روتر',
    'router_detail' => 'جزئیات روتر',
    'add_router' => 'افزودن روتر',

    /** QR */
    'scan_me' => 'اسکن کن من',
    'attendance_qr' => 'QR حضور',
    'qr_image' => 'تصویر QR',
    'add_qr' => 'افزودن QR',
    'qr_section' => 'بخش QR',

    /** NFC */
    'nfc_section' => 'بخش NFC',
    'created_by' => 'ایجاد شده توسط',

    /** Role and permission */
    'role_section' => 'بخش نقش',
    'autorize_backend_login' => 'مجوز ورود به بخش پشتیبان',
    'role_name' => 'نام نقش',
    'permissions' => 'مجوزها',
    'check_all' => 'انتخاب همه',
    'module' => 'ماژول',
    'add_role' => 'افزودن نقش',
    'assign_permissions' => 'اختصاص مجوزها',
    'confirm_role_deletion' => 'آیا مطمئن هستید که می‌خواهید نقش را حذف کنید؟',
    'can_login' => 'می‌تواند وارد شود',
    'permission_setting' => 'تنظیمات مجوز',
    'assign' => 'اختصاص دادن',

    /** General Setting */
    'general_setting_section' => 'بخش تنظیمات عمومی',
    'general_setting' => 'تنظیمات عمومی',

    /** App Setting */
    'export_database_data' => 'صادر کردن داده‌های پایگاه داده',
    'check_router_bssid' =>'بررسی BSSID روتر',

    /** Fiscal Years */
    'fiscal_years' => 'سال‌های مالی',
    'year' => 'سال',
    'add_fiscal_year' => 'افزودن سال مالی',

    /** Notifications */
    'notification_section' => 'بخش اطلاع‌رسانی',
    'confirm_notification_send' => 'آیا مطمئن هستید که می‌خواهید اطلاع‌رسانی را ارسال کنید؟',
    'notification' => 'اطلاع‌رسانی',
    'published_date' => 'تاریخ انتشار',
    'all_types' => 'تمام نوع‌ها',
    'notification_lists' => 'فهرست‌های اطلاع‌رسانی',
    'notified_member' => 'عضو اطلاع‌رسانی شده',
    'notification_title' => 'عنوان اطلاع‌رسانی',
    'notification_description' => 'توضیحات اطلاع‌رسانی',
    'send_notification' => 'ارسال اطلاع‌رسانی',
    'enter_notification_title' => 'عنوان اطلاع‌رسانی را وارد کنید',

    /** feature control */
    'app_setting' => 'تنظیمات برنامه',
    'sn' => 'شماره',
    'group' => 'گروه',
    'export_table_data' => 'خروجی اطلاعات جدول',
    'leave_requests' => 'درخواست‌های مرخصی',
    'employee_lists' => 'لیست کارمندان',
    'attendances' => 'حضور و غیاب‌ها',
    'confirm_change_status' => 'آیا مطمئن هستید که می‌خواهید وضعیت را تغییر دهید؟',
    'yes' => 'بله',
    'no' => 'خیر',

    /** Api response */
    /** Auth Controller */
    'invalid_login_credentials'=>'اطلاعات ورود نامعتبر است!',
    'authenticated'=>'احراز هویت شده',
    'user_detail_not_found'=>'جزئیات کاربر یافت نشد',
    'partial_logout_successful'=>'خروج موفقیت آمیز',
    /** Dashboard Controller */
    'data_found'=>'داده‌ها یافت شد',
    /** AdvanceSalary Controller */
    'advance_salary_pending_error'=>'تا زمانی که درخواست قبلی تسویه نشود، نمی‌توان درخواست حقوق دیگری را درخواست کرد.',
    'data_updated_successfully'=>'داده‌ها با موفقیت به روز شد',
    'user_updated_advance_salary_request' => ':name جزئیات درخواست حقوق پیشرفته را به‌روزرسانی کرده است',
    'data_created_successfully'=>'داده‌ها با موفقیت ایجاد شد',
    'advance_salary_request_alert'=>'هشدار درخواست حقوق پیشرفته',
    'user_submitted_advance_salary_request' => ':name درخواست حقوق پیشرفته به مبلغ :amount را ارسال کرده است',
    /** Attendance Api */
    'check_out_successful'=>'خروج با موفقیت انجام شد',
    'check_out_notification'=>'اعلان خروج',
    'check_in_successful'=>'ورود با موفقیت انجام شد',
    'check_in_notification'=>'اعلان ورود',
    'not_checked_in_yet'=>'هنوز وارد نشده‌اید',
    'alert_multi_checkin_shift'=>'متاسفیم! کارمند نمی‌تواند دو بار در یک شیفت وارد شود.',
    'checkout_alert_for_shift'=>'کارمند قبلاً از شیفت خارج شده است',
    'alert_checkin'=>'متاسفیم! کارمند نمی‌تواند دو بار در یک روز وارد شود.',
    'checkout_alert'=>'کارمند قبلاً امروز خارج شده است',
    'attendance_alert_status'=>':status قبلاً انجام شده است',
    'employee_checked_in' => ':name در ساعت :time وارد شده است',
    'employee_checked_out' => ':name در ساعت :time خارج شده است',
    'has_worked_for' => 'و برای مدت :time کار کرده است',
    'multi_checkout_warning'=>'حداکثر تعداد ورود و خروج‌های مجاز برای امروز را انجام داده‌اید.',
    'employee_checked_out_and_worked' => ':name در ساعت :check_out_time خارج شده و برای مدت :worked_time کار کرده است',
    'invalid_attendance_type'=>'نوع حضور نامعتبر است.',
    'invalid_qr'=>'QR نامعتبر است یا در دسترس نیست',
    'invalid_nfc'=>'نشانه NFC نامعتبر است یا در دسترس نیست',
    'validation_failed'=>'اعتبارسنجی ناموفق بود',

    /** Leave Api Controller */
    'leave_request_cancelled' => 'درخواست مرخصی با موفقیت لغو شد',
    'leave_request_cannot_be_cancelled' => 'درخواست مرخصی پس از به‌روزرسانی از حالت معلق، قابل لغو نیست.',
    'leave_request_notification' => 'اطلاعیه درخواست مرخصی',
    'leave_request_submitted' => ':name از :start_time تا :end_time در :issue_date درخواست مرخصی کرده است. دلیل: :reasons',
    'leave_request_submitted_successfully' => 'درخواست مرخصی با موفقیت ارسال شد',
    'leave_request_cancelled_successfully' => 'درخواست مرخصی با موفقیت لغو شد',
    'leave_request_submit' => ':name درخواست :no_of_days روز(های) مرخصی از :leave_from در :leave_requested_date کرده است. دلیل: :reasons',

    /** NFC api Controller */
    'nfc_token_already_exist' => 'توکن NFC از قبل وجود دارد.',
    'nfc_added_successfully' => 'NFC با موفقیت اضافه شد',

    /** Notification Api Controller */
    'updated_successfully' => 'با موفقیت به‌روزرسانی شد',
    'successfully_sent_notification' => 'اطلاعیه با موفقیت ارسال شد',
    'data_not_found' => 'داده‌ها پیدا نشد',
    'content_not_found' => 'محتوا پیدا نشد',

    /** Support Api Controller */
    'support_notification' => 'اطلاعیه پشتیبانی',
    'support_request_submitted' => ':name درخواست پشتیبانی داده است.',
    'query_submitted_successfully' => 'استعلام با موفقیت ارسال شد',

    /** Tada Api Controller  */
    'attachment_detail_not_found' => 'جزئیات پیوست پیدا نشد',
    'cannot_delete_attachment_detail' => 'پس از تأیید، نمی‌توان جزئیات پیوست را حذف کرد',
    'upload_another_attachment_before_delete' => 'لطفاً قبل از حذف، پیوست دیگری بارگذاری کنید.',
    'attachment_deleted_successfully' => 'پیوست با موفقیت حذف شد',
    'tada_update_alert' => 'پس از تأیید، نمی‌توانید جزئیات را به‌روزرسانی کنید، لطفاً با مدیر تماس بگیرید',
    'tada_notification' => ':name یک TADA جدید برای :title ارسال کرده است',
    'tada_detail_notification' => ':name جزئیات TADA ارسالی برای :title را به‌روزرسانی کرده است',
    'tada_alert' => 'هشدار TADA',

    /** TaskDetailApi Controller */
    'status_changed_successfully' => 'وضعیت با موفقیت تغییر کرد',
    'task_detail_not_found' => 'جزئیات وظیفه پیدا نشد',

    /** TaskCheckListApi Controller */
    'status_updated_successfully' => 'وضعیت با موفقیت به‌روزرسانی شد',

    /** TaskCommentApi Controller */
    'comment_notification' => 'اطلاعیه نظر',
    'task_mention' => 'شما در وظیفه :task :type ذکر شده‌اید',
    'comment_reply' => 'پاسخ به نظر',
    'comment_reply_deleted_successfully' => 'پاسخ به نظر با موفقیت حذف شد',
    'comment_deleted_successfully' => 'نظر با موفقیت حذف شد',
    'comment_added_successfully' => 'نظر با موفقیت اضافه شد',

    /** userProfile Api */
    'invalid_base64_image' => 'مقدار Base64 تصویر معتبر نیست',
    'demo_version' => 'این نسخه آزمایشی است. لطفاً برای استفاده از ویژگی‌های کامل، برنامه را خریداری کنید',
    'user_not_found' => 'جزئیات کاربر پیدا نشد',
    'profile_updated' => 'پروفایل با موفقیت به‌روزرسانی شد',
    'incorrect_current_password' => 'رمز عبور فعلی اشتباه است',
    'new_password_same_as_old' => 'رمز عبور جدید نمی‌تواند همان رمز عبور قدیمی باشد',
    'password_changed' => 'رمز عبور با موفقیت تغییر کرد',


    /** leave_approval */
    'leave_approval'=>'تأیید مرخصی',
    'leave_approval_list'=>'لیست تأیید مرخصی',
    'add_leave_approval'=>'افزودن تأیید مرخصی',
    'subject'=>'موضوع',
    'related'=>'مرتبط',
    'select_related'=>'انتخاب مرتبط',
    'max_days_to_sign'=>'حداکثر تعداد روزهای امضا',
    'notification_recipient'=>'دریافت‌کننده اطلاعیه',
    'select_notification_recipient'=>'انتخاب دریافت‌کننده اطلاعیه',
    'approval_process' =>'فرآیند تأیید',
    'approver'=>'تأییدکننده',
    'select_approver'=>'انتخاب تأییدکننده',
    'head_of_department'=>'رئیس بخش',
    'specific_personnel'=>'پرسنل خاص',
    'applicable_from'=>'قابل اجرا از',

    /** Event Management */
    'event_section'=>'بخش رویداد',
    'event_title'=>'عنوان رویداد',
    'event_location'=>'محل رویداد',
    'event_start_date'=>'تاریخ شروع رویداد',
    'event_start_time'=>'زمان شروع رویداد',
    'event_end_date'=>'تاریخ پایان رویداد',
    'event_end_time'=>'زمان پایان رویداد',
    'all_departments'=>'تمام بخش‌ها',
    'delete_event_confirmation'=>'آیا مطمئن هستید که می‌خواهید این رویداد را حذف کنید؟',
    'create_event'=>'ایجاد رویداد',
    'show_event'=>'نمایش رویداد',
    'enter_event_title'=>'عنوان رویداد را وارد کنید',
    'edit_event_detail'=>'ویرایش جزئیات رویداد',
    'delete_event'=>'حذف رویداد',
    'event_calendar'=>'تقویم رویدادها',

    /** Training Management */
    'training_types'=>'انواع آموزش',
    'select_training_type'=>'انتخاب نوع آموزش',
    'training'=>'آموزش',
    'select_trainer'=>'انتخاب مربی',
    'trainer'=>'مربی',
    'add_trainer'=>'افزودن مربی',
    'add_training'=>'افزودن آموزش',
    'trainer_lists'=>'لیست مربیان',
    'training_list'=>'لیست آموزش‌ها',
    'total_training'=>'مجموع آموزش‌ها',
    'training_type'=>'نوع آموزش',
    'training_management'=>'مدیریت آموزش',
    'add_training_types'=>'افزودن انواع آموزش',
    'training_date'=>'تاریخ آموزش',
    'trainer_type'=>'نوع مربی',
    'select_trainer_type'=>'انتخاب نوع مربی',
    'expertise' =>'حوزه تخصص',
    'certificate' =>'گواهینامه',
    'contact_number' =>'شماره تماس',
    'training_for' =>'آموزش برای',
    'time' =>'زمان',
    'updated_by' =>'به‌روزرسانی شده توسط',

    'select_task' => 'انتخاب وظیفه',
    'event_host' =>'میزبان رویداد',
    'host' =>'میزبان',
    'location' =>'موقعیت مکانی',
    'event_list'=>'لیست رویدادها',
    'total_tasks'=>'کل وظایف',
    'applicable_to_tax_report'=>'اجزای حقوقی که برای همه قابل اعمال هستند، در گزارش مالیاتی استفاده خواهند شد.',

    'no_departments_found'=>'بخشی یافت نشد',
    'error_loading_departments'=>'خطا در بارگذاری بخش‌ها',
    'no_employees_found'=>'کارمندی یافت نشد',
    'update_send' => 'به‌روزرسانی و ارسال اطلاعیه',
    'create_send' => 'ایجاد و ارسال اطلاعیه',


    'admin_permission_msg' => 'اگر این گزینه انتخاب شود، تمام مراحل سلسله‌مراتبی کنار گذاشته می‌شوند و کاربران دارای این نقش می‌توانند تمام مرخصی‌ها را مشاهده و ویرایش کنند. این گزینه را برای نقش‌های خاص مانند منابع انسانی نگه دارید',
    'coming_soon' => 'به زودی',
    'assign_trainer_section' => 'بخش تخصیص مربی',
    'assign_trainer' => 'تخصیص مربی',


];
