<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('employee_payslip_additional_details', function (Blueprint $table) {
            $table->id();
            $table->foreignId('employee_payslip_id')->constrained('employee_payslips');
            $table->unsignedBigInteger('salary_component_id');
            $table->double('amount',10,2);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('employee_payslip_additional_details');
    }
};
