<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Authentication Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines are used during authentication for various
    | messages that we need to display to the user. You are free to modify
    | these language lines according to your application's requirements.
    |
    */
    /** dashboard */
    'welcome' => 'مرحبًا بك في لوحة حضور الموظفين',
    'total_employees' => 'إجمالي الموظفين',
    'total_departments' => 'إجمالي الأقسام',
    'total_holidays' => 'إجمالي الإجازات',
    'paid_leaves' => 'الإجازات المدفوعة',
    'on_leave_today' => 'في إجازة اليوم',
    'pending_leave_requests' => 'طلبات الإجازة المعلقة',
    'total_check_in_today' => 'إجمالي تسجيلات الدخول اليوم',
    'total_check_out_today' => 'إجمالي تسجيلات الخروج اليوم',
    'projects_detail' => 'تفاصيل المشاريع',
    'total_projects' => 'إجمالي المشاريع',
    'pending_projects' => 'المشاريع المعلقة',
    'on_hold_projects' => 'المشاريع المتوقفة',
    'in_progress_projects' => 'المشاريع قيد التقدم',
    'finished_projects' => 'المشاريع المنتهية',
    'cancelled_projects' => 'المشاريع الملغاة',
    'top_clients' => 'أهم العملاء',
    'task_details' => 'تفاصيل المهام',
    'recent_projects' => 'المشاريع الأخيرة',
    'title' => 'العنوان',
    'date_start' => 'تاريخ البدء',
    'deadline' => 'الموعد النهائي',
    'leader' => 'قائد المشروع',
    'completion' => 'الاكتمال',
    'priority' => 'الأولوية',
    'check_in_at' => 'تسجيل الدخول في',
    'check_out_at' => 'تسجيل الخروج في',
    'punch_in' => 'تسجيل الدخول',
    'punch_out' => 'تسجيل الخروج',
    'no_records_found' => 'لم يتم العثور على سجلات!',
    'project_management' => 'إدارة المشاريع',
    'view_all_clients' => 'عرض جميع العملاء',
    'view_all_projects' => 'عرض جميع المشاريع',
    'error_message' => 'خطأ: لم يمكن معالجة الطلب.',
    'success_message' => 'نجاح: تمت العملية بنجاح.',
    'name' => 'الاسم',
    'email' => 'البريد الإلكتروني',
    'contact' => 'الاتصال',
    'project' => 'المشروع',
    'pending' => 'معلق',
    'on_hold' => 'في الانتظار',
    'in_progress' => 'قيد التنفيذ',
    'completed' => 'مكتمل',
    'cancelled' => 'ملغى',
    'search_menu' => 'قائمة البحث',


    /** nav */
    'latest_notifications' => 'أحدث الإشعارات',
    'view_all' => 'عرض الكل',
    'profile' => 'الملف الشخصي',
    'edit_profile' => 'تعديل الملف الشخصي',
    'request_leave' => 'طلب إجازة',
    'log_out' => 'تسجيل الخروج',
    'light_mode' => 'الوضع الفاتح',
    'dark_mode' => 'الوضع الداكن',

    /** menu */
    'dashboard' => 'لوحة التحكم',
    'company_management' => 'إدارة الشركة',
    'company' => 'الشركة',
    'branch' => 'الفرع',
    'department' => 'القسم',
    'post' => 'المنصب',
    'employee_management' => 'إدارة الموظفين',
    'employees' => 'الموظفين',
    'logout_requests' => 'طلبات تسجيل الخروج',
    'attendance_section' => 'قسم الحضور',
    'clients' => 'العملاء',
    'task_management' => 'إدارة المهام',
    'holidays' => 'الإجازات',
    'notice' => 'الإشعارات',
    'payroll_management' => 'إدارة الرواتب',
    'payroll' => 'الرواتب',
    'payroll_setting' => 'إعدادات الرواتب',
    'advance_salary' => 'الراتب المقدم',
    'employee_salary' => 'راتب الموظف',
    'leave' => 'الإجازة',
    'team_meeting' => 'اجتماع الفريق',
    'tada' => 'تادا',
    'shift_management' => 'إدارة الورديات',
    'office_time' => 'وقت المكتب',
    'award_management' => 'إدارة الجوائز',
    'award_types' => 'أنواع الجوائز',
    'awards' => 'الجوائز',
    'asset_management' => 'إدارة الأصول',
    'asset_types' => 'أنواع الأصول',
    'assets' => 'الأصول',
    'content_management' => 'إدارة المحتوى',
    'support' => 'الدعم',
    'attendance_methods' => 'طرق الحضور',
    'routers' => 'أجهزة التوجيه',
    'qr' => 'رمز الاستجابة السريعة',
    'nfc' => 'الاتصال قريب المدى',
    'settings' => 'الإعدادات',
    'roles_permissions' => 'الأدوار والأذونات',
    'general_settings' => 'الإعدادات العامة',
    'app_settings' => 'إعدادات التطبيق',
    'notifications' => 'الإشعارات',
    'payment_currency' => 'عملة الدفع',
    'feature_control' => 'التحكم في الميزات',
    'salary_component' => 'مكون الراتب',
    'salary_group' => 'مجموعة الراتب',
    'salary_tds' => 'ضريبة الراتب',
    'overtime' => 'وقت إضافي',
    'undertime' => 'تحت الوقت',
    'payment_method' => 'طريقة الدفع',
    'leave_types' => 'أنواع الإجازات',
    'leave_request' => 'طلب إجازة',
    'time_leave_request' => 'طلب إجازة بالوقت',

    /** company */
    'company_profile' => 'ملف الشركة',
    'update_company' => 'تحديث الشركة',
    'create_company' => 'إنشاء شركة',
    'company_name' => 'اسم الشركة',
    'company_owner' => 'مالك الشركة',
    'address' => 'العنوان',
    'email_address' => 'البريد الإلكتروني',
    'phone_no' => 'رقم الهاتف',
    'website_url' => 'رابط الموقع',
    'check_office_off_days' => 'تحقق من أيام عطلة المكتب',
    'upload_logo' => 'تحميل الشعار',
    'update' => 'تحديث',
    'save' => 'حفظ',

    /** Branch */
    'title_branch' => 'الفرع',
    'branch_section' => 'قسم الفرع',
    'branches' => 'الفروع',
    'add_branch' => 'إضافة فرع',
    'branch_lists' => 'قوائم الفروع',
    'search_by_branch_name' => 'البحث باسم الفرع',
    'filter' => 'تصفية',
    'reset' => 'إعادة تعيين',
    'phone' => 'الهاتف',
    'total_employee' => 'إجمالي الموظفين',
    'action' => 'الإجراء',
    'are_you_sure_change_status' => 'هل أنت متأكد أنك تريد تغيير الحالة؟',
    'are_you_sure_delete_branch' => 'هل أنت متأكد أنك تريد حذف الفرع؟',
    'branch_create' => 'إنشاء فرع',
    'branch_update' => 'تحديث الفرع',
    'branch_name' => 'اسم الفرع',
    'required_field' => 'حقل مطلوب',
    'branch_head' => 'رئيس الفرع',
    'select_branch_head' => 'اختر رئيس الفرع',
    'phone_number' => 'رقم الهاتف',
    'branch_location_latitude' => 'خط عرض موقع الفرع',
    'enter_branch_location_latitude' => 'أدخل خط عرض موقع الفرع',
    'branch_location_longitude' => 'خط طول موقع الفرع',
    'enter_branch_location_longitude' => 'أدخل خط طول موقع الفرع',
    'status' => 'الحالة',
    'select_status' => 'اختر الحالة',
    'active' => 'نشط',
    'inactive' => 'غير نشط',
    'create' => 'إنشاء',

    /** Department */
    'department_section' => 'قسم القسم',
    'departments' => 'الأقسام',
    'add_department' => 'إضافة قسم',
    'department_lists' => 'قوائم الأقسام',
    'search_by_department_name' => 'البحث باسم القسم',
    'select_branch' => 'اختر الفرع',
    'edit' => 'تحرير',
    'delete' => 'حذف',
    'are_you_sure_delete_department' => 'هل أنت متأكد أنك تريد حذف القسم؟',
    'edit_department' => 'تحرير القسم',
    'button_back' => 'الرجوع',
    'breadcrumb' => 'مسار التنقل',
    'update_department' => 'تحديث القسم',
    'create_department' => 'إنشاء قسم',
    'department_name' => 'اسم القسم',
    'department_head' => 'رئيس القسم',
    'select_department_head' => 'اختر رئيس القسم',
    'create_update_department' => 'إنشاء/تحديث القسم',

    /** Post */
    'post_section' => 'قسم الوظيفة',
    'posts' => 'الوظائف',
    'add_post' => 'إضافة وظيفة',
    'search_by_department' => 'البحث بالقسم',
    'search_by_post_name' => 'البحث باسم الوظيفة',
    'post_name' => 'اسم الوظيفة',
    'post_empty' => 'لا توجد وظائف',
    'edit_post_title' => 'تحرير الوظيفة',
    'create_post_title' => 'إنشاء وظيفة',
    'department_label' => 'القسم',
    'post_name_label' => 'اسم الوظيفة',
    'status_label' => 'الحالة',
    'select_department' => 'اختر القسم',
    'active_option' => 'نشط',
    'inactive_option' => 'غير نشط',
    'update_update_button' => 'تحديث الوظيفة',
    'change_status_confirmation' => 'هل أنت متأكد أنك تريد تغيير الحالة؟',
    'delete_post_confirmation' => 'هل أنت متأكد أنك تريد حذف الوظيفة؟',
    'employee_list_title' => 'قائمة الموظفين',

    /** Employee List */
    'employees_title' => 'الموظفين',
    'employees_action' => 'القوائم',
    'add_employee' => 'إضافة موظف',
    'employee_section' => 'قسم الموظفين',
    'employee_create' => 'إنشاء موظف',
    'employee_name' => 'اسم الموظف',
    'employee_email' => 'البريد الإلكتروني للموظف',
    'employee_phone' => 'رقم هاتف الموظف',
    'full_name' => 'الاسم الكامل',
    'designation' => 'التعيين',
    'role' => 'الدور',
    'shift' => 'الوردية',
    'workplace' => 'مكان العمل',
    'is_active' => 'نشط',
    'edit_detail' => 'تحرير التفاصيل',
    'delete_user' => 'حذف المستخدم',
    'change_password' => 'تغيير كلمة المرور',
    'force_logout' => 'تسجيل خروج إجباري',
    'all_fields_required' => 'جميع الحقول (<span style="color: red">*</span>) مطلوبة',
    'personal_detail' => 'تفاصيل شخصية',
    'employee_code' => 'رمز الموظف',
    'enter_name' => 'أدخل الاسم',
    'enter_employee_address' => 'أدخل عنوان الموظف',
    'enter_email' => 'أدخل البريد الإلكتروني',
    'dob' => 'تاريخ الميلاد',
    'gender' => 'الجنس',
    'select_gender' => 'اختر الجنس',
    'marital_status' => 'الحالة الاجتماعية',
    'choose_marital_status' => 'اختر الحالة الاجتماعية',
    'upload_avatar' => 'تحميل الصورة الرمزية',
    'description' => 'الوصف',
    'username' => 'اسم المستخدم',
    'enter_username' => 'أدخل اسم المستخدم',
    'password' => 'كلمة المرور',
    'enter_password' => 'أدخل كلمة المرور',
    'select_role' => 'اختر الدور',
    'company_detail' => 'تفاصيل الشركة',
    'supervisor' => 'المشرف',
    'employment_type' => 'نوع التوظيف',
    'select_employment_type' => 'اختر نوع التوظيف',
    'joining_date' => 'تاريخ الانضمام',
    'enter_joining_date' => 'أدخل تاريخ الانضمام',
    'workspace' => 'مكان العمل',
    'select_workspace' => 'اختر مكان العمل',
    'field' => 'ميدان',
    'office' => 'مكتب',
    'leave_detail' => 'تفاصيل الإجازة',
    'leave_allocated' => 'الإجازة المخصصة',
    'assigned_leaves' => 'الإجازات المخصصة',
    'no_of_days' => 'عدد الأيام',
    'total_leave_days' => 'إجمالي أيام الإجازة',
    'bank_detail' => 'تفاصيل البنك',
    'bank_name' => 'اسم البنك',
    'bank_account_number' => 'رقم الحساب البنكي',
    'account_holder_name' => 'اسم صاحب الحساب',
    'bank_account_type' => 'نوع الحساب البنكي',
    'select_account_type' => 'اختر نوع الحساب',
    'create_user' => 'إنشاء مستخدم',
    'update_user' => 'تحديث المستخدم',
    'new_password' => 'كلمة مرور جديدة',
    'enter_new_password' => 'أدخل كلمة مرور جديدة',
    'confirm_password' => 'تأكيد كلمة المرور',
    'confirm_password_placeholder' => 'تأكيد كلمة المرور',
    'submit' => 'إرسال',
    'user_change_password' => 'تغيير كلمة المرور للمستخدم',
    'confirm_delete_employee' => 'هل أنت متأكد أنك تريد حذف الموظف؟',
    'confirm_force_logout' => 'هل أنت متأكد أنك تريد إجبار المستخدم على تسجيل الخروج؟',
    'confirm_change_workplace' => 'هل أنت متأكد أنك تريد تغيير مكان العمل؟',
    'select_supervisor' => 'اختر المشرف',
    'select_office_time' => 'اختر وقت المكتب',
    'select_option' => 'اختر خيارًا',
    'enter_address' => 'يرجى إدخال العنوان.',
    'enter_valid_email' => 'يرجى إدخال عنوان بريد إلكتروني صالح.',
    'enter_phone_number' => 'يرجى إدخال رقم الهاتف.',
    'create_employee' => 'إنشاء موظف',
    'add' => 'إضافة',
    'edit_user_detail' => 'تحرير تفاصيل المستخدم',
    'show_user_details' => 'عرض تفاصيل المستخدم',
    'detail' => 'تفاصيل',
    'back' => 'عودة',
    'user_detail' => 'تفاصيل المستخدم',
    'date_of_birth' => 'تاريخ الميلاد',
    'not_applicable' => 'غير قابل للتطبيق',
    'office_detail' => 'تفاصيل المكتب',
    'home' => 'منزل',
    'account_detail' => 'تفاصيل الحساب',
    'account_number' => 'رقم الحساب',
    'account_type' => 'نوع الحساب',
    'account_holder' => 'صاحب الحساب',
    'not_available' => 'غير متوفر',

    /** logout requests */
    'logout_request_status' => 'حالة طلب تسجيل الخروج',
    'take_action' => 'اتخاذ إجراء',
    'confirm_accept_logout_request' => 'هل أنت متأكد أنك تريد قبول طلب تسجيل الخروج؟',

    /** attendance */
    'attendance' => 'الحضور',
    'employee_attendance_lists' => 'قوائم حضور الموظفين',
    'attendance_of_the_day' => 'حضور اليوم',
    'date_placeholder_bs' => 'سنة/شهر/يوم',
    'csv_export' => 'تصدير CSV',
    'attendance_status' => 'حالة الحضور',
    'attendance_by' => 'الحضور بواسطة',
    'show_detail' => 'عرض التفاصيل',
    'show_checkin_location' => 'عرض موقع تسجيل الدخول',
    'show_checkout_location' => 'عرض موقع تسجيل الخروج',
    'checkin' => 'تسجيل الدخول',
    'checkout' => 'تسجيل الخروج',
    'approved' => 'موافَق',
    'rejected' => 'مرفوض',
    'self' => 'ذاتي',
    'admin' => 'مسؤول',
    'edit_attendance_time' => 'تحرير وقت الحضور',
    'employee_attendance_detail' => 'تفاصيل حضور الموظف',
    'attendance_of' => 'حضور',
    'total_days_in_month' => 'إجمالي الأيام في الشهر',
    'present_days' => 'أيام الحضور',
    'absent_days' => 'أيام الغياب',
    'weekend_days' => 'أيام نهاية الأسبوع',
    'holiday_days' => 'أيام العطلة',
    'leave_days' => 'أيام الإجازة',
    'working_hours' => 'ساعات العمل',
    'worked_hours' => 'الساعات التي تم العمل بها',
    'attendance_details_of' => 'تفاصيل الحضور لشهر :month',
    'all_month' => 'كل الشهر',
    'worked_hour' => 'ساعة العمل',
    'add_attendance_time' => 'إضافة وقت الحضور',
    'confirm_change_attendance_status' => 'هل أنت متأكد أنك تريد تغيير حالة الحضور؟',
    'check_in' => 'تسجيل الدخول',
    'check_out' => 'تسجيل الخروج',
    'attendance_title' => 'الحضور',
    'attendance_action' => 'تفاصيل حضور الموظف',
    'filter_placeholder' => 'سنة الحضور على سبيل المثال: :min_year',
    'filter_button' => 'تصفية',
    'csv_export_button' => 'تصدير CSV',
    'reset_button' => 'إعادة تعيين',
    'total_days' => 'إجمالي الأيام في الشهر',
    'attendance_details' => 'تفاصيل الحضور لـ :monthName',
    'date' => 'تاريخ',
    'change_attendance_status' => 'تغيير حالة الحضور',
    'create_attendance' => 'إنشاء حضور',
    'admin_remark' => 'ملاحظة المسؤول',
    'edit_attendance' => 'تحرير الحضور',
    'admin_edit_remark' => 'ملاحظة تحرير المسؤول',
    'confirm_check_in' => 'هل أنت متأكد أنك تريد تسجيل دخول الموظف؟',
    'confirm_check_out' => 'هل أنت متأكد أنك تريد تسجيل خروج الموظف؟',
    'edit_attendance_title' => 'تحرير حضور (:name) في وقت :date',
    'create_attendance_title' => 'إنشاء حضور (:name) في وقت :date',
    'total_worked_hours' => 'إجمالي ساعات العمل',
    'attendance_report' => 'تقرير الحضور',

    /** clients */
    'client_listing' => 'قائمة العملاء',
    'add_client' => 'إضافة عميل',
    'client_name' => 'اسم العميل',
    'client_email' => 'بريد العميل الإلكتروني',
    'edit_client_detail' => 'تعديل تفاصيل العميل',
    'show_client_detail' => 'عرض تفاصيل العميل',
    'delete_client_detail' => 'حذف تفاصيل العميل',
    'client_invoices' => 'فواتير العميل',
    'client_detail' => 'تفاصيل العميل:',
    'client_project_lists' => 'قوائم مشاريع العميل:',
    'country' => 'البلد',
    'edit_client' => 'تعديل العميل',
    'create_client' => 'إنشاء عميل',
    'client_section' => 'قسم العملاء',
    'client_contact' => 'رقم اتصال العميل',
    'client_address' => 'العنوان',
    'client_country' => 'البلد',
    'upload_profile' => 'تحميل ملف تعريف العميل',
    'enter_client_name' => 'أدخل اسم العميل',
    'enter_client_email' => 'أدخل بريد العميل',
    'enter_contact_number' => 'أدخل رقم الاتصال',
    'enter_client_address' => 'أدخل عنوان العميل',
    'enter_country' => 'أدخل البلد',
    'confirm_status_change' => 'هل أنت متأكد أنك تريد تغيير الحالة؟',
    'confirm_delete_client' => 'هل أنت متأكد أنك تريد حذف تفاصيل العميل؟',

    /** Project management */
    'lists' => 'قوائم',
    'create_project' => 'إنشاء مشروع',
    'project_filter' => 'مرشح المشروع',
    'search_by_project' => 'البحث حسب المشروع',
    'search_by_status' => 'البحث حسب الحالة',
    'search_by_priority' => 'البحث حسب الأولوية',
    'client' => 'العميل',
    'all_tasks' => 'جميع المهام',
    'completed_tasks' => 'المهام المكتملة',
    'days_left' => 'الأيام المتبقية',
    'team_member' => 'عضو الفريق',
    'start_date' => 'تاريخ البدء',
    'due_date' => 'تاريخ الاستحقاق',
    'view' => 'عرض',
    'projects' => 'المشاريع',
    'assign_employee' => 'تعيين موظف',
    'client_contact_number' => 'رقم اتصال العميل',
    'upload_client_profile' => 'تحميل ملف تعريف العميل',
    'project_name' => 'اسم المشروع',
    'project_start_date' => 'تاريخ بدء المشروع',
    'project_deadline' => 'الموعد النهائي للمشروع',
    'project_status' => 'حالة المشروع',
    'select_project_status' => 'اختر حالة المشروع',
    'project_cost' => 'تكلفة المشروع',
    'select_priority' => 'اختر الأولوية',
    'estimated_hours' => 'الساعات المقدرة',
    'select_client' => 'اختر العميل',
    'upload_project_logo' => 'تحميل شعار المشروع',
    'uploaded_files_images' => 'الملفات والصور المحملة',
    'no_project_file_uploaded' => 'لم يتم تحميل ملف المشروع',
    'update_project' => 'تحديث المشروع',
    'project_leader' => 'قائد المشروع',
    'assign_member' => 'تعيين عضو',
    'edit_project' => 'تحرير المشروع',
    'project_document' => 'مستند المشروع',
    'upload_documents' => 'تحميل المستندات',
    'upload_project_attachments' => 'تحميل مرفقات المشروع',
    'show_project_detail' => 'عرض تفاصيل المشروع',
    'upload_attachments' => 'تحميل المرفقات',
    'project_attachments' => 'مرفقات المشروع',
    'uploaded_image_files' => 'ملفات الصور المحملة',
    'no_project_image_found' => 'لم يتم العثور على صورة للمشروع',
    'uploaded_files' => 'الملفات المحملة',
    'no_project_files_found' => 'لم يتم العثور على ملفات للمشروع',
    'project_tasks_lists' => 'قوائم مهام المشروع',
    'project_summary' => 'ملخص المشروع',
    'cost' => 'التكلفة:',
    'total_hours' => 'إجمالي الساعات:',
    'created' => 'تم الإنشاء:',
    'remaining_days' => 'الأيام المتبقية:',
    'project_leaders' => 'قادة المشروع',
    'update_leader' => 'تحديث القائد',
    'project_members' => 'أعضاء المشروع',
    'update_member' => 'تحديث العضو',
    'project_client_detail' => 'تفاصيل عميل المشروع',
    'delete_project_detail' => 'هل أنت متأكد أنك تريد حذف تفاصيل المشروع؟',
    'delete_project_document' => 'هل أنت متأكد أنك تريد حذف مستند المشروع؟',
    'search_by_member' => 'البحث حسب العضو',
    'add_employee_to_project' => 'إضافة موظف إلى المشروع',

    /** Task management */
    'tasks' => 'المهام',
    'task_filter' => 'تصفية المهام',
    'search_by_task_name' => 'البحث بواسطة اسم المهمة',
    'not_started' => 'لم تبدأ بعد',
    'create_tasks' => 'إنشاء مهام',
    'end_date' => 'تاريخ الانتهاء',
    'task_name' => 'اسم المهمة',
    'enter_task_name' => 'أدخل اسم المهمة',
    'select_project' => 'اختر المشروع',
    'task_start_date' => 'تاريخ بدء المهمة',
    'task_start_time' => 'وقت بدء المهمة',
    'task_end_date' => 'تاريخ انتهاء المهمة',
    'task_end_time' => 'وقت انتهاء المهمة',
    'task_status' => 'حالة المهمة',
    'select_task_status' => 'اختر حالة المهمة',
    'uploaded_files_and_images' => 'الملفات والصور المرفوعة',
    'task_attachments' => 'مرفقات المهمة',
    'update_task' => 'تحديث المهمة',
    'create_task' => 'إنشاء مهمة',
    'mention' => 'أشر',
    'comment' => 'تعليق',
    'close' => 'إغلاق',
    'write_comment' => 'أكتب تعليقاً',
    'reply' => 'رد',
    'delete_confirm' => 'هل أنت متأكد أنك تريد حذف :title ؟',
    'task_member_placeholder' => 'تعيين عضو للمهمة',
    'project_placeholder' => 'اختر المشروع',
    'project_filter_placeholder' => 'البحث بواسطة المشروع',
    'task_name_placeholder' => 'البحث بواسطة اسم المهمة',
    'change_task_status_confirm' => 'هل أنت متأكد أنك تريد تغيير حالة المهمة النشطة؟',
    'change_status_confirm' => 'هل أنت متأكد أنك تريد تغيير الحالة؟',
    'delete_task_detail_confirm' => 'هل أنت متأكد أنك تريد حذف تفاصيل المهمة؟',
    'create_checklist_text' => 'إنشاء قائمة تدقيق',
    'close_checklist_text' => 'إغلاق',
    'remove_checklist_text' => 'إزالة',
    'remove_checklist_title' => 'إزالة القائمة',
    'view_all_comments' => 'عرض جميع التعليقات',
    'comments' => 'تعليقات',
    'edit_task' => 'تعديل المهمة',
    'edit_task_detail' => 'تعديل تفاصيل المهمة',
    'show_task_detail' => 'عرض تفاصيل المهمة',
    'task_edit' => 'تعديل المهمة',
    'create_checklist' => 'إنشاء قائمة تدقيق',
    'upload_attachment' => 'رفع مرفق',
    'total_checklist' => 'إجمالي القوائم التدقيق',
    'completed_checklist' => 'القوائم التدقيق المكتملة',
    'task_checklist_lists' => 'قوائم تدقيق المهام',
    'assigned_to' => 'مخصص لـ',
    'create_task_checklist' => 'إنشاء قائمة تدقيق للمهمة',
    'enter_checklist_title' => 'أدخل عنوان القائمة التدقيقية',
    'select_member' => 'اختر العضو',
    'add_more_checklist' => 'إضافة المزيد من القوائم التدقيقية',
    'image' => 'صورة',
    'file' => 'ملف',
    'edit_checklist' => 'تعديل القائمة التدقيقية',
    'delete_checklist' => 'حذف القائمة التدقيقية',
    'checklist' => 'قائمة تدقيق',
    'edit_task_checklist' => 'تعديل قائمة تدقيق المهمة',
    'checklist_name' => 'اسم القائمة التدقيقية',
    'assign_task_checklist' => 'تعيين قائمة تدقيق للمهمة',
    'task_summary' => 'ملخص المهمة',
    'task_members' => 'أعضاء المهمة',
    'task_attachment_title' => 'مرفق المهمة',
    'upload_attachment_action' => 'رفع مرفق',
    'upload_task_attachments' => 'رفع مرفقات المهمة',
    'upload_task_attachments_text' => 'رفع مرفقات المهمة',
    'choose_file_text' => 'اختر ملف',

    /** Holiday */
    'holiday_section' => 'قسم العطلة',
    'event' => 'الحدث',
    'event_date' => 'تاريخ الحدث',
    'is_public_holiday' => 'هل هو عطلة عامة؟',
    'confirm_delete_holiday' => 'هل أنت متأكد أنك تريد حذف تفاصيل العطلة؟',
    'holiday_detail_title' => 'تفاصيل العطلة',
    'holiday' => 'العطلة',
    'csv_import' => 'استيراد CSV',
    'import' => 'استيراد',
    'holiday_detail_csv' => 'تفاصيل العطلة من CSV',
    'holiday_csv_example' => 'مثال على CSV للعطلات',
    'add_holiday' => 'إضافة عطلة',
    'import_holiday_csv' => 'استيراد CSV للعطلات',
    'holiday_filter' => 'تصفية العطلات',
    'event_name' => 'اسم الحدث',
    'leave_requested_year' => 'سنة الإجازة المطلوبة',
    'holiday_detail' => 'تفاصيل العطلة',

    /** Notice */
    'notices_section' => 'قسم الإشعارات',
    'notice_title' => 'عنوان الإشعار',
    'notice_description' => 'وصف الإشعار',
    'notice_receiver' => 'مستلم الإشعار',
    'send_notice' => 'إرسال الإشعار',
    'all_employees' => 'جميع الموظفين',
    'create_notice' => 'إنشاء إشعار',
    'edit_notice' => 'تعديل الإشعار',
    'notices' => 'الإشعارات',
    'receiver' => 'المستلم',
    'published_from' => 'نشر من',
    'publish_to' => 'نشر إلى',
    'publish_date' => 'تاريخ النشر',
    'show_notice_content' => 'عرض محتوى الإشعار',
    'delete_notice_detail' => 'حذف تفاصيل الإشعار',
    'notice_lists' => 'قوائم الإشعارات',
    'confirm_change_notice_status' => 'هل أنت متأكد أنك تريد تغيير حالة الإشعار؟',
    'confirm_delete_notice' => 'هل أنت متأكد أنك تريد حذف الإشعار؟',
    'confirm_send_notice' => 'هل أنت متأكد أنك تريد إرسال الإشعار؟',
    'notice_detail_modal_title' => 'تفاصيل الإشعار :title',

    /** payroll */
    'employee_payroll' => 'رواتب الموظفين',
    'payroll_generate' => 'توليد الرواتب',
    'payroll_create' => 'إنشاء الرواتب',
    'payroll_edit' => 'تحرير الرواتب',
    'select_year' => 'اختر السنة',
    'salary_cycle' => 'دورة الراتب',
    'salary_month' => 'شهر الراتب',
    'salary_week' => 'أسبوع الراتب',
    'select_week' => 'اختر الأسبوع',
    'include_tada' => 'تضمين TADA',
    'include_advance_salary' => 'تضمين الراتب المقدم',
    'use_attendance' => 'استخدام الحضور',
    'generate' => 'توليد',
    'clear' => 'مسح',
    'report' => 'تقرير:',
    'duration' => 'المدة',
    'payroll_summary' => 'ملخص الرواتب',
    'total_basic_salary' => 'إجمالي الراتب الأساسي:',
    'total_net_salary' => 'إجمالي الراتب الصافي:',
    'total_allowance' => 'إجمالي البدلات:',
    'total_deduction' => 'إجمالي الاستقطاعات:',
    'total_overtime' => 'إجمالي العمل الإضافي:',
    'total_undertime' => 'إجمالي العمل الناقص:',
    'paid_by' => 'دفع بواسطة',
    'net_salary' => 'صافي الراتب',
    'paid_on' => 'تم الدفع في',
    'pay_button' => 'دفع',
    'select_payment_method.' => 'يرجى اختيار طريقة الدفع.',
    'confirm_delete_payroll' => 'هل أنت متأكد أنك تريد حذف رواتب الموظف؟',
    'confirm_generate_payroll' => 'هل أنت متأكد أنك تريد توليد الرواتب؟',
    'confirm_change_cycle' => 'هل أنت متأكد أنك تريد تغيير دورة الراتب؟',
    'payment_title' => 'إجراء الدفع',
    'payment_method_placeholder' => 'اختر طريقة الدفع',
    'payment_date' => 'تاريخ الدفع',
    'hourly_rate' => 'سعر الساعة',
    'hourly' => 'ساعياً',
    'working_hours_in_week' => 'ساعات العمل في الأسبوع',
    'annual_salary' => 'الراتب السنوي (CTC)',
    'annual' => 'سنوي',
    'basic_salary' => 'الراتب الأساسي',
    'fixed_allowance' => 'البدلات الثابتة',
    'total' => 'الإجمالي',
    'net_total' => 'الإجمالي الصافي',
    'earnings' => 'الأرباح',
    'deductions' => 'الخصومات',
    'create_salary' => 'إنشاء الراتب',
    'edit_salary' => 'تحرير الراتب',
    'add_salary' => 'إضافة الراتب',
    'calculation_type' => 'نوع الحساب',
    'monthly_amount' => 'المبلغ الشهري',
    'annual_amount' => 'المبلغ السنوي',
    'salary_slip' => 'قائمة الرواتب',
    'edit_salary_slip' => 'تحرير قائمة الرواتب',
    'payslip' => 'إيصال الرواتب',
    'for_the_month_of' => 'لشهر',
    'from' => 'من',
    'to' => 'إلى',
    'employee_id' => 'معرف الموظف',
    'earning' => 'الأرباح',
    'deduction' => 'الخصم',
    'actual_salary' => 'الراتب الفعلي',
    'total_earning' => 'إجمالي الأرباح',
    'actual_salary_formula' => '(إجمالي الأرباح - إجمالي الخصومات)',
    'bonus' => 'المكافأة',
    'taxable_salary' => 'الراتب الخاضع للضريبة',
    'taxable_salary_formula' => '(الراتب الفعلي + المكافأة)',
    'tax' => 'الضريبة',
    'salary_after_tax' => 'الراتب بعد الضريبة',
    'expenses_claim' => 'مطالبات النفقات (TADA)',
    'absent' => 'غائب',
    'absent_deduction_formula' => '((grossSalary / عدد الأيام الكلي) * عدد أيام الغياب)',
    'net_salary_formula' => 'صافي الراتب = (الراتب الفعلي - الراتب المقدم + TADA)',
    'monthly' => 'شهرياً',
    'weekly' => 'أسبوعياً',
    'salary_increment' => 'زيادة الراتب',
    'increment' => 'زيادة',
    'current_salary' => 'الراتب الحالي',
    'annual_increment_percent' => 'النسبة السنوية للزيادة %',
    'annual_increment_amount' => 'مبلغ الزيادة السنوية',
    'revised_salary_label' => 'الراتب المعدل',
    'fiscal_year_label' => 'الزيادة للسنة المالية',
    'applicable_from_label' => 'تسري من (التاريخ)',
    'applicable_to_label' => 'تسري حتى (التاريخ)',
    'remark' => 'ملاحظة',
    'fiscal_year' => 'السنة المالية',
    'select_fiscal_year' => 'اختر السنة المالية',
    'list' => 'قائمة',
    'employee_salary_filter' => 'فلتر رواتب الموظفين',
    'salary_review_history' => 'سجل مراجعة الرواتب',
    'increase_salary' => 'زيادة الراتب',
    'all' => 'الكل',
    'employee_payslip' => 'إيصال رواتب الموظف',
    'salary_from' => 'الراتب من',
    'salary_to' => 'الراتب إلى',
    'unpaid_leave' => 'إجازة غير مدفوعة',
    'paid_leave' => 'إجازة مدفوعة',
    'employee_gross_salary' => 'إجمالي راتب الموظف',
    'salary_increment_log' => 'سجل زيادة الراتب',
    'log' => 'سجل',
    'salary_revised_on' => 'الراتب المعدل في',
    'increment_by' => 'زيادة بواسطة',
    'increment_value' => 'قيمة الزيادة',
    'old_salary' => 'الراتب القديم',
    'new_salary' => 'الراتب الجديد',
    'date_to' => 'التاريخ إلى',
    'date_from' => 'التاريخ من',
    'salary_increment_remark' => 'ملاحظة زيادة الراتب',
    'advance_salary_requests' => 'طلبات الراتب المقدم',
    'advance_salary_request_filter' => 'فلتر طلبات الراتب المقدم',
    'delete_confirmation' => 'هل أنت متأكد أنك تريد الحذف؟',
    'payslip_for_the_month_of' => 'إيصال الرواتب لشهر',
    'absent_deduction' => 'خصم الغياب',

    /** Advance Salary */
    'is_paid' => 'هل تم الدفع؟',
    'released_on' => 'تم الإصدار في',
    'requested_on' => 'تم الطلب في',
    'released_amount' => 'المبلغ المفرج عنه',
    'requested_amount' => 'المبلغ المطلوب',
    'search_by_month' => 'البحث حسب الشهر',
    'search_by_employee_name' => 'البحث حسب اسم الموظف',
    'advance_salary_detail' => 'تفاصيل الراتب المسبق',
    'is_settled' => 'هل تم التسوية',
    'verified_by' => 'تم التحقق بواسطة',
    'amount_released_date' => 'تاريخ إصدار المبلغ',
    'advance_requested_date' => 'تاريخ طلب المقدم',
    'total_released_amount' => 'إجمالي المبلغ المفرج عنه',
    'total_request_amount' => 'إجمالي المبلغ المطلوب',
    'employee' => 'موظف',
    'select_employee' => 'اختر موظفًا',
    'advance_salary_request_detail' => 'تفاصيل طلب الراتب المسبق',
    'proof_of_advance_salary_payment' => 'إثبات دفع الراتب المسبق',
    'attachments' => 'المرفقات',
    'processing' => 'جاري المعالجة',

    /** Tax report */
    'tax_report' => 'تقرير الضرائب',
    'employee_tax_report' => 'تقرير ضرائب الموظف',
    'tax_report_edit' => 'تعديل تقرير الضرائب',
    'tax_report_detail_of' => 'تفاصيل تقرير الضرائب عن',
    'tax_report_detail' => 'تفاصيل تقرير الضرائب',
    'salary_sheet' => 'كشف الراتب',
    'particular' => 'تفاصيل',
    'income' => 'دخل',
    'tax_data_not_available' => 'بيانات الضرائب غير متوفرة للحالة الاجتماعية الحالية',
    'remain_tds_formula' => '(إجمالي ضريبة TDS المستحقة / عدد الأشهر المتبقية)',
    'remaining_month' => 'الشهر المتبقي',
    'tds_calculation_msg' => 'حساب TDS للشهر الحالي (الشهر المحسوب)',
    'total_due_tds' => 'إجمالي TDS المستحقة',
    'total_paid_tds' => 'إجمالي TDS المدفوعة',
    'total_payable_tds' => 'إجمالي TDS القابلة للدفع',
    'other_discount' => 'خصم آخر',
    'female_discount' => 'خصم للإناث',
    'medical_claim' => 'مطالبة طبية',
    'less' => 'أقل',
    'less_tax_deduction' => 'أقل: خصم ضريبي',
    'tax_amount' => 'مبلغ الضريبة',
    'percent' => 'نسبة مئوية',
    'tax_calculation_on_taxable_income' => 'حساب الضريبة على الدخل الخاضع للضريبة',
    'taxable_income' => 'الدخل الخاضع للضريبة',
    'ssf_contribution' => 'مساهمة SSF',
    'ssf_contribution_salary' => 'مساهمة SSF في الراتب',
    'total_retirement_contribution_allowed' => 'إجمالي مساهمة التقاعد المسموح بها',
    'total_income' => 'إجمالي الدخل',
    'amount' => 'مقدار',
    'additional_information' => 'معلومات إضافية',
    'total_payable' => 'إجمالي المبلغ الواجب دفعه',
    'tds_paid' => 'TDS المدفوعة',
    'ssf_deduction' => 'خصم SSF',
    'tax_report_generate' => 'توليد تقرير الضرائب',
    'print' => 'طباعة',
    'gross_earnings' => 'الأرباح الإجمالية',
    'tax_payable' => 'الضريبة المستحقة',

    /** Payroll Setting  */
    'advance_salary_limit' => 'حد الراتب المسبق',
    'select_month' => 'اختر الشهر',
    'applicable_month' => 'الشهر المعمول به',
    'value' => 'القيمة',
    'value_type' => 'نوع القيمة',
    'enter_bonus_type' => 'أدخل نوع المكافأة',
    'salary_components' => 'مكونات الراتب',
    'add_bonus' => 'أضف مكافأة',
    'max_daily_ot' => 'الحد الأقصى للـ OT اليومي',
    'assign_overtime_to_employee' => 'تعيين العمل الإضافي للموظف',
    'overtime_pay_rate' => 'معدل دفع العمل الإضافي (لكل ساعة)',
    'overtime_rate_percent' => 'نسبة معدل العمل الإضافي (لكل ساعة)',
    'placeholder_overtime_pay_rate' => 'أدخل معدل دفع العمل الإضافي',
    'placeholder_overtime_rate_percent' => 'أدخل نسبة معدل العمل الإضافي',
    'rate_type' => 'نوع المعدل',
    'select_rate_type' => 'اختر نوع المعدل',
    'ot_valid_after_hour' => 'العمل الإضافي صالح بعد؟ ساعة',
    'placeholder_ot_valid_after_hour' => 'أدخل الساعات بعد التي يكون فيها العمل الإضافي صالحًا',
    'monthly_ot' => 'الحد الأقصى للـ OT الشهري',
    'placeholder_monthly_ot' => 'أدخل الحد الأقصى للـ OT الشهري',
    'weekly_ot' => 'الحد الأقصى للـ OT الأسبوعي',
    'placeholder_weekly_ot' => 'أدخل الحد الأقصى للـ OT الأسبوعي',
    'daily_ot' => 'الحد الأقصى للـ OT اليومي',
    'placeholder_daily_ot' => 'أدخل الحد الأقصى للـ OT اليومي',
    'pay_percent' => 'نسبة الدفع/المعدل',
    'employee_count' => 'عدد الموظفين',
    'hour' => 'ساعة',
    'currency_setting' => 'إعدادات العملة',
    'payroll_currency' => 'عملة الرواتب',
    'choose_payroll_currency' => 'اختر عملة الرواتب',
    'add_payment_method' => 'أضف طريقة الدفع',
    'payment_method_name' => 'اسم طريقة الدفع',
    'update_payment_method' => 'تحديث طريقة الدفع',
    'component_value' => 'قيمة المكون',
    'component_type' => 'نوع المكون',
    'add_salary_component' => 'أضف مكون راتب',
    'apply_for_all' => 'تطبيق على الجميع',
    'component_value_annual' => 'قيمة المكون (سنوياً)',
    'select_value_type' => 'اختر نوع القيمة',
    'select_component_type' => 'اختر نوع المكون',
    'enter_salary_component_name' => 'أدخل اسم مكون الراتب',
    'add_salary_group' => 'أضف مجموعة رواتب',
    'delete_confirm_salary_group' => 'هل أنت متأكد أنك تريد حذف تفاصيل المجموعة؟',
    'assign_employee_to_group' => 'تعيين موظف إلى مجموعة',
    'choose_salary_component' => 'اختر مكون الراتب',
    'assign_salary_components' => 'تعيين مكونات الراتب',
    'enter_salary_group_name' => 'أدخل اسم مجموعة الرواتب',
    'add_more_tds_detail' => 'أضف المزيد من تفاصيل TDS',
    'enter_tds_in_percent' => 'أدخل TDS بالنسبه المئوية',
    'enter_annual_salary_to' => 'أدخل الراتب السنوي إلى',
    'enter_annual_salary_from' => 'أدخل الراتب السنوي من',
    'select_marital_status' => 'اختر الحالة الاجتماعية',
    'create_salary_tds' => 'إنشاء TDS للراتب',
    'update_salary_tds' => 'تحديث TDS للراتب',
    'salary_tds_detail_for_single' => 'تفاصيل TDS للراتب للفرد',
    'add_salary_tds' => 'أضف TDS للراتب',
    'annual_salary_to' => 'الراتب السنوي إلى',
    'annual_salary_from' => 'الراتب السنوي من',
    'tds' => 'TDS (%)',
    'salary_tds_detail_for_married' => 'تفاصيل TDS للراتب للمتزوجين',
    'ssf' => 'SSF',
    'employee_contribution' => 'مساهمة الموظف',
    'office_contribution' => 'مساهمة المكتب',
    'assign_undertime_to_employee' => 'تعيين وقت غير كافٍ للموظف',
    'enter_title' => 'أدخل العنوان',
    'undertime_after_minute' => 'الدقائق بعد التي ينطبق فيها وقت غير كافٍ',
    'placeholder_ut_after' => 'أدخل الساعات بعد التي ينطبق فيها وقت غير كافٍ',
    'penalty_type' => 'نوع العقوبة',
    'select_penalty_type' => 'اختر نوع العقوبة',
    'penalty_percent' => 'نسبة العقوبة (لكل ساعة)',
    'penalty_percent_placeholder' => 'أدخل نسبة العقوبة للوقت غير الكافي',
    'penalty_rate' => 'معدل العقوبة (لكل ساعة)',
    'penalty_rate_placeholder' => 'أدخل معدل العقوبة للوقت غير الكافي',

    /** Leave */
    'leave_type_section' => 'قسم نوع الإجازة',
    'select_leave_type' => 'اختر نوع الإجازة',
    'leave_type' => 'نوع الإجازة',
    'leave_allocated_days' => 'أيام الإجازة المخصصة',
    'allocated_days' => 'الأيام المخصصة',
    'is_paid_leave' => 'هل هي إجازة مدفوعة',
    'leave_type_name' => 'اسم نوع الإجازة',
    'leave_type_placeholder' => 'أدخل نوع الإجازة',
    'add_leave_type' => 'إضافة نوع إجازة',
    'type' => 'النوع',
    'edit_leave_type_detail' => 'تعديل تفاصيل نوع الإجازة',
    'delete_leave_type' => 'حذف نوع الإجازة',
    'delete_leave_confirmation' => 'هل أنت متأكد أنك تريد حذف نوع الإجازة؟',
    'leave_request_section' => 'قسم طلب الإجازة',
    'approve' => 'الموافقة',
    'reject' => 'رفض',
    'from_date' => 'من تاريخ',
    'to_date' => 'إلى تاريخ',
    'start_time' => 'وقت البدء',
    'end_time' => 'وقت الانتهاء',
    'reason' => 'السبب',
    'requested_for' => 'طلبت من أجل',
    'requested_by' => 'طلب بواسطة',
    'requested_days' => 'الأيام المطلوبة',
    'requested_date' => 'تاريخ الطلب',
    'all_status' => 'جميع الحالات',
    'all_leave_type' => 'جميع أنواع الإجازات',
    'leave_request_filter' => 'فلتر طلب الإجازة',
    'create_leave_request' => 'إنشاء طلب إجازة',
    'leave_reason' => 'سبب الإجازة',
    'referred_by' => 'مُحيل بواسطة',
    'leave_date' => 'تاريخ الإجازة',
    'time_leave_request_filter' => 'فلتر طلب الإجازة بالوقت',
    'create_time_leave_request' => 'إنشاء طلب إجازة بالوقت',
    'time_leave_request_section' => 'قسم طلب الإجازة بالوقت',
    'time_leave_status_update' => 'تحديث حالة الإجازة بالوقت',

    /** Team Meeting */
    'team_meeting_section' => 'قسم اجتماع الفريق',
    'update_and' => 'تحديث و',
    'create_and' => 'إنشاء و',
    'send' => 'إرسال',
    'meeting_participator' => 'مشارك الاجتماع',
    'image_hint' => 'يُوصى أن تكون الصورة بشكل أفقي',
    'meeting_description' => 'وصف الاجتماع',
    'upload_image' => 'تحميل الصورة',
    'meeting_start_time' => 'وقت بدء الاجتماع',
    'meeting_date' => 'تاريخ الاجتماع',
    'meeting_venue' => 'مكان الاجتماع',
    'enter_venue_name' => 'أدخل اسم المكان',
    'enter_content_title' => 'أدخل عنوان المحتوى',
    'meeting_title' => 'عنوان الاجتماع',
    'delete_team_meeting_confirmation' => 'هل أنت متأكد أنك تريد حذف اجتماع الفريق؟',
    'image_delete_confirmation' => 'هل أنت متأكد أنك تريد إزالة الصورة؟',
    'create_team_meeting' => 'إنشاء اجتماع الفريق',
    'delete_team_meeting' => 'حذف تفاصيل الاجتماع',
    'edit_meeting_detail' => 'تعديل تفاصيل الاجتماع',
    'show_team_meeting' => 'عرض محتوى اجتماع الفريق',
    'participators' => 'المشاركون',
    'participator' => 'المشارك',
    'team_meeting_filter' => 'فلتر اجتماع الفريق',
    'agenda' => 'جدول الأعمال',
    'creator' => 'المنشئ',

    /** Tada */
    'tada_attachment' => 'مرفق تادا',
    'upload_tada_attachment' => 'تحميل مرفق تادا',
    'accepted' => 'مقبول',
    'tada_status_change' => 'هل أنت متأكد أنك تريد تغيير حالة تسوية تادا؟',
    'delete_tada_confirm' => 'هل أنت متأكد أنك تريد حذف :title؟',
    'uploaded_attachment' => 'المرفق المرفوع',
    'no_attachment_file' => 'لا يوجد ملف مرفق',
    'total_expense' => 'إجمالي النفقات',
    'create_tada' => 'إنشاء تادا',
    'edit_tada' => 'تعديل تادا',
    'tada_listing' => 'قائمة تادا',
    'tada_filter' => 'فلتر تادا',
    'submitted_date' => 'تاريخ التقديم',
    'expense' => 'نفقات',
    'tada_detail' => 'تفاصيل تادا',
    'verified_date' => 'تاريخ التحقق',
    'tada_summary' => 'ملخص تادا',
    'update_status' => 'تحديث الحالة',
    'category' => 'فئة',
    'select_category' => 'اختيار فئة',
    'opening_time' => 'وقت الافتتاح',
    'closing_time' => 'وقت الإغلاق',
    'checkin_checkout_rule' => 'قاعدة تسجيل الوصول/المغادرة',
    'early_check_in' => 'تسجيل الوصول المبكر',
    'check_in_before' => 'يمكن تسجيل الوصول قبل (بالمينت)',
    'checkin_before' => 'تسجيل الوصول قبل',
    'enter_check_in_before' => 'أدخل يمكن تسجيل الوصول قبل (بالمينت)',
    'early_check_out' => 'تسجيل الخروج المبكر',
    'check_out_before' => 'يمكن تسجيل الخروج قبل (بالمينت)',
    'checkout_before' => 'تسجيل الخروج قبل',
    'enter_check_out_before' => 'أدخل يمكن تسجيل الخروج قبل (بالمينت)',
    'late_check_in' => 'تسجيل الوصول المتأخر',
    'check_in_after' => 'يمكن تسجيل الوصول بعد (بالمينت)',
    'checkin_after' => 'تسجيل الوصول بعد',
    'enter_check_in_after' => 'أدخل يمكن تسجيل الوصول بعد (بالمينت)',
    'late_check_out' => 'تسجيل الخروج المتأخر',
    'checkout_after' => 'تسجيل الخروج بعد',
    'check_out_after' => 'يمكن تسجيل الخروج بعد (بالمينت)',
    'enter_check_out_after' => 'أدخل يمكن تسجيل الخروج بعد (بالمينت)',
    'enter_shift_name' => 'أدخل اسم الشيفت',
    'select_shift' => 'اختيار شيفت',
    'delete_office_time_confirm' => 'هل أنت متأكد أنك تريد حذف جدول المكتب؟',
    'office_time_detail' => 'تفاصيل وقت المكتب',
    'office_schedule' => 'جدول المكتب',
    'add_office_time' => 'إضافة وقت المكتب',

    /** Award Types */
    'award_distributed' => 'الجائزة الموزعة',
    'add_award_types' => 'إضافة أنواع الجوائز',
    'gift_item' => 'عنصر هدية',
    'awarded_date' => 'تاريخ منح الجائزة',

    /** Award */
    'award' => 'جائزة',
    'award_name' => 'اسم الجائزة',
    'select_award_type' => 'اختيار نوع الجائزة',
    'enter_gift_item' => 'أدخل عنصر الهدية',
    'award_base' => 'أساس الجائزة',
    'select_award_base' => 'اختيار أساس الجائزة',
    'awarded_by' => 'منح بواسطة',
    'enter_awarded_by' => 'أدخل من منح الجائزة',
    'award_description' => 'وصف الجائزة',
    'gift_description' => 'وصف الهدية',
    'reward_code' => 'رمز المكافأة',
    'enter_reward_code' => 'أدخل رمز المكافأة',
    'add_award' => 'إضافة جائزة',
    'attachment' => 'مرفق',
    'award_lists' => 'قوائم الجوائز',

    /** Asset Types */
    'add_asset_types' => 'إضافة أنواع الأصول',
    'asset_item_count' => 'عدد عناصر الأصول',
    'asset_type' => 'نوع الأصل',
    'asset_name' => 'اسم الأصل',
    'purchased_date' => 'تاريخ الشراء',
    'is_working' => 'يعمل',
    'is_available' => 'متوفر',
    'asset' => 'أصل',

    /** Assets */
    'select_asset_type' => 'اختر نوع الأصل',
    'assigned_date' => 'تاريخ التعيين',
    'is_available_for_employee' => 'متوفر للموظف',
    'select_availability' => 'حدد التوفر',
    'warranty_end_date' => 'تاريخ انتهاء الضمان',
    'warranty_available' => 'الضمان متوفر',
    'select_warranty_availability' => 'حدد توفر الضمان',
    'asset_serial_number' => 'رقم تسلسلي للأصل',
    'enter_asset_serial_number' => 'أدخل رقم تسلسلي للأصل',
    'asset_code' => 'رمز الأصل',
    'enter_asset_code' => 'أدخل رمز الأصل',
    'change_availability_status' => 'هل أنت متأكد أنك تريد تغيير حالة التوفر؟',
    'delete_asset_confirm' => 'هل أنت متأكد أنك تريد حذف :title?',
    'add_asset' => 'إضافة أصل',
    'asset_image' => 'صورة الأصل',
    'asset_assigned_employee' => 'موظف مخصص للأصل',
    'assets_filter' => 'فلتر الأصول',
    'working_status' => 'حالة العمل',
    'availability_status' => 'حالة التوفر',
    'yes_available' => 'متوفر',
    'notavailable' => 'غير متوفر',
    'purchased_from' => 'تم شراؤه من',
    'purchased_to' => 'تم شراؤه إلى',

    /** Content Management */
    'content_section' => 'قسم المحتوى',
    'content' => 'المحتوى',
    'content_type' => 'نوع المحتوى',
    'content_title' => 'عنوان المحتوى',
    'select_content_type' => 'اختر نوع المحتوى',
    'delete_content_confirm' => 'هل أنت متأكد أنك تريد حذف محتوى الصفحة الثابتة؟',
    'company_static_content' => 'محتوى الشركة الثابت',
    'add_content' => 'إضافة محتوى',

    /** Support */
    'delete_support_confirm' => 'هل أنت متأكد أنك تريد حذف :title?',
    'ticket_lists' => 'قوائم التذاكر',
    'query_by' => 'استعلام بواسطة',
    'concerned_department' => 'القسم المعني',
    'unseen' => 'غير مرئي',
    'read_status' => 'حالة القراءة',
    'seen' => 'مرئي',
    'query_status' => 'حالة الاستعلام',
    'support_filter' => 'فلتر الدعم',
    'query_lists' => 'قوائم الاستعلام',
    'department_support_requested_from' => 'الدعم المطلوب من القسم',
    'department_support_requested_to' => 'الدعم المطلوب إلى القسم',
    'change_query_status' => 'تغيير حالة الاستعلام',

    /** Router */
    'router_section' => 'قسم جهاز التوجيه',
    'router_bssid' => 'بSSID لجهاز التوجيه',
    'router' => 'جهاز التوجيه',
    'router_detail' => 'تفاصيل جهاز التوجيه',
    'add_router' => 'إضافة جهاز توجيه',

    /** QR */
    'scan_me' => 'امسحني',
    'attendance_qr' => 'QR الحضور',
    'qr_image' => 'صورة QR',
    'add_qr' => 'إضافة QR',
    'qr_section' => 'قسم QR',

    /** NFC */
    'nfc_section' => 'قسم NFC',
    'created_by' => 'أنشأ بواسطة',

    /** Role and permission */
    'role_section' => 'قسم الدور',
    'authorize_backend_login' => 'تفويض تسجيل الدخول إلى الواجهة الخلفية',
    'role_name' => 'اسم الدور',
    'permissions' => 'الأذونات',
    'check_all' => 'تحديد الكل',
    'module' => 'الوحدة',
    'add_role' => 'إضافة دور',
    'assign_permissions' => 'تعيين الأذونات',
    'confirm_role_deletion' => 'هل أنت متأكد أنك تريد حذف الدور؟',
    'can_login' => 'يمكن تسجيل الدخول',
    'permission_setting' => 'إعداد الأذونات',
    'assign' => 'تعيين',

    /** General Setting */
    'general_setting_section' => 'قسم الإعدادات العامة',
    'general_setting' => 'الإعدادات العامة',

    /** App Setting */
    'export_database_data' => 'تصدير بيانات قاعدة البيانات',
    'check_router_bssid' => 'التحقق من BSSID للراوتر',

    /** Fiscal Years */
    'fiscal_years' => 'السنوات المالية',
    'year' => 'السنة',
    'add_fiscal_year' => 'إضافة سنة مالية',

    /** Notifications */
    'notification_section' => 'قسم الإشعارات',
    'confirm_notification_send' => 'هل أنت متأكد أنك تريد إرسال الإشعار؟',
    'notification' => 'إشعار',
    'published_date' => 'تاريخ النشر',
    'all_types' => 'جميع الأنواع',
    'notification_lists' => 'قوائم الإشعارات',
    'notified_member' => 'عضو تم إشعاره',
    'notification_title' => 'عنوان الإشعار',
    'notification_description' => 'وصف الإشعار',
    'send_notification' => 'إرسال إشعار',
    'enter_notification_title' => 'أدخل عنوان الإشعار',

    /** feature control */
    'app_setting' => 'إعدادات التطبيق',
    'sn' => 'رقم التسلسل',
    'group' => 'مجموعة',
    'export_table_data' => 'تصدير بيانات الجدول',
    'leave_requests' => 'طلبات الإجازة',
    'employee_lists' => 'قوائم الموظفين',
    'attendances' => 'الحضور',
    'confirm_change_status' => 'هل أنت متأكد أنك تريد تغيير الحالة؟',
    'yes' => 'نعم',
    'no' => 'لا',


    /** Api response */
    /** Auth Controller */
    'invalid_login_credentials' => 'بيانات تسجيل الدخول غير صحيحة!',
    'authenticated' => 'مصادق عليه',
    'user_detail_not_found' => 'تفاصيل المستخدم غير موجودة',
    'partial_logout_successful' => 'تسجيل الخروج الجزئي ناجح',
    /** Dashboard Controller */
    'data_found' => 'تم العثور على البيانات',
    /** AdvanceSalary Controller */
    'advance_salary_pending_error' => 'لا يمكن طلب راتب مقدم آخر حتى يتم تسوية الطلب السابق.',
    'data_updated_successfully' => 'تم تحديث البيانات بنجاح',
    'user_updated_advance_salary_request' => ':name قام بتحديث تفاصيل طلب راتب مقدم',
    'data_created_successfully' => 'تم إنشاء البيانات بنجاح',
    'advance_salary_request_alert' => 'تنبيه طلب راتب مقدم',
    'user_submitted_advance_salary_request' => ':name قدم طلب راتب مقدم بمبلغ :amount',
    /** Attendance Api */
    'check_out_successful' => 'تم تسجيل الخروج بنجاح',
    'check_out_notification' => 'إشعار تسجيل الخروج',
    'check_in_successful' => 'تم تسجيل الدخول بنجاح',
    'check_in_notification' => 'إشعار تسجيل الدخول',
    'not_checked_in_yet' => 'لم يتم تسجيل الدخول بعد',
    'alert_multi_checkin_shift' => 'عذراً! لا يمكن للموظف تسجيل الدخول مرتين في نفس الوردية.',
    'checkout_alert_for_shift' => 'الموظف قد خرج بالفعل من الوردية',
    'alert_checkin' => 'عذراً! لا يمكن للموظف تسجيل الدخول مرتين في اليوم.',
    'checkout_alert' => 'الموظف قد خرج بالفعل اليوم',
    'attendance_alert_status' => ':status تم بالفعل',
    'employee_checked_in' => ':name سجل الدخول في الساعة :time',
    'employee_checked_out' => ':name سجل الخروج في الساعة :time',
    'has_worked_for' => 'وعمل لمدة :time',
    'multi_checkout_warning' => 'لقد وصلت إلى الحد الأقصى لعدد مرات تسجيل الدخول والخروج المسموح بها اليوم.',
    'employee_checked_out_and_worked' => ':name سجل الخروج في الساعة :check_out_time وعمل لمدة :worked_time',
    'invalid_attendance_type' => 'نوع الحضور غير صالح.',
    'invalid_qr' => 'رمز QR غير صالح أو غير متاح',
    'invalid_nfc' => 'رمز NFC غير صالح أو غير متاح',
    'validation_failed' => 'فشل في التحقق',

    /** Leave Api Controller */
    'leave_request_cancelled' => 'تم إلغاء طلب الإجازة بنجاح',
    'leave_request_cannot_be_cancelled' => 'لا يمكن إلغاء طلب الإجازة بمجرد تحديثه من حالة الانتظار.',
    'leave_request_notification' => 'إشعار طلب الإجازة',
    'leave_request_submitted' => ':name طلب إجازة من :start_time إلى :end_time في :issue_date. السبب: :reasons',
    'leave_request_submitted_successfully' => 'تم تقديم طلب الإجازة بنجاح',
    'leave_request_cancelled_successfully' => 'تم إلغاء طلب الإجازة بنجاح',
    'leave_request_submit' => ':name طلب :no_of_days يوم(أيام) إجازة من :leave_from في :leave_requested_date. السبب: :reasons',

    /** NFC api Controller */
    'nfc_token_already_exist' => 'رمز NFC موجود بالفعل.',
    'nfc_added_successfully' => 'تمت إضافة NFC بنجاح',

    /** Notification Api Controller */
    'updated_successfully' => 'تم التحديث بنجاح',
    'successfully_sent_notification' => 'تم إرسال الإشعار بنجاح',
    'data_not_found' => 'البيانات غير موجودة',
    'content_not_found' => 'المحتوى غير موجود',

    /** Support Api Controller */
    'support_notification' => 'إشعار الدعم',
    'support_request_submitted' => ':name طلب الدعم.',
    'query_submitted_successfully' => 'تم تقديم الاستفسار بنجاح',

    /** Tada Api Controller  */
    'attachment_detail_not_found' => 'تفاصيل المرفق غير موجودة',
    'cannot_delete_attachment_detail' => 'لا يمكن حذف تفاصيل المرفق بعد التحقق',
    'upload_another_attachment_before_delete' => 'يرجى تحميل مرفق آخر قبل الحذف.',
    'attachment_deleted_successfully' => 'تم حذف المرفق بنجاح',
    'tada_update_alert' => 'لا يمكنك تحديث التفاصيل بعد التحقق، يرجى الاتصال بالمسؤول',
    'tada_notification' => ':name قدم TADA جديد لـ :title',
    'tada_detail_notification' => ':name قام بتحديث تفاصيل TADA المقدمة لـ :title',
    'tada_alert' => 'تنبيه TADA',

    /** TaskDetailApi Controller */
    'status_changed_successfully' => 'تم تغيير الحالة بنجاح',
    'task_detail_not_found' => 'تفاصيل المهمة غير موجودة',

    /** TaskCheckListApi Controller */
    'status_updated_successfully' => 'تم تحديث الحالة بنجاح',

    /** TaskCommentApi Controller */
    'comment_notification' => 'إشعار التعليق',
    'task_mention' => 'تم الإشارة إليك في المهمة :task :type',
    'comment_reply' => 'رد التعليق',
    'comment_reply_deleted_successfully' => 'تم حذف رد التعليق بنجاح',
    'comment_deleted_successfully' => 'تم حذف التعليق بنجاح',
    'comment_added_successfully' => 'تمت إضافة التعليق بنجاح',

    /** userProfile Api */
    'invalid_base64_image' => 'قيمة Base64 ليست صورة صالحة',
    'demo_version' => 'هذه نسخة تجريبية. يرجى شراء التطبيق لاستخدام الميزات الكاملة',
    'user_not_found' => 'تفاصيل المستخدم غير موجودة',
    'profile_updated' => 'تم تحديث الملف الشخصي بنجاح',
    'incorrect_current_password' => 'كلمة المرور الحالية غير صحيحة',
    'new_password_same_as_old' => 'لا يمكن أن تكون كلمة المرور الجديدة هي نفس كلمة المرور القديمة',
    'password_changed' => 'تم تغيير كلمة المرور بنجاح',

    /** leave_approval */
    'leave_approval' => 'موافقة الإجازة',
    'leave_approval_list' => 'قائمة موافقات الإجازة',
    'add_leave_approval' => 'إضافة موافقة الإجازة',
    'subject' => 'الموضوع',
    'related' => 'مرتبط',
    'select_related' => 'اختر المرتبط',
    'max_days_to_sign' => 'الحد الأقصى لعدد الأيام للتوقيع',
    'notification_recipient' => 'مستلم الإشعار',
    'select_notification_recipient' => 'اختر مستلم الإشعار',
    'approval_process' => 'عملية الموافقة',
    'approver' => 'الموافق',
    'select_approver' => 'اختر الموافق',
    'head_of_department' => 'رئيس القسم',
    'specific_personnel' => 'شخص معين',
    'applicable_from' => 'ساري من',

    /** Event Management */
    'event_section' => 'قسم الحدث',
    'event_title' => 'عنوان الحدث',
    'event_location' => 'موقع الحدث',
    'event_start_date' => 'تاريخ بدء الحدث',
    'event_start_time' => 'وقت بدء الحدث',
    'event_end_date' => 'تاريخ انتهاء الحدث',
    'event_end_time' => 'وقت انتهاء الحدث',
    'all_departments' => 'جميع الأقسام',
    'delete_event_confirmation' => 'هل أنت متأكد أنك تريد حذف هذا الحدث؟',
    'create_event' => 'إنشاء حدث',
    'show_event' => 'عرض الحدث',
    'enter_event_title' => 'أدخل عنوان الحدث',
    'edit_event_detail' => 'تعديل تفاصيل الحدث',
    'delete_event' => 'حذف الحدث',
    'event_calendar' => 'تقويم الحدث',

    /** Training Management */
    'training_types' => 'أنواع التدريب',
    'select_training_type' => 'اختر نوع التدريب',
    'training' => 'التدريب',
    'select_trainer' => 'اختر المدرب',
    'trainer' => 'المدرب',
    'add_trainer' => 'إضافة مدرب',
    'add_training' => 'إضافة تدريب',
    'trainer_lists' => 'قائمة المدربين',
    'training_list' => 'قائمة التدريب',
    'total_training' => 'إجمالي التدريب',
    'training_type' => 'نوع التدريب',
    'training_management' => 'إدارة التدريب',
    'add_training_types' => 'إضافة أنواع التدريب',
    'training_date' => 'تاريخ التدريب',
    'trainer_type' => 'نوع المدرب',
    'select_trainer_type' => 'اختر نوع المدرب',
    'expertise' => 'مجال الخبرة',
    'certificate' => 'شهادة',
    'contact_number' => 'رقم الاتصال',
    'training_for' => 'التدريب لـ',
    'time' => 'الوقت',
    'updated_by' => 'تم التحديث بواسطة',

    'select_task' => 'اختر المهمة',
    'event_host' => 'مضيف الحدث',
    'host' => 'المضيف',
    'location' => 'الموقع',
    'event_list' => 'قائمة الأحداث',
    'total_tasks' => 'إجمالي المهام',
    'applicable_to_tax_report' => 'سيتم استخدام مكونات الراتب التي تنطبق على الجميع في تقرير الضرائب.',

    'no_departments_found' => 'لم يتم العثور على قسم',
    'error_loading_departments' => 'خطأ في تحميل الأقسام',
    'no_employees_found' => 'لم يتم العثور على موظفين',
    'update_send' => 'تحديث وإرسال الإشعار',
    'create_send' => 'إنشاء وإرسال الإشعار',


    'admin_permission_msg' => 'إذا تم اختيار هذا الخيار، سيتم تجاوز جميع خطوات التسلسل الهرمي وسيتمكن المستخدمون الذين لديهم هذا الدور من عرض وتحرير جميع الإجازات. احتفظ بهذا الخيار للأدوار الخاصة مثل الموارد البشرية',
    'coming_soon' => 'قريباً',
    'assign_trainer_section' => 'قسم تعيين المدرب',
    'assign_trainer' => 'تعيين المدرب',


    'export_csv' => 'تصدير CSV',
    'termination_types' => 'أنواع الإنهاء',
    'select_termination_type' => 'اختر نوع الإنهاء',
    'termination' => 'إنهاء',
    'add_termination' => 'إضافة إنهاء',
    'termination_list' => 'قائمة الإنهاء',
    'total_termination' => 'إجمالي الإنهاء',
    'termination_type' => 'نوع الإنهاء',
    'termination_management' => 'إدارة الإنهاء',
    'add_termination_types' => 'إضافة أنواع الإنهاء',
    'termination_date' => 'تاريخ الإنهاء',
    'notice_date' => 'تاريخ الإشعار',
    'resignation_types' => 'أنواع الاستقالة',
    'select_resignation_type' => 'اختر نوع الاستقالة',
    'resignation' => 'استقالة',
    'add_resignation' => 'إضافة استقالة',
    'resignation_list' => 'قائمة الاستقالة',
    'total_resignation' => 'إجمالي الاستقالة',
    'resignation_type' => 'نوع الاستقالة',
    'resignation_management' => 'إدارة الاستقالة',
    'add_resignation_types' => 'إضافة أنواع الاستقالة',
    'resignation_date' => 'تاريخ الاستقالة',
    'last_date' => 'آخر تاريخ',
    'last_working_day' => 'آخر يوم عمل',
    'resignation_notification' => 'طلب الاستقالة',
    'resignation_submit' => ':name قد طلب الاستقالة في :resignation_date سارية من :last_working_day.',
    'resignation_submitted_successfully' => 'تم تقديم الاستقالة بنجاح',
    'resignation_fetched_successfully' => 'تم جلب الاستقالة بنجاح',
    'resignation_exist_error' => 'استقالتك بالفعل :status.',
    'document' => 'وثيقة',
    'venue' => 'مكان',
    'select_warning_type' => 'اختر نوع التحذير',
    'warning' => 'تحذير',
    'message' => 'رسالة',
    'add_warning' => 'إضافة تحذير',
    'warning_list' => 'قائمة التحذير',
    'total_warning' => 'إجمالي التحذير',
    'warning_type' => 'نوع التحذير',
    'warning_management' => 'إدارة التحذير',
    'add_warning_types' => 'إضافة أنواع التحذير',
    'warning_date' => 'تاريخ التحذير',
    'warning_notification' => 'طلب التحذير',
    'warning_submit' => ':name قد قدم رده على التحذير بشأن :subject صدر في :date',
    'warning_submitted_successfully' => 'تم تقديم التحذير بنجاح',
    'response_submitted_successfully' => 'تم تسجيل ردك بنجاح',
    'warning_fetched_successfully' => 'تم جلب التحذير بنجاح',
    'warning_exist_error' => 'ردك مسجل بالفعل.',
    'response_section' => 'قسم الرد',
    'response' => 'رد',
    'select_complaint_type' => 'اختر نوع الشكوى',
    'complaint' => 'شكوى',
    'complaint_from' => 'شكوى من',
    'add_complaint' => 'إضافة شكوى',
    'complaint_list' => 'قائمة الشكاوى',
    'total_complaint' => 'إجمالي الشكاوى',
    'complaint_type' => 'نوع الشكوى',
    'complaint_management' => 'إدارة الشكاوى',
    'add_complaint_types' => 'إضافة أنواع الشكاوى',
    'complaint_date' => 'تاريخ الشكوى',
    'complaint_notification' => 'طلب الشكوى',
    'complaint_submit' => 'تم تقديم الرد على الشكوى بشأن :subject صدر في :date',
    'complaint_submitted_successfully' => 'تم تقديم الشكوى بنجاح',
    'complaint_fetched_successfully' => 'تم جلب الشكوى بنجاح',
    'complaint_exist_error' => 'ردك مسجل بالفعل.',
    'complain_to' => 'تقديم شكوى إلى',
    'hr_admin_setup' => 'إعداد إدارة الموارد البشرية',
    'edit_branch' => 'تعديل الفرع',
    'branch_head_error' => 'المستخدم المحدد هو بالفعل رئيس فرع آخر، يرجى اختيار مستخدم مختلف',
    'department_head_error' => 'المستخدم المحدد هو بالفعل رئيس قسم آخر، يرجى اختيار مستخدم مختلف',
    'promotion' => 'ترقية',
    'add_promotion' => 'إضافة ترقية',
    'promotion_list' => 'قائمة الترقية',
    'promotion_section' => 'قسم الترقية',
    'total_promotion' => 'إجمالي الترقية',
    'promotion_type' => 'نوع الترقية',
    'promotion_management' => 'إدارة الترقية',
    'add_promotion_types' => 'إضافة أنواع الترقية',
    'promotion_date' => 'تاريخ الترقية',
    'promotion_notification' => 'طلب الترقية',
    'promotion_submitted_successfully' => 'تم تقديم الترقية بنجاح',
    'promotion_fetched_successfully' => 'تم جلب الترقية بنجاح',
    'select_post' => 'اختر منصب',
    'old_post' => 'المنصب القديم',
    'new_post' => 'المنصب الجديد',
    'transfer' => 'نقل',
    'transfer_details' => 'تفاصيل النقل',
    'add_transfer' => 'إضافة نقل',
    'transfer_list' => 'قائمة النقل',
    'transfer_section' => 'قسم النقل',
    'total_transfer' => 'إجمالي النقل',
    'transfer_type' => 'نوع النقل',
    'transfer_management' => 'إدارة النقل',
    'add_transfer_types' => 'إضافة أنواع النقل',
    'transfer_date' => 'تاريخ النقل',
    'transfer_notification' => 'طلب النقل',
    'transfer_submitted_successfully' => 'تم تقديم النقل بنجاح',
    'transfer_fetched_successfully' => 'تم جلب النقل بنجاح',
    'old_branch' => 'الفرع القديم',
    'new_branch' => 'الفرع الجديد',
    'old_department' => 'القسم القديم',
    'new_department' => 'القسم الجديد',
    'theme_color' => 'لون المظهر',
    'background_color' => 'لون الخلفية',
    'primary_color' => 'اللون الأساسي',
    'hover_color' => 'لون التحويم',
    'dark_primary_color' => 'اللون الأساسي الداكن',
    'dark_hover_color' => 'لون التحويم الداكن',
    'users' => 'المستخدمون',
    'user_section' => 'قسم المستخدم',
    'add_user' => 'إضافة مستخدم',
    'user_management' => 'إدارة المستخدم',
    'user' => 'مستخدم',
    'office_time_not_found' => 'وقت المكتب غير موجود',
    'asset_type_not_found' => 'نوع الأصل غير موجود',
    'employee_not_found' => 'الموظفون غير موجودون',
    'error_loading_asset_types' => 'خطأ في تحميل أنواع الأصول',
    'error_loading_employees' => 'خطأ في تحميل الموظفين',
    'error_loading_termination_types' => 'خطأ في تحميل أنواع الإنهاء',
    'error_loading_department' => 'خطأ في تحميل الأقسام',
    'leave_type_not_found' => 'نوع الإجازة غير موجود',
    'error_loading_leave_types' => 'خطأ في تحميل أنواع الإجازة',
    'no_department_found' => 'لم يتم العثور على قسم',
    'award_filter' => 'تصفية الجوائز',
    'select_award' => 'اختر جائزة',
    'award_type_not_found' => 'نوع الجائزة غير موجود',
    'termination_filter' => 'تصفية الإنهاء',
    'training_type_filter' => 'تصفية نوع التدريب',
    'asset_type_filter' => 'تصفية نوع الأصل',
    'award_type_filter' => 'تصفية نوع الجائزة',
    'termination_type_filter' => 'تصفية نوع الإنهاء',
    'resignation_filter' => 'تصفية الاستقالة',
    'promotion_filter' => 'تصفية الترقية',
    'complaint_filter' => 'تصفية الشكاوى',
    'warning_filter' => 'تصفية التحذير',
    'transfer_filter' => 'تصفية النقل',
    'trainer_filter' => 'تصفية المدرب',
    'office_time_filter' => 'تصفية وقت المكتب',
    'leave_type_filter' => 'تصفية نوع الإجازة',
    'client_filter' => 'تصفية العميل',
    'router_filter' => 'تصفية الراوتر',
    'project_not_found' => 'المشروع غير موجود',
    'error_loading_training_types' => 'خطأ في تحميل أنواع التدريب',

    'post_filter'=>'فلتر المنشورات',
    'event_filter'=>'فلتر الأحداث',
    'training_filter'=>'فلتر التدريب',
    'post_lists'=>'قوائم المنشورات',
    'tada_lists'=>'قوائم تادا',
    'advance_salary_filter'=>'فلتر راتب مقدم',
    'log_filter'=>'فلتر سجل الحضور',
    'advance_salary_lists'=>'قوائم الراتب المقدم',
    'logout_request_filter'=>'فلتر طلب تسجيل الخروج',
    'leave_approval_filter'=>'فلتر الموافقة على الإجازة',
    'user_list'=>'قائمة المستخدمين',
    'projects_not_found'=>'المشاريع غير موجودة',
    'attendance_logs'=>'سجلات الحضور',
    'attendance_type'=>'نوع الحضور',
    'identifier'=>'المعرف',
    'nfc_lists'=>'قوائم NFC',
    'qr_lists'=>'قوائم QR',
    'qr_filter'=>'فلتر QR',
    'nfc_filter'=>'فلتر NFC',
    'select_notice_receiver'=>'اختر متلقي الإشعار',
    'generated_salary_lists'=>'قوائم الرواتب المولدة',
    'employee_salaries'=>'رواتب الموظفين',
    'select_meeting_participants'=>'اختر المشاركين في الاجتماع',
    'employee_filter'=>'فلتر الموظفين',
    'attendance_filter'=>'فلتر الحضور',
    'notice_filter'=>'فلتر الإشعارات',
    'award_type_lists'=>'قوائم أنواع الجوائز',
    'termination_type_lists'=>'قوائم أنواع الإنهاء',
    'holiday_lists'=>'قوائم العطلات',
    'asset_lists'=>'قوائم الأصول',
    'router_lists'=>'قوائم الراوتر',
    'meeting_list'=>'قوائم الاجتماعات',
    'app_qr'=>'رمز QR للتطبيق',
    'digital_hr_dashboard'=>'لوحة تحكم الموارد البشرية الرقمية',
    'training_type_list'=>'قائمة أنواع التدريب',
    'time_leave_list'=>'قوائم طلبات الإجازة الزمنية',
    'support_list'=>'قوائم الدعم',
    'role_list'=>'قوائم الأدوار',
    'asset_type_list'=>'قوائم أنواع الأصول',
    'add_undertime'=>'إضافة وقت ناقص',
    'threshold_time'=>'الوقت الحدي',
    'ssf_rule'=>'قاعدة SSF',
    'upload_warning'=>'يرجى رفع مستند واحد على الأقل عندما تكون الحالة موافق عليها',
    'check_in_latitude'=>'خط العرض للتسجيل الداخلي',
    'check_in_longitude'=>'خط الطول للتسجيل الداخلي',
    'check_out_latitude'=>'خط العرض للتسجيل الخارجي',
    'check_out_longitude'=>'خط الطول للتسجيل الخارجي',
];
