<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Authentication Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines are used during authentication for various
    | messages that we need to display to the user. You are free to modify
    | these language lines according to your application's requirements.
    |
    */
    /** dashboard */
    'welcome' => 'Willkommen im Anwesenheits-Dashboard',
    'total_employees' => 'Gesamtzahl der Mitarbeiter',
    'total_departments' => 'Gesamtzahl der Abteilungen',
    'total_holidays' => 'Gesamtzahl der Feiertage',
    'paid_leaves' => 'Bezahlte Urlaube',
    'on_leave_today' => 'Heute im Urlaub',
    'pending_leave_requests' => 'Ausstehende Urlaubsanträge',
    'total_check_in_today' => 'Gesamtzahl der Check-ins heute',
    'total_check_out_today' => 'Gesamtzahl der Check-outs heute',
    'projects_detail' => 'Projekt-Details',
    'total_projects' => 'Gesamtzahl der Projekte',
    'pending_projects' => 'Ausstehende Projekte',
    'on_hold_projects' => 'Projekte in Wartestellung',
    'in_progress_projects' => 'Laufende Projekte',
    'finished_projects' => 'Abgeschlossene Projekte',
    'cancelled_projects' => 'Stornierte Projekte',
    'top_clients' => 'Top-Kunden',
    'task_details' => 'Aufgabendetails',
    'recent_projects' => 'Neueste Projekte',
    'title' => 'Titel',
    'date_start' => 'Startdatum',
    'deadline' => 'Frist',
    'leader' => 'Projektleiter',
    'completion' => 'Fertigstellung',
    'priority' => 'Priorität',
    'check_in_at' => 'Eingecheckt um',
    'check_out_at' => 'Ausgecheckt um',
    'punch_in' => 'Stempeln',
    'punch_out' => 'Aus stempeln',
    'no_records_found' => 'Keine Aufzeichnungen gefunden!',
    'project_management' => 'Projektmanagement',
    'view_all_clients' => 'Alle Kunden ansehen',
    'view_all_projects' => 'Alle Projekte anzeigen',
    'error_message' => 'Fehler: Anfrage konnte nicht verarbeitet werden.',
    'success_message' => 'Erfolg: Aktion erfolgreich abgeschlossen.',
    'name' => 'Name',
    'email' => 'E-Mail',
    'contact' => 'Kontakt',
    'project' => 'Projekt',
    'pending' => 'Ausstehend',
    'on_hold' => 'In Wartestellung',
    'in_progress' => 'In Bearbeitung',
    'completed' => 'Abgeschlossen',
    'cancelled' => 'Abgebrochen',
    'search_menu' => 'Suchmenü',

    /** nav */
    'latest_notifications' => 'Neueste Benachrichtigungen',
    'view_all' => 'Alle anzeigen',
    'profile' => 'Profil',
    'edit_profile' => 'Profil bearbeiten',
    'request_leave' => 'Urlaub beantragen',
    'log_out' => 'Abmelden',
    'light_mode' => 'Hellen Modus',
    'dark_mode' => 'Dunklen Modus',

    /** menu */
    'dashboard' => 'Dashboard',
    'company_management' => 'Unternehmensverwaltung',
    'company' => 'Unternehmen',
    'branch' => 'Zweigstelle',
    'department' => 'Abteilung',
    'post' => 'Posten',
    'employee_management' => 'Mitarbeiterverwaltung',
    'employees' => 'Mitarbeiter',
    'logout_requests' => 'Logout-Anfragen',
    'attendance_section' => 'Anwesenheitsbereich',
    'clients' => 'Kunden',
    'task_management' => 'Aufgabenverwaltung',
    'holidays' => 'Ferien',
    'notice' => 'Mitteilung',
    'payroll_management' => 'Gehaltsabrechnung',
    'payroll' => 'Gehaltsabrechnung',
    'payroll_setting' => 'Gehaltsabrechnung Einstellung',
    'advance_salary' => 'Vorschusslohn',
    'employee_salary' => 'Mitarbeitergehalt',
    'leave' => 'Verlassen',
    'team_meeting' => 'Teamtreffen',
    'tada' => 'Tada',
    'shift_management' => 'Schichtmanagement',
    'office_time' => 'Bürozeit',
    'award_management' => 'Preismanagement',
    'award_types' => 'Preistypen',
    'awards' => 'Auszeichnungen',
    'asset_management' => 'Vermögensverwaltung',
    'asset_types' => 'Anlagearten',
    'assets' => 'Vermögenswerte',
    'content_management' => 'Inhaltsverwaltung',
    'support' => 'Unterstützung',
    'attendance_methods' => 'Anwesenheitsmethoden',
    'routers' => 'Router',
    'qr' => 'QR',
    'nfc' => 'NFC',
    'settings' => 'Einstellungen',
    'roles_permissions' => 'Rollen & Berechtigungen',
    'general_settings' => 'Allgemeine Einstellungen',
    'app_settings' => 'App Einstellungen',
    'notifications' => 'Benachrichtigungen',
    'payment_currency' => 'Zahlungswährung',
    'feature_control' => 'Funktionenkontrolle',
    'salary_component' => 'Gehaltsbestandteil',
    'salary_group' => 'Gehaltsgruppe',
    'salary_tds' => 'Gehaltssteuer',
    'overtime' => 'Überstunden',
    'undertime' => 'Unterzeit',
    'payment_method' => 'Zahlungsmethode',
    'leave_types' => 'Urlaubsarten',
    'leave_request' => 'Urlaubsantrag',
    'time_leave_request' => 'Zeiturlaubsantrag',


    /** company */
    'company_profile' => 'Firmenprofil',
    'update_company' => 'Firma aktualisieren',
    'create_company' => 'Firma erstellen',
    'company_name' => 'Firmenname',
    'company_owner' => 'Firmeninhaber',
    'address' => 'Adresse',
    'email_address' => 'E-Mail-Adresse',
    'phone_no' => 'Telefonnummer',
    'website_url' => 'Website-URL',
    'check_office_off_days' => 'Büro-Freie Tage überprüfen',
    'upload_logo' => 'Logo hochladen',
    'update' => 'Aktualisieren',
    'save' => 'Speichern',

    /** Branch */
    'title_branch' => 'Zweigstelle',
    'branch_section' => 'Zweigstellenbereich',
    'branches' => 'Zweigstellen',
    'add_branch' => 'Zweigstelle hinzufügen',
    'branch_lists' => 'Zweigstellenlisten',
    'search_by_branch_name' => 'Nach Zweigstellenname suchen',
    'filter' => 'Filter',
    'reset' => 'Zurücksetzen',
    'phone' => 'Telefon',
    'total_employee' => 'Gesamtmitarbeiter',
    'action' => 'Aktion',
    'are_you_sure_change_status' => 'Sind Sie sicher, dass Sie den Status ändern möchten?',
    'are_you_sure_delete_branch' => 'Sind Sie sicher, dass Sie die Zweigstelle löschen möchten?',
    'branch_create' => 'Zweigstelle erstellen',
    'branch_update' => 'Zweigstelle aktualisieren',
    'branch_name' => 'Zweigstellenname',
    'required_field' => 'Pflichtfeld',
    'branch_head' => 'Zweigstellenleiter',
    'select_branch_head' => 'Zweigstellenleiter auswählen',
    'phone_number' => 'Telefonnummer',
    'branch_location_latitude' => 'Breitengrad der Zweigstelle',
    'enter_branch_location_latitude' => 'Breitengrad der Zweigstelle eingeben',
    'branch_location_longitude' => 'Längengrad der Zweigstelle',
    'enter_branch_location_longitude' => 'Längengrad der Zweigstelle eingeben',
    'status' => 'Status',
    'select_status' => 'Status auswählen',
    'active' => 'Aktiv',
    'inactive' => 'Inaktiv',
    'create' => 'Erstellen',

    /** Department */
    'department_section' => 'Abteilungsbereich',
    'departments' => 'Abteilungen',
    'add_department' => 'Abteilung hinzufügen',
    'department_lists' => 'Abteilungsliste',
    'search_by_department_name' => 'Nach Abteilungsname suchen',
    'select_branch' => 'Zweigstelle auswählen',
    'edit' => 'Bearbeiten',
    'delete' => 'Löschen',
    'are_you_sure_delete_department' => 'Sind Sie sicher, dass Sie die Abteilung löschen möchten?',
    'edit_department' => 'Abteilung bearbeiten',
    'button_back' => 'Zurück',
    'breadcrumb' => 'Brotkrumen',
    'update_department' => 'Abteilung aktualisieren',
    'create_department' => 'Abteilung erstellen',
    'department_name' => 'Abteilungsname',
    'department_head' => 'Abteilungsleiter',
    'select_department_head' => 'Abteilungsleiter auswählen',
    'create_update_department' => 'Abteilung erstellen/aktualisieren',

    /** Post */
    'post_section' => 'Beitragsbereich',
    'posts' => 'Beiträge',
    'add_post' => 'Beitrag hinzufügen',
    'search_by_department' => 'Nach Abteilung suchen',
    'search_by_post_name' => 'Nach Beitragsname suchen',
    'post_name' => 'Beitragsname',
    'post_empty' => 'Keine Beiträge',
    'edit_post_title' => 'Beitrag bearbeiten',
    'create_post_title' => 'Beitrag erstellen',
    'department_label' => 'Abteilung',
    'post_name_label' => 'Beitragsname',
    'status_label' => 'Status',
    'select_department' => 'Abteilung auswählen',
    'active_option' => 'Aktiv',
    'inactive_option' => 'Inaktiv',
    'update_update_button' => 'Beitrag aktualisieren',
    'change_status_confirmation' => 'Sind Sie sicher, dass Sie den Status ändern möchten?',
    'delete_post_confirmation' => 'Sind Sie sicher, dass Sie den Beitrag löschen möchten?',
    'employee_list_title' => 'Mitarbeiterliste',

    /** Employee List */
    'employees_title' => 'Mitarbeiter',
    'employees_action' => 'Listen',
    'add_employee' => 'Mitarbeiter hinzufügen',
    'employee_section' => 'Mitarbeiterbereich',
    'employee_create' => 'Mitarbeiter erstellen',
    'employee_name' => 'Mitarbeitername',
    'employee_email' => 'Mitarbeiter-E-Mail',
    'employee_phone' => 'Mitarbeiter-Telefonnummer',
    'full_name' => 'Vollständiger Name',
    'designation' => 'Bezeichnung',
    'role' => 'Rolle',
    'shift' => 'Schicht',
    'workplace' => 'Arbeitsplatz',
    'is_active' => 'Ist aktiv',
    'edit_detail' => 'Details bearbeiten',
    'delete_user' => 'Benutzer löschen',
    'change_password' => 'Passwort ändern',
    'force_logout' => 'Zwangsabmeldung',
    'all_fields_required' => 'Alle (<span style="color: red">*</span>) Felder sind erforderlich',
    'personal_detail' => 'Persönliche Details',
    'employee_code' => 'Mitarbeitercode',
    'enter_name' => 'Name eingeben',
    'enter_employee_address' => 'Mitarbeiteradresse eingeben',
    'enter_email' => 'Email eingeben',
    'dob' => 'Geburtsdatum',
    'gender' => 'Geschlecht',
    'select_gender' => 'Geschlecht auswählen',
    'marital_status' => 'Familienstand',
    'choose_marital_status' => 'Familienstand wählen',
    'upload_avatar' => 'Avatar hochladen',
    'description' => 'Beschreibung',
    'username' => 'Benutzername',
    'enter_username' => 'Benutzername eingeben',
    'password' => 'Passwort',
    'enter_password' => 'Passwort eingeben',
    'select_role' => 'Rolle auswählen',
    'company_detail' => 'Firmendetails',
    'supervisor' => 'Vorgesetzter',
    'employment_type' => 'Beschäftigungsart',
    'select_employment_type' => 'Beschäftigungsart auswählen',
    'joining_date' => 'Eintrittsdatum',
    'enter_joining_date' => 'Eintrittsdatum eingeben',
    'workspace' => 'Arbeitsplatz',
    'select_workspace' => 'Arbeitsplatz auswählen',
    'field' => 'Feld',
    'office' => 'Büro',
    'leave_detail' => 'Urlaubsdetails',
    'leave_allocated' => 'Urlaub zugeteilt',
    'assigned_leaves' => 'Zugewiesene Urlaubstage',
    'no_of_days' => 'Anzahl der Tage',
    'total_leave_days' => 'Gesamturlaubstage',
    'bank_detail' => 'Bankdetails',
    'bank_name' => 'Bankname',
    'bank_account_number' => 'Bankkontonummer',
    'account_holder_name' => 'Kontoinhabername',
    'bank_account_type' => 'Bankkontoart',
    'select_account_type' => 'Kontotyp auswählen',
    'create_user' => 'Benutzer erstellen',
    'update_user' => 'Benutzer aktualisieren',
    'new_password' => 'Neues Passwort',
    'enter_new_password' => 'Neues Passwort eingeben',
    'confirm_password' => 'Passwort bestätigen',
    'confirm_password_placeholder' => 'Passwort bestätigen',
    'submit' => 'Einreichen',
    'user_change_password' => 'Benutzer Passwort ändern',
    'confirm_delete_employee' => 'Sind Sie sicher, dass Sie den Mitarbeiter löschen möchten?',
    'confirm_force_logout' => 'Sind Sie sicher, dass Sie den Benutzer zur Abmeldung zwingen möchten?',
    'confirm_change_workplace' => 'Sind Sie sicher, dass Sie den Arbeitsplatz wechseln möchten?',
    'select_supervisor' => 'Vorgesetzten auswählen',
    'select_office_time' => 'Bürozeit auswählen',
    'select_option' => 'Option auswählen',
    'enter_address' => 'Bitte Adresse eingeben.',
    'enter_valid_email' => 'Bitte eine gültige Email-Adresse eingeben.',
    'enter_phone_number' => 'Bitte Telefonnummer eingeben.',
    'create_employee' => 'Mitarbeiter erstellen',
    'add' => 'Hinzufügen',
    'edit_user_detail' => 'Benutzerdetails bearbeiten',
    'show_user_details' => 'Benutzerdetails anzeigen',
    'detail' => 'Detail',
    'back' => 'Zurück',
    'user_detail' => 'Benutzerdetail',
    'date_of_birth' => 'Geburtsdatum',
    'not_applicable' => 'N/A',
    'office_detail' => 'Bürodetails',
    'home' => 'Heim',
    'account_detail' => 'Kontodetails',
    'account_number' => 'Kontonummer',
    'account_type' => 'Kontotyp',
    'account_holder' => 'Kontoinhaber',
    'not_available' => 'N/A',

    /** logout requests */
    'logout_request_status' => 'Abmeldeanforderungsstatus',
    'take_action' => 'Maßnahme ergreifen',
    'confirm_accept_logout_request' => 'Sind Sie sicher, dass Sie die Abmeldeanforderung annehmen möchten?',

    /** attendance */
    'attendance' => 'Anwesenheit',
    'employee_attendance_lists' => 'Anwesenheitslisten der Mitarbeiter',
    'attendance_of_the_day' => 'Anwesenheit des Tages',
    'date_placeholder_bs' => 'jj/mm/tt',
    'csv_export' => 'CSV-Export',
    'attendance_status' => 'Anwesenheitsstatus',
    'attendance_by' => 'Anwesenheit durch',
    'show_detail' => 'Details anzeigen',
    'show_checkin_location' => 'Check-in-Standort anzeigen',
    'show_checkout_location' => 'Check-out-Standort anzeigen',
    'checkin' => 'Check-in',
    'checkout' => 'Check-out',
    'approved' => 'Genehmigt',
    'rejected' => 'Abgelehnt',
    'self' => 'Selbst',
    'admin' => 'Admin',
    'edit_attendance_time' => 'Anwesenheitszeit bearbeiten',
    'employee_attendance_detail' => 'Anwesenheitsdetails des Mitarbeiters',
    'attendance_of' => 'Anwesenheit von',
    'total_days_in_month' => 'Gesamttage im Monat',
    'present_days' => 'Anwesenheitstage',
    'absent_days' => 'Abwesenheitstage',
    'weekend_days' => 'Wochenendtagen',
    'holiday_days' => 'Feiertage',
    'leave_days' => 'Urlaubstage',
    'working_hours' => 'Arbeitsstunden',
    'worked_hours' => 'Geleistete Stunden',
    'attendance_details_of' => 'Anwesenheitsdetails für :month',
    'all_month' => 'Ganzen Monat',
    'worked_hour' => 'Gearbeitete Stunde',
    'add_attendance_time' => 'Anwesenheitszeit hinzufügen',
    'confirm_change_attendance_status' => 'Sind Sie sicher, dass Sie den Anwesenheitsstatus ändern möchten?',
    'check_in' => 'Einchecken',
    'check_out' => 'Auschecken',
    'attendance_title' => 'Anwesenheit',
    'attendance_action' => 'Anwesenheitsdetails des Mitarbeiters',
    'filter_placeholder' => 'Anwesenheitsjahr z.B.: :min_year',
    'filter_button' => 'Filter',
    'csv_export_button' => 'CSV-Export',
    'reset_button' => 'Zurücksetzen',
    'total_days' => 'Gesamttage im Monat',
    'attendance_details' => 'Anwesenheitsdetails von :monthName',
    'date' => 'Datum',
    'change_attendance_status' => 'Anwesenheitsstatus ändern',
    'create_attendance' => 'Anwesenheit erstellen',
    'admin_remark' => 'Admin-Bemerkung',
    'edit_attendance' => 'Anwesenheit bearbeiten',
    'admin_edit_remark' => 'Admin-Bearbeitungsbemerkung',
    'confirm_check_in' => 'Sind Sie sicher, dass Sie den Mitarbeiter einchecken möchten?',
    'confirm_check_out' => 'Sind Sie sicher, dass Sie den Mitarbeiter auschecken möchten?',
    'edit_attendance_title' => 'Anwesenheit bearbeiten (:name) Zeit von :date',
    'create_attendance_title' => 'Anwesenheit erstellen (:name) Zeit von :date',
    'total_worked_hours' => 'Gesamtarbeitsstunden',
    'attendance_report' => 'Anwesenheitsbericht',

    /** clients */
    'client_listing' => 'Kundenliste',
    'add_client' => 'Kunde hinzufügen',
    'client_name' => 'Kundenname',
    'client_email' => 'Kunden-E-Mail',
    'edit_client_detail' => 'Kundendetails bearbeiten',
    'show_client_detail' => 'Kundendetails anzeigen',
    'delete_client_detail' => 'Kundendetails löschen',
    'client_invoices' => 'Kundenrechnungen',
    'client_detail' => 'Kundendetail:',
    'client_project_lists' => 'Projektlisten des Kunden:',
    'country' => 'Land',
    'edit_client' => 'Kunde bearbeiten',
    'create_client' => 'Kunde erstellen',
    'client_section' => 'Kundensektion',
    'client_contact' => 'Kundenkontakt',
    'client_address' => 'Adresse',
    'client_country' => 'Land',
    'upload_profile' => 'Kundenprofil hochladen',
    'enter_client_name' => 'Kundenname eingeben',
    'enter_client_email' => 'Kunden-E-Mail eingeben',
    'enter_contact_number' => 'Kontaktnummer eingeben',
    'enter_client_address' => 'Kundenadresse eingeben',
    'enter_country' => 'Land eingeben',
    'confirm_status_change' => 'Sind Sie sicher, dass Sie den Status ändern möchten?',
    'confirm_delete_client' => 'Sind Sie sicher, dass Sie die Kundendetails löschen möchten?',

    /** Project management */
    'lists' => 'Listen',
    'create_project' => 'Projekt erstellen',
    'project_filter' => 'Projektfilter',
    'search_by_project' => 'Nach Projekt suchen',
    'search_by_status' => 'Nach Status suchen',
    'search_by_priority' => 'Nach Priorität suchen',
    'client' => 'Kunde',
    'all_tasks' => 'Alle Aufgaben',
    'completed_tasks' => 'Abgeschlossene Aufgaben',
    'days_left' => 'Tage übrig',
    'team_member' => 'Teammitglied',
    'start_date' => 'Startdatum',
    'due_date' => 'Fälligkeitsdatum',
    'view' => 'Anzeigen',
    'projects' => 'Projekte',
    'assign_employee' => 'Mitarbeiter zuweisen',
    'client_contact_number' => 'Kontaktnummer des Kunden',
    'upload_client_profile' => 'Kundenprofil hochladen',
    'project_name' => 'Projektname',
    'project_start_date' => 'Projektstartdatum',
    'project_deadline' => 'Projektdeadline',
    'project_status' => 'Projektstatus',
    'select_project_status' => 'Projektstatus auswählen',
    'project_cost' => 'Projektkosten',
    'select_priority' => 'Priorität auswählen',
    'estimated_hours' => 'Geschätzte Stunden',
    'select_client' => 'Kunde auswählen',
    'upload_project_logo' => 'Projektlogo hochladen',
    'uploaded_files_images' => 'Hochgeladene Dateien und Bilder',
    'no_project_file_uploaded' => 'Keine Projektdatei hochgeladen',
    'update_project' => 'Projekt aktualisieren',
    'project_leader' => 'Projektleiter',
    'assign_member' => 'Mitglied zuweisen',
    'edit_project' => 'Projekt bearbeiten',
    'project_document' => 'Projektdokument',
    'upload_documents' => 'Dokumente hochladen',
    'upload_project_attachments' => 'Projektanhänge hochladen',
    'show_project_detail' => 'Projektdetails anzeigen',
    'upload_attachments' => 'Anhänge hochladen',
    'project_attachments' => 'Projektanhänge',
    'uploaded_image_files' => 'Hochgeladene Bilddateien',
    'no_project_image_found' => 'Kein Projektbild gefunden',
    'uploaded_files' => 'Hochgeladene Dateien',
    'no_project_files_found' => 'Keine Projektdateien gefunden',
    'project_tasks_lists' => 'Projektaufgabenlisten',
    'project_summary' => 'Projektzusammenfassung',
    'cost' => 'Kosten:',
    'total_hours' => 'Gesamtstunden:',
    'created' => 'Erstellt:',
    'remaining_days' => 'Verbleibende Tage:',
    'project_leaders' => 'Projektleiter',
    'update_leader' => 'Leiter aktualisieren',
    'project_members' => 'Projektmitglieder',
    'update_member' => 'Mitglied aktualisieren',
    'project_client_detail' => 'Projektkundendetail',
    'delete_project_detail' => 'Sind Sie sicher, dass Sie die Projektdetails löschen möchten?',
    'delete_project_document' => 'Sind Sie sicher, dass Sie das Projektdokument löschen möchten?',
    'search_by_member' => 'Nach Mitglied suchen',
    'add_employee_to_project' => 'Mitarbeiter zum Projekt hinzufügen',

    /** Task management */
    'tasks' => 'Aufgaben',
    'task_filter' => 'Aufgabenfilter',
    'search_by_task_name' => 'Nach Aufgabenname suchen',
    'not_started' => 'Nicht gestartet',
    'create_tasks' => 'Aufgaben erstellen',
    'end_date' => 'Enddatum',
    'task_name' => 'Aufgabenname',
    'enter_task_name' => 'Aufgabenname eingeben',
    'select_project' => 'Projekt auswählen',
    'task_start_date' => 'Startdatum der Aufgabe',
    'task_start_time' => 'Startzeit der Aufgabe',
    'task_end_date' => 'Enddatum der Aufgabe',
    'task_end_time' => 'Endzeit der Aufgabe',
    'task_status' => 'Aufgabenstatus',
    'select_task_status' => 'Aufgabenstatus auswählen',
    'uploaded_files_and_images' => 'Hochgeladene Dateien und Bilder',
    'task_attachments' => 'Aufgabenanhänge',
    'update_task' => 'Aufgabe aktualisieren',
    'create_task' => 'Aufgabe erstellen',
    'mention' => 'Erwähnung',
    'comment' => 'Kommentar',
    'close' => 'Schließen',
    'write_comment' => 'Kommentar schreiben',
    'reply' => 'Antworten',
    'delete_confirm' => 'Sind Sie sicher, dass Sie ":title" löschen möchten?',
    'task_member_placeholder' => 'Mitglied der Aufgabe zuweisen',
    'project_placeholder' => 'Projekt auswählen',
    'project_filter_placeholder' => 'Nach Projekt suchen',
    'task_name_placeholder' => 'Nach Aufgabenname suchen',
    'change_task_status_confirm' => 'Sind Sie sicher, dass Sie den Status der Aufgabe ändern möchten?',
    'change_status_confirm' => 'Sind Sie sicher, dass Sie den Status ändern möchten?',
    'delete_task_detail_confirm' => 'Sind Sie sicher, dass Sie die Details der Aufgabe löschen möchten?',
    'create_checklist_text' => 'Checkliste erstellen',
    'close_checklist_text' => 'Schließen',
    'remove_checklist_text' => 'Entfernen',
    'remove_checklist_title' => 'Checkliste entfernen',
    'view_all_comments' => 'Alle Kommentare anzeigen',
    'comments' => 'Kommentare',
    'edit_task' => 'Aufgabe bearbeiten',
    'edit_task_detail' => 'Aufgabendetails bearbeiten',
    'show_task_detail' => 'Aufgabendetails anzeigen',
    'task_edit' => 'Aufgabe bearbeiten',
    'create_checklist' => 'Checkliste erstellen',
    'upload_attachment' => 'Anhang hochladen',
    'total_checklist' => 'Gesamtchecklisten',
    'completed_checklist' => 'Abgeschlossene Checklisten',
    'task_checklist_lists' => 'Aufgaben-Checklisten',
    'assigned_to' => 'Zugewiesen an',
    'create_task_checklist' => 'Aufgaben-Checkliste erstellen',
    'enter_checklist_title' => 'Checklisten-Titel eingeben',
    'select_member' => 'Mitglied auswählen',
    'add_more_checklist' => 'Weitere Checklisten hinzufügen',
    'image' => 'Bild',
    'file' => 'Datei',
    'edit_checklist' => 'Checkliste bearbeiten',
    'delete_checklist' => 'Checkliste löschen',
    'checklist' => 'Checkliste',
    'edit_task_checklist' => 'Aufgaben-Checkliste bearbeiten',
    'checklist_name' => 'Checklistenname',
    'assign_task_checklist' => 'Aufgaben-Checkliste zuweisen',
    'task_summary' => 'Aufgabenübersicht',
    'task_members' => 'Aufgabenmitglieder',
    'task_attachment_title' => 'Aufgabenanhänge',
    'upload_attachment_action' => 'Anhang hochladen',
    'upload_task_attachments' => 'Aufgabenanhänge hochladen',
    'upload_task_attachments_text' => 'Aufgabenanhänge hochladen',
    'choose_file_text' => 'Datei auswählen',

    /** Holiday */
    'holiday_section' => 'Feiertagsbereich',
    'event' => 'Ereignis',
    'event_date' => 'Ereignisdatum',
    'is_public_holiday' => 'Ist ein öffentlicher Feiertag?',
    'confirm_delete_holiday' => 'Sind Sie sicher, dass Sie die Feiertagsdetails löschen möchten?',
    'holiday_detail_title' => 'Feiertagsdetail',
    'holiday' => 'Feiertag',
    'csv_import' => 'CSV Importieren',
    'import' => 'Importieren',
    'holiday_detail_csv' => 'Feiertagsdetail CSV',
    'holiday_csv_example' => 'Beispiel CSV für Feiertage',
    'add_holiday' => 'Feiertag hinzufügen',
    'import_holiday_csv' => 'Feiertags-CSV importieren',
    'holiday_filter' => 'Feiertagsfilter',
    'event_name' => 'Ereignisname',
    'leave_requested_year' => 'Beantragtes Jahr für Urlaub',
    'holiday_detail' => 'Feiertagsdetail',

    /** Notice */
    'notices_section' => 'Mitteilungsabschnitt',
    'notice_title' => 'Mitteilungstitel',
    'notice_description' => 'Mitteilungsbeschreibung',
    'notice_receiver' => 'Mitteilungsempfänger',
    'send_notice' => 'Mitteilung senden',
    'all_employees' => 'Alle Mitarbeiter',
    'create_notice' => 'Mitteilung erstellen',
    'edit_notice' => 'Mitteilung bearbeiten',
    'notices' => 'Mitteilungen',
    'receiver' => 'Empfänger',
    'published_from' => 'Veröffentlicht ab',
    'publish_to' => 'Veröffentlichen bis',
    'publish_date' => 'Veröffentlichungsdatum',
    'show_notice_content' => 'Mitteilungsinhalt anzeigen',
    'delete_notice_detail' => 'Mitteilungsdetail löschen',
    'notice_lists' => 'Mitteilungslisten',
    'confirm_change_notice_status' => 'Möchten Sie den Status der Mitteilung wirklich ändern?',
    'confirm_delete_notice' => 'Möchten Sie die Mitteilung wirklich löschen?',
    'confirm_send_notice' => 'Möchten Sie die Mitteilung wirklich senden?',
    'notice_detail_modal_title' => 'Benachrichtigung :title Detail',

    /** payroll */
    'employee_payroll' => 'Mitarbeiterabrechnung',
    'payroll_generate' => 'Abrechnung erzeugen',
    'payroll_create' => 'Abrechnung erstellen',
    'payroll_edit' => 'Abrechnung bearbeiten',
    'select_year' => 'Jahr auswählen',
    'salary_cycle' => 'Gehaltszyklus',
    'salary_month' => 'Gehaltsmonat',
    'salary_week' => 'Gehaltswoche',
    'select_week' => 'Woche auswählen',
    'include_tada' => 'TADA einschließen',
    'include_advance_salary' => 'Vorausgehalt einschließen',
    'use_attendance' => 'Anwesenheit nutzen',
    'generate' => 'Erzeugen',
    'clear' => 'Löschen',
    'report' => 'Bericht:',
    'duration' => 'Dauer',
    'payroll_summary' => 'Abrechnungsübersicht',
    'total_basic_salary' => 'Gesamtes Grundgehalt:',
    'total_net_salary' => 'Gesamtnettogehalt:',
    'total_allowance' => 'Gesamtzulage:',
    'total_deduction' => 'Gesamtabzug:',
    'total_overtime' => 'Gesamtüberstunden:',
    'total_undertime' => 'Gesamtfehlzeiten:',
    'paid_by' => 'Bezahlt von',
    'net_salary' => 'Nettogehalt',
    'paid_on' => 'Bezahlt am',
    'pay_button' => 'Bezahlen',
    'select_payment_method.' => 'Bitte wählen Sie eine Zahlungsmethode.',
    'confirm_delete_payroll' => 'Sind Sie sicher, dass Sie die Mitarbeiterabrechnung löschen möchten?',
    'confirm_generate_payroll' => 'Sind Sie sicher, dass Sie die Abrechnung erzeugen möchten?',
    'confirm_change_cycle' => 'Sind Sie sicher, dass Sie den Gehaltszyklus ändern möchten?',
    'payment_title' => 'Zahlung vornehmen',
    'payment_method_placeholder' => 'Zahlungsmethode auswählen',
    'payment_date' => 'Zahlungsdatum',
    'hourly_rate' => 'Stundensatz',
    'hourly' => 'Stündlich',
    'working_hours_in_week' => 'Arbeitsstunden pro Woche',
    'annual_salary' => 'Jahresgehalt (CTC)',
    'annual' => 'Jährlich',
    'basic_salary' => 'Grundgehalt',
    'fixed_allowance' => 'Feste Zulage',
    'total' => 'Gesamt',
    'net_total' => 'Nettogesamt',
    'earnings' => 'Einkommen',
    'deductions' => 'Abzüge',
    'create_salary' => 'Gehalt erstellen',
    'edit_salary' => 'Gehalt bearbeiten',
    'add_salary' => 'Gehalt hinzufügen',
    'calculation_type' => 'Berechnungstyp',
    'monthly_amount' => 'Monatlicher Betrag',
    'annual_amount' => 'Jährlicher Betrag',
    'salary_slip' => 'Gehaltsabrechnung',
    'edit_salary_slip' => 'Gehaltsabrechnung bearbeiten',
    'payslip' => 'Gehaltszettel',
    'for_the_month_of' => 'für den Monat',
    'from' => 'von',
    'to' => 'bis',
    'employee_id' => 'Mitarbeiter-ID',
    'earning' => 'Einkommen',
    'deduction' => 'Abzug',
    'actual_salary' => 'Tatsächliches Gehalt',
    'total_earning' => 'Gesamteinkommen',
    'actual_salary_formula' => '(Gesamteinkommen - Gesamtabzüge)',
    'bonus' => 'Bonus',
    'taxable_salary' => 'Steuerpflichtiges Gehalt',
    'taxable_salary_formula' => '(Tatsächliches Gehalt + Bonus)',
    'tax' => 'Steuer',
    'salary_after_tax' => 'Gehalt nach Steuern',
    'expenses_claim' => 'Ausgabenansprüche (TADA)',
    'absent' => 'Abwesend',
    'absent_deduction_formula' => '((Bruttogehalt / Gesamttage) * Abwesenheitstage)',
    'net_salary_formula' => 'Nettogehalt = (Tatsächliches Gehalt - Vorausgehalt + TADA)',
    'monthly' => 'Monatlich',
    'weekly' => 'Wöchentlich',
    'salary_increment' => 'Gehaltserhöhung',
    'increment' => 'Erhöhung',
    'current_salary' => 'Aktuelles Gehalt',
    'annual_increment_percent' => 'Jährliche Erhöhung %',
    'annual_increment_amount' => 'Jährlicher Erhöhungsbetrag',
    'revised_salary_label' => 'Überarbeitetes Gehalt',
    'fiscal_year_label' => 'Erhöhung für das Geschäftsjahr',
    'applicable_from_label' => 'Gültig ab (Datum)',
    'applicable_to_label' => 'Gültig bis (Datum)',
    'remark' => 'Bemerkung',
    'fiscal_year' => 'Geschäftsjahr',
    'select_fiscal_year' => 'Geschäftsjahr auswählen',
    'list' => 'Liste',
    'employee_salary_filter' => 'Mitarbeitergehaltsfilter',
    'salary_review_history' => 'Gehaltsüberprüfungshistorie',
    'increase_salary' => 'Gehalt erhöhen',
    'all' => 'Alle',
    'employee_payslip' => 'Mitarbeitergehaltszettel',
    'salary_from' => 'Gehalt von',
    'salary_to' => 'Gehalt bis',
    'unpaid_leave' => 'Unbezahlter Urlaub',
    'paid_leave' => 'Bezahlter Urlaub',
    'employee_gross_salary' => 'Bruttogehalt des Mitarbeiters',
    'salary_increment_log' => 'Gehaltserhöhung Protokoll',
    'log' => 'Protokoll',
    'salary_revised_on' => 'Gehalt überarbeitet am',
    'increment_by' => 'Erhöhung durch',
    'increment_value' => 'Erhöhungswert',
    'old_salary' => 'Altes Gehalt',
    'new_salary' => 'Neues Gehalt',
    'date_to' => 'Datum bis',
    'date_from' => 'Datum von',
    'salary_increment_remark' => 'Bemerkung zur Gehaltserhöhung',
    'advance_salary_requests' => 'Vorausgehaltsanträge',
    'advance_salary_request_filter' => 'Filter für Vorausgehaltsanträge',
    'delete_confirmation' => 'Sind Sie sicher, dass Sie löschen möchten?',
    'payslip_for_the_month_of' => 'Gehaltszettel für den Monat',
    'absent_deduction' => 'Abwesenheitsabzug',

    /** Advance Salary */
    'is_paid' => 'Wurde bezahlt?',
    'released_on' => 'Veröffentlicht am',
    'requested_on' => 'Angefordert am',
    'released_amount' => 'Ausgezahlter Betrag',
    'requested_amount' => 'Angeforderter Betrag',
    'search_by_month' => 'Nach Monat suchen',
    'search_by_employee_name' => 'Nach Mitarbeitername suchen',
    'advance_salary_detail' => 'Detail der Vorauszahlung',
    'is_settled' => 'Abgerechnet',
    'verified_by' => 'Verifiziert von',
    'amount_released_date' => 'Datum der Freigabe des Betrags',
    'advance_requested_date' => 'Datum der Anforderung des Vorschusses',
    'total_released_amount' => 'Gesamtfreigabebetrag',
    'total_request_amount' => 'Gesamterforderungsbetrag',
    'employee' => 'Mitarbeiter',
    'select_employee' => 'Mitarbeiter auswählen',
    'advance_salary_request_detail' => 'Detail der Vorauszahlungsanforderung',
    'proof_of_advance_salary_payment' => 'Nachweis der Vorauszahlung',
    'attachments' => 'Anhänge',
    'processing' => 'Wird bearbeitet',

    /** Tax report */
    'tax_report' => 'Steuerbericht',
    'employee_tax_report' => 'Steuerbericht des Mitarbeiters',
    'tax_report_edit' => 'Steuerbericht bearbeiten',
    'tax_report_detail_of' => 'Details des Steuerberichts von',
    'tax_report_detail' => 'Details des Steuerberichts',
    'salary_sheet' => 'Gehaltsabrechnung',
    'particular' => 'Besonderheit',
    'income' => 'Einkommen',
    'tax_data_not_available' => 'Keine Steuerdaten für den aktuellen Familienstand verfügbar',
    'remain_tds_formula' => '(Gesamtschuldiger TDS / Anzahl der verbleibenden Monate)',
    'remaining_month' => 'Verbleibender Monat',
    'tds_calculation_msg' => 'TDS-Berechnung für den aktuellen Monat (Berechnungsmonat)',
    'total_due_tds' => 'Gesamt fälliger TDS',
    'total_paid_tds' => 'Gesamt gezahlter TDS',
    'total_payable_tds' => 'Gesamt zu zahlender TDS',
    'other_discount' => 'Weitere Ermäßigung',
    'female_discount' => 'Frauenrabatt',
    'medical_claim' => 'Medizinische Forderung',
    'less' => 'weniger',
    'less_tax_deduction' => 'weniger: Steuerabzug',
    'tax_amount' => 'Steuerbetrag',
    'percent' => 'Prozent',
    'tax_calculation_on_taxable_income' => 'Steuerberechnung auf das steuerpflichtige Einkommen',
    'taxable_income' => 'Steuerpflichtiges Einkommen',
    'ssf_contribution' => 'SSF-Beitrag',
    'ssf_contribution_salary' => 'SSF-Beitrag Gehalt',
    'total_retirement_contribution_allowed' => 'Gesamterlaubter Altersvorsorgebeitrag',
    'total_income' => 'Gesamteinkommen',
    'amount' => 'Betrag',
    'additional_information' => 'Zusätzliche Informationen',
    'total_payable' => 'Gesamt zu zahlender Betrag',
    'tds_paid' => 'Gezahlte TDS',
    'ssf_deduction' => 'SSF-Abzug',
    'tax_report_generate' => 'Steuerbericht erstellen',
    'print' => 'Drucken',
    'gross_earnings' => 'Bruttoeinkommen',
    'tax_payable' => 'Fällige Steuer',

    /** Payroll Setting  */
    'advance_salary_limit' => 'Vorschussgrenze',
    'select_month' => 'Monat auswählen',
    'applicable_month' => 'Anwendbarer Monat',
    'value' => 'Wert',
    'value_type' => 'Werttyp',
    'enter_bonus_type' => 'Bonusart eingeben',
    'salary_components' => 'Gehaltsbestandteile',
    'add_bonus' => 'Bonus hinzufügen',
    'max_daily_ot' => 'Max. tägliche Überstunden',
    'assign_overtime_to_employee' => 'Überstunden dem Mitarbeiter zuweisen',
    'overtime_pay_rate' => 'Überstundenvergütung (pro Stunde)',
    'overtime_rate_percent' => 'Überstundenrate (pro Stunde)',
    'placeholder_overtime_pay_rate' => 'Überstundenvergütung eingeben',
    'placeholder_overtime_rate_percent' => 'Überstundenrate eingeben',
    'rate_type' => 'Satztyp',
    'select_rate_type' => 'Satztyp auswählen',
    'ot_valid_after_hour' => 'Überstunden gültig nach? Stunde',
    'placeholder_ot_valid_after_hour' => 'Stunden eingeben, nach denen Überstunden gültig sind',
    'monthly_ot' => 'Maximale monatliche Überstunden',
    'placeholder_monthly_ot' => 'Maximale monatliche Überstunden eingeben',
    'weekly_ot' => 'Maximale wöchentliche Überstunden',
    'placeholder_weekly_ot' => 'Maximale wöchentliche Überstunden eingeben',
    'daily_ot' => 'Maximale tägliche Überstunden',
    'placeholder_daily_ot' => 'Maximale tägliche Überstunden eingeben',
    'pay_percent' => 'Zahlungsprozentsatz/Ratensatz',
    'employee_count' => 'Mitarbeiteranzahl',
    'hour' => 'Stunde',
    'currency_setting' => 'Währungseinstellungen',
    'payroll_currency' => 'Gehaltswährung',
    'choose_payroll_currency' => 'Gehaltswährung wählen',
    'add_payment_method' => 'Zahlungsmethode hinzufügen',
    'payment_method_name' => 'Name der Zahlungsmethode',
    'update_payment_method' => 'Zahlungsmethode aktualisieren',
    'component_value' => 'Komponentenwert',
    'component_type' => 'Komponententyp',
    'add_salary_component' => 'Gehaltsbestandteil hinzufügen',
    'apply_for_all' => 'Für alle anwenden',
    'component_value_annual' => 'Komponentenwert (jährlich)',
    'select_value_type' => 'Werttyp auswählen',
    'select_component_type' => 'Komponententyp auswählen',
    'enter_salary_component_name' => 'Namen des Gehaltsbestandteils eingeben',
    'add_salary_group' => 'Gehaltsgruppe hinzufügen',
    'delete_confirm_salary_group' => 'Sind Sie sicher, dass Sie die Gruppendetails löschen möchten?',
    'assign_employee_to_group' => 'Mitarbeiter der Gruppe zuweisen',
    'choose_salary_component' => 'Gehaltsbestandteil auswählen',
    'assign_salary_components' => 'Gehaltsbestandteile zuweisen',
    'enter_salary_group_name' => 'Namen der Gehaltsgruppe eingeben',
    'add_more_tds_detail' => 'Weitere TDS-Details hinzufügen',
    'enter_tds_in_percent' => 'TDS in Prozent eingeben',
    'enter_annual_salary_to' => 'Jahresgehalt bis eingeben',
    'enter_annual_salary_from' => 'Jahresgehalt von eingeben',
    'select_marital_status' => 'Familienstand auswählen',
    'create_salary_tds' => 'TDS für Gehalt erstellen',
    'update_salary_tds' => 'TDS für Gehalt aktualisieren',
    'salary_tds_detail_for_single' => 'TDS-Detail für Einzelpersonen',
    'add_salary_tds' => 'TDS für Gehalt hinzufügen',
    'annual_salary_to' => 'Jahresgehalt bis',
    'annual_salary_from' => 'Jahresgehalt von',
    'tds' => 'TDS (%)',
    'salary_tds_detail_for_married' => 'TDS-Detail für Verheiratete',
    'ssf' => 'SSF',
    'employee_contribution' => 'Mitarbeiterbeitrag',
    'office_contribution' => 'Bürobeitrag',
    'assign_undertime_to_employee' => 'Unterstunden dem Mitarbeiter zuweisen',
    'enter_title' => 'Titel eingeben',
    'undertime_after_minute' => 'Minuten nach denen Unterstunden gelten',
    'placeholder_ut_after' => 'Stunden eingeben, nach denen Unterstunden gelten',
    'penalty_type' => 'Strafart',
    'select_penalty_type' => 'Strafart auswählen',
    'penalty_percent' => 'Strafprozentsatz (pro Stunde)',
    'penalty_percent_placeholder' => 'Unterstunden-Strafprozentsatz eingeben',
    'penalty_rate' => 'Strafrate (pro Stunde)',
    'penalty_rate_placeholder' => 'Unterstunden-Strafrate eingeben',

    /** Leave */
    'leave_type_section' => 'Urlaubsart Abschnitt',
    'select_leave_type' => 'Urlaubsart auswählen',
    'leave_type' => 'Urlaubsart',
    'leave_allocated_days' => 'Zugewiesene Urlaubstage',
    'allocated_days' => 'Zugewiesene Tage',
    'is_paid_leave' => 'Ist bezahlter Urlaub',
    'leave_type_name' => 'Name der Urlaubsart',
    'leave_type_placeholder' => 'Urlaubsart eingeben',
    'add_leave_type' => 'Urlaubsart hinzufügen',
    'type' => 'Typ',
    'edit_leave_type_detail' => 'Details der Urlaubsart bearbeiten',
    'delete_leave_type' => 'Urlaubsart löschen',
    'delete_leave_confirmation' => 'Sind Sie sicher, dass Sie die Urlaubsart löschen möchten?',
    'leave_request_section' => 'Urlaubsantragsabschnitt',
    'approve' => 'Genehmigen',
    'reject' => 'Ablehnen',
    'from_date' => 'Von Datum',
    'to_date' => 'Bis Datum',
    'start_time' => 'Beginnzeit',
    'end_time' => 'Endzeit',
    'reason' => 'Grund',
    'requested_for' => 'Beantragt für',
    'requested_by' => 'Beantragt von',
    'requested_days' => 'Beantragte Tage',
    'requested_date' => 'Antragsdatum',
    'all_status' => 'Alle Status',
    'all_leave_type' => 'Alle Urlaubsarten',
    'leave_request_filter' => 'Urlaubsantragsfilter',
    'create_leave_request' => 'Urlaubsantrag erstellen',
    'leave_reason' => 'Urlaubsgrund',
    'referred_by' => 'Empfohlen von',
    'leave_date' => 'Urlaubsdatum',
    'time_leave_request_filter' => 'Filter für zeitbezogenen Urlaubsantrag',
    'create_time_leave_request' => 'Zeitbezogenen Urlaubsantrag erstellen',
    'time_leave_request_section' => 'Abschnitt für zeitbezogenen Urlaubsantrag',
    'time_leave_status_update' => 'Aktualisierung des Status für zeitbezogenen Urlaub',

    /** Team Meeting */
    'team_meeting_section' => 'Team-Meeting-Bereich',
    'update_and' => 'aktualisieren und',
    'create_and' => 'Erstellen und',
    'send' => 'Senden',
    'meeting_participator' => 'Teilnehmer',
    'image_hint' => 'Bild sollte idealerweise im Querformat sein',
    'meeting_description' => 'Meeting-Beschreibung',
    'upload_image' => 'Bild hochladen',
    'meeting_start_time' => 'Beginn des Meetings',
    'meeting_date' => 'Meeting-Datum',
    'meeting_venue' => 'Meeting-Ort',
    'enter_venue_name' => 'Geben Sie den Ort ein',
    'enter_content_title' => 'Geben Sie den Inhaltstitel ein',
    'meeting_title' => 'Meeting-Titel',
    'delete_team_meeting_confirmation' => 'Sind Sie sicher, dass Sie das Team-Meeting löschen möchten?',
    'image_delete_confirmation' => 'Sind Sie sicher, dass Sie das Bild entfernen möchten?',
    'create_team_meeting' => 'Team-Meeting erstellen',
    'delete_team_meeting' => 'Team-Meeting-Details löschen',
    'edit_meeting_detail' => 'Meeting-Details bearbeiten',
    'show_team_meeting' => 'Team-Meeting-Inhalt anzeigen',
    'participators' => 'Teilnehmer',
    'participator' => 'Teilnehmer',
    'team_meeting_filter' => 'Team-Meeting-Filter',
    'agenda' => 'Agenda',
    'creator' => 'Ersteller',

    /** Tada */
    'tada_attachment' => 'Tada-Anhang',
    'upload_tada_attachment' => 'Tada-Anhang hochladen',
    'accepted' => 'Akzeptiert',
    'tada_status_change' => 'Sind Sie sicher, dass Sie den Tada-Abrechnungsstatus ändern möchten?',
    'delete_tada_confirm' => 'Sind Sie sicher, dass Sie :title löschen möchten?',
    'uploaded_attachment' => 'Hochgeladener Anhang',
    'no_attachment_file' => 'Keine Anhangdatei',
    'total_expense' => 'Gesamtausgaben',
    'create_tada' => 'Tada erstellen',
    'edit_tada' => 'Tada bearbeiten',
    'tada_listing' => 'Tada-Liste',
    'tada_filter' => 'Tada-Filter',
    'submitted_date' => 'Eingereichtes Datum',
    'expense' => 'Ausgaben',
    'tada_detail' => 'Tada-Details',
    'verified_date' => 'Verifiziertes Datum',
    'tada_summary' => 'Tada-Zusammenfassung',
    'update_status' => 'Status aktualisieren',
    'category' => 'Kategorie',
    'select_category' => 'Kategorie auswählen',
    'opening_time' => 'Öffnungszeit',
    'closing_time' => 'Schließzeit',
    'checkin_checkout_rule' => 'Check-In/Out-Regel',
    'early_check_in' => 'Früher Check-In',
    'check_in_before' => 'Kann vor (in Minuten) einchecken',
    'checkin_before' => 'Vorher einchecken',
    'enter_check_in_before' => 'Geben Sie ein, wie viele Minuten vorher einchecken kann',
    'early_check_out' => 'Früher Check-Out',
    'check_out_before' => 'Kann vor (in Minuten) auschecken',
    'checkout_before' => 'Vorher auschecken',
    'enter_check_out_before' => 'Geben Sie ein, wie viele Minuten vorher auschecken kann',
    'late_check_in' => 'Später Check-In',
    'check_in_after' => 'Kann nach (in Minuten) einchecken',
    'checkin_after' => 'Nachher einchecken',
    'enter_check_in_after' => 'Geben Sie ein, wie viele Minuten nachher einchecken kann',
    'late_check_out' => 'Später Check-Out',
    'checkout_after' => 'Nachher auschecken',
    'check_out_after' => 'Kann nach (in Minuten) auschecken',
    'enter_check_out_after' => 'Geben Sie ein, wie viele Minuten nachher auschecken kann',
    'enter_shift_name' => 'Schichtnamen eingeben',
    'select_shift' => 'Schicht auswählen',
    'delete_office_time_confirm' => 'Sind Sie sicher, dass Sie den Bürostundenplan löschen möchten?',
    'office_time_detail' => 'Bürozeiten-Detail',
    'office_schedule' => 'Bürozeitplan',
    'add_office_time' => 'Bürozeiten hinzufügen',

    /** Award Types */
    'award_distributed' => 'Preis Vergeben',
    'add_award_types' => 'Preistypen Hinzufügen',
    'gift_item' => 'Geschenkartikel',
    'awarded_date' => 'Preisverleihungsdatum',

    /** Award */
    'award' => 'Preis',
    'award_name' => 'Preisname',
    'select_award_type' => 'Preistyp Auswählen',
    'enter_gift_item' => 'Geschenkartikel Eingeben',
    'award_base' => 'Preisgrundlage',
    'select_award_base' => 'Preisgrundlage Auswählen',
    'awarded_by' => 'Verliehen Von',
    'enter_awarded_by' => 'Verliehen Von Eingeben',
    'award_description' => 'Preisbeschreibung',
    'gift_description' => 'Geschenkbeschreibung',
    'reward_code' => 'Belohnungscode',
    'enter_reward_code' => 'Belohnungscode Eingeben',
    'add_award' => 'Preis Hinzufügen',
    'attachment' => 'Anhang',
    'award_lists' => 'Preisliste',

    /** Asset Types */
    'add_asset_types' => 'Asset-Typen hinzufügen',
    'asset_item_count' => 'Anzahl der Asset-Artikel',
    'asset_type' => 'Asset-Typ',
    'asset_name' => 'Asset-Name',
    'purchased_date' => 'Kaufdatum',
    'is_working' => 'Funktioniert',
    'is_available' => 'Verfügbar',
    'asset' => 'Asset',

    /** Assets */
    'select_asset_type' => 'Asset-Typ auswählen',
    'assigned_date' => 'Zuweisungsdatum',
    'is_available_for_employee' => 'Für Mitarbeiter verfügbar',
    'select_availability' => 'Verfügbarkeit auswählen',
    'warranty_end_date' => 'Garantieende-Datum',
    'warranty_available' => 'Garantie verfügbar',
    'select_warranty_availability' => 'Garantieverfügbarkeit auswählen',
    'asset_serial_number' => 'Seriennummer des Assets',
    'enter_asset_serial_number' => 'Seriennummer des Assets eingeben',
    'asset_code' => 'Asset-Code',
    'enter_asset_code' => 'Asset-Code eingeben',
    'change_availability_status' => 'Sind Sie sicher, dass Sie den Verfügbarkeitsstatus ändern möchten?',
    'delete_asset_confirm' => 'Sind Sie sicher, dass Sie :title löschen möchten?',
    'add_asset' => 'Asset hinzufügen',
    'asset_image' => 'Asset-Bild',
    'asset_assigned_employee' => 'Zugewiesener Mitarbeiter',
    'assets_filter' => 'Asset-Filter',
    'working_status' => 'Arbeitsstatus',
    'availability_status' => 'Verfügbarkeitsstatus',
    'yes_available' => 'Ja verfügbar',
    'notavailable' => 'Nicht verfügbar',
    'purchased_from' => 'Gekauft von',
    'purchased_to' => 'Gekauft an',

    /** Content Management */
    'content_section' => 'Inhaltsbereich',
    'content' => 'Inhalt',
    'content_type' => 'Inhaltstyp',
    'content_title' => 'Inhaltstitel',
    'select_content_type' => 'Inhaltstyp auswählen',
    'delete_content_confirm' => 'Sind Sie sicher, dass Sie den Inhalt der statischen Seite löschen möchten?',
    'company_static_content' => 'Statischer Inhalt der Firma',
    'add_content' => 'Inhalt hinzufügen',

    /** Support */
    'delete_support_confirm' => 'Sind Sie sicher, dass Sie :title löschen möchten?',
    'ticket_lists' => 'Ticketlisten',
    'query_by' => 'Anfrage von',
    'concerned_department' => 'Betrifft Abteilung',
    'unseen' => 'Ungesehen',
    'read_status' => 'Lesestatus',
    'seen' => 'Gesehen',
    'query_status' => 'Anfrage Status',
    'support_filter' => 'Support-Filter',
    'query_lists' => 'Anfragenlisten',
    'department_support_requested_from' => 'Unterstützung vom Abteilung angefordert',
    'department_support_requested_to' => 'Unterstützung an Abteilung angefordert',
    'change_query_status' => 'Anfrage Status ändern',

    /** Router */
    'router_section' => 'Router-Bereich',
    'router_bssid' => 'Router BSSID',
    'router' => 'Router',
    'router_detail' => 'Router-Detail',
    'add_router' => 'Router hinzufügen',

    /** QR */
    'scan_me' => 'Scanne mich',
    'attendance_qr' => 'Teilnahme QR',
    'qr_image' => 'QR-Bild',
    'add_qr' => 'QR hinzufügen',
    'qr_section' => 'QR-Bereich',

    /** NFC */
    'nfc_section' => 'NFC-Bereich',
    'created_by' => 'Erstellt von',

    /** Role and permission */
    'role_section' => 'Rollenbereich',
    'autorize_backend_login' => 'Backend-Login autorisieren',
    'role_name' => 'Rollenname',
    'permissions' => 'Berechtigungen',
    'check_all' => 'Alle auswählen',
    'module' => 'Modul',
    'add_role' => 'Rolle hinzufügen',
    'assign_permissions' => 'Berechtigungen zuweisen',
    'confirm_role_deletion' => 'Sind Sie sicher, dass Sie die Rolle löschen möchten?',
    'can_login' => 'Kann sich anmelden',
    'permission_setting' => 'Berechtigungseinstellungen',
    'assign' => 'Zuweisen',

    /** General Setting */
    'general_setting_section' => 'Allgemeiner Einstellungsbereich',
    'general_setting' => 'Allgemeine Einstellungen',

    /** App Setting */
    'export_database_data' => 'Datenbankdaten exportieren',
    'check_router_bssid' => 'Router-BSSID überprüfen',

    /** Fiscal Years */
    'fiscal_years' => 'Geschäftsjahre',
    'year' => 'Jahr',
    'add_fiscal_year' => 'Geschäftsjahr hinzufügen',

    /** Notifications */
    'notification_section' => 'Benachrichtigungsbereich',
    'confirm_notification_send' => 'Sind Sie sicher, dass Sie die Benachrichtigung senden möchten?',
    'notification' => 'Benachrichtigung',
    'published_date' => 'Veröffentlichungsdatum',
    'all_types' => 'Alle Typen',
    'notification_lists' => 'Benachrichtigungslisten',
    'notified_member' => 'Benachrichtigtes Mitglied',
    'notification_title' => 'Benachrichtigungstitel',
    'notification_description' => 'Benachrichtigungsbeschreibung',
    'send_notification' => 'Benachrichtigung senden',
    'enter_notification_title' => 'Geben Sie den Titel der Benachrichtigung ein',

    /** feature control */
    'app_setting' => 'App-Einstellung',
    'sn' => 'SN',
    'group' => 'Gruppe',
    'export_table_data' => 'Tabellendaten exportieren',
    'leave_requests' => 'Urlaubsanfragen',
    'employee_lists' => 'Mitarbeiterlisten',
    'attendances' => 'Anwesenheiten',
    'confirm_change_status' => 'Sind Sie sicher, dass Sie den Status ändern möchten?',
    'yes' => 'Ja',
    'no' => 'Nein',


    /** Api response */
    /** Auth Controller */
    'invalid_login_credentials' => 'Ungültige Anmeldedaten!',
    'authenticated' => 'Authentifiziert',
    'user_detail_not_found' => 'Benutzerdetails nicht gefunden',
    'partial_logout_successful' => 'Teilweiser Logout erfolgreich',
    /** Dashboard Controller */
    'data_found' => 'Daten gefunden',
    /** AdvanceSalary Controller */
    'advance_salary_pending_error' => 'Ein weiterer Vorschuss kann nicht angefordert werden, bis die vorherige Vorschussanfrage beglichen ist.',
    'data_updated_successfully' => 'Daten erfolgreich aktualisiert',
    'user_updated_advance_salary_request' => ':name hat eine Vorschussanfrage aktualisiert',
    'data_created_successfully' => 'Daten erfolgreich erstellt',
    'advance_salary_request_alert' => 'Vorschussanforderung Alarm',
    'user_submitted_advance_salary_request' => ':name hat eine Vorschussanforderung in Höhe von :amount eingereicht',
    /** Attendance Api */
    'check_out_successful' => 'Erfolgreich ausgecheckt',
    'check_out_notification' => 'Checkout-Benachrichtigung',
    'check_in_successful' => 'Erfolgreich eingecheckt',
    'check_in_notification' => 'Check-In-Benachrichtigung',
    'not_checked_in_yet' => 'Noch nicht eingecheckt',
    'alert_multi_checkin_shift' => 'Entschuldigung! Der Mitarbeiter kann nicht zweimal in einer Schicht einchecken.',
    'checkout_alert_for_shift' => 'Mitarbeiter bereits aus der Schicht ausgecheckt',
    'alert_checkin' => 'Entschuldigung! Mitarbeiter kann nicht zweimal an einem Tag einchecken.',
    'checkout_alert' => 'Mitarbeiter hat bereits heute ausgecheckt',
    'attendance_alert_status' => ':status bereits abgeschlossen',
    'employee_checked_in' => ':name hat um :time eingecheckt',
    'employee_checked_out' => ':name hat um :time ausgecheckt',
    'has_worked_for' => 'und hat für :time gearbeitet',
    'multi_checkout_warning' => 'Sie haben die maximale Anzahl an Ein- und Auscheckvorgängen für heute erreicht.',
    'employee_checked_out_and_worked' => ':name hat um :check_out_time ausgecheckt und hat für :worked_time gearbeitet',
    'invalid_attendance_type' => 'Ungültiger Anwesenheitstyp.',
    'invalid_qr' => 'Ungültiger QR oder QR ist nicht verfügbar',
    'invalid_nfc' => 'Ungültiges NFC-Token oder NFC ist nicht verfügbar',
    'validation_failed' => 'Validierung fehlgeschlagen',

    /** Leave Api Controller */
    'leave_request_cancelled' => 'Urlaubsantrag erfolgreich storniert',
    'leave_request_cannot_be_cancelled' => 'Der Urlaubsantrag kann nicht storniert werden, nachdem er aus dem Status „Ausstehend“ aktualisiert wurde.',
    'leave_request_notification' => 'Urlaubsantragsbenachrichtigung',
    'leave_request_submitted' => ':name hat Urlaub von :start_time bis :end_time am :issue_date beantragt. Grund: :reasons',
    'leave_request_submitted_successfully' => 'Urlaubsantrag erfolgreich eingereicht',
    'leave_request_cancelled_successfully' => 'Urlaubsantrag erfolgreich storniert',
    'leave_request_submit' => ':name hat :no_of_days Tag(e) Urlaub von :leave_from am :leave_requested_date beantragt. Grund: :reasons',

    /** NFC api Controller */
    'nfc_token_already_exist' => 'NFC-Token existiert bereits.',
    'nfc_added_successfully' => 'NFC erfolgreich hinzugefügt',

    /** Notification Api Controller */
    'updated_successfully' => 'Erfolgreich aktualisiert',
    'successfully_sent_notification' => 'Benachrichtigung erfolgreich gesendet',
    'data_not_found' => 'Daten nicht gefunden',
    'content_not_found' => 'Inhalt nicht gefunden',

    /** Support Api Controller */
    'support_notification' => 'Support-Benachrichtigung',
    'support_request_submitted' => ':name hat Unterstützung angefordert.',
    'query_submitted_successfully' => 'Anfrage erfolgreich eingereicht',

    /** Tada Api Controller  */
    'attachment_detail_not_found' => 'Anhangsdetails nicht gefunden',
    'cannot_delete_attachment_detail' => 'Anhangsdetails können nach der Überprüfung nicht gelöscht werden',
    'upload_another_attachment_before_delete' => 'Bitte laden Sie einen weiteren Anhang hoch, bevor Sie löschen.',
    'attachment_deleted_successfully' => 'Anhang erfolgreich gelöscht',
    'tada_update_alert' => 'Sie können die Details nach der Überprüfung nicht aktualisieren. Bitte kontaktieren Sie den Administrator',
    'tada_notification' => ':name hat ein neues TADA für :title eingereicht',
    'tada_detail_notification' => ':name hat die Details des eingereichten TADA für :title aktualisiert',
    'tada_alert' => 'TADA-Alarm',

    /** TaskDetailApi Controller */
    'status_changed_successfully' => 'Status erfolgreich geändert',
    'task_detail_not_found' => 'Aufgabendetails nicht gefunden',

    /** TaskCheckListApi Controller */
    'status_updated_successfully' => 'Status erfolgreich aktualisiert',

    /** TaskCommentApi Controller */
    'comment_notification' => 'Kommentarbenachrichtigung',
    'task_mention' => 'Sie wurden in der Aufgabe :task :type erwähnt',
    'comment_reply' => 'Kommentarantwort',
    'comment_reply_deleted_successfully' => 'Kommentarantwort erfolgreich gelöscht',
    'comment_deleted_successfully' => 'Kommentar erfolgreich gelöscht',
    'comment_added_successfully' => 'Kommentar erfolgreich hinzugefügt',

    /** userProfile Api */
    'invalid_base64_image' => 'Base64-Wert ist kein gültiges Bild',
    'demo_version' => 'Dies ist eine Demoversion. Bitte kaufen Sie die Anwendung, um die vollständigen Funktionen nutzen zu können',
    'user_not_found' => 'Benutzerdetails nicht gefunden',
    'profile_updated' => 'Profil erfolgreich aktualisiert',
    'incorrect_current_password' => 'Falsches aktuelles Passwort',
    'new_password_same_as_old' => 'Neues Passwort darf nicht dasselbe wie das alte Passwort sein',
    'password_changed' => 'Passwort erfolgreich geändert',

    /** leave_approval */
    'leave_approval' => 'Urlaubsfreigabe',
    'leave_approval_list' => 'Liste der Urlaubsfreigaben',
    'add_leave_approval' => 'Urlaubsfreigabe hinzufügen',
    'subject' => 'Betreff',
    'related' => 'Verwandt',
    'select_related' => 'Wählen Sie Verwandt',
    'max_days_to_sign' => 'Maximale Anzahl von Tagen zur Unterzeichnung',
    'notification_recipient' => 'Empfänger der Benachrichtigung',
    'select_notification_recipient' => 'Wählen Sie den Empfänger der Benachrichtigung',
    'approval_process' => 'Genehmigungsprozess',
    'approver' => 'Genehmiger',
    'select_approver' => 'Genehmiger auswählen',
    'head_of_department' => 'Abteilungsleiter',
    'specific_personnel' => 'Spezifisches Personal',
    'applicable_from' => 'Anwendbar ab',

    /** Event Management */
    'event_section' => 'Veranstaltungsbereich',
    'event_title' => 'Veranstaltungstitel',
    'event_location' => 'Veranstaltungsort',
    'event_start_date' => 'Veranstaltungsbeginn (Datum)',
    'event_start_time' => 'Veranstaltungsbeginn (Uhrzeit)',
    'event_end_date' => 'Veranstaltungsende (Datum)',
    'event_end_time' => 'Veranstaltungsende (Uhrzeit)',
    'all_departments' => 'Alle Abteilungen',
    'delete_event_confirmation' => 'Möchten Sie dieses Ereignis wirklich löschen?',
    'create_event' => 'Veranstaltung erstellen',
    'show_event' => 'Veranstaltung anzeigen',
    'enter_event_title' => 'Veranstaltungstitel eingeben',
    'edit_event_detail' => 'Veranstaltungsdetails bearbeiten',
    'delete_event' => 'Veranstaltung löschen',
    'event_calendar' => 'Veranstaltungskalender',

    /** Training Management */
    'training_types' => 'Schulungsarten',
    'select_training_type' => 'Schulungsart auswählen',
    'training' => 'Schulung',
    'select_trainer' => 'Trainer auswählen',
    'trainer' => 'Trainer',
    'add_trainer' => 'Trainer hinzufügen',
    'add_training' => 'Schulung hinzufügen',
    'trainer_lists' => 'Trainerliste',
    'training_list' => 'Schulungsliste',
    'total_training' => 'Gesamtschulungen',
    'training_type' => 'Schulungstyp',
    'training_management' => 'Schulungsmanagement',
    'add_training_types' => 'Schulungsarten hinzufügen',
    'training_date' => 'Schulungsdatum',
    'trainer_type' => 'Trainertyp',
    'select_trainer_type' => 'Trainertyp auswählen',
    'expertise' => 'Fachgebiet',
    'certificate' => 'Zertifikat',
    'contact_number' => 'Kontaktnummer',
    'training_for' => 'Schulung für',
    'time' => 'Zeit',
    'updated_by' => 'Aktualisiert von',

    'select_task' => 'Aufgabe auswählen',
    'event_host' => 'Veranstalter',
    'host' => 'Gastgeber',
    'location' => 'Standort',
    'event_list' => 'Veranstaltungsliste',
    'total_tasks' => 'Gesamtaufgaben',
    'applicable_to_tax_report' => 'Lohnbestandteile, die für alle gelten, werden im Steuerbericht verwendet.',

    'no_departments_found' => 'Keine Abteilungen gefunden',
    'error_loading_departments' => 'Fehler beim Laden der Abteilungen',
    'no_employees_found' => 'Keine Mitarbeiter gefunden',
    'update_send' => 'Aktualisieren und Benachrichtigung senden',
    'create_send' => 'Erstellen und Benachrichtigung senden',


    'admin_permission_msg' => 'Wenn diese Option ausgewählt wird, werden alle Hierarchiestufen übersprungen und Benutzer mit dieser Rolle können alle Urlaube anzeigen und bearbeiten. Behalten Sie diese Option für spezielle Rollen wie HR bei',
    'coming_soon' => 'Bald kommen',
    'assign_trainer_section' => 'Trainer zuweisen Abschnitt',
    'assign_trainer' => 'Trainer zuweisen',

    'export_csv' => 'CSV exportieren',

    /** Termination Management */
    'termination_types' => 'Kündigungsarten',
    'select_termination_type' => 'Kündigungsart auswählen',
    'termination' => 'Kündigung',
    'add_termination' => 'Kündigung hinzufügen',
    'termination_list' => 'Kündigungsliste',
    'total_termination' => 'Gesamtkündigungen',
    'termination_type' => 'Kündigungsart',
    'termination_management' => 'Kündigungsmanagement',
    'add_termination_types' => 'Kündigungsarten hinzufügen',
    'termination_date' => 'Kündigungsdatum',
    'notice_date' => 'Kündigungsfristdatum',

    /** Resignation Management */
    'resignation_types' => 'Rücktrittsarten',
    'select_resignation_type' => 'Rücktrittsart auswählen',
    'resignation' => 'Rücktritt',
    'add_resignation' => 'Rücktritt hinzufügen',
    'resignation_list' => 'Rücktrittsliste',
    'total_resignation' => 'Gesamtrücktritte',
    'resignation_type' => 'Rücktrittsart',
    'resignation_management' => 'Rücktrittsmanagement',
    'add_resignation_types' => 'Rücktrittsarten hinzufügen',
    'resignation_date' => 'Rücktrittsdatum',
    'last_date' => 'Letztes Datum',
    'last_working_day' => 'Letzter Arbeitstag',
    'resignation_notification' => 'Rücktrittsaufforderung',
    'resignation_submit' => ':name hat am :resignation_date einen Rücktritt beantragt, der ab :last_working_day wirksam wird.',
    'resignation_submitted_successfully' => 'Rücktritt erfolgreich eingereicht',
    'resignation_fetched_successfully' => 'Rücktritt erfolgreich abgerufen',
    'resignation_exist_error' => 'Ihr Rücktritt ist bereits :status.',
    'document' => 'Dokument',
    'venue' => 'Veranstaltungsort',

    /** Warning Management */
    'select_warning_type' => 'Warnungsart auswählen',
    'warning' => 'Warnung',
    'message' => 'Nachricht',
    'add_warning' => 'Warnung hinzufügen',
    'warning_list' => 'Warnungsliste',
    'total_warning' => 'Gesamtwarnungen',
    'warning_type' => 'Warnungsart',
    'warning_management' => 'Warnungsmanagement',
    'add_warning_types' => 'Warnungsarten hinzufügen',
    'warning_date' => 'Warnungsdatum',
    'warning_notification' => 'Warnungsaufforderung',
    'warning_submit' => ':name hat auf die Warnung zu :subject vom :date geantwortet',
    'warning_submitted_successfully' => 'Warnung erfolgreich eingereicht',
    'response_submitted_successfully' => 'Ihre Antwort wurde erfolgreich aufgezeichnet',
    'warning_fetched_successfully' => 'Warnung erfolgreich abgerufen',
    'warning_exist_error' => 'Ihre Antwort ist bereits aufgezeichnet.',
    'response_section' => 'Antwortabschnitt',
    'response' => 'Antwort',

    /** Complaint Management */
    'select_complaint_type' => 'Beschwerdeart auswählen',
    'complaint' => 'Beschwerde',
    'complaint_from' => 'Beschwerde von',
    'add_complaint' => 'Beschwerde hinzufügen',
    'complaint_list' => 'Beschwerdeliste',
    'total_complaint' => 'Gesamtbeschwerden',
    'complaint_type' => 'Beschwerdeart',
    'complaint_management' => 'Beschwerdemanagement',
    'add_complaint_types' => 'Beschwerdearten hinzufügen',
    'complaint_date' => 'Beschwerdedatum',
    'complaint_notification' => 'Beschwerdeaufforderung',
    'complaint_submit' => 'Antwort auf die Beschwerde zu :subject vom :date wurde提交',
    'complaint_submitted_successfully' => ' Beschwerde erfolgreich eingereicht',
    'complaint_fetched_successfully' => 'Beschwerde erfolgreich abgerufen',
    'complaint_exist_error' => 'Ihre Antwort ist bereits aufgezeichnet.',
    'complain_to' => 'Beschwerde an',

    'hr_admin_setup' => 'HR-Admin-Einrichtung',
    'edit_branch' => 'Zweigstelle bearbeiten',
    'branch_head_error' => 'Der ausgewählte Benutzer ist bereits Leiter einer anderen Zweigstelle, bitte wählen Sie einen anderen Benutzer',
    'department_head_error' => 'Der ausgewählte Benutzer ist bereits Leiter einer anderen Abteilung, bitte wählen Sie einen anderen Benutzer',

    /** Promotion Management */
    'promotion' => 'Beförderung',
    'add_promotion' => 'Beförderung hinzufügen',
    'promotion_list' => 'Beförderungsliste',
    'promotion_section' => 'Beförderungsabschnitt',
    'total_promotion' => 'Gesamtbeförderungen',
    'promotion_type' => 'Beförderungsart',
    'promotion_management' => 'Beförderungsmanagement',
    'add_promotion_types' => 'Beförderungsarten hinzufügen',
    'promotion_date' => 'Beförderungsdatum',
    'promotion_notification' => 'Beförderungsaufforderung',
    'promotion_submitted_successfully' => 'Beförderung erfolgreich eingereicht',
    'promotion_fetched_successfully' => 'Beförderung erfolgreich abgerufen',

    'select_post' => 'Posten auswählen',
    'old_post' => 'Alter Posten',
    'new_post' => 'Neuer Posten',

    /** Transfer Management */
    'transfer' => 'Versetzung',
    'transfer_details' => 'Versetzungsdetails',
    'add_transfer' => 'Versetzung hinzufügen',
    'transfer_list' => 'Versetzungsliste',
    'transfer_section' => 'Versetzungsabschnitt',
    'total_transfer' => 'Gesamtversetzungen',
    'transfer_type' => 'Versetzungsart',
    'transfer_management' => 'Versetzungsmanagement',
    'add_transfer_types' => 'Versetzungsarten hinzufügen',
    'transfer_date' => 'Versetzungsdatum',
    'transfer_notification' => 'Versetzungsaufforderung',
    'transfer_submitted_successfully' => 'Versetzung erfolgreich eingereicht',
    'transfer_fetched_successfully' => 'Versetzung erfolgreich abgerufen',
    'old_branch' => 'Alte Zweigstelle',
    'new_branch' => 'Neue Zweigstelle',
    'old_department' => 'Alte Abteilung',
    'new_department' => 'Neue Abteilung',

    /** theme color */
    'theme_color' => 'Themenfarbe',
    'background_color' => 'Hintergrundfarbe',
    'primary_color' => 'Primärfarbe',
    'hover_color' => 'Hover-Farbe',
    'dark_primary_color' => 'Dunkle Primärfarbe',
    'dark_hover_color' => 'Dunkle Hover-Farbe',

    /** Admin Management */
    'users' => 'Benutzer',
    'user_section' => 'Benutzerabschnitt',
    'add_user' => 'Benutzer hinzufügen',
    'user_management' => 'Benutzerverwaltung',
    'user' => 'Benutzer',

    'office_time_not_found' => 'Bürozeit nicht gefunden',
    'asset_type_not_found' => 'Asset-Typ nicht gefunden',
    'employee_not_found' => 'Mitarbeiter nicht gefunden',
    'error_loading_asset_types' => 'Fehler beim Laden der Asset-Typen',
    'error_loading_employees' => 'Fehler beim Laden der Mitarbeiter',
    'error_loading_termination_types' => 'Fehler beim Laden der Kündigungsarten',
    'error_loading_department' => 'Fehler beim Laden der Abteilungen',
    'leave_type_not_found' => 'Urlaubsart nicht gefunden',
    'error_loading_leave_types' => 'Fehler beim Laden der Urlaubsarten',
    'no_department_found' => 'Keine Abteilung gefunden',
    'award_filter' => 'Auszeichnungsfilter',
    'select_award' => 'Auszeichnung auswählen',
    'award_type_not_found' => 'Auszeichnungsart nicht gefunden',
    'termination_filter' => 'Kündigungsfilter',
    'training_type_filter' => 'Trainingsartfilter',
    'asset_type_filter' => 'Asset-Typfilter',
    'award_type_filter' => 'Auszeichnungsartfilter',
    'termination_type_filter' => 'Kündigungsartfilter',
    'resignation_filter' => 'Rücktrittsfilter',
    'promotion_filter' => 'Beförderungsfilter',
    'complaint_filter' => 'Beschwerdefilter',
    'warning_filter' => 'Warnungsfilter',
    'transfer_filter' => 'Versetzungsfilter',
    'trainer_filter' => 'Trainerfilter',
    'office_time_filter' => 'Bürozeitfilter',
    'leave_type_filter' => 'Urlaubsartfilter',
    'client_filter' => 'Kundenfilter',
    'router_filter' => 'Routerfilter',
    'project_not_found' => 'Projekt nicht gefunden',
    'error_loading_training_types' => 'Fehler beim Laden der Trainingsarten',


    'post_filter' => 'Beitragsfilter',
    'event_filter' => 'Ereignisfilter',
    'training_filter' => 'Trainingsfilter',
    'post_lists' => 'Beitragslisten',
    'tada_lists' => 'Tada-Listen',
    'advance_salary_filter' => 'Vorschussgehaltsfilter',
    'log_filter' => 'Anwesenheitsprotokollfilter',
    'advance_salary_lists' => 'Vorschussgehaltslisten',
    'logout_request_filter' => 'Abmeldungsanforderungsfilter',
    'leave_approval_filter' => 'Urlaubsgenehmigungsfilter',
    'user_list' => 'Benutzerliste',
    'projects_not_found' => 'Projekte nicht gefunden',
    'attendance_logs' => 'Anwesenheitsprotokolle',
    'attendance_type' => 'Anwesenheitstyp',
    'identifier' => 'Identifikator',
    'nfc_lists' => 'NFC-Listen',
    'qr_lists' => 'QR-Listen',
    'qr_filter' => 'QR-Filter',
    'nfc_filter' => 'NFC-Filter',
    'select_notice_receiver' => 'Empfänger der Benachrichtigung auswählen',
    'generated_salary_lists' => 'Generierte Gehaltslisten',
    'employee_salaries' => 'Mitarbeitergehälter',
    'select_meeting_participants' => 'Teilnehmer des Meetings auswählen',
    'employee_filter' => 'Mitarbeiterfilter',
    'attendance_filter' => 'Anwesenheitsfilter',
    'notice_filter' => 'Benachrichtigungsfilter',
    'award_type_lists' => 'Listen der Auszeichnungstypen',
    'termination_type_lists' => 'Listen der Kündigungstypen',
    'holiday_lists' => 'Feiertagslisten',
    'asset_lists' => 'Vermögenslisten',
    'router_lists' => 'Routerlisten',
    'meeting_list' => 'Meetinglisten',
    'app_qr' => 'App-QR',
    'digital_hr_dashboard' => 'Digitales HR-Dashboard',
    'training_type_list' => 'Liste der Trainingstypen',
    'time_leave_list' => 'Listen der Zeiturlaubsanträge',
    'support_list' => 'Supportlisten',
    'role_list' => 'Rollenlisten',
    'asset_type_list' => 'Listen der Vermögenstypen',
    'add_undertime' => 'Unterzeit hinzufügen',
    'threshold_time' => 'Schwellenzeit',
    'ssf_rule' => 'SSF-Regel',
    'upload_warning' => 'Bitte laden Sie mindestens ein Dokument hoch, wenn der Status genehmigt ist',

    'check_in_latitude'=>'Check-In-Breitengrad',
    'check_in_longitude'=>'Check-In-Längengrad',
    'check_out_latitude'=>'Check-Out-Breitengrad',
    'check_out_longitude'=>'Check-Out-Längengrad',
];
