<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Authentication Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines are used during authentication for various
    | messages that we need to display to the user. You are free to modify
    | these language lines according to your application's requirements.
    |
    */

    /** dashboard */
    'welcome' => 'Bienvenido al Panel de Asistencia',
    'total_employees' => 'Total de Empleados',
    'total_departments' => 'Total de Departamentos',
    'total_holidays' => 'Total de Feriados',
    'paid_leaves' => 'Permisos Pagados',
    'on_leave_today' => 'De permiso hoy',
    'pending_leave_requests' => 'Solicitudes de permiso pendientes',
    'total_check_in_today' => 'Total de Entradas Hoy',
    'total_check_out_today' => 'Total de Salidas Hoy',
    'projects_detail' => 'Detalles de los Proyectos',
    'total_projects' => 'Total de Proyectos',
    'pending_projects' => 'Proyectos Pendientes',
    'on_hold_projects' => 'Proyectos en Espera',
    'in_progress_projects' => 'Proyectos en Progreso',
    'finished_projects' => 'Proyectos Terminados',
    'cancelled_projects' => 'Proyectos Cancelados',
    'top_clients' => 'Principales Clientes',
    'task_details' => 'Detalles de la Tarea',
    'recent_projects' => 'Proyectos Recientes',
    'title' => 'Título',
    'date_start' => 'Fecha de Inicio',
    'deadline' => 'Fecha Límite',
    'leader' => 'Líder',
    'completion' => 'Finalización',
    'priority' => 'Prioridad',
    'check_in_at' => 'Registrado a las',
    'check_out_at' => 'Salida a las',
    'punch_in' => 'Registrar Entrada',
    'punch_out' => 'Registrar Salida',
    'no_records_found' => 'No se encontraron registros!',
    'project_management' => 'Gestión de Proyectos',
    'view_all_clients' => 'Ver Todos los Clientes',
    'view_all_projects' => 'Ver Todos los Proyectos',
    'error_message' => 'Error: No se pudo procesar la solicitud.',
    'success_message' => 'Éxito: Acción completada con éxito.',
    'name' => 'Nombre',
    'email' => 'Correo Electrónico',
    'contact' => 'Contacto',
    'project' => 'Proyecto',
    'pending' => 'Pendiente',
    'on_hold' => 'En espera',
    'in_progress' => 'En progreso',
    'completed' => 'Completado',
    'cancelled' => 'Cancelado',
    'search_menu' => 'Menú de búsqueda',


    /** nav */
    'latest_notifications' => 'Últimas Notificaciones',
    'view_all' => 'Ver todo',
    'profile' => 'Perfil',
    'edit_profile' => 'Editar Perfil',
    'request_leave' => 'Solicitar Permiso',
    'log_out' => 'Cerrar sesión',
    'light_mode' => 'Modo Claro',
    'dark_mode' => 'Modo Oscuro',

    /** menu */
    'dashboard' => 'Tablero',
    'company_management' => 'Gestión de la Empresa',
    'company' => 'Empresa',
    'branch' => 'Sucursal',
    'department' => 'Departamento',
    'post' => 'Publicación',
    'employee_management' => 'Gestión de Empleados',
    'employees' => 'Empleados',
    'logout_requests' => 'Solicitudes de Cierre de Sesión',
    'attendance_section' => 'Sección de Asistencia',
    'clients' => 'Clientes',
    'task_management' => 'Gestión de Tareas',
    'holidays' => 'Vacaciones',
    'notice' => 'Aviso',
    'payroll_management' => 'Gestión de Nóminas',
    'payroll' => 'Nómina',
    'payroll_setting' => 'Configuración de Nómina',
    'advance_salary' => 'Salario Anticipado',
    'employee_salary' => 'Salario de Empleado',
    'leave' => 'Permiso',
    'team_meeting' => 'Reunión de Equipo',
    'tada' => 'Tada',
    'shift_management' => 'Gestión de Turnos',
    'office_time' => 'Horario de Oficina',
    'award_management' => 'Gestión de Premios',
    'award_types' => 'Tipos de Premios',
    'awards' => 'Premios',
    'asset_management' => 'Gestión de Activos',
    'asset_types' => 'Tipos de Activos',
    'assets' => 'Activos',
    'content_management' => 'Gestión de Contenidos',
    'support' => 'Soporte',
    'attendance_methods' => 'Métodos de Asistencia',
    'routers' => 'Enrutadores',
    'qr' => 'Código QR',
    'nfc' => 'NFC',
    'settings' => 'Configuraciones',
    'roles_permissions' => 'Roles y Permisos',
    'general_settings' => 'Configuraciones Generales',
    'app_settings' => 'Configuraciones de la Aplicación',
    'notifications' => 'Notificaciones',
    'payment_currency' => 'Moneda de Pago',
    'feature_control' => 'Control de Funcionalidades',
    'salary_component' => 'Componente Salarial',
    'salary_group' => 'Grupo Salarial',
    'salary_tds' => 'Impuesto sobre el Salario',
    'overtime' => 'Horas Extras',
    'undertime' => 'Tiempo Inferior',
    'payment_method' => 'Método de Pago',
    'leave_types' => 'Tipos de Licencia',
    'leave_request' => 'Solicitud de Licencia',
    'time_leave_request' => 'Solicitud de Licencia Temporal',



    /** company */
    'company_profile' => 'Perfil de la Empresa',
    'update_company' => 'Actualizar Empresa',
    'create_company' => 'Crear Empresa',
    'company_name' => 'Nombre de la Empresa',
    'company_owner' => 'Propietario de la Empresa',
    'address' => 'Dirección',
    'email_address' => 'Dirección de Correo Electrónico',
    'phone_no' => 'Número de Teléfono',
    'website_url' => 'URL del Sitio Web',
    'check_office_off_days' => 'Verificar Días Libres de la Oficina',
    'upload_logo' => 'Subir Logotipo',
    'update' => 'Actualizar',
    'save' => 'Guardar',

    /** Branch */
    'title_branch' => 'Sucursal',
    'branch_section' => 'Sección de Sucursales',
    'branches' => 'Sucursales',
    'add_branch' => 'Agregar Sucursal',
    'branch_lists' => 'Listas de Sucursales',
    'search_by_branch_name' => 'Buscar por Nombre de Sucursal',
    'filter' => 'Filtrar',
    'reset' => 'Restablecer',
    'phone' => 'Teléfono',
    'total_employee' => 'Total de Empleados',
    'action' => 'Acción',
    'are_you_sure_change_status' => '¿Está seguro de que desea cambiar el estado?',
    'are_you_sure_delete_branch' => '¿Está seguro de que desea eliminar la sucursal?',
    'branch_create' => 'Crear Sucursal',
    'branch_update' => 'Actualizar Sucursal',
    'branch_name' => 'Nombre de la Sucursal',
    'required_field' => 'Campo Obligatorio',
    'branch_head' => 'Jefe de Sucursal',
    'select_branch_head' => 'Seleccionar Jefe de Sucursal',
    'phone_number' => 'Número de Teléfono',
    'branch_location_latitude' => 'Latitud de la Ubicación de la Sucursal',
    'enter_branch_location_latitude' => 'Ingresar Latitud de la Ubicación de la Sucursal',
    'branch_location_longitude' => 'Longitud de la Ubicación de la Sucursal',
    'enter_branch_location_longitude' => 'Ingresar Longitud de la Ubicación de la Sucursal',
    'status' => 'Estado',
    'select_status' => 'Seleccionar Estado',
    'active' => 'Activo',
    'inactive' => 'Inactivo',
    'create' => 'Crear',

    /** Department */
    'department_section' => 'Sección de Departamentos',
    'departments' => 'Departamentos',
    'add_department' => 'Agregar Departamento',
    'department_lists' => 'Listas de Departamentos',
    'search_by_department_name' => 'Buscar por Nombre de Departamento',
    'select_branch' => 'Seleccionar Sucursal',
    'edit' => 'Editar',
    'delete' => 'Eliminar',
    'are_you_sure_delete_department' => '¿Está seguro de que desea eliminar el departamento?',
    'edit_department' => 'Editar Departamento',
    'button_back' => 'Atrás',
    'breadcrumb' => 'Miga de Pan',
    'update_department' => 'Actualizar Departamento',
    'create_department' => 'Crear Departamento',
    'department_name' => 'Nombre del Departamento',
    'department_head' => 'Jefe de Departamento',
    'select_department_head' => 'Seleccionar Jefe de Departamento',
    'create_update_department' => 'Crear/Actualizar Departamento',

    /** Post */
    'post_section' => 'Sección de Puestos',
    'posts' => 'Puestos',
    'add_post' => 'Agregar Puesto',
    'search_by_department' => 'Buscar por Departamento',
    'search_by_post_name' => 'Buscar por Nombre de Puesto',
    'post_name' => 'Nombre del Puesto',
    'post_empty' => 'Puesto Vacío',
    'edit_post_title' => 'Editar Puesto',
    'create_post_title' => 'Crear Puesto',
    'department_label' => 'Departamento',
    'post_name_label' => 'Nombre del Puesto',
    'status_label' => 'Estado',
    'select_department' => 'Seleccionar Departamento',
    'active_option' => 'Activo',
    'inactive_option' => 'Inactivo',
    'update_update_button' => 'Actualizar Puesto',
    'change_status_confirmation' => '¿Está seguro de que desea cambiar el estado?',
    'delete_post_confirmation' => '¿Está seguro de que desea eliminar el puesto?',
    'employee_list_title' => 'Lista de Empleados',

    /** Employee List */
    'employees_title' => 'Empleados',
    'employees_action' => 'Listas',
    'add_employee' => 'Agregar Empleado',
    'employee_section' => 'Sección de Empleados',
    'employee_create' => 'Crear Empleado',
    'employee_name' => 'Nombre del Empleado',
    'employee_email' => 'Correo Electrónico del Empleado',
    'employee_phone' => 'Número de Teléfono del Empleado',
    'full_name' => 'Nombre Completo',
    'designation' => 'Designación',
    'role' => 'Rol',
    'shift' => 'Turno',
    'workplace' => 'Lugar de Trabajo',
    'is_active' => 'Está Activo',
    'edit_detail' => 'Editar Detalle',
    'delete_user' => 'Eliminar Usuario',
    'change_password' => 'Cambiar Contraseña',
    'force_logout' => 'Forzar Cierre de Sesión',
    'all_fields_required' => 'Todos los campos (<span style="color: red">*</span>) son obligatorios',
    'personal_detail' => 'Detalle personal',
    'employee_code' => 'Código de empleado',
    'enter_name' => 'Ingrese el nombre',
    'enter_employee_address' => 'Ingrese la dirección del empleado',
    'enter_email' => 'Ingrese el correo electrónico',
    'dob' => 'Fecha de nacimiento',
    'gender' => 'Género',
    'select_gender' => 'Seleccione el género',
    'marital_status' => 'Estado civil',
    'choose_marital_status' => 'Elija el estado civil',
    'upload_avatar' => 'Subir avatar',
    'description' => 'Descripción',
    'username' => 'Nombre de usuario',
    'enter_username' => 'Ingrese el nombre de usuario',
    'password' => 'Contraseña',
    'enter_password' => 'Ingrese la contraseña',
    'select_role' => 'Seleccione el rol',
    'company_detail' => 'Detalle de la empresa',
    'supervisor' => 'Supervisor',
    'employment_type' => 'Tipo de empleo',
    'select_employment_type' => 'Seleccione el tipo de empleo',
    'joining_date' => 'Fecha de ingreso',
    'enter_joining_date' => 'Ingrese la fecha de ingreso',
    'workspace' => 'Lugar de trabajo',
    'select_workspace' => 'Seleccione el lugar de trabajo',
    'field' => 'Campo',
    'office' => 'Oficina',
    'leave_detail' => 'Detalle de licencia',
    'leave_allocated' => 'Licencia asignada',
    'assigned_leaves' => 'Licencias asignadas',
    'no_of_days' => 'Número de días',
    'total_leave_days' => 'Total de días de licencia',
    'bank_detail' => 'Detalle bancario',
    'bank_name' => 'Nombre del banco',
    'bank_account_number' => 'Número de cuenta bancaria',
    'account_holder_name' => 'Nombre del titular de la cuenta',
    'bank_account_type' => 'Tipo de cuenta bancaria',
    'select_account_type' => 'Seleccione el tipo de cuenta',
    'create_user' => 'Crear usuario',
    'update_user' => 'Actualizar usuario',
    'new_password' => 'Nueva contraseña',
    'enter_new_password' => 'Ingrese la nueva contraseña',
    'confirm_password' => 'Confirmar contraseña',
    'confirm_password_placeholder' => 'Confirmar contraseña',
    'submit' => 'Enviar',
    'user_change_password' => 'El usuario cambia la contraseña',
    'confirm_delete_employee' => '¿Está seguro de que desea eliminar al empleado?',
    'confirm_force_logout' => '¿Está seguro de que desea forzar la desconexión del usuario?',
    'confirm_change_workplace' => '¿Está seguro de que desea cambiar el lugar de trabajo?',
    'select_supervisor' => 'Seleccione supervisor',
    'select_office_time' => 'Seleccione el horario de la oficina',
    'select_option' => 'Seleccione una opción',
    'enter_address' => 'Por favor, ingrese la dirección.',
    'enter_valid_email' => 'Por favor, ingrese una dirección de correo electrónico válida.',
    'enter_phone_number' => 'Por favor, ingrese el número de teléfono.',
    'create_employee' => 'Crear empleado',
    'add' => 'Agregar',
    'edit_user_detail' => 'Editar detalles del usuario',
    'show_user_details' => 'Mostrar detalles del usuario',
    'detail' => 'Detalle',
    'back' => 'Atrás',
    'user_detail' => 'Detalle del usuario',
    'date_of_birth' => 'Fecha de nacimiento',
    'not_applicable' => 'N/A',
    'office_detail' => 'Detalle de la oficina',
    'home' => 'Inicio',
    'account_detail' => 'Detalle de la cuenta',
    'account_number' => 'Número de cuenta',
    'account_type' => 'Tipo de cuenta',
    'account_holder' => 'Titular de la cuenta',
    'not_available' => 'N/A',

    /** logout requests */
    'logout_request_status' => 'Estado de la solicitud de desconexión',
    'take_action' => 'Tomar acción',
    'confirm_accept_logout_request' => '¿Está seguro de que desea aceptar la solicitud de desconexión?',

    /** attendance */
    'attendance' => 'Asistencia',
    'employee_attendance_lists' => 'Listas de asistencia de empleados',
    'attendance_of_the_day' => 'Asistencia del día',
    'date_placeholder_bs' => 'aa/mm/dd',
    'csv_export' => 'Exportar CSV',
    'attendance_status' => 'Estado de asistencia',
    'attendance_by' => 'Asistencia por',
    'show_detail' => 'Mostrar detalle',
    'show_checkin_location' => 'Mostrar ubicación de entrada',
    'show_checkout_location' => 'Mostrar ubicación de salida',
    'checkin' => 'entrada',
    'checkout' => 'salida',
    'approved' => 'Aprobado',
    'rejected' => 'Rechazado',
    'self' => 'Propio',
    'admin' => 'Admin',
    'edit_attendance_time' => 'Editar tiempo de asistencia',
    'employee_attendance_detail' => 'Detalle de asistencia del empleado',
    'attendance_of' => 'Asistencia de',
    'total_days_in_month' => 'Total de días en el mes',
    'present_days' => 'Días presentes',
    'absent_days' => 'Días ausentes',
    'weekend_days' => 'Días de fin de semana',
    'holiday_days' => 'Días festivos',
    'leave_days' => 'Días de licencia',
    'working_hours' => 'Horas de trabajo',
    'worked_hours' => 'Horas trabajadas',
    'attendance_details_of' => 'Detalles de asistencia de :month',
    'all_month' => 'Todo el mes',
    'worked_hour' => 'Hora trabajada',
    'add_attendance_time' => 'Agregar tiempo de asistencia',
    'confirm_change_attendance_status' => '¿Está seguro de que desea cambiar el estado de asistencia?',
    'check_in' => 'Registrar entrada',
    'check_out' => 'Registrar salida',
    'attendance_title' => 'Asistencia',
    'attendance_action' => 'Detalle de asistencia del empleado',
    'filter_placeholder' => 'Año de asistencia p. ej.: :min_year',
    'filter_button' => 'Filtrar',
    'csv_export_button' => 'Exportar CSV',
    'reset_button' => 'Restablecer',
    'total_days' => 'Total de días en el mes',
    'attendance_details' => 'Detalles de asistencia de :monthName',
    'date' => 'Fecha',
    'change_attendance_status' => 'Cambiar estado de asistencia',
    'create_attendance' => 'Crear asistencia',
    'admin_remark' => 'Observación del administrador',
    'edit_attendance' => 'Editar asistencia',
    'admin_edit_remark' => 'Observación de edición del administrador',
    'confirm_check_in' => '¿Está seguro de que desea registrar la entrada del empleado?',
    'confirm_check_out' => '¿Está seguro de que desea registrar la salida del empleado?',
    'edit_attendance_title' => 'Editar asistencia (:name) del :date',
    'create_attendance_title' => 'Crear asistencia (:name) del :date',
    'total_worked_hours' => 'Total de horas trabajadas',
    'attendance_report' => 'Informe de asistencia',

    /** clients */
    'client_listing' => 'Listado de clientes',
    'add_client' => 'Agregar cliente',
    'client_name' => 'Nombre del cliente',
    'client_email' => 'Correo electrónico del cliente',
    'edit_client_detail' => 'Editar detalle del cliente',
    'show_client_detail' => 'Mostrar detalle del cliente',
    'delete_client_detail' => 'Eliminar detalle del cliente',
    'client_invoices' => 'Facturas del cliente',
    'client_detail' => 'Detalle del cliente:',
    'client_project_lists' => 'Listas de proyectos del cliente:',
    'country' => 'País',
    'edit_client' => 'Editar cliente',
    'create_client' => 'Crear cliente',
    'client_section' => 'Sección de clientes',
    'client_contact' => 'Número de contacto del cliente',
    'client_address' => 'Dirección',
    'client_country' => 'País',
    'upload_profile' => 'Subir perfil del cliente',
    'enter_client_name' => 'Ingrese el nombre del cliente',
    'enter_client_email' => 'Ingrese el correo electrónico del cliente',
    'enter_contact_number' => 'Ingrese el número de contacto',
    'enter_client_address' => 'Ingrese la dirección del cliente',
    'enter_country' => 'Ingrese el país',
    'confirm_status_change' => '¿Está seguro de que desea cambiar el estado?',
    'confirm_delete_client' => '¿Está seguro de que desea eliminar los detalles del cliente?',

    /** Project management */
    'lists' => 'Listas',
    'create_project' => 'Crear Proyecto',
    'project_filter' => 'Filtro de Proyecto',
    'search_by_project' => 'Buscar por Proyecto',
    'search_by_status' => 'Buscar por Estado',
    'search_by_priority' => 'Buscar por Prioridad',
    'client' => 'Cliente',
    'all_tasks' => 'Todas las Tareas',
    'completed_tasks' => 'Tareas Completadas',
    'days_left' => 'días restantes',
    'team_member' => 'Miembro del Equipo',
    'start_date' => 'Fecha de Inicio',
    'due_date' => 'Fecha de Vencimiento',
    'view' => 'Ver',
    'projects' => 'Proyectos',
    'assign_employee' => 'Asignar Empleado',
    'client_contact_number' => 'Número de Contacto del Cliente',
    'upload_client_profile' => 'Subir Perfil del Cliente',
    'project_name' => 'Nombre del Proyecto',
    'project_start_date' => 'Fecha de Inicio del Proyecto',
    'project_deadline' => 'Fecha Límite del Proyecto',
    'project_status' => 'Estado del Proyecto',
    'select_project_status' => 'Seleccionar Estado del Proyecto',
    'project_cost' => 'Costo del Proyecto',
    'select_priority' => 'Seleccionar Prioridad',
    'estimated_hours' => 'Horas Estimadas',
    'select_client' => 'Seleccionar Cliente',
    'upload_project_logo' => 'Subir Logo del Proyecto',
    'uploaded_files_images' => 'Archivos e Imágenes Subidos',
    'no_project_file_uploaded' => 'No se han subido archivos del proyecto',
    'update_project' => 'Actualizar Proyecto',
    'project_leader' => 'Líder del Proyecto',
    'assign_member' => 'Asignar Miembro',
    'edit_project' => 'Editar Proyecto',
    'project_document' => 'Documento del Proyecto',
    'upload_documents' => 'Subir Documentos',
    'upload_project_attachments' => 'Subir Adjuntos del Proyecto',
    'show_project_detail' => 'Mostrar Detalle del Proyecto',
    'upload_attachments' => 'Subir Adjuntos',
    'project_attachments' => 'Adjuntos del Proyecto',
    'uploaded_image_files' => 'Archivos de Imagen Subidos',
    'no_project_image_found' => 'No se encontró imagen del proyecto',
    'uploaded_files' => 'Archivos Subidos',
    'no_project_files_found' => 'No se encontraron archivos del proyecto',
    'project_tasks_lists' => 'Listas de Tareas del Proyecto',
    'project_summary' => 'Resumen del Proyecto',
    'cost' => 'Costo:',
    'total_hours' => 'Horas Totales:',
    'created' => 'Creado:',
    'remaining_days' => 'Días Restantes:',
    'project_leaders' => 'Líderes del Proyecto',
    'update_leader' => 'Actualizar Líder',
    'project_members' => 'Miembros del Proyecto',
    'update_member' => 'Actualizar Miembro',
    'project_client_detail' => 'Detalle del Cliente del Proyecto',
    'delete_project_detail' => '¿Estás seguro de que quieres eliminar el Detalle del Proyecto?',
    'delete_project_document' => '¿Estás seguro de que quieres eliminar el Documento del Proyecto?',
    'search_by_member' => 'Buscar por miembro',
    'add_employee_to_project' => 'Agregar empleado al proyecto',

    /** Task management */
    'tasks' => 'Tareas',
    'task_filter' => 'Filtro de tareas',
    'search_by_task_name' => 'Buscar por nombre de tarea',
    'not_started' => 'No iniciada',
    'create_tasks' => 'Crear tareas',
    'end_date' => 'Fecha de finalización',
    'task_name' => 'Nombre de la tarea',
    'enter_task_name' => 'Ingrese el nombre de la tarea',
    'select_project' => 'Seleccionar proyecto',
    'task_start_date' => 'Fecha de inicio de la tarea',
    'task_start_time' => 'Hora de inicio de la tarea',
    'task_end_date' => 'Fecha de finalización de la tarea',
    'task_end_time' => 'Hora de finalización de la tarea',
    'task_status' => 'Estado de la tarea',
    'select_task_status' => 'Seleccionar estado de la tarea',
    'uploaded_files_and_images' => 'Archivos e imágenes cargados',
    'task_attachments' => 'Archivos adjuntos de la tarea',
    'update_task' => 'Actualizar tarea',
    'create_task' => 'Crear tarea',
    'mention' => 'Mención',
    'comment' => 'Comentario',
    'close' => 'Cerrar',
    'write_comment' => 'Escribir un comentario',
    'reply' => 'Responder',
    'delete_confirm' => '¿Seguro que desea eliminar ":title"?',
    'task_member_placeholder' => 'Asignar miembro a la tarea',
    'project_placeholder' => 'Seleccionar proyecto',
    'project_filter_placeholder' => 'Buscar por proyecto',
    'task_name_placeholder' => 'Buscar por nombre de tarea',
    'change_task_status_confirm' => '¿Seguro que desea cambiar el estado de la tarea?',
    'change_status_confirm' => '¿Seguro que desea cambiar el estado?',
    'delete_task_detail_confirm' => '¿Seguro que desea eliminar los detalles de la tarea?',
    'create_checklist_text' => 'Crear lista de verificación',
    'close_checklist_text' => 'Cerrar',
    'remove_checklist_text' => 'Eliminar',
    'remove_checklist_title' => 'Eliminar lista de verificación',
    'view_all_comments' => 'Ver todos los comentarios',
    'comments' => 'Comentarios',
    'edit_task' => 'Editar tarea',
    'edit_task_detail' => 'Editar detalles de la tarea',
    'show_task_detail' => 'Mostrar detalles de la tarea',
    'task_edit' => 'Editar tarea',
    'create_checklist' => 'Crear lista de verificación',
    'upload_attachment' => 'Subir adjunto',
    'total_checklist' => 'Total de listas de verificación',
    'completed_checklist' => 'Listas de verificación completadas',
    'task_checklist_lists' => 'Listas de verificación de tareas',
    'assigned_to' => 'Asignado a',
    'create_task_checklist' => 'Crear lista de verificación de tarea',
    'enter_checklist_title' => 'Ingresar título de la lista de verificación',
    'select_member' => 'Seleccionar miembro',
    'add_more_checklist' => 'Agregar más listas de verificación',
    'image' => 'Imagen',
    'file' => 'Archivo',
    'edit_checklist' => 'Editar lista de verificación',
    'delete_checklist' => 'Eliminar lista de verificación',
    'checklist' => 'Lista de verificación',
    'edit_task_checklist' => 'Editar lista de verificación de tarea',
    'checklist_name' => 'Nombre de la lista de verificación',
    'assign_task_checklist' => 'Asignar lista de verificación de tarea',
    'task_summary' => 'Resumen de la tarea',
    'task_members' => 'Miembros de la tarea',
    'task_attachment_title' => 'Adjuntos de la tarea',
    'upload_attachment_action' => 'Subir adjunto',
    'upload_task_attachments' => 'Subir adjuntos de la tarea',
    'upload_task_attachments_text' => 'Subir adjuntos de la tarea',
    'choose_file_text' => 'Seleccionar archivo',

    /** Holiday */
    'holiday_section' => 'Sección de Vacaciones',
    'event' => 'Evento',
    'event_date' => 'Fecha del Evento',
    'is_public_holiday' => '¿Es Feriado Público?',
    'confirm_delete_holiday' => '¿Estás seguro de que quieres eliminar los detalles de la vacación?',
    'holiday_detail_title' => 'Detalle de la Vacación',
    'holiday' => 'Vacación',
    'csv_import' => 'Importar CSV',
    'import' => 'Importar',
    'holiday_detail_csv' => 'Detalle de la Vacación en CSV',
    'holiday_csv_example' => 'Ejemplo CSV de Vacaciones',
    'add_holiday' => 'Agregar Vacación',
    'import_holiday_csv' => 'Importar CSV de Vacaciones',
    'holiday_filter' => 'Filtrar Vacaciones',
    'event_name' => 'Nombre del Evento',
    'leave_requested_year' => 'Año de Solicitud de Permiso',
    'holiday_detail' => 'Detalle de la Vacación',

    /** Notice */
    'notices_section' => 'Sección de Noticias',
    'notice_title' => 'Título de la Noticia',
    'notice_description' => 'Descripción de la Noticia',
    'notice_receiver' => 'Receptor de la Noticia',
    'send_notice' => 'Enviar Noticia',
    'all_employees' => 'Todos los Empleados',
    'create_notice' => 'Crear Noticia',
    'edit_notice' => 'Editar Noticia',
    'notices' => 'Noticias',
    'receiver' => 'Receptor',
    'published_from' => 'Publicado Desde',
    'publish_to' => 'Publicar Hasta',
    'publish_date' => 'Fecha de Publicación',
    'show_notice_content' => 'Mostrar Contenido de la Noticia',
    'delete_notice_detail' => 'Eliminar Detalle de la Noticia',
    'notice_lists' => 'Listas de Noticias',
    'confirm_change_notice_status' => '¿Está seguro de que desea cambiar el estado de la Noticia?',
    'confirm_delete_notice' => '¿Está seguro de que desea eliminar la Noticia?',
    'confirm_send_notice' => '¿Está seguro de que desea enviar la Noticia?',
    'notice_detail_modal_title' => 'Detalle de la notificación :title',


    /** payroll */
    'employee_payroll'=>'Nómina del empleado',
    'payroll_generate'=>'Generar nómina',
    'payroll_create'=>'Crear nómina',
    'payroll_edit'=>'Editar nómina',
    'select_year' => 'Seleccionar año',
    'salary_cycle' => 'Ciclo salarial',
    'salary_month' => 'Mes salarial',
    'salary_week' => 'Semana salarial',
    'select_week' => 'Seleccionar semana',
    'include_tada' => 'Incluir TADA',
    'include_advance_salary' => 'Incluir salario adelantado',
    'use_attendance' => 'Usar asistencia',
    'generate' => 'Generar',
    'clear' => 'Borrar',
    'report' => 'Informe:',
    'duration' => 'Duración',
    'payroll_summary' => 'Resumen de nómina',
    'total_basic_salary' => 'Salario básico total:',
    'total_net_salary' => 'Salario neto total:',
    'total_allowance' => 'Asignación total:',
    'total_deduction' => 'Deducción total:',
    'total_overtime' => 'Horas extras totales:',
    'total_undertime' => 'Tiempo insuficiente total:',
    'paid_by'=>'Pagado por',
    'net_salary'=>'Salario neto',
    'paid_on'=>'Pagado el',
    'pay_button' => 'Pagar',
    'select_payment_method.'=>'Por favor, seleccione un método de pago.',
    'confirm_delete_payroll'=>'¿Está seguro de que desea eliminar la nómina del empleado?',
    'confirm_generate_payroll'=>'¿Está seguro de que desea generar la nómina?',
    'confirm_change_cycle'=>'¿Está seguro de que desea cambiar el ciclo salarial?',
    'payment_title' => 'Realizar pago',
    'payment_method_placeholder' => 'Seleccionar método de pago',
    'payment_date' => 'Fecha de pago',
    'hourly_rate' => 'Tarifa por hora',
    'hourly' => 'Por hora',
    'working_hours_in_week' => 'Horas laborales en la semana',
    'annual_salary' => 'Salario anual (CTC)',
    'annual' => 'Anual',
    'basic_salary' => 'Salario básico',
    'fixed_allowance' => 'Asignación fija',
    'total' => 'Total',
    'net_total' => 'Total neto',
    'earnings' => 'Ganancias',
    'deductions' => 'Deducciones',
    'create_salary'=>'Crear salario',
    'edit_salary'=>'Editar salario',
    'add_salary'=>'Agregar salario',
    'calculation_type'=>'Tipo de cálculo',
    'monthly_amount'=>'Monto mensual',
    'annual_amount'=>'Monto anual',
    'salary_slip' => 'Recibo de salario',
    'edit_salary_slip' => 'Editar recibo de salario',
    'payslip' => 'Nómina',
    'for_the_month_of' => 'para el mes de',
    'from'=>'de',
    'to'=>'a',
    'employee_id'=>'ID de empleado',
    'earning' => 'Ganancia',
    'deduction' => 'Deducción',
    'actual_salary' => 'Salario real',
    'total_earning'=>'Ganancia total',
    'actual_salary_formula' => '(Ganancia total - Deducciones totales)',
    'bonus' => 'Bono',
    'taxable_salary' => 'Salario sujeto a impuestos',
    'taxable_salary_formula' => '(Salario real + Bono)',
    'tax' => 'Impuesto',
    'salary_after_tax' => 'Salario después de impuestos',
    'expenses_claim' => 'Reclamaciones de gastos (TADA)',
    'absent' => 'Ausente',
    'absent_deduction_formula' => '((Salario bruto / días totales) * días de ausencia)',
    'net_salary_formula' => 'Salario neto = (Salario real - Salario adelantado + TADA)',
    'monthly' => 'Mensual',
    'weekly' => 'Semanal',
    'salary_increment' => 'Incremento salarial',
    'increment' => 'Incremento',
    'current_salary' => 'Salario actual',
    'annual_increment_percent' => 'Incremento anual %',
    'annual_increment_amount' => 'Monto de incremento anual',
    'revised_salary_label' => 'Salario revisado',
    'fiscal_year_label' => 'Incremento para el año fiscal',
    'applicable_from_label' => 'Aplicable desde (Fecha)',
    'applicable_to_label' => 'Aplicable hasta (Fecha)',
    'remark' => 'Comentario',
    'fiscal_year' => 'Año fiscal',
    'select_fiscal_year' => 'Seleccionar año fiscal',
    'list'=>'Lista',
    'employee_salary_filter'=>'Filtro de salario de empleados',
    'salary_review_history'=>'Historial de revisión salarial',
    'increase_salary'=>'Incrementar salario',
    'all'=>'Todos',
    'employee_payslip'=>'Nómina de empleado',
    'salary_from'=>'Salario desde',
    'salary_to'=>'Salario hasta',
    'unpaid_leave'=>'Permiso no remunerado',
    'paid_leave'=>'Permiso remunerado',
    'employee_gross_salary'=>'Salario bruto del empleado',
    'salary_increment_log'=>'Registro de incremento salarial',
    'log'=>'Registro',
    'salary_revised_on'=>'Salario revisado en',
    'increment_by'=>'Incremento por',
    'increment_value'=>'Valor de incremento',
    'old_salary'=>'Salario antiguo',
    'new_salary'=>'Nuevo salario',
    'date_to'=>'Fecha hasta',
    'date_from'=>'Fecha desde',
    'salary_increment_remark'=>'Comentario de incremento salarial',
    'advance_salary_requests'=>'Solicitudes de salario adelantado',
    'advance_salary_request_filter'=>'Filtro de solicitudes de salario adelantado',
    'delete_confirmation'=>'¿Está seguro de que desea eliminar?',
    'payslip_for_the_month_of'=>'Nómina del mes de',
    'absent_deduction'=>'Deducción por ausencia',

    /** Advance Salary */
    'is_paid' => '¿Está Pagado?',
    'released_on' => 'Liberado En',
    'requested_on' => 'Solicitado En',
    'released_amount' => 'Monto Liberado',
    'requested_amount' => 'Monto Solicitado',
    'search_by_month' => 'Buscar por Mes',
    'search_by_employee_name' => 'Buscar por Nombre del Empleado',
    'advance_salary_detail' => 'Detalle del Salario Adelantado',
    'is_settled' => 'Está Liquidado',
    'verified_by' => 'Verificado Por',
    'amount_released_date' => 'Fecha de Liberación del Monto',
    'advance_requested_date' => 'Fecha de Solicitud del Adelanto',
    'total_released_amount' => 'Monto Total Liberado',
    'total_request_amount' => 'Monto Total Solicitado',
    'employee' => 'Empleado',
    'select_employee' => 'Seleccionar Empleado',
    'advance_salary_request_detail' => 'Detalle de Solicitud de Salario Adelantado',
    'proof_of_advance_salary_payment' => 'Prueba de Pago de Salario Adelantado',
    'attachments' => 'Adjuntos',
    'processing' => 'Procesando',

    /** Tax report */
    'tax_report' => 'Informe de Impuestos',
    'employee_tax_report' => 'Informe de Impuestos del Empleado',
    'tax_report_edit' => 'Editar Informe de Impuestos',
    'tax_report_detail_of' => 'Detalle del Informe de Impuestos de',
    'tax_report_detail' => 'Detalle del Informe de Impuestos',
    'salary_sheet' => 'Hoja de Salario',
    'particular' => 'Particular',
    'income' => 'Ingresos',
    'tax_data_not_available' => 'Datos fiscales no disponibles para el estado civil actual',
    'remain_tds_formula' => '(TDS Total Adeudado / Número de meses restantes)',
    'remaining_month' => 'Mes Restante',
    'tds_calculation_msg' => 'Cálculo de TDS para el Mes Actual (Mes de Cálculo)',
    'total_due_tds' => 'TDS Total Adeudado',
    'total_paid_tds' => 'TDS Total Pagado',
    'total_payable_tds' => 'TDS Total a Pagar',
    'other_discount' => 'Otro Descuento',
    'female_discount' => 'Descuento para Mujeres',
    'medical_claim' => 'Reclamo Médico',
    'less' => 'menos',
    'less_tax_deduction' => 'menos: Deducción Fiscal',
    'tax_amount' => 'Monto de Impuestos',
    'percent' => 'Porcentaje',
    'tax_calculation_on_taxable_income' => 'Cálculo de Impuestos sobre Ingresos Imponibles',
    'taxable_income' => 'Ingreso Imponible',
    'ssf_contribution' => 'Contribución SSF',
    'ssf_contribution_salary' => 'Contribución SSF al Salario',
    'total_retirement_contribution_allowed' => 'Contribución Total a la Jubilación Permitida',
    'total_income' => 'Ingreso Total',
    'amount' => 'Cantidad',
    'additional_information' => 'Información Adicional',
    'total_payable' => 'Total a Pagar',
    'tds_paid' => 'TDS Pagado',
    'ssf_deduction' => 'Deducción SSF',
    'tax_report_generate' => 'Generar Informe de Impuestos',
    'print' => 'Imprimir',
    'gross_earnings' => 'Ganancias Brutas',
    'tax_payable' => 'Impuesto a Pagar',

    /** Payroll Setting  */
    'advance_salary_limit' => 'Límite de Salario Adelantado',
    'select_month' => 'Seleccionar Mes',
    'applicable_month' => 'Mes Aplicable',
    'value' => 'Valor',
    'value_type' => 'Tipo de Valor',
    'enter_bonus_type' => 'Ingresar Tipo de Bono',
    'salary_components' => 'Componentes del Salario',
    'add_bonus' => 'Agregar Bono',
    'max_daily_ot' => 'Máximo Diario de Horas Extras',
    'assign_overtime_to_employee' => 'Asignar Horas Extras al Empleado',
    'overtime_pay_rate' => 'Tasa de Pago por Horas Extras (por hora)',
    'overtime_rate_percent' => 'Porcentaje de Tasa de Horas Extras (por hora)',
    'placeholder_overtime_pay_rate' => 'Ingresar Tasa de Pago por Horas Extras',
    'placeholder_overtime_rate_percent' => 'Ingresar Porcentaje de Tasa de Horas Extras',
    'rate_type' => 'Tipo de Tasa',
    'select_rate_type' => 'Seleccionar Tipo de Tasa',
    'ot_valid_after_hour' => 'Horas Extras Válidas Después de ? Hora',
    'placeholder_ot_valid_after_hour' => 'Ingresar Horas Después de las Cuales las Horas Extras son Válidas',
    'monthly_ot' => 'Máximo Mensual de Horas Extras',
    'placeholder_monthly_ot' => 'Ingresar Máximo Mensual de Horas Extras',
    'weekly_ot' => 'Máximo Semanal de Horas Extras',
    'placeholder_weekly_ot' => 'Ingresar Máximo Semanal de Horas Extras',
    'daily_ot' => 'Máximo Diario de Horas Extras',
    'placeholder_daily_ot' => 'Ingresar Máximo Diario de Horas Extras',
    'pay_percent' => 'Porcentaje/Tasa de Pago',
    'employee_count' => 'Número de Empleados',
    'hour' => 'Hora',
    'currency_setting' => 'Configuración de Moneda',
    'payroll_currency' => 'Moneda de Nómina',
    'choose_payroll_currency' => 'Elegir Moneda de Nómina',
    'add_payment_method' => 'Agregar Método de Pago',
    'payment_method_name' => 'Nombre del Método de Pago',
    'update_payment_method' => 'Actualizar Método de Pago',
    'component_value' => 'Valor del Componente',
    'component_type' => 'Tipo de Componente',
    'add_salary_component' => 'Agregar Componente de Salario',
    'apply_for_all' => 'Aplicar para Todos',
    'component_value_annual' => 'Valor del Componente (Anual)',
    'select_value_type' => 'Seleccionar Tipo de Valor',
    'select_component_type' => 'Seleccionar Tipo de Componente',
    'enter_salary_component_name' => 'Ingresar Nombre del Componente de Salario',
    'add_salary_group' => 'Agregar Grupo de Salario',
    'delete_confirm_salary_group' => '¿Está seguro de que desea eliminar los detalles del grupo?',
    'assign_employee_to_group' => 'Asignar Empleado al Grupo',
    'choose_salary_component' => 'Elegir Componente de Salario',
    'assign_salary_components' => 'Asignar Componentes de Salario',
    'enter_salary_group_name' => 'Ingresar Nombre del Grupo de Salario',
    'add_more_tds_detail' => 'Agregar Más Detalles de TDS',
    'enter_tds_in_percent' => 'Ingresar TDS en Porcentaje',
    'enter_annual_salary_to' => 'Ingresar Salario Anual Hasta',
    'enter_annual_salary_from' => 'Ingresar Salario Anual Desde',
    'select_marital_status' => 'Seleccionar Estado Civil',
    'create_salary_tds' => 'Crear TDS de Salario',
    'update_salary_tds' => 'Actualizar TDS de Salario',
    'salary_tds_detail_for_single' => 'Detalle de TDS de Salario para Solteros',
    'add_salary_tds' => 'Agregar TDS de Salario',
    'annual_salary_to' => 'Salario Anual Hasta',
    'annual_salary_from' => 'Salario Anual Desde',
    'tds' => 'TDS (%)',
    'salary_tds_detail_for_married' => 'Detalle de TDS de Salario para Casados',
    'ssf' => 'SSF',
    'employee_contribution' => 'Contribución del Empleado',
    'office_contribution' => 'Contribución de la Oficina',
    'assign_undertime_to_employee' => 'Asignar Tiempo Corto al Empleado',
    'enter_title' => 'Ingresar Título',
    'undertime_after_minute' => 'Minutos Después de los Cuales se Aplica el Tiempo Corto',
    'placeholder_ut_after' => 'Ingresar Horas Después de las Cuales se Aplica el Tiempo Corto',
    'penalty_type' => 'Tipo de Penalización',
    'select_penalty_type' => 'Seleccionar Tipo de Penalización',
    'penalty_percent' => 'Porcentaje de Penalización (por hora)',
    'penalty_percent_placeholder' => 'Ingresar Porcentaje de Penalización por Tiempo Corto',
    'penalty_rate' => 'Tasa de Penalización (por hora)',
    'penalty_rate_placeholder' => 'Ingresar Tasa de Penalización por Tiempo Corto',

    /** Leave */
    'leave_type_section' => 'Sección de Tipo de Permiso',
    'select_leave_type' => 'Seleccionar Tipo de Permiso',
    'leave_type' => 'Tipo de Permiso',
    'leave_allocated_days' => 'Días de Permiso Asignados',
    'allocated_days' => 'Días Asignados',
    'is_paid_leave' => 'Es Permiso Pagado',
    'leave_type_name' => 'Nombre del Tipo de Permiso',
    'leave_type_placeholder' => 'Ingrese Tipo de Permiso',
    'add_leave_type' => 'Agregar Tipo de Permiso',
    'type' => 'Tipo',
    'edit_leave_type_detail' => 'Editar Detalles del Tipo de Permiso',
    'delete_leave_type' => 'Eliminar Tipo de Permiso',
    'delete_leave_confirmation' => '¿Está seguro de que desea eliminar el Tipo de Permiso?',
    'leave_request_section' => 'Sección de Solicitud de Permiso',
    'approve' => 'Aprobar',
    'reject' => 'Rechazar',
    'from_date' => 'Desde Fecha',
    'to_date' => 'Hasta Fecha',
    'start_time' => 'Hora de Inicio',
    'end_time' => 'Hora de Fin',
    'reason' => 'Razón',
    'requested_for' => 'Solicitado Para',
    'requested_by' => 'Solicitado Por',
    'requested_days' => 'Días Solicitados',
    'requested_date' => 'Fecha de Solicitud',
    'all_status' => 'Todos los Estados',
    'all_leave_type' => 'Todos los Tipos de Permiso',
    'leave_request_filter' => 'Filtro de Solicitud de Permiso',
    'create_leave_request' => 'Crear Solicitud de Permiso',
    'leave_reason' => 'Razón del Permiso',
    'referred_by' => 'Referido Por',
    'leave_date' => 'Fecha de Permiso',
    'time_leave_request_filter' => 'Filtro de Solicitud de Permiso por Tiempo',
    'create_time_leave_request' => 'Crear Solicitud de Permiso por Tiempo',
    'time_leave_request_section' => 'Sección de Solicitud de Permiso por Tiempo',
    'time_leave_status_update' => 'Actualización del Estado del Permiso por Tiempo',

    /** Team Meeting */
    'team_meeting_section' => 'Sección de Reunión de Equipo',
    'update_and' => 'Actualizar y',
    'create_and' => 'Crear y',
    'send' => 'Enviar',
    'meeting_participator' => 'Participante de la reunión',
    'image_hint' => 'Se recomienda que la imagen esté en formato horizontal',
    'meeting_description' => 'Descripción de la reunión',
    'upload_image' => 'Subir imagen',
    'meeting_start_time' => 'Hora de inicio de la reunión',
    'meeting_date' => 'Fecha de la reunión',
    'meeting_venue' => 'Lugar de la reunión',
    'enter_venue_name' => 'Ingrese el nombre del lugar',
    'enter_content_title' => 'Ingrese el título del contenido',
    'meeting_title' => 'Título de la reunión',
    'delete_team_meeting_confirmation' => '¿Está seguro de que desea eliminar la reunión del equipo?',
    'image_delete_confirmation' => '¿Está seguro de que desea eliminar la imagen?',
    'create_team_meeting' => 'Crear reunión de equipo',
    'delete_team_meeting' => 'Eliminar detalle de la reunión de equipo',
    'edit_meeting_detail' => 'Editar detalle de la reunión',
    'show_team_meeting' => 'Mostrar contenido de la reunión del equipo',
    'participators' => 'Participantes',
    'participator' => 'Participante',
    'team_meeting_filter' => 'Filtro de reunión de equipo',
    'agenda' => 'Agenda',
    'creator' => 'Creador',

    /** Tada */
    'tada_attachment' => 'Adjunto Tada',
    'upload_tada_attachment' => 'Subir Adjunto Tada',
    'accepted' => 'Aceptado',
    'tada_status_change' => '¿Está seguro de que desea cambiar el estado del acuerdo Tada?',
    'delete_tada_confirm' => '¿Está seguro de que desea eliminar :title?',
    'uploaded_attachment' => 'Adjunto Subido',
    'no_attachment_file' => 'No hay archivo adjunto',
    'total_expense' => 'Gasto Total',
    'create_tada' => 'Crear Tada',
    'edit_tada' => 'Editar Tada',
    'tada_listing' => 'Listado Tada',
    'tada_filter' => 'Filtro Tada',
    'submitted_date' => 'Fecha de Envío',
    'expense' => 'Gasto',
    'tada_detail' => 'Detalle Tada',
    'verified_date' => 'Fecha de Verificación',
    'tada_summary' => 'Resumen Tada',
    'update_status' => 'Actualizar Estado',
    'category' => 'Categoría',
    'select_category' => 'Seleccionar Categoría',
    'opening_time' => 'Hora de Apertura',
    'closing_time' => 'Hora de Cierre',
    'checkin_checkout_rule' => 'Regla de Check-In/Check-Out',
    'early_check_in' => 'Check-In Temprano',
    'check_in_before' => 'Puede hacer check-in antes (en minutos)',
    'checkin_before' => 'Check-In Antes',
    'enter_check_in_before' => 'Ingrese cuánto antes puede hacer check-in (en minutos)',
    'early_check_out' => 'Check-Out Temprano',
    'check_out_before' => 'Puede hacer check-out antes (en minutos)',
    'checkout_before' => 'Check-Out Antes',
    'enter_check_out_before' => 'Ingrese cuánto antes puede hacer check-out (en minutos)',
    'late_check_in' => 'Check-In Tardío',
    'check_in_after' => 'Puede hacer check-in después (en minutos)',
    'checkin_after' => 'Check-In Después',
    'enter_check_in_after' => 'Ingrese cuánto después puede hacer check-in (en minutos)',
    'late_check_out' => 'Check-Out Tardío',
    'checkout_after' => 'Check-Out Después',
    'check_out_after' => 'Puede hacer check-out después (en minutos)',
    'enter_check_out_after' => 'Ingrese cuánto después puede hacer check-out (en minutos)',
    'enter_shift_name' => 'Ingrese el Nombre del Turno',
    'select_shift' => 'Seleccionar Turno',
    'delete_office_time_confirm' => '¿Está seguro de que desea eliminar el Horario de Oficina?',
    'office_time_detail' => 'Detalle del Horario de Oficina',
    'office_schedule' => 'Horario de Oficina',
    'add_office_time' => 'Agregar Horario de Oficina',

    /** Award Types */
    'award_distributed' => 'Premio Distribuido',
    'add_award_types' => 'Agregar Tipos de Premios',
    'gift_item' => 'Artículo de Regalo',
    'awarded_date' => 'Fecha de Otorgamiento',

    /** Award */
    'award' => 'Premio',
    'award_name' => 'Nombre del Premio',
    'select_award_type' => 'Seleccionar Tipo de Premio',
    'enter_gift_item' => 'Ingresar Artículo de Regalo',
    'award_base' => 'Base del Premio',
    'select_award_base' => 'Seleccionar Base del Premio',
    'awarded_by' => 'Otorgado Por',
    'enter_awarded_by' => 'Ingresar Otorgado Por',
    'award_description' => 'Descripción del Premio',
    'gift_description' => 'Descripción del Regalo',
    'reward_code' => 'Código de Recompensa',
    'enter_reward_code' => 'Ingresar Código de Recompensa',
    'add_award' => 'Agregar Premio',
    'attachment' => 'Adjunto',
    'award_lists' => 'Listas de Premios',

    /** Asset Types */
    'add_asset_types' => 'Agregar Tipos de Activos',
    'asset_item_count' => 'Cantidad de Artículos de Activo',
    'asset_type' => 'Tipo de Activo',
    'asset_name' => 'Nombre del Activo',
    'purchased_date' => 'Fecha de Compra',
    'is_working' => 'Está Funcionando',
    'is_available' => 'Está Disponible',
    'asset' => 'Activo',

    /** Assets */
    'select_asset_type' => 'Seleccionar Tipo de Activo',
    'assigned_date' => 'Fecha de Asignación',
    'is_available_for_employee' => 'Disponible para el Empleado',
    'select_availability' => 'Seleccionar Disponibilidad',
    'warranty_end_date' => 'Fecha de Fin de Garantía',
    'warranty_available' => 'Garantía Disponible',
    'select_warranty_availability' => 'Seleccionar Disponibilidad de Garantía',
    'asset_serial_number' => 'Número de Serie del Activo',
    'enter_asset_serial_number' => 'Ingresar Número de Serie del Activo',
    'asset_code' => 'Código del Activo',
    'enter_asset_code' => 'Ingresar Código del Activo',
    'change_availability_status' => '¿Estás seguro de que quieres cambiar el estado de disponibilidad?',
    'delete_asset_confirm' => '¿Estás seguro de que quieres eliminar :title?',
    'add_asset' => 'Agregar Activo',
    'asset_image' => 'Imagen del Activo',
    'asset_assigned_employee' => 'Empleado Asignado al Activo',
    'assets_filter' => 'Filtro de Activos',
    'working_status' => 'Estado de Funcionamiento',
    'availability_status' => 'Estado de Disponibilidad',
    'yes_available' => 'Sí, Disponible',
    'notavailable' => 'No Disponible',
    'purchased_from' => 'Comprado De',
    'purchased_to' => 'Comprado A',

    /** Content Management */
    'content_section' => 'Sección de Contenido',
    'content' => 'Contenido',
    'content_type' => 'Tipo de Contenido',
    'content_title' => 'Título del Contenido',
    'select_content_type' => 'Seleccionar Tipo de Contenido',
    'delete_content_confirm' => '¿Estás seguro de que deseas eliminar el contenido de la página estática?',
    'company_static_content' => 'Contenido Estático de la Empresa',
    'add_content' => 'Agregar Contenido',

    /** Support */
    'delete_support_confirm' => '¿Estás seguro de que deseas eliminar :title?',
    'ticket_lists' => 'Listas de Tickets',
    'query_by' => 'Consulta Por',
    'concerned_department' => 'Departamento Concernido',
    'unseen' => 'No Visto',
    'read_status' => 'Estado de Lectura',
    'seen' => 'Visto',
    'query_status' => 'Estado de Consulta',
    'support_filter' => 'Filtro de Soporte',
    'query_lists' => 'Listas de Consultas',
    'department_support_requested_from' => 'Soporte Solicitado Desde el Departamento',
    'department_support_requested_to' => 'Soporte Solicitado Al Departamento',
    'change_query_status' => 'Cambiar Estado de Consulta',

    /** Router */
    'router_section' => 'Sección de Router',
    'router_bssid' => 'BSSID del Router',
    'router' => 'Router',
    'router_detail' => 'Detalles del Router',
    'add_router' => 'Agregar Router',

    /** QR */
    'scan_me' => 'Escanéame',
    'attendance_qr' => 'QR de Asistencia',
    'qr_image' => 'Imagen QR',
    'add_qr' => 'Agregar QR',
    'qr_section' => 'Sección QR',

    /** NFC */
    'nfc_section' => 'Sección NFC',
    'created_by' => 'Creado Por',

    /** Role and permission */
    'role_section' => 'Sección de Roles',
    'autorize_backend_login' => 'Autorizar Inicio de Sesión en el Backend',
    'role_name' => 'Nombre del Rol',
    'permissions' => 'Permisos',
    'check_all' => 'Seleccionar Todos',
    'module' => 'Módulo',
    'add_role' => 'Agregar Rol',
    'assign_permissions' => 'Asignar Permisos',
    'confirm_role_deletion' => '¿Estás seguro de que deseas eliminar el rol?',
    'can_login' => 'Puede Iniciar Sesión',
    'permission_setting' => 'Configuración de Permisos',
    'assign' => 'Asignar',

    /** General Setting */
    'general_setting_section' => 'Sección de Configuración General',
    'general_setting' => 'Configuración General',

    /** App Setting */
    'export_database_data' => 'Exportar Datos de la Base de Datos',
    'check_router_bssid' =>'Verificar BSSID del router',

    /** Fiscal Years */
    'fiscal_years' => 'Años Fiscales',
    'year' => 'Año',
    'add_fiscal_year' => 'Agregar Año Fiscal',

    /** Notifications */
    'notification_section' => 'Sección de Notificaciones',
    'confirm_notification_send' => '¿Estás seguro de que quieres enviar la notificación?',
    'notification' => 'Notificación',
    'published_date' => 'Fecha de Publicación',
    'all_types' => 'Todos los Tipos',
    'notification_lists' => 'Listas de Notificaciones',
    'notified_member' => 'Miembro Notificado',
    'notification_title' => 'Título de la Notificación',
    'notification_description' => 'Descripción de la Notificación',
    'send_notification' => 'Enviar Notificación',
    'enter_notification_title' => 'Ingresa el Título de la Notificación',

    /** feature control */
    'app_setting' => 'Configuración de la Aplicación',
    'sn' => 'SN',
    'group' => 'Grupo',
    'export_table_data' => 'Exportar Datos de la Tabla',
    'leave_requests' => 'Solicitudes de Permiso',
    'employee_lists' => 'Listas de Empleados',
    'attendances' => 'Asistencias',
    'confirm_change_status' => '¿Está seguro de que desea cambiar el estado?',
    'yes' => 'Sí',
    'no' => 'No',

    /** Api response */
    /** Auth Controller */
    'invalid_login_credentials'=>'¡Credenciales de inicio de sesión no válidas!',
    'authenticated'=>'Autenticado',
    'user_detail_not_found'=>'Detalle de usuario no encontrado',
    'partial_logout_successful'=>'Cierre de sesión parcial exitoso',
    /** Dashboard Controller */
    'data_found'=>'Datos encontrados',
    /** AdvanceSalary Controller */
    'advance_salary_pending_error'=>'No se puede solicitar otro adelanto hasta que se liquide la solicitud anterior.',
    'data_updated_successfully'=>'Datos actualizados con éxito',
    'user_updated_advance_salary_request' => ':name ha actualizado una solicitud de adelanto',
    'data_created_successfully'=>'Datos creados con éxito',
    'advance_salary_request_alert'=>'Alerta de Solicitud de Adelanto',
    'user_submitted_advance_salary_request' => ':name ha presentado una solicitud de adelanto por un monto de :amount',
    /** Attendance Api */
    'check_out_successful'=>'Salida exitosa',
    'check_out_notification'=>'Notificación de salida',
    'check_in_successful'=>'Entrada exitosa',
    'check_in_notification'=>'Notificación de entrada',
    'not_checked_in_yet'=>'Aún no se ha registrado la entrada',
    'alert_multi_checkin_shift'=>'¡Lo siento! El empleado no puede registrar la entrada dos veces en un turno.',
    'checkout_alert_for_shift'=>'El empleado ya ha salido del turno',
    'alert_checkin'=>'¡Lo siento! el empleado no puede registrar la entrada dos veces al día.',
    'checkout_alert'=>'El empleado ya ha salido hoy',
    'attendance_alert_status'=>':status ya realizado',
    'employee_checked_in' => ':name registró la entrada a las :time',
    'employee_checked_out' => ':name registró la salida a las :time',
    'has_worked_for' => 'y ha trabajado por :time',
    'multi_checkout_warning'=>'Has alcanzado el número máximo de registros de entrada y salida permitidos para hoy.',
    'employee_checked_out_and_worked' => ':name registró la salida a las :check_out_time y ha trabajado por :worked_time',
    'invalid_attendance_type'=>'Tipo de asistencia no válido.',
    'invalid_qr'=>'QR no válido o QR no disponible',
    'invalid_nfc'=>'Token NFC no válido o NFC no disponible',
    'validation_failed'=>'Validación fallida',

    /** Leave Api Controller */
    'leave_request_cancelled' => 'Solicitud de licencia cancelada con éxito',
    'leave_request_cannot_be_cancelled' => 'La solicitud de licencia no puede ser cancelada una vez que se ha actualizado desde el estado pendiente.',
    'leave_request_notification' => 'Notificación de Solicitud de Licencia',
    'leave_request_submitted' => ':name ha solicitado licencia de :start_time a :end_time en :issue_date. Motivo: :reasons',
    'leave_request_submitted_successfully' => 'Solicitud de licencia enviada con éxito',
    'leave_request_cancelled_successfully' => 'Solicitud de licencia cancelada con éxito',
    'leave_request_submit' => ':name ha solicitado :no_of_days día(s) de licencia desde :leave_from en :leave_requested_date. Motivo: :reasons',

    /** NFC api Controller */
    'nfc_token_already_exist' => 'El token NFC ya existe.',
    'nfc_added_successfully' => 'NFC añadido con éxito',

    /** Notification Api Controller */
    'updated_successfully' => 'Actualizado con éxito',
    'successfully_sent_notification' => 'Notificación enviada con éxito',
    'data_not_found' => 'Datos no encontrados',
    'content_not_found' => 'Contenido no encontrado',

    /** Support Api Controller */
    'support_notification' => 'Notificación de Soporte',
    'support_request_submitted' => ':name ha solicitado soporte.',
    'query_submitted_successfully' => 'Consulta enviada con éxito',

    /** Tada Api Controller  */
    'attachment_detail_not_found' => 'Detalles del adjunto no encontrados',
    'cannot_delete_attachment_detail' => 'No se puede eliminar el detalle del adjunto una vez verificado',
    'upload_another_attachment_before_delete' => 'Por favor, cargue otro adjunto antes de eliminar.',
    'attachment_deleted_successfully' => 'Adjunto eliminado con éxito',
    'tada_update_alert' => 'No puede actualizar los detalles una vez verificado, por favor contacte al administrador',
    'tada_notification' => ':name ha enviado un nuevo TADA para :title',
    'tada_detail_notification' => ':name ha actualizado los detalles del TADA enviado para :title',
    'tada_alert' => 'Alerta TADA',

    /** TaskDetailApi Controller */
    'status_changed_successfully' => 'Estado cambiado con éxito',
    'task_detail_not_found' => 'Detalles de la tarea no encontrados',

    /** TaskCheckListApi Controller */
    'status_updated_successfully' => 'Estado actualizado con éxito',

    /** TaskCommentApi Controller */
    'comment_notification' => 'Notificación de Comentario',
    'task_mention' => 'Se le menciona en la tarea :task :type',
    'comment_reply' => 'Respuesta al comentario',
    'comment_reply_deleted_successfully' => 'Respuesta al comentario eliminada con éxito',
    'comment_deleted_successfully' => 'Comentario eliminado con éxito',
    'comment_added_successfully' => 'Comentario añadido con éxito',

    /** userProfile Api */
    'invalid_base64_image' => 'El valor Base64 no es una imagen válida',
    'demo_version' => 'Esta es una versión de demostración. Adquiera la aplicación para usar todas las funciones',
    'user_not_found' => 'Detalles del usuario no encontrados',
    'profile_updated' => 'Perfil actualizado con éxito',
    'incorrect_current_password' => 'Contraseña actual incorrecta',
    'new_password_same_as_old' => 'La nueva contraseña no puede ser la misma que la antigua',
    'password_changed' => 'Contraseña cambiada con éxito',


    /** leave_approval */
    'leave_approval'=>'Aprobación de permiso',
    'leave_approval_list'=>'Lista de aprobaciones de permiso',
    'add_leave_approval'=>'Agregar aprobación de permiso',
    'subject'=>'Asunto',
    'related'=>'Relacionado',
    'select_related'=>'Seleccionar relacionado',
    'max_days_to_sign'=>'Número máximo de días para firmar',
    'notification_recipient'=>'Destinatario de la notificación',
    'select_notification_recipient'=>'Seleccionar destinatario de la notificación',
    'approval_process' =>'Proceso de aprobación',
    'approver'=>'Aprobador',
    'select_approver'=>'Seleccionar aprobador',
    'head_of_department'=>'Jefe de departamento',
    'specific_personnel'=>'Personal específico',
    'applicable_from'=>'Aplicable desde',

    /** Event Management */
    'event_section'=>'Sección de eventos',
    'event_title'=>'Título del evento',
    'event_location'=>'Ubicación del evento',
    'event_start_date'=>'Fecha de inicio del evento',
    'event_start_time'=>'Hora de inicio del evento',
    'event_end_date'=>'Fecha de finalización del evento',
    'event_end_time'=>'Hora de finalización del evento',
    'all_departments'=>'Todos los departamentos',
    'delete_event_confirmation'=>'¿Está seguro de que desea eliminar este evento?',
    'create_event'=>'Crear evento',
    'show_event'=>'Mostrar evento',
    'enter_event_title'=>'Ingresar título del evento',
    'edit_event_detail'=>'Editar detalles del evento',
    'delete_event'=>'Eliminar evento',
    'event_calendar'=>'Calendario de eventos',

    /** Training Management */
    'training_types'=>'Tipos de formación',
    'select_training_type'=>'Seleccionar tipo de formación',
    'training'=>'Formación',
    'select_trainer'=>'Seleccionar entrenador',
    'trainer'=>'Entrenador',
    'add_trainer'=>'Agregar entrenador',
    'add_training'=>'Agregar formación',
    'trainer_lists'=>'Lista de entrenadores',
    'training_list'=>'Lista de formaciones',
    'total_training'=>'Total de formaciones',
    'training_type'=>'Tipo de formación',
    'training_management'=>'Gestión de formación',
    'add_training_types'=>'Agregar tipos de formación',
    'training_date'=>'Fecha de formación',
    'trainer_type'=>'Tipo de entrenador',
    'select_trainer_type'=>'Seleccionar tipo de entrenador',
    'expertise' =>'Campo de especialización',
    'certificate' =>'Certificado',
    'contact_number' =>'Número de contacto',
    'training_for' =>'Formación para',
    'time' =>'Tiempo',
    'updated_by' =>'Actualizado por',

    'select_task' => 'Seleccionar tarea',
    'event_host' =>'Anfitrión del evento',
    'host' =>'Anfitrión',
    'location' =>'Ubicación',
    'event_list'=>'Lista de eventos',
    'total_tasks'=>'Tareas totales',
    'applicable_to_tax_report'=>'Los componentes salariales aplicables a todos se utilizarán en el informe de impuestos.',

    'no_departments_found'=>'No se encontraron departamentos',
    'error_loading_departments'=>'Error al cargar departamentos',
    'no_employees_found'=>'No se encontraron empleados',
    'update_send' => 'Actualizar y enviar notificación',
    'create_send' => 'Crear y enviar notificación',


    'admin_permission_msg' => 'Si se selecciona esta opción, se omitirán todos los pasos jerárquicos y los usuarios con este rol podrán ver y editar todas las licencias. Mantenga esta opción para roles especiales como Recursos Humanos',
    'coming_soon' => 'Muy pronto',
    'assign_trainer_section' => 'Sección de asignación de entrenador',
    'assign_trainer' => 'Asignar entrenador',

    'export_csv' => 'Exportar CSV',

    /** Termination Management */
    'termination_types'=>'Tipos de terminación',
    'select_termination_type'=>'Seleccionar tipo de terminación',
    'termination'=>'Terminación',
    'add_termination'=>'Agregar terminación',
    'termination_list'=>'Lista de terminaciones',
    'total_termination'=>'Total de terminaciones',
    'termination_type'=>'Tipo de terminación',
    'termination_management'=>'Gestión de terminaciones',
    'add_termination_types'=>'Agregar tipos de terminación',
    'termination_date'=>'Fecha de terminación',
    'notice_date'=>'Fecha de notificación',

    /** Resignation Management */
    'resignation_types'=>'Tipos de renuncia',
    'select_resignation_type'=>'Seleccionar tipo de renuncia',
    'resignation'=>'Renuncia',
    'add_resignation'=>'Agregar renuncia',
    'resignation_list'=>'Lista de renuncias',
    'total_resignation'=>'Total de renuncias',
    'resignation_type'=>'Tipo de renuncia',
    'resignation_management'=>'Gestión de renuncias',
    'add_resignation_types'=>'Agregar tipos de renuncia',
    'resignation_date'=>'Fecha de renuncia',
    'last_date'=>'Última fecha',
    'last_working_day'=>'Último día laboral',
    'resignation_notification' => 'Solicitud de renuncia',
    'resignation_submit' => ':name ha solicitado una renuncia el :resignation_date con efecto a partir del :last_working_day.',
    'resignation_submitted_successfully' => 'Renuncia enviada exitosamente',
    'resignation_fetched_successfully' => 'Renuncia obtenida exitosamente',
    'resignation_exist_error' => 'Tu renuncia ya está :status.',
    'document' => 'Documento',
    'venue' => 'Lugar',

    /** Warning Management */
    'select_warning_type'=>'Seleccionar tipo de advertencia',
    'warning'=>'Advertencia',
    'message'=>'Mensaje',
    'add_warning'=>'Agregar advertencia',
    'warning_list'=>'Lista de advertencias',
    'total_warning'=>'Total de advertencias',
    'warning_type'=>'Tipo de advertencia',
    'warning_management'=>'Gestión de advertencias',
    'add_warning_types'=>'Agregar tipos de advertencia',
    'warning_date'=>'Fecha de advertencia',
    'warning_notification' => 'Solicitud de advertencia',
    'warning_submit' => ':name ha enviado su respuesta a la advertencia sobre :subject emitida el :date ',
    'warning_submitted_successfully' => 'Advertencia enviada exitosamente',
    'response_submitted_successfully' => 'Tu respuesta fue registrada exitosamente',
    'warning_fetched_successfully' => 'Advertencia obtenida exitosamente',
    'warning_exist_error' => 'Tu respuesta ya está registrada.',
    'response_section' => 'Sección de respuesta',
    'response' => 'Respuesta',

    /** Complaint Management */
    'select_complaint_type'=>'Seleccionar tipo de queja',
    'complaint'=>'Queja',
    'complaint_from'=>'Queja de',
    'add_complaint'=>'Agregar queja',
    'complaint_list'=>'Lista de quejas',
    'total_complaint'=>'Total de quejas',
    'complaint_type'=>'Tipo de queja',
    'complaint_management'=>'Gestión de quejas',
    'add_complaint_types'=>'Agregar tipos de queja',
    'complaint_date'=>'Fecha de queja',
    'complaint_notification' => 'Solicitud de queja',
    'complaint_submit' => 'Se ha enviado la respuesta a la queja sobre :subject emitida el :date',
    'complaint_submitted_successfully' => 'Queja enviada exitosamente',
    'complaint_fetched_successfully' => 'Queja obtenida exitosamente',
    'complaint_exist_error' => 'Tu respuesta ya está registrada.',
    'complain_to' => 'Quejarse a',

    'hr_admin_setup' => 'Configuración de administración de RRHH',
    'edit_branch' => 'Editar sucursal',
    'branch_head_error'=>'El usuario seleccionado ya es jefe de otra sucursal, por favor selecciona un usuario diferente',
    'department_head_error'=>'El usuario seleccionado ya es jefe de otro departamento, por favor selecciona un usuario diferente',

    /** Promotion Management */
    'promotion'=>'Promoción',
    'add_promotion'=>'Agregar promoción',
    'promotion_list'=>'Lista de promociones',
    'promotion_section'=>'Sección de promoción',
    'total_promotion'=>'Total de promociones',
    'promotion_type'=>'Tipo de promoción',
    'promotion_management'=>'Gestión de promociones',
    'add_promotion_types'=>'Agregar tipos de promoción',
    'promotion_date'=>'Fecha de promoción',
    'promotion_notification' => 'Solicitud de promoción',
    'promotion_submitted_successfully' => 'Promoción enviada exitosamente',
    'promotion_fetched_successfully' => 'Promoción obtenida exitosamente',

    'select_post' => 'Seleccionar puesto',
    'old_post' => 'Puesto anterior',
    'new_post' => 'Nuevo puesto',

    /** Transfer Management */
    'transfer'=>'Transferencia',
    'transfer_details'=>'Detalles de transferencia',
    'add_transfer'=>'Agregar transferencia',
    'transfer_list'=>'Lista de transferencias',
    'transfer_section'=>'Sección de transferencia',
    'total_transfer'=>'Total de transferencias',
    'transfer_type'=>'Tipo de transferencia',
    'transfer_management'=>'Gestión de transferencias',
    'add_transfer_types'=>'Agregar tipos de transferencia',
    'transfer_date'=>'Fecha de transferencia',
    'transfer_notification' => 'Solicitud de transferencia',
    'transfer_submitted_successfully' => 'Transferencia enviada exitosamente',
    'transfer_fetched_successfully' => 'Transferencia obtenida exitosamente',
    'old_branch' => 'Sucursal anterior',
    'new_branch' => 'Nueva sucursal',
    'old_department' => 'Departamento anterior',
    'new_department' => 'Nuevo departamento',

    /** theme color */
    'theme_color'=>'Color del tema',
    'background_color'=>'Color de fondo',
    'primary_color'=>'Color primario',
    'hover_color'=>'Color de desplazamiento',
    'dark_primary_color'=>'Color primario oscuro',
    'dark_hover_color'=>'Color de desplazamiento oscuro',

    /** Admin Management */
    'users'=>'Usuarios',
    'user_section'=>'Sección de usuario',
    'add_user'=>'Agregar usuario',
    'user_management'=>'Gestión de usuarios',
    'user'=>'Usuario',

    'office_time_not_found'=>'Horario de oficina no encontrado',
    'asset_type_not_found'=>'Tipo de activo no encontrado',
    'employee_not_found'=>'Empleados no encontrados',
    'error_loading_asset_types'=>'Error al cargar tipos de activos',
    'error_loading_employees'=>'Error al cargar empleados',
    'error_loading_termination_types'=>'Error al cargar tipos de terminación',
    'error_loading_department'=>'Error al cargar departamentos',
    'leave_type_not_found'=>'Tipo de licencia no encontrado',
    'error_loading_leave_types'=>'Error al cargar tipos de licencias',
    'no_department_found'=>'Departamento no encontrado',
    'award_filter'=>'Filtro de premios',
    'select_award'=>'Seleccionar premio',
    'award_type_not_found'=>'Tipo de premio no encontrado',
    'termination_filter'=>'Filtro de terminación',
    'training_type_filter'=>'Filtro de tipo de capacitación',
    'asset_type_filter'=>'Filtro de tipo de activo',
    'award_type_filter'=>'Filtro de tipo de premio',
    'termination_type_filter'=>'Filtro de tipo de terminación',
    'resignation_filter'=>'Filtro de renuncia',
    'promotion_filter'=>'Filtro de promoción',
    'complaint_filter'=>'Filtro de queja',
    'warning_filter'=>'Filtro de advertencia',
    'transfer_filter'=>'Filtro de transferencia',
    'trainer_filter'=>'Filtro de entrenador',
    'office_time_filter'=>'Filtro de horario de oficina',
    'leave_type_filter'=>'Filtro de tipo de licencia',
    'client_filter'=>'Filtro de cliente',
    'router_filter'=>'Filtro de enrutador',
    'project_not_found'=>'Proyecto no encontrado',
    'error_loading_training_types'=>'Error al cargar tipos de capacitación',
    'post_filter'=>'Filtro de publicaciones',
    'event_filter'=>'Filtro de eventos',
    'training_filter'=>'Filtro de entrenamiento',
    'post_lists'=>'Listas de publicaciones',
    'tada_lists'=>'Listas Tada',
    'advance_salary_filter'=>'Filtro de salario anticipado',
    'log_filter'=>'Filtro de registro de asistencia',
    'advance_salary_lists'=>'Listas de salario anticipado',
    'logout_request_filter'=>'Filtro de solicitud de cierre de sesión',
    'leave_approval_filter'=>'Filtro de aprobación de permisos',
    'user_list'=>'Lista de usuarios',
    'projects_not_found'=>'Proyectos no encontrados',
    'attendance_logs'=>'Registros de asistencia',
    'attendance_type'=>'Tipo de asistencia',
    'identifier'=>'Identificador',
    'nfc_lists'=>'Listas NFC',
    'qr_lists'=>'Listas QR',
    'qr_filter'=>'Filtro QR',
    'nfc_filter'=>'Filtro NFC',
    'select_notice_receiver'=>'Seleccionar receptor de notificación',
    'generated_salary_lists'=>'Listas de salarios generados',
    'employee_salaries'=>'Salarios de empleados',
    'select_meeting_participants'=>'Seleccionar participantes de la reunión',
    'employee_filter'=>'Filtro de empleados',
    'attendance_filter'=>'Filtro de asistencia',
    'notice_filter'=>'Filtro de notificaciones',
    'award_type_lists'=>'Listas de tipos de premios',
    'termination_type_lists'=>'Listas de tipos de terminación',
    'holiday_lists'=>'Listas de días festivos',
    'asset_lists'=>'Listas de activos',
    'router_lists'=>'Listas de routers',
    'meeting_list'=>'Listas de reuniones',
    'app_qr'=>'QR de la aplicación',
    'digital_hr_dashboard'=>'Tablero digital de RRHH',
    'training_type_list'=>'Lista de tipos de entrenamiento',
    'time_leave_list'=>'Listas de solicitudes de permiso de tiempo',
    'support_list'=>'Listas de soporte',
    'role_list'=>'Listas de roles',
    'asset_type_list'=>'Listas de tipos de activos',
    'add_undertime'=>'Agregar tiempo insuficiente',
    'threshold_time'=>'Tiempo umbral',
    'ssf_rule'=>'Regla SSF',
    'upload_warning'=>'Por favor, suba al menos un documento cuando el estado sea aprobado',

    'check_in_latitude'=>'Latitud de entrada',
    'check_in_longitude'=>'Longitud de entrada',
    'check_out_latitude'=>'Latitud de salida',
    'check_out_longitude'=>'Longitud de salida',
];
