<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Authentication Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines are used during authentication for various
    | messages that we need to display to the user. You are free to modify
    | these language lines according to your application's requirements.
    |
    */

    /** dashboard */
    'welcome' => 'Bem-vindo ao Painel de Presença',
    'total_employees' => 'Total de Funcionários',
    'total_departments' => 'Total de Departamentos',
    'total_holidays' => 'Total de Feriados',
    'paid_leaves' => 'Licenças Remuneradas',
    'on_leave_today' => 'De licença hoje',
    'pending_leave_requests' => 'Solicitações de licença pendentes',
    'total_check_in_today' => 'Total de Entradas Hoje',
    'total_check_out_today' => 'Total de Saídas Hoje',
    'projects_detail' => 'Detalhes dos Projetos',
    'total_projects' => 'Total de Projetos',
    'pending_projects' => 'Projetos Pendentes',
    'on_hold_projects' => 'Projetos em Espera',
    'in_progress_projects' => 'Projetos em Andamento',
    'finished_projects' => 'Projetos Concluídos',
    'cancelled_projects' => 'Projetos Cancelados',
    'top_clients' => 'Principais Clientes',
    'task_details' => 'Detalhes da Tarefa',
    'recent_projects' => 'Projetos Recentes',
    'title' => 'Título',
    'date_start' => 'Data de Início',
    'deadline' => 'Prazo',
    'leader' => 'Líder',
    'completion' => 'Conclusão',
    'priority' => 'Prioridade',
    'check_in_at' => 'Check-in às',
    'check_out_at' => 'Check-out às',
    'punch_in' => 'Registrar Entrada',
    'punch_out' => 'Registrar Saída',
    'no_records_found' => 'Nenhum registro encontrado!',
    'project_management' => 'Gerenciamento de Projetos',
    'view_all_clients' => 'Ver Todos os Clientes',
    'view_all_projects' => 'Ver Todos os Projetos',
    'error_message' => 'Erro: Não foi possível processar a solicitação.',
    'success_message' => 'Sucesso: Ação concluída com sucesso.',
    'name' => 'Nome',
    'email' => 'Email',
    'contact' => 'Contato',
    'project' => 'Projeto',
    'pending' => 'Pendente',
    'on_hold' => 'Em espera',
    'in_progress' => 'Em progresso',
    'completed' => 'Concluído',
    'cancelled' => 'Cancelado',
    'search_menu' => 'Menu de pesquisa',

    /** nav */
    'latest_notifications' => 'Últimas Notificações',
    'view_all' => 'Ver tudo',
    'profile' => 'Perfil',
    'edit_profile' => 'Editar Perfil',
    'request_leave' => 'Solicitar Licença',
    'log_out' => 'Sair',
    'light_mode' => 'Modo Claro',
    'dark_mode' => 'Modo Escuro',

    /** menu */
    'dashboard' => 'Painel de Controle',
    'company_management' => 'Gestão da Empresa',
    'company' => 'Empresa',
    'branch' => 'Filial',
    'department' => 'Departamento',
    'post' => 'Cargo',
    'employee_management' => 'Gestão de Funcionários',
    'employees' => 'Funcionários',
    'logout_requests' => 'Pedidos de Logout',
    'attendance_section' => 'Seção de Presença',
    'clients' => 'Clientes',
    'task_management' => 'Gestão de Tarefas',
    'holidays' => 'Feriados',
    'notice' => 'Aviso',
    'payroll_management' => 'Gestão de Folha de Pagamento',
    'payroll' => 'Folha de Pagamento',
    'payroll_setting' => 'Configuração da Folha de Pagamento',
    'advance_salary' => 'Salário Antecipado',
    'employee_salary' => 'Salário do Funcionário',
    'leave' => 'Licença',
    'team_meeting' => 'Reunião de Equipe',
    'tada' => 'Tada',
    'shift_management' => 'Gestão de Turnos',
    'office_time' => 'Horário de Escritório',
    'award_management' => 'Gestão de Prêmios',
    'award_types' => 'Tipos de Prêmios',
    'awards' => 'Prêmios',
    'asset_management' => 'Gestão de Ativos',
    'asset_types' => 'Tipos de Ativos',
    'assets' => 'Ativos',
    'content_management' => 'Gestão de Conteúdo',
    'support' => 'Suporte',
    'attendance_methods' => 'Métodos de Presença',
    'routers' => 'Roteadores',
    'qr' => 'QR',
    'nfc' => 'NFC',
    'settings' => 'Configurações',
    'roles_permissions' => 'Funções e Permissões',
    'general_settings' => 'Configurações Gerais',
    'app_settings' => 'Configurações do Aplicativo',
    'notifications' => 'Notificações',
    'payment_currency' => 'Moeda de Pagamento',
    'feature_control' => 'Controle de Recursos',
    'salary_component' => 'Componente Salarial',
    'salary_group' => 'Grupo Salarial',
    'salary_tds' => 'Imposto sobre Salário',
    'overtime' => 'Hora Extra',
    'undertime' => 'Subtempo',
    'payment_method' => 'Método de Pagamento',
    'leave_types' => 'Tipos de Licença',
    'leave_request' => 'Pedido de Licença',
    'time_leave_request' => 'Pedido de Licença por Tempo',

    /** company */
    'company_profile' => 'Perfil da empresa',
    'update_company' => 'Atualizar empresa',
    'create_company' => 'Criar empresa',
    'company_name' => 'Nome da empresa',
    'company_owner' => 'Proprietário da empresa',
    'address' => 'Endereço',
    'email_address' => 'Endereço de e-mail',
    'phone_no' => 'Número de telefone',
    'website_url' => 'URL do site',
    'check_office_off_days' => 'Verificar dias de folga do escritório',
    'upload_logo' => 'Enviar logotipo',
    'update' => 'Atualizar',
    'save' => 'Salvar',

    /** Branch */
    'title_branch' => 'Filial',
    'branch_section' => 'Seção de filiais',
    'branches' => 'Filiais',
    'add_branch' => 'Adicionar filial',
    'branch_lists' => 'Listas de filiais',
    'search_by_branch_name' => 'Pesquisar por nome da filial',
    'filter' => 'Filtro',
    'reset' => 'Redefinir',
    'phone' => 'Telefone',
    'total_employee' => 'Total de funcionários',
    'action' => 'Ação',
    'are_you_sure_change_status' => 'Tem certeza de que deseja alterar o status?',
    'are_you_sure_delete_branch' => 'Tem certeza de que deseja excluir a filial?',
    'branch_create' => 'Criar filial',
    'branch_update' => 'Atualizar filial',
    'branch_name' => 'Nome da filial',
    'required_field' => 'Campo obrigatório',
    'branch_head' => 'Chefe da filial',
    'select_branch_head' => 'Selecione o chefe da filial',
    'phone_number' => 'Número de telefone',
    'branch_location_latitude' => 'Latitude da localização da filial',
    'enter_branch_location_latitude' => 'Digite a latitude da localização da filial',
    'branch_location_longitude' => 'Longitude da localização da filial',
    'enter_branch_location_longitude' => 'Digite a longitude da localização da filial',
    'status' => 'Status',
    'select_status' => 'Selecione o status',
    'active' => 'Ativo',
    'inactive' => 'Inativo',
    'create' => 'Criar',

    /** Department */
    'department_section' => 'Seção de departamentos',
    'departments' => 'Departamentos',
    'add_department' => 'Adicionar departamento',
    'department_lists' => 'Listas de departamentos',
    'search_by_department_name' => 'Pesquisar por nome do departamento',
    'select_branch' => 'Selecionar filial',
    'edit' => 'Editar',
    'delete' => 'Excluir',
    'are_you_sure_delete_department' => 'Tem certeza de que deseja excluir o departamento?',
    'edit_department' => 'Editar departamento',
    'button_back' => 'Voltar',
    'breadcrumb' => 'Trilha de navegação',
    'update_department' => 'Atualizar departamento',
    'create_department' => 'Criar departamento',
    'department_name' => 'Nome do departamento',
    'department_head' => 'Chefe do departamento',
    'select_department_head' => 'Selecione o chefe do departamento',
    'create_update_department' => 'Criar/Atualizar departamento',

    /** Post */
    'post_section' => 'Seção de cargos',
    'posts' => 'Cargos',
    'add_post' => 'Adicionar cargo',
    'search_by_department' => 'Pesquisar por departamento',
    'search_by_post_name' => 'Pesquisar por nome do cargo',
    'post_name' => 'Nome do cargo',
    'post_empty' => 'Cargo vazio',
    'edit_post_title' => 'Editar cargo',
    'create_post_title' => 'Criar cargo',
    'department_label' => 'Departamento',
    'post_name_label' => 'Nome do cargo',
    'status_label' => 'Status',
    'select_department' => 'Selecionar departamento',
    'active_option' => 'Ativo',
    'inactive_option' => 'Inativo',
    'update_update_button' => 'Atualizar cargo',
    'change_status_confirmation' => 'Tem certeza de que deseja alterar o status?',
    'delete_post_confirmation' => 'Tem certeza de que deseja excluir o cargo?',
    'employee_list_title' => 'Lista de funcionários',

    /** Employee List */
    'employees_title' => 'Funcionários',
    'employees_action' => 'Listas',
    'add_employee' => 'Adicionar funcionário',
    'employee_section' => 'Seção de funcionários',
    'employee_create' => 'Criar funcionário',
    'employee_name' => 'Nome do funcionário',
    'employee_email' => 'E-mail do funcionário',
    'employee_phone' => 'Telefone do funcionário',
    'full_name' => 'Nome completo',
    'designation' => 'Designação',
    'role' => 'Função',
    'shift' => 'Turno',
    'workplace' => 'Local de trabalho',
    'is_active' => 'Ativo',
    'edit_detail' => 'Editar detalhes',
    'delete_user' => 'Excluir usuário',
    'change_password' => 'Alterar senha',
    'force_logout' => 'Forçar logout',
    'all_fields_required' => 'Todos os campos marcados com (<span style="color: red">*</span>) são obrigatórios',
    'personal_detail' => 'Detalhes pessoais',
    'employee_code' => 'Código do funcionário',
    'enter_name' => 'Digite o nome',
    'enter_employee_address' => 'Digite o endereço do funcionário',
    'enter_email' => 'Digite o e-mail',
    'dob' => 'Data de nascimento',
    'gender' => 'Gênero',
    'select_gender' => 'Selecione o gênero',
    'marital_status' => 'Estado civil',
    'choose_marital_status' => 'Escolha o estado civil',
    'upload_avatar' => 'Enviar avatar',
    'description' => 'Descrição',
    'username' => 'Nome de usuário',
    'enter_username' => 'Digite o nome de usuário',
    'password' => 'Senha',
    'enter_password' => 'Digite a senha',
    'select_role' => 'Selecione a função',
    'company_detail' => 'Detalhes da empresa',
    'supervisor' => 'Supervisor',
    'employment_type' => 'Tipo de emprego',
    'select_employment_type' => 'Selecione o tipo de emprego',
    'joining_date' => 'Data de admissão',
    'enter_joining_date' => 'Digite a data de admissão',
    'workspace' => 'Espaço de trabalho',
    'select_workspace' => 'Selecione o espaço de trabalho',
    'field' => 'Campo',
    'office' => 'Escritório',
    'leave_detail' => 'Detalhes do afastamento',
    'leave_allocated' => 'Afastamento alocado',
    'assigned_leaves' => 'Afastamentos atribuídos',
    'no_of_days' => 'Número de dias',
    'total_leave_days' => 'Total de dias de afastamento',
    'bank_detail' => 'Detalhes bancários',
    'bank_name' => 'Nome do banco',
    'bank_account_number' => 'Número da conta bancária',
    'account_holder_name' => 'Nome do titular da conta',
    'bank_account_type' => 'Tipo de conta bancária',
    'select_account_type' => 'Selecione o tipo de conta',
    'create_user' => 'Criar usuário',
    'update_user' => 'Atualizar usuário',
    'new_password' => 'Nova senha',
    'enter_new_password' => 'Digite a nova senha',
    'confirm_password' => 'Confirmar senha',
    'confirm_password_placeholder' => 'Confirmar senha',
    'submit' => 'Enviar',
    'user_change_password' => 'Alterar senha do usuário',
    'confirm_delete_employee' => 'Tem certeza de que deseja excluir o funcionário?',
    'confirm_force_logout' => 'Tem certeza de que deseja forçar o logout?',
    'confirm_change_workplace' => 'Tem certeza de que deseja alterar o local de trabalho?',
    'select_supervisor' => 'Selecionar supervisor',
    'select_office_time' => 'Selecionar horário do escritório',
    'select_option' => 'Selecionar opção',
    'not_available' => 'Não disponível',

    /** logout requests */
    'logout_request_status' => 'Status do pedido de logout',
    'take_action' => 'Tomar ação',
    'confirm_accept_logout_request' => 'Tem certeza de que deseja aceitar o pedido de logout?',

    /** attendance */
    'attendance' => 'Frequência',
    'employee_attendance_lists' => 'Listas de frequência dos funcionários',
    'attendance_of_the_day' => 'Frequência do dia',
    'date_placeholder_bs' => 'Ano/Mês/Dia',
    'csv_export' => 'Exportar CSV',
    'attendance_status' => 'Status de frequência',
    'attendance_by' => 'Frequência por',
    'show_detail' => 'Mostrar detalhes',
    'show_checkin_location' => 'Mostrar localização de check-in',
    'show_checkout_location' => 'Mostrar localização de check-out',
    'checkin' => 'Check-in',
    'checkout' => 'Check-out',
    'approved' => 'Aprovado',
    'rejected' => 'Rejeitado',
    'self' => 'Próprio',
    'admin' => 'Admin',
    'edit_attendance_time' => 'Editar hora de frequência',
    'employee_attendance_detail' => 'Detalhes de frequência do funcionário',
    'attendance_of' => 'Frequência de',
    'total_days_in_month' => 'Total de dias no mês',
    'present_days' => 'Dias presentes',
    'absent_days' => 'Dias ausentes',
    'weekend_days' => 'Dias de fim de semana',
    'holiday_days' => 'Dias de feriado',
    'leave_days' => 'Dias de afastamento',
    'working_hours' => 'Horas de trabalho',
    'worked_hours' => 'Horas trabalhadas',
    'attendance_details_of' => 'Detalhes de presença de :month',
    'all_month' => 'Todo mês',
    'worked_hour' => 'Hora trabalhada',
    'add_attendance_time' => 'Adicionar hora de frequência',
    'confirm_change_attendance_status' => 'Tem certeza de que deseja alterar o status de frequência?',
    'check_in' => 'Check-in',
    'check_out' => 'Check-out',
    'attendance_title' => 'Frequência',
    'attendance_action' => 'Detalhe de frequência do funcionário',
    'filter_placeholder' => 'Ano de frequência, ex: :min_year',
    'filter_button' => 'Filtrar',
    'csv_export_button' => 'Exportar CSV',
    'reset_button' => 'Redefinir',
    'total_days' => 'Total de dias no mês',
    'attendance_details' => 'Detalhes de frequência de :monthName',
    'date' => 'Data',
    'change_attendance_status' => 'Alterar status de frequência',
    'create_attendance' => 'Criar frequência',
    'admin_remark' => 'Observação do administrador',
    'edit_attendance' => 'Editar frequência',
    'admin_edit_remark' => 'Observação do administrador editada',
    'confirm_check_in' => 'Tem certeza de que deseja fazer o check-in do funcionário?',
    'confirm_check_out' => 'Tem certeza de que deseja fazer o check-out do funcionário?',
    'edit_attendance_title' => 'Editar hora de frequência (:name) em :date',
    'create_attendance_title' => 'Criar hora de frequência (:name) em :date',
    'total_worked_hours' => 'Total de horas trabalhadas',
    'attendance_report' => 'Relatório de frequência',

    /** clients */
    'client_listing' => 'Listagem de clientes',
    'add_client' => 'Adicionar cliente',
    'client_name' => 'Nome do cliente',
    'client_email' => 'Email do cliente',
    'edit_client_detail' => 'Editar detalhes do cliente',
    'show_client_detail' => 'Mostrar detalhes do cliente',
    'delete_client_detail' => 'Excluir detalhes do cliente',
    'client_invoices' => 'Faturas do cliente',
    'client_detail' => 'Detalhe do cliente:',
    'client_project_lists' => 'Listas de projetos do cliente:',
    'country' => 'País',
    'edit_client' => 'Editar cliente',
    'create_client' => 'Criar cliente',
    'client_section' => 'Seção de clientes',
    'client_contact' => 'Contato do cliente',
    'client_address' => 'Endereço',
    'client_country' => 'País',
    'upload_profile' => 'Carregar perfil do cliente',
    'enter_client_name' => 'Inserir nome do cliente',
    'enter_client_email' => 'Inserir email do cliente',
    'enter_contact_number' => 'Inserir número de contato',
    'enter_client_address' => 'Inserir endereço do cliente',
    'enter_country' => 'Inserir país',
    'confirm_status_change' => 'Tem certeza que deseja alterar o status?',
    'confirm_delete_client' => 'Tem certeza que deseja excluir os detalhes do cliente?',


    /** Project management */
    'lists' => 'Listas',
    'create_project' => 'Criar Projeto',
    'project_filter' => 'Filtro de Projeto',
    'search_by_project' => 'Buscar por Projeto',
    'search_by_status' => 'Buscar por Status',
    'search_by_priority' => 'Buscar por Prioridade',
    'client' => 'Cliente',
    'all_tasks' => 'Todas as Tarefas',
    'completed_tasks' => 'Tarefas Concluídas',
    'days_left' => 'dias restantes',
    'team_member' => 'Membro da Equipe',
    'start_date' => 'Data de Início',
    'due_date' => 'Data de Vencimento',
    'view' => 'Ver',
    'projects' => 'Projetos',
    'assign_employee' => 'Atribuir Funcionário',
    'client_contact_number' => 'Número de Contato do Cliente',
    'upload_client_profile' => 'Enviar Perfil do Cliente',
    'project_name' => 'Nome do Projeto',
    'project_start_date' => 'Data de Início do Projeto',
    'project_deadline' => 'Prazo do Projeto',
    'project_status' => 'Status do Projeto',
    'select_project_status' => 'Selecionar Status do Projeto',
    'project_cost' => 'Custo do Projeto',
    'select_priority' => 'Selecionar Prioridade',
    'estimated_hours' => 'Horas Estimadas',
    'select_client' => 'Selecionar Cliente',
    'upload_project_logo' => 'Enviar Logotipo do Projeto',
    'uploaded_files_images' => 'Arquivos e Imagens Enviados',
    'no_project_file_uploaded' => 'Nenhum arquivo do projeto enviado',
    'update_project' => 'Atualizar Projeto',
    'project_leader' => 'Líder do Projeto',
    'assign_member' => 'Atribuir Membro',
    'edit_project' => 'Editar Projeto',
    'project_document' => 'Documento do Projeto',
    'upload_documents' => 'Enviar Documentos',
    'upload_project_attachments' => 'Enviar Anexos do Projeto',
    'show_project_detail' => 'Mostrar Detalhe do Projeto',
    'upload_attachments' => 'Enviar Anexos',
    'project_attachments' => 'Anexos do Projeto',
    'uploaded_image_files' => 'Arquivos de Imagem Enviados',
    'no_project_image_found' => 'Nenhuma imagem do projeto encontrada',
    'uploaded_files' => 'Arquivos Enviados',
    'no_project_files_found' => 'Nenhum arquivo do projeto encontrado',
    'project_tasks_lists' => 'Listas de Tarefas do Projeto',
    'project_summary' => 'Resumo do Projeto',
    'cost' => 'Custo:',
    'total_hours' => 'Total de Horas:',
    'created' => 'Criado:',
    'remaining_days' => 'Dias Restantes:',
    'project_leaders' => 'Líderes do Projeto',
    'update_leader' => 'Atualizar Líder',
    'project_members' => 'Membros do Projeto',
    'update_member' => 'Atualizar Membro',
    'project_client_detail' => 'Detalhe do Cliente do Projeto',
    'delete_project_detail' => 'Tem certeza de que deseja excluir o Detalhe do Projeto?',
    'delete_project_document' => 'Tem certeza de que deseja excluir o Documento do Projeto?',
    'search_by_member' => 'Buscar por membro',
    'add_employee_to_project' => 'Adicionar funcionário ao projeto',

    /** Task management */
    'tasks' => 'Tarefas',
    'task_filter' => 'Filtro de Tarefas',
    'search_by_task_name' => 'Buscar por Nome da Tarefa',
    'not_started' => 'Não Iniciado',
    'create_tasks' => 'Criar Tarefas',
    'end_date' => 'Data de Término',
    'task_name' => 'Nome da Tarefa',
    'enter_task_name' => 'Digite o Nome da Tarefa',
    'select_project' => 'Selecionar Projeto',
    'task_start_date' => 'Data de Início da Tarefa',
    'task_start_time' => 'Hora de Início da Tarefa',
    'task_end_date' => 'Data de Término da Tarefa',
    'task_end_time' => 'Hora de Término da Tarefa',
    'task_status' => 'Status da Tarefa',
    'select_task_status' => 'Selecionar Status da Tarefa',
    'uploaded_files_and_images' => 'Arquivos e Imagens Enviados',
    'task_attachments' => 'Anexos da Tarefa',
    'update_task' => 'Atualizar Tarefa',
    'create_task' => 'Criar Tarefa',
    'mention' => 'Mencionar',
    'comment' => 'Comentário',
    'close' => 'Fechar',
    'write_comment' => 'Escrever um Comentário',
    'reply' => 'Responder',
    'delete_confirm' => 'Tem certeza de que deseja excluir ":title"?',
    'task_member_placeholder' => 'Atribuir membro à tarefa',
    'project_placeholder' => 'Selecionar Projeto',
    'project_filter_placeholder' => 'Buscar por projeto',
    'task_name_placeholder' => 'Buscar por Nome da Tarefa',
    'change_task_status_confirm' => 'Tem certeza de que deseja mudar o status da tarefa?',
    'change_status_confirm' => 'Tem certeza de que deseja mudar o status?',
    'delete_task_detail_confirm' => 'Tem certeza de que deseja excluir detalhes da tarefa?',
    'create_checklist_text' => 'Criar Checklist',
    'close_checklist_text' => 'Fechar',
    'remove_checklist_text' => 'Remover',
    'remove_checklist_title' => 'Remover checklist',
    'view_all_comments' => 'Ver Todos os Comentários',
    'comments' => 'Comentários',
    'edit_task' => 'Editar Tarefa',
    'edit_task_detail' => 'Editar Detalhes da Tarefa',
    'show_task_detail' => 'Mostrar Detalhes da Tarefa',
    'task_edit' => 'Editar Tarefa',
    'create_checklist' => 'Criar Checklist',
    'upload_attachment' => 'Enviar Anexo',
    'total_checklist' => 'Total de Checklists',
    'completed_checklist' => 'Checklists Completos',
    'task_checklist_lists' => 'Listas de Checklists de Tarefas',
    'assigned_to' => 'Atribuído a',
    'create_task_checklist' => 'Criar Checklist de Tarefa',
    'enter_checklist_title' => 'Digite o Título da Checklist',
    'select_member' => 'Selecionar Membro',
    'add_more_checklist' => 'Adicionar Mais Checklists',
    'image' => 'Imagem',
    'file' => 'Arquivo',
    'edit_checklist' => 'Editar Checklist',
    'delete_checklist' => 'Excluir Checklist',
    'checklist' => 'Checklist',
    'edit_task_checklist' => 'Editar Checklist de Tarefa',
    'checklist_name' => 'Nome da Checklist',
    'assign_task_checklist' => 'Atribuir Checklist de Tarefa',
    'task_summary' => 'Resumo da Tarefa',
    'task_members' => 'Membros da Tarefa',
    'task_attachment_title' => 'Anexo da Tarefa',
    'upload_attachment_action' => 'Enviar Anexo',
    'upload_task_attachments' => 'Enviar Anexos da Tarefa',
    'upload_task_attachments_text' => 'Enviar Anexos da Tarefa',
    'choose_file_text' => 'Escolher arquivo',

    /** Holiday */
    'holiday_section' => 'Seção de Feriado',
    'event' => 'Evento',
    'event_date' => 'Data do Evento',
    'is_public_holiday' => 'É Feriado Público?',
    'confirm_delete_holiday' => 'Tem certeza de que deseja excluir os detalhes do feriado?',
    'holiday_detail_title' => 'Detalhes do Feriado',
    'holiday' => 'Feriado',
    'csv_import' => 'Importar CSV',
    'import' => 'Importar',
    'holiday_detail_csv' => 'Detalhes do Feriado em CSV',
    'holiday_csv_example' => 'Exemplo de CSV de Feriado',
    'add_holiday' => 'Adicionar Feriado',
    'import_holiday_csv' => 'Importar CSV de Feriado',
    'holiday_filter' => 'Filtro de Feriado',
    'event_name' => 'Nome do Evento',
    'leave_requested_year' => 'Ano Solicitado de Licença',
    'holiday_detail' => 'Detalhe do Feriado',

    /** notice */
    'notices_section' => 'Seção de Avisos',
    'notice_title' => 'Título do Aviso',
    'notice_description' => 'Descrição do Aviso',
    'notice_receiver' => 'Destinatário do Aviso',
    'send_notice' => 'Enviar Aviso',
    'all_employees' => 'Todos os Funcionários',
    'create_notice' => 'Criar Aviso',
    'edit_notice' => 'Editar Aviso',
    'notices' => 'Avisos',
    'receiver' => 'Destinatário',
    'published_from' => 'Publicado De',
    'publish_to' => 'Publicar Até',
    'publish_date' => 'Data de Publicação',
    'show_notice_content' => 'Mostrar Conteúdo do Aviso',
    'delete_notice_detail' => 'Excluir Detalhe do Aviso',
    'notice_lists' => 'Listas de Avisos',
    'confirm_change_notice_status' => 'Tem certeza de que deseja alterar o status do Aviso?',
    'confirm_delete_notice' => 'Tem certeza de que deseja excluir o Aviso?',
    'confirm_send_notice' => 'Tem certeza de que deseja enviar o Aviso?',
    'notice_detail_modal_title' => 'Detalhe do Aviso :title',


    /** payroll */
    'employee_payroll'=>'Folha de Pagamento do Funcionário',
    'payroll_generate'=>'Gerar Folha de Pagamento',
    'payroll_create'=>'Criar Folha de Pagamento',
    'payroll_edit'=>'Editar Folha de Pagamento',
    'select_year' => 'Selecionar Ano',
    'salary_cycle' => 'Ciclo de Salário',
    'salary_month' => 'Mês de Salário',
    'salary_week' => 'Semana de Salário',
    'select_week' => 'Selecionar Semana',
    'include_tada' => 'Incluir TADA',
    'include_advance_salary' => 'Incluir Salário Antecipado',
    'use_attendance' => 'Usar Frequência',
    'generate' => 'Gerar',
    'clear' => 'Limpar',
    'report' => 'Relatório:',
    'duration' => 'Duração',
    'payroll_summary' => 'Resumo da Folha de Pagamento',
    'total_basic_salary' => 'Salário Básico Total:',
    'total_net_salary' => 'Salário Líquido Total:',
    'total_allowance' => 'Total de Subsídios:',
    'total_deduction' => 'Total de Deduções:',
    'total_overtime' => 'Total de Horas Extras:',
    'total_undertime' => 'Total de Horas Incompletas:',
    'paid_by'=>'Pago por',
    'net_salary'=>'Salário Líquido',
    'paid_on'=>'Pago em',
    'pay_button' => 'Pagar',
    'select_payment_method.'=>'Por favor, selecione um método de pagamento.',
    'confirm_delete_payroll'=>'Tem certeza de que deseja excluir a folha de pagamento do funcionário?',
    'confirm_generate_payroll'=>'Tem certeza de que deseja gerar a folha de pagamento?',
    'confirm_change_cycle'=>'Tem certeza de que deseja alterar o ciclo de salário?',
    'payment_title' => 'Realizar Pagamento',
    'payment_method_placeholder' => 'Selecionar Método de Pagamento',
    'payment_date' => 'Data de Pagamento',
    'hourly_rate' => 'Taxa Horária',
    'hourly' => 'Horário',
    'working_hours_in_week' => 'Horas de Trabalho na Semana',
    'annual_salary' => 'Salário Anual (CTC)',
    'annual' => 'Anual',
    'basic_salary' => 'Salário Básico',
    'fixed_allowance' => 'Subsídio Fixo',
    'total' => 'Total',
    'net_total' => 'Total Líquido',
    'earnings' => 'Rendimentos',
    'deductions' => 'Deduções',
    'create_salary'=>'Criar Salário',
    'edit_salary'=>'Editar Salário',
    'add_salary'=>'Adicionar Salário',
    'calculation_type'=>'Tipo de Cálculo',
    'monthly_amount'=>'Valor Mensal',
    'annual_amount'=>'Valor Anual',
    'salary_slip' => 'Holerite',
    'edit_salary_slip' => 'Editar Holerite',
    'payslip' => 'Holerite',
    'for_the_month_of' => 'para o mês de',
    'from'=>'de',
    'to'=>'para',
    'employee_id'=>'ID do Funcionário',
    'earning' => 'Rendimento',
    'deduction' => 'Dedução',
    'actual_salary' => 'Salário Real',
    'total_earning'=>'Rendimento Total',
    'actual_salary_formula' => '(Rendimento Total - Deduções Totais)',
    'bonus' => 'Bônus',
    'taxable_salary' => 'Salário Tributável',
    'taxable_salary_formula' => '(Salário Real + Bônus)',
    'tax' => 'Imposto',
    'salary_after_tax' => 'Salário Após Imposto',
    'expenses_claim' => 'Reivindicações de Despesas (TADA)',
    'absent' => 'Ausente',
    'absent_deduction_formula' => '((salário bruto / total de dias) * dias ausentes)',
    'net_salary_formula' => 'Salário Líquido = (Salário Real - Salário Antecipado + TADA)',
    'monthly' => 'mensal',
    'weekly' => 'semanal',
    'salary_increment' => 'Aumento de Salário',
    'increment' => 'Incremento',
    'current_salary' => 'Salário Atual',
    'annual_increment_percent' => 'Aumento Anual %',
    'annual_increment_amount' => 'Valor de Aumento Anual',
    'revised_salary_label' => 'Salário Revisado',
    'fiscal_year_label' => 'Aumento para o Ano Fiscal',
    'applicable_from_label' => 'Aplicável a partir de (Data)',
    'applicable_to_label' => 'Aplicável até (Data)',
    'remark' => 'Observação',
    'fiscal_year' => 'Ano Fiscal',
    'select_fiscal_year' => 'Selecionar Ano Fiscal',
    'list'=>'Lista',
    'employee_salary_filter'=>'Filtro de Salário de Funcionário',
    'salary_review_history'=>'Histórico de Revisão Salarial',
    'increase_salary'=>'Aumentar Salário',
    'all'=>'Todos',
    'employee_payslip'=>'Holerite do Funcionário',
    'salary_from'=>'Salário de',
    'salary_to'=>'Salário para',
    'unpaid_leave'=>'Licença Não Remunerada',
    'paid_leave'=>'Licença Remunerada',
    'employee_gross_salary'=>'Salário Bruto do Funcionário',
    'salary_increment_log'=>'Registro de Aumento de Salário',
    'log'=>'Registro',
    'salary_revised_on'=>'Salário Revisado em',
    'increment_by'=>'Aumento por',
    'increment_value'=>'Valor do Aumento',
    'old_salary'=>'Salário Antigo',
    'new_salary'=>'Novo Salário',
    'date_to'=>'Data para',
    'date_from'=>'Data de',
    'salary_increment_remark'=>'Observação sobre o Aumento de Salário',
    'advance_salary_requests'=>'Solicitações de Salário Antecipado',
    'advance_salary_request_filter'=>'Filtro de Solicitações de Salário Antecipado',
    'delete_confirmation'=>'Tem certeza de que deseja excluir?',
    'payslip_for_the_month_of'=>'Holerite para o Mês de',
    'absent_deduction'=>'Dedução por Ausência',

    /** Advance Salary */
    'is_paid' => 'Está Pago?',
    'released_on' => 'Liberado Em',
    'requested_on' => 'Solicitado Em',
    'released_amount' => 'Valor Liberado',
    'requested_amount' => 'Valor Solicitado',
    'search_by_month' => 'Pesquisar por Mês',
    'search_by_employee_name' => 'Pesquisar por Nome do Funcionário',
    'advance_salary_detail' => 'Detalhe do Salário Antecipado',
    'is_settled' => 'Está Liquidado',
    'verified_by' => 'Verificado Por',
    'amount_released_date' => 'Data de Liberação do Valor',
    'advance_requested_date' => 'Data de Solicitação do Antecipado',
    'total_released_amount' => 'Valor Total Liberado',
    'total_request_amount' => 'Valor Total Solicitado',
    'employee' => 'Funcionário',
    'select_employee' => 'Selecionar Funcionário',
    'advance_salary_request_detail' => 'Detalhe da Solicitação de Salário Antecipado',
    'proof_of_advance_salary_payment' => 'Comprovante de Pagamento de Salário Antecipado',
    'attachments' => 'Anexos',
    'processing' => 'Processando',

    /** Tax report */
    'tax_report' => 'Relatório Fiscal',
    'employee_tax_report' => 'Relatório Fiscal do Funcionário',
    'tax_report_edit' => 'Editar Relatório Fiscal',
    'tax_report_detail_of' => 'Detalhes do Relatório Fiscal de',
    'tax_report_detail' => 'Detalhes do Relatório Fiscal',
    'salary_sheet' => 'Folha de Pagamento',
    'particular' => 'Particular',
    'income' => 'Rendimento',
    'tax_data_not_available' => 'Dados fiscais não disponíveis para o estado civil atual',
    'remain_tds_formula' => '(Total de TDS Devido / Número de meses restantes)',
    'remaining_month' => 'Mês Restante',
    'tds_calculation_msg' => 'Cálculo de TDS para o Mês Atual (Mês de Cálculo)',
    'total_due_tds' => 'Total de TDS Devido',
    'total_paid_tds' => 'Total de TDS Pago',
    'total_payable_tds' => 'Total de TDS a Pagar',
    'other_discount' => 'Outro Desconto',
    'female_discount' => 'Desconto para Mulheres',
    'medical_claim' => 'Reclamação Médica',
    'less' => 'menos',
    'less_tax_deduction' => 'menos: Dedução Fiscal',
    'tax_amount' => 'Valor do Imposto',
    'percent' => 'Percentual',
    'tax_calculation_on_taxable_income' => 'Cálculo do Imposto sobre a Renda Tributável',
    'taxable_income' => 'Renda Tributável',
    'ssf_contribution' => 'Contribuição SSF',
    'ssf_contribution_salary' => 'Contribuição SSF no Salário',
    'total_retirement_contribution_allowed' => 'Contribuição Total para Aposentadoria Permitida',
    'total_income' => 'Rendimento Total',
    'amount' => 'Valor',
    'additional_information' => 'Informações Adicionais',
    'total_payable' => 'Total a Pagar',
    'tds_paid' => 'TDS Pago',
    'ssf_deduction' => 'Dedução SSF',
    'tax_report_generate' => 'Gerar Relatório Fiscal',
    'print' => 'Imprimir',
    'gross_earnings' => 'Rendimentos Brutos',
    'tax_payable' => 'Imposto a Pagar',

    /** Payroll Setting  */
    'advance_salary_limit' => 'Limite de Salário Adiantado',
    'select_month' => 'Selecionar Mês',
    'applicable_month' => 'Mês Aplicável',
    'value' => 'Valor',
    'value_type' => 'Tipo de Valor',
    'enter_bonus_type' => 'Digite o Tipo de Bônus',
    'salary_components' => 'Componentes do Salário',
    'add_bonus' => 'Adicionar Bônus',
    'max_daily_ot' => 'Máximo Diário de Horas Extras',
    'assign_overtime_to_employee' => 'Atribuir Horas Extras ao Funcionário',
    'overtime_pay_rate' => 'Taxa de Pagamento de Horas Extras (por hora)',
    'overtime_rate_percent' => 'Porcentagem da Taxa de Horas Extras (por hora)',
    'placeholder_overtime_pay_rate' => 'Digite a Taxa de Pagamento de Horas Extras',
    'placeholder_overtime_rate_percent' => 'Digite a Porcentagem da Taxa de Horas Extras',
    'rate_type' => 'Tipo de Taxa',
    'select_rate_type' => 'Selecionar Tipo de Taxa',
    'ot_valid_after_hour' => 'Horas Extras Válidas Após ? Hora',
    'placeholder_ot_valid_after_hour' => 'Digite Horas Após as Quais as Horas Extras São Válidas',
    'monthly_ot' => 'Máximo Mensal de Horas Extras',
    'placeholder_monthly_ot' => 'Digite o Máximo Mensal de Horas Extras',
    'weekly_ot' => 'Máximo Semanal de Horas Extras',
    'placeholder_weekly_ot' => 'Digite o Máximo Semanal de Horas Extras',
    'daily_ot' => 'Máximo Diário de Horas Extras',
    'placeholder_daily_ot' => 'Digite o Máximo Diário de Horas Extras',
    'pay_percent' => 'Percentual/Taxa de Pagamento',
    'employee_count' => 'Número de Funcionários',
    'hour' => 'Hora',
    'currency_setting' => 'Configuração de Moeda',
    'payroll_currency' => 'Moeda da Folha de Pagamento',
    'choose_payroll_currency' => 'Escolher Moeda da Folha de Pagamento',
    'add_payment_method' => 'Adicionar Método de Pagamento',
    'payment_method_name' => 'Nome do Método de Pagamento',
    'update_payment_method' => 'Atualizar Método de Pagamento',
    'component_value' => 'Valor do Componente',
    'component_type' => 'Tipo de Componente',
    'add_salary_component' => 'Adicionar Componente de Salário',
    'apply_for_all' => 'Aplicar a Todos',
    'component_value_annual' => 'Valor do Componente (Anual)',
    'select_value_type' => 'Selecionar Tipo de Valor',
    'select_component_type' => 'Selecionar Tipo de Componente',
    'enter_salary_component_name' => 'Digite o Nome do Componente de Salário',
    'add_salary_group' => 'Adicionar Grupo de Salário',
    'delete_confirm_salary_group' => 'Tem certeza de que deseja excluir os detalhes do grupo?',
    'assign_employee_to_group' => 'Atribuir Funcionário ao Grupo',
    'choose_salary_component' => 'Escolher Componente de Salário',
    'assign_salary_components' => 'Atribuir Componentes de Salário',
    'enter_salary_group_name' => 'Digite o Nome do Grupo de Salário',
    'add_more_tds_detail' => 'Adicionar Mais Detalhes de TDS',
    'enter_tds_in_percent' => 'Digite TDS em Percentual',
    'enter_annual_salary_to' => 'Digite o Salário Anual Até',
    'enter_annual_salary_from' => 'Digite o Salário Anual De',
    'select_marital_status' => 'Selecionar Estado Civil',
    'create_salary_tds' => 'Criar TDS de Salário',
    'update_salary_tds' => 'Atualizar TDS de Salário',
    'salary_tds_detail_for_single' => 'Detalhes de TDS de Salário para Solteiros',
    'add_salary_tds' => 'Adicionar TDS de Salário',
    'annual_salary_to' => 'Salário Anual Até',
    'annual_salary_from' => 'Salário Anual De',
    'tds' => 'TDS (%)',
    'salary_tds_detail_for_married' => 'Detalhes de TDS de Salário para Casados',
    'ssf' => 'SSF',
    'employee_contribution' => 'Contribuição do Funcionário',
    'office_contribution' => 'Contribuição do Escritório',
    'assign_undertime_to_employee' => 'Atribuir Tempo Abaixo ao Funcionário',
    'enter_title' => 'Digite o Título',
    'undertime_after_minute' => 'Minutos Após os Quais o Tempo Abaixo é Aplicado',
    'placeholder_ut_after' => 'Digite Horas Após as Quais o Tempo Abaixo é Aplicado',
    'penalty_type' => 'Tipo de Penalidade',
    'select_penalty_type' => 'Selecionar Tipo de Penalidade',
    'penalty_percent' => 'Percentual de Penalidade (por hora)',
    'penalty_percent_placeholder' => 'Digite Percentual de Penalidade para Tempo Abaixo',
    'penalty_rate' => 'Taxa de Penalidade (por hora)',
    'penalty_rate_placeholder' => 'Digite Taxa de Penalidade para Tempo Abaixo',

    /** Leave */
    'leave_type_section' => 'Seção do Tipo de Licença',
    'select_leave_type' => 'Selecionar Tipo de Licença',
    'leave_type' => 'Tipo de Licença',
    'leave_allocated_days' => 'Dias de Licença Alocados',
    'allocated_days' => 'Dias Alocados',
    'is_paid_leave' => 'É Licença Remunerada',
    'leave_type_name' => 'Nome do Tipo de Licença',
    'leave_type_placeholder' => 'Digite o Tipo de Licença',
    'add_leave_type' => 'Adicionar Tipo de Licença',
    'type' => 'Tipo',
    'edit_leave_type_detail' => 'Editar Detalhes do Tipo de Licença',
    'delete_leave_type' => 'Excluir Tipo de Licença',
    'delete_leave_confirmation' => 'Tem certeza de que deseja excluir o Tipo de Licença?',
    'leave_request_section' => 'Seção de Solicitação de Licença',
    'approve' => 'Aprovar',
    'reject' => 'Rejeitar',
    'from_date' => 'De Data',
    'to_date' => 'Até Data',
    'start_time' => 'Hora de Início',
    'end_time' => 'Hora de Término',
    'reason' => 'Motivo',
    'requested_for' => 'Solicitado Para',
    'requested_by' => 'Solicitado Por',
    'requested_days' => 'Dias Solicitados',
    'requested_date' => 'Data da Solicitação',
    'all_status' => 'Todos os Status',
    'all_leave_type' => 'Todos os Tipos de Licença',
    'leave_request_filter' => 'Filtro de Solicitação de Licença',
    'create_leave_request' => 'Criar Solicitação de Licença',
    'leave_reason' => 'Motivo da Licença',
    'referred_by' => 'Referido Por',
    'leave_date' => 'Data da Licença',
    'time_leave_request_filter' => 'Filtro de Solicitação de Licença por Tempo',
    'create_time_leave_request' => 'Criar Solicitação de Licença por Tempo',
    'time_leave_request_section' => 'Seção de Solicitação de Licença por Tempo',
    'time_leave_status_update' => 'Atualização de Status de Licença por Tempo',

    /** Team Meeting */
    'team_meeting_section' => 'Seção de Reunião de Equipe',
    'update_and' => 'atualizar e',
    'create_and' => 'Criar e',
    'send' => 'Enviar',
    'meeting_participator' => 'Participante da reunião',
    'image_hint' => 'Imagem é recomendada em formato paisagem',
    'meeting_description' => 'Descrição da Reunião',
    'upload_image' => 'Carregar Imagem',
    'meeting_start_time' => 'Hora de Início da Reunião',
    'meeting_date' => 'Data da Reunião',
    'meeting_venue' => 'Local da Reunião',
    'enter_venue_name' => 'Digite o nome do local',
    'enter_content_title' => 'Digite o título do conteúdo',
    'meeting_title' => 'Título da Reunião',
    'delete_team_meeting_confirmation' => 'Tem certeza de que deseja excluir a reunião da equipe?',
    'image_delete_confirmation' => 'Tem certeza de que deseja remover a imagem?',
    'create_team_meeting' => 'Criar Reunião de Equipe',
    'delete_team_meeting' => 'Excluir detalhes da reunião de equipe',
    'edit_meeting_detail' => 'Editar detalhes da reunião',
    'show_team_meeting' => 'Mostrar conteúdo da reunião de equipe',
    'participators' => 'Participantes',
    'participator' => 'Participante',
    'team_meeting_filter' => 'Filtro de Reunião de Equipe',
    'agenda' => 'Agenda',
    'creator' => 'Criador',

    /** Tada */
    'tada_attachment' => 'Anexo Tada',
    'upload_tada_attachment' => 'Fazer upload do anexo Tada',
    'accepted' => 'Aceito',
    'tada_status_change' => 'Tem certeza de que deseja mudar o status do ajuste Tada?',
    'delete_tada_confirm' => 'Tem certeza de que deseja excluir :title?',
    'uploaded_attachment' => 'Anexo carregado',
    'no_attachment_file' => 'Nenhum arquivo anexado',
    'total_expense' => 'Despesa Total',
    'create_tada' => 'Criar Tada',
    'edit_tada' => 'Editar Tada',
    'tada_listing' => 'Lista Tada',
    'tada_filter' => 'Filtro Tada',
    'submitted_date' => 'Data de Submissão',
    'expense' => 'Despesa',
    'tada_detail' => 'Detalhe Tada',
    'verified_date' => 'Data de Verificação',
    'tada_summary' => 'Resumo Tada',
    'update_status' => 'Atualizar Status',
    'category' => 'Categoria',
    'select_category' => 'Selecionar Categoria',
    'opening_time' => 'Hora de Abertura',
    'closing_time' => 'Hora de Fechamento',
    'checkin_checkout_rule' => 'Regra de Check-In/Check-Out',
    'early_check_in' => 'Check-In Antecipado',
    'check_in_before' => 'Pode fazer check-in antes (em minutos)',
    'checkin_before' => 'Check-In Antes',
    'enter_check_in_before' => 'Digite quanto antes pode fazer check-in (em minutos)',
    'early_check_out' => 'Check-Out Antecipado',
    'check_out_before' => 'Pode fazer check-out antes (em minutos)',
    'checkout_before' => 'Check-Out Antes',
    'enter_check_out_before' => 'Digite quanto antes pode fazer check-out (em minutos)',
    'late_check_in' => 'Check-In Tardio',
    'check_in_after' => 'Pode fazer check-in depois (em minutos)',
    'checkin_after' => 'Check-In Depois',
    'enter_check_in_after' => 'Digite quanto depois pode fazer check-in (em minutos)',
    'late_check_out' => 'Check-Out Tardio',
    'checkout_after' => 'Check-Out Depois',
    'check_out_after' => 'Pode fazer check-out depois (em minutos)',
    'enter_check_out_after' => 'Digite quanto depois pode fazer check-out (em minutos)',
    'enter_shift_name' => 'Digite o Nome do Turno',
    'select_shift' => 'Selecionar Turno',
    'delete_office_time_confirm' => 'Tem certeza de que deseja excluir o Horário do Escritório?',
    'office_time_detail' => 'Detalhe do Horário do Escritório',
    'office_schedule' => 'Horário do Escritório',
    'add_office_time' => 'Adicionar Horário do Escritório',

    /** Award Types */
    'award_distributed' => 'Prêmio Distribuído',
    'add_award_types' => 'Adicionar Tipos de Prêmios',
    'gift_item' => 'Item de Presente',
    'awarded_date' => 'Data de Concessão',

    /** Award */
    'award' => 'Prêmio',
    'award_name' => 'Nome do Prêmio',
    'select_award_type' => 'Selecionar Tipo de Prêmio',
    'enter_gift_item' => 'Inserir Item de Presente',
    'award_base' => 'Base do Prêmio',
    'select_award_base' => 'Selecionar Base do Prêmio',
    'awarded_by' => 'Concedido Por',
    'enter_awarded_by' => 'Inserir Concedido Por',
    'award_description' => 'Descrição do Prêmio',
    'gift_description' => 'Descrição do Presente',
    'reward_code' => 'Código de Recompensa',
    'enter_reward_code' => 'Inserir Código de Recompensa',
    'add_award' => 'Adicionar Prêmio',
    'attachment' => 'Anexo',
    'award_lists' => 'Listas de Prêmios',

    /** Asset Types */
    'add_asset_types' => 'Adicionar Tipos de Ativos',
    'asset_item_count' => 'Quantidade de Itens de Ativo',
    'asset_type' => 'Tipo de Ativo',
    'asset_name' => 'Nome do Ativo',
    'purchased_date' => 'Data de Compra',
    'is_working' => 'Está Funcionando',
    'is_available' => 'Está Disponível',
    'asset' => 'Ativo',

    /** Assets */
    'select_asset_type' => 'Selecionar Tipo de Ativo',
    'assigned_date' => 'Data de Atribuição',
    'is_available_for_employee' => 'Disponível para o Funcionário',
    'select_availability' => 'Selecionar Disponibilidade',
    'warranty_end_date' => 'Data de Término da Garantia',
    'warranty_available' => 'Garantia Disponível',
    'select_warranty_availability' => 'Selecionar Disponibilidade da Garantia',
    'asset_serial_number' => 'Número de Série do Ativo',
    'enter_asset_serial_number' => 'Inserir Número de Série do Ativo',
    'asset_code' => 'Código do Ativo',
    'enter_asset_code' => 'Inserir Código do Ativo',
    'change_availability_status' => 'Você tem certeza de que deseja mudar o status de disponibilidade?',
    'delete_asset_confirm' => 'Você tem certeza de que deseja excluir :title?',
    'add_asset' => 'Adicionar Ativo',
    'asset_image' => 'Imagem do Ativo',
    'asset_assigned_employee' => 'Funcionário Atribuído ao Ativo',
    'assets_filter' => 'Filtro de Ativos',
    'working_status' => 'Status de Funcionamento',
    'availability_status' => 'Status de Disponibilidade',
    'yes_available' => 'Sim, Disponível',
    'notavailable' => 'Não Disponível',
    'purchased_from' => 'Comprado de',
    'purchased_to' => 'Comprado para',

    /** Content Management */
    'content_section' => 'Seção de Conteúdo',
    'content' => 'Conteúdo',
    'content_type' => 'Tipo de Conteúdo',
    'content_title' => 'Título do Conteúdo',
    'select_content_type' => 'Selecionar Tipo de Conteúdo',
    'delete_content_confirm' => 'Tem certeza de que deseja excluir o conteúdo da página estática?',
    'company_static_content' => 'Conteúdo Estático da Empresa',
    'add_content' => 'Adicionar Conteúdo',

    /** Support */
    'delete_support_confirm' => 'Tem certeza de que deseja excluir :title?',
    'ticket_lists' => 'Listas de Tickets',
    'query_by' => 'Consulta Por',
    'concerned_department' => 'Departamento Concernido',
    'unseen' => 'Não Visto',
    'read_status' => 'Status de Leitura',
    'seen' => 'Visto',
    'query_status' => 'Status da Consulta',
    'support_filter' => 'Filtro de Suporte',
    'query_lists' => 'Listas de Consultas',
    'department_support_requested_from' => 'Suporte Solicitado do Departamento',
    'department_support_requested_to' => 'Suporte Solicitado ao Departamento',
    'change_query_status' => 'Mudar Status da Consulta',

    /** Router */
    'router_section' => 'Seção do Roteador',
    'router_bssid' => 'BSSID do Roteador',
    'router' => 'Roteador',
    'router_detail' => 'Detalhes do Roteador',
    'add_router' => 'Adicionar Roteador',

    /** QR */
    'scan_me' => 'Escaneie-me',
    'attendance_qr' => 'QR de Presença',
    'qr_image' => 'Imagem QR',
    'add_qr' => 'Adicionar QR',
    'qr_section' => 'Seção QR',

    /** NFC */
    'nfc_section' => 'Seção NFC',
    'created_by' => 'Criado por',

    /** Role and permission */
    'role_section' => 'Seção de Papéis',
    'autorize_backend_login' => 'Autorizar Login no Backend',
    'role_name' => 'Nome do Papel',
    'permissions' => 'Permissões',
    'check_all' => 'Selecionar Todos',
    'module' => 'Módulo',
    'add_role' => 'Adicionar Papel',
    'assign_permissions' => 'Atribuir Permissões',
    'confirm_role_deletion' => 'Tem certeza de que deseja excluir o papel?',
    'can_login' => 'Pode fazer login',
    'permission_setting' => 'Configuração de Permissões',
    'assign' => 'Atribuir',

    /** General Setting */
    'general_setting_section' => 'Seção de Configuração Geral',
    'general_setting' => 'Configuração Geral',

    /** App Setting */
    'export_database_data' => 'Exportar Dados do Banco de Dados',
    'check_router_bssid' =>'Verificar BSSID do roteador',

    /** Fiscal Years */
    'fiscal_years' => 'Anos Fiscais',
    'year' => 'Ano',
    'add_fiscal_year' => 'Adicionar Ano Fiscal',

    /** Notifications */
    'notification_section' => 'Seção de Notificações',
    'confirm_notification_send' => 'Tem certeza de que deseja enviar a notificação?',
    'notification' => 'Notificação',
    'published_date' => 'Data de Publicação',
    'all_types' => 'Todos os Tipos',
    'notification_lists' => 'Listas de Notificações',
    'notified_member' => 'Membro Notificado',
    'notification_title' => 'Título da Notificação',
    'notification_description' => 'Descrição da Notificação',
    'send_notification' => 'Enviar Notificação',
    'enter_notification_title' => 'Digite o Título da Notificação',

    /** feature control */
    'app_setting' => 'Configuração do aplicativo',
    'sn' => 'SN',
    'group' => 'Grupo',
    'export_table_data' => 'Exportar dados da tabela',
    'leave_requests' => 'Pedidos de afastamento',
    'employee_lists' => 'Listas de funcionários',
    'attendances' => 'Frequências',
    'confirm_change_status' => 'Tem certeza de que deseja alterar o status?',
    'yes' => 'Sim',
    'no' => 'Não',

    /** Api response */
    /** Auth Controller */
    'invalid_login_credentials'=>'Credenciais de login inválidas!',
    'authenticated'=>'Autenticado',
    'user_detail_not_found'=>'Detalhes do usuário não encontrados',
    'partial_logout_successful'=>'Logout parcial bem-sucedido',
    /** Dashboard Controller */
    'data_found'=>'Dados encontrados',
    /** AdvanceSalary Controller */
    'advance_salary_pending_error'=>'Outro adiantamento salarial não pode ser solicitado até que o pedido anterior seja liquidado.',
    'data_updated_successfully'=>'Dados atualizados com sucesso',
    'user_updated_advance_salary_request' => ':name atualizou o detalhe do pedido de adiantamento salarial',
    'data_created_successfully'=>'Dados criados com sucesso',
    'advance_salary_request_alert'=>'Alerta de Pedido de Adiantamento Salarial',
    'user_submitted_advance_salary_request' => ':name apresentou um pedido de adiantamento salarial no valor de :amount',
    /** Attendance Api */
    'check_out_successful'=>'Checkout bem-sucedido',
    'check_out_notification'=>'Notificação de Checkout',
    'check_in_successful'=>'Check-in bem-sucedido',
    'check_in_notification'=>'Notificação de Check-in',
    'not_checked_in_yet'=>'Ainda não fez check-in',
    'alert_multi_checkin_shift'=>'Desculpe! O funcionário não pode fazer check-in duas vezes em um turno.',
    'checkout_alert_for_shift'=>'Funcionário já fez checkout do turno',
    'alert_checkin'=>'Desculpe! o funcionário não pode fazer check-in duas vezes no mesmo dia.',
    'checkout_alert'=>'Funcionário já fez check-out hoje',
    'attendance_alert_status'=>':status já feito',
    'employee_checked_in' => ':name fez check-in às :time',
    'employee_checked_out' => ':name fez check-out às :time',
    'has_worked_for' => 'e trabalhou por :time',
    'multi_checkout_warning'=>'Você atingiu o número máximo de check-ins e check-outs permitidos para hoje.',
    'employee_checked_out_and_worked' => ':name fez check-out às :check_out_time e trabalhou por :worked_time',
    'invalid_attendance_type'=>'Tipo de presença inválido.',
    'invalid_qr'=>'QR inválido ou QR não disponível',
    'invalid_nfc'=>'Token NFC inválido ou NFC não disponível',
    'validation_failed'=>'Falha na validação',

    /** Leave Api Controller */
    'leave_request_cancelled' => 'Solicitação de licença cancelada com sucesso',
    'leave_request_cannot_be_cancelled' => 'A solicitação de licença não pode ser cancelada uma vez que foi atualizada do estado pendente.',
    'leave_request_notification' => 'Notificação de Solicitação de Licença',
    'leave_request_submitted' => ':name solicitou licença de :start_time a :end_time em :issue_date. Motivo: :reasons',
    'leave_request_submitted_successfully' => 'Solicitação de licença submetida com sucesso',
    'leave_request_cancelled_successfully' => 'Solicitação de licença cancelada com sucesso',
    'leave_request_submit' => ':name solicitou :no_of_days dia(s) de licença a partir de :leave_from em :leave_requested_date. Motivo: :reasons',

    /** NFC api Controller */
    'nfc_token_already_exist' => 'Token NFC já existe.',
    'nfc_added_successfully' => 'NFC adicionado com sucesso',

    /** Notification Api Controller */
    'updated_successfully' => 'Atualizado com sucesso',
    'successfully_sent_notification' => 'Notificação enviada com sucesso',
    'data_not_found' => 'Dados não encontrados',
    'content_not_found' => 'Conteúdo não encontrado',

    /** Support Api Controller */
    'support_notification' => 'Notificação de Suporte',
    'support_request_submitted' => ':name solicitou suporte.',
    'query_submitted_successfully' => 'Consulta submetida com sucesso',

    /** Tada Api Controller  */
    'attachment_detail_not_found' => 'Detalhes do anexo não encontrados',
    'cannot_delete_attachment_detail' => 'Não é possível excluir os detalhes do anexo uma vez verificados',
    'upload_another_attachment_before_delete' => 'Por favor, envie outro anexo antes de excluir.',
    'attachment_deleted_successfully' => 'Anexo excluído com sucesso',
    'tada_update_alert' => 'Você não pode atualizar os detalhes uma vez verificados, entre em contato com o administrador',
    'tada_notification' => ':name enviou um novo TADA para :title',
    'tada_detail_notification' => ':name atualizou os detalhes do TADA submetido para :title',
    'tada_alert' => 'Alerta TADA',

    /** TaskDetailApi Controller */
    'status_changed_successfully' => 'Status alterado com sucesso',
    'task_detail_not_found' => 'Detalhes da tarefa não encontrados',

    /** TaskCheckListApi Controller */
    'status_updated_successfully' => 'Status atualizado com sucesso',

    /** TaskCommentApi Controller */
    'comment_notification' => 'Notificação de Comentário',
    'task_mention' => 'Você foi mencionado na tarefa :task :type',
    'comment_reply' => 'Resposta ao comentário',
    'comment_reply_deleted_successfully' => 'Resposta ao comentário excluída com sucesso',
    'comment_deleted_successfully' => 'Comentário excluído com sucesso',
    'comment_added_successfully' => 'Comentário adicionado com sucesso',

    /** userProfile Api */
    'invalid_base64_image' => 'O valor Base64 não é uma imagem válida',
    'demo_version' => 'Esta é uma versão de demonstração. Compre o aplicativo para usar o recurso completo',
    'user_not_found' => 'Detalhes do usuário não encontrados',
    'profile_updated' => 'Perfil atualizado com sucesso',
    'incorrect_current_password' => 'Senha atual incorreta',
    'new_password_same_as_old' => 'A nova senha não pode ser a mesma que a senha antiga',
    'password_changed' => 'Senha alterada com sucesso',


    /** leave_approval */
    'leave_approval'=>'Aprovação de Licença',
    'leave_approval_list'=>'Lista de Aprovações de Licença',
    'add_leave_approval'=>'Adicionar Aprovação de Licença',
    'subject'=>'Assunto',
    'related'=>'Relacionado',
    'select_related'=>'Selecionar Relacionado',
    'max_days_to_sign'=>'Número máximo de dias para assinar',
    'notification_recipient'=>'Destinatário da Notificação',
    'select_notification_recipient'=>'Selecionar Destinatário da Notificação',
    'approval_process' =>'Processo de Aprovação',
    'approver'=>'Aprovador',
    'select_approver'=>'Selecionar Aprovador',
    'head_of_department'=>'Chefe do Departamento',
    'specific_personnel'=>'Pessoal Específico',
    'applicable_from'=>'Aplicável a partir de',

    /** Event Management */
    'event_section'=>'Seção de Eventos',
    'event_title'=>'Título do Evento',
    'event_location'=>'Local do Evento',
    'event_start_date'=>'Data de Início do Evento',
    'event_start_time'=>'Hora de Início do Evento',
    'event_end_date'=>'Data de Término do Evento',
    'event_end_time'=>'Hora de Término do Evento',
    'all_departments'=>'Todos os Departamentos',
    'delete_event_confirmation'=>'Tem certeza de que deseja excluir este evento?',
    'create_event'=>'Criar Evento',
    'show_event'=>'Mostrar Evento',
    'enter_event_title'=>'Digite o Título do Evento',
    'edit_event_detail'=>'Editar Detalhes do Evento',
    'delete_event'=>'Excluir Evento',
    'event_calendar'=>'Calendário de Eventos',

    /** Training Management */
    'training_types'=>'Tipos de Treinamento',
    'select_training_type'=>'Selecionar Tipo de Treinamento',
    'training'=>'Treinamento',
    'select_trainer'=>'Selecionar Treinador',
    'trainer'=>'Treinador',
    'add_trainer'=>'Adicionar Treinador',
    'add_training'=>'Adicionar Treinamento',
    'trainer_lists'=>'Lista de Treinadores',
    'training_list'=>'Lista de Treinamentos',
    'total_training'=>'Total de Treinamentos',
    'training_type'=>'Tipo de Treinamento',
    'training_management'=>'Gestão de Treinamento',
    'add_training_types'=>'Adicionar Tipos de Treinamento',
    'training_date'=>'Data do Treinamento',
    'trainer_type'=>'Tipo de Treinador',
    'select_trainer_type'=>'Selecionar Tipo de Treinador',
    'expertise' =>'Área de Especialização',
    'certificate' =>'Certificado',
    'contact_number' =>'Número de Contato',
    'training_for' =>'Treinamento para',
    'time' =>'Horário',
    'updated_by' =>'Atualizado por',

    'select_task' => 'Selecionar Tarefa',
    'event_host' =>'Anfitrião do Evento',
    'host' =>'Anfitrião',
    'location' =>'Localização',
    'event_list'=>'Lista de Eventos',
    'total_tasks'=>'Total de Tarefas',
    'applicable_to_tax_report'=>'Os componentes salariais aplicáveis a todos serão usados no relatório fiscal.',

    'no_departments_found'=>'Nenhum Departamento Encontrado',
    'error_loading_departments'=>'Erro ao Carregar Departamentos',
    'no_employees_found'=>'Nenhum Funcionário Encontrado',
    'update_send' => 'Atualizar e Enviar Notificação',
    'create_send' => 'Criar e Enviar Notificação',


    'admin_permission_msg' => 'Se esta opção for selecionada, todas as etapas hierárquicas serão ignoradas e os usuários com este papel poderão visualizar e editar todas as licenças. Mantenha esta opção para papéis especiais como RH',
    'coming_soon' => 'Em breve',
    'assign_trainer_section' => 'Seção de Atribuição de Treinador',
    'assign_trainer' => 'Atribuir Treinador',


    'export_csv' => 'Exportar CSV',

    /** Termination Management */
    'termination_types'=>'Tipos de Terminação',
    'select_termination_type'=>'Selecionar Tipo de Terminação',
    'termination'=>'Terminação',
    'add_termination'=>'Adicionar Terminação',
    'termination_list'=>'Lista de Terminações',
    'total_termination'=>'Total de Terminações',
    'termination_type'=>'Tipo de Terminação',
    'termination_management'=>'Gestão de Terminações',
    'add_termination_types'=>'Adicionar Tipos de Terminação',
    'termination_date'=>'Data de Terminação',
    'notice_date'=>'Data de Notificação',

    /** Resignation Management */
    'resignation_types'=>'Tipos de Demissão',
    'select_resignation_type'=>'Selecionar Tipo de Demissão',
    'resignation'=>'Demissão',
    'add_resignation'=>'Adicionar Demissão',
    'resignation_list'=>'Lista de Demissões',
    'total_resignation'=>'Total de Demissões',
    'resignation_type'=>'Tipo de Demissão',
    'resignation_management'=>'Gestão de Demissões',
    'add_resignation_types'=>'Adicionar Tipos de Demissão',
    'resignation_date'=>'Data de Demissão',
    'last_date'=>'Última Data',
    'last_working_day'=>'Último Dia de Trabalho',
    'resignation_notification' => 'Solicitação de Demissão',
    'resignation_submit' => ':name solicitou demissão em :resignation_date, com efeito a partir de :last_working_day.',
    'resignation_submitted_successfully' => 'Demissão submetida com sucesso',
    'resignation_fetched_successfully' => 'Demissão obtida com sucesso',
    'resignation_exist_error' => 'Sua demissão já está :status.',
    'document' => 'Documento',
    'venue' => 'Local',

    /** Warning Management */
    'select_warning_type'=>'Selecionar Tipo de Aviso',
    'warning'=>'Aviso',
    'message'=>'Mensagem',
    'add_warning'=>'Adicionar Aviso',
    'warning_list'=>'Lista de Avisos',
    'total_warning'=>'Total de Avisos',
    'warning_type'=>'Tipo de Aviso',
    'warning_management'=>'Gestão de Avisos',
    'add_warning_types'=>'Adicionar Tipos de Aviso',
    'warning_date'=>'Data de Aviso',
    'warning_notification' => 'Solicitação de Aviso',
    'warning_submit' => ':name submeteu sua resposta ao aviso sobre :subject emitido em :date ',
    'warning_submitted_successfully' => 'Aviso submetido com sucesso',
    'response_submitted_successfully' => 'Sua resposta foi registrada com sucesso',
    'warning_fetched_successfully' => 'Aviso obtido com sucesso',
    'warning_exist_error' => 'Sua resposta já foi registrada.',
    'response_section' => 'Seção de Resposta',
    'response' => 'Resposta',

    /** Complaint Management */
    'select_complaint_type'=>'Selecionar Tipo de Reclamação',
    'complaint'=>'Reclamação',
    'complaint_from'=>'Reclamação de',
    'add_complaint'=>'Adicionar Reclamação',
    'complaint_list'=>'Lista de Reclamações',
    'total_complaint'=>'Total de Reclamações',
    'complaint_type'=>'Tipo de Reclamação',
    'complaint_management'=>'Gestão de Reclamações',
    'add_complaint_types'=>'Adicionar Tipos de Reclamação',
    'complaint_date'=>'Data de Reclamação',
    'complaint_notification' => 'Solicitação de Reclamação',
    'complaint_submit' => 'Resposta à reclamação sobre :subject emitida em :date foi submetida',
    'complaint_submitted_successfully' => 'Reclamação submetida com sucesso',
    'complaint_fetched_successfully' => 'Reclamação obtida com sucesso',
    'complaint_exist_error' => 'Sua resposta já foi registrada.',
    'complain_to' => 'Reclamar para',

    'hr_admin_setup' => 'Configuração de Administração de RH',
    'edit_branch' => 'Editar Filial',
    'branch_head_error'=>'O usuário selecionado já é chefe de outra filial, por favor, selecione um usuário diferente',
    'department_head_error'=>'O usuário selecionado já é chefe de outro departamento, por favor, selecione um usuário diferente',

    /** Promotion Management */
    'promotion'=>'Promoção',
    'add_promotion'=>'Adicionar Promoção',
    'promotion_list'=>'Lista de Promoções',
    'promotion_section'=>'Seção de Promoção',
    'total_promotion'=>'Total de Promoções',
    'promotion_type'=>'Tipo de Promoção',
    'promotion_management'=>'Gestão de Promoções',
    'add_promotion_types'=>'Adicionar Tipos de Promoção',
    'promotion_date'=>'Data de Promoção',
    'promotion_notification' => 'Solicitação de Promoção',
    'promotion_submitted_successfully' => 'Promoção submetida com sucesso',
    'promotion_fetched_successfully' => 'Promoção obtida com sucesso',

    'select_post' => 'Selecionar Cargo',
    'old_post' => 'Cargo Antigo',
    'new_post' => 'Novo Cargo',

    /** Transfer Management */
    'transfer'=>'Transferência',
    'transfer_details'=>'Detalhes da Transferência',
    'add_transfer'=>'Adicionar Transferência',
    'transfer_list'=>'Lista de Transferências',
    'transfer_section'=>'Seção de Transferência',
    'total_transfer'=>'Total de Transferências',
    'transfer_type'=>'Tipo de Transferência',
    'transfer_management'=>'Gestão de Transferências',
    'add_transfer_types'=>'Adicionar Tipos de Transferência',
    'transfer_date'=>'Data de Transferência',
    'transfer_notification' => 'Solicitação de Transferência',
    'transfer_submitted_successfully' => 'Transferência submetida com sucesso',
    'transfer_fetched_successfully' => 'Transferência obtida com sucesso',
    'old_branch' => 'Filial Antiga',
    'new_branch' => 'Nova Filial',
    'old_department' => 'Departamento Antigo',
    'new_department' => 'Novo Departamento',

    /** theme color */
    'theme_color'=>'Cor do Tema',
    'background_color'=>'Cor de Fundo',
    'primary_color'=>'Cor Primária',
    'hover_color'=>'Cor de Passagem',
    'dark_primary_color'=>'Cor Primária Escura',
    'dark_hover_color'=>'Cor de Passagem Escura',

    /** Admin Management */
    'users'=>'Usuários',
    'user_section'=>'Seção de Usuário',
    'add_user'=>'Adicionar Usuário',
    'user_management'=>'Gestão de Usuários',
    'user'=>'Usuário',

    'office_time_not_found'=>'Horário de escritório não encontrado',
    'asset_type_not_found'=>'Tipo de ativo não encontrado',
    'employee_not_found'=>'Funcionários não encontrados',
    'error_loading_asset_types'=>'Erro ao carregar tipos de ativos',
    'error_loading_employees'=>'Erro ao carregar funcionários',
    'error_loading_termination_types'=>'Erro ao carregar tipos de terminação',
    'error_loading_department'=>'Erro ao carregar departamentos',
    'leave_type_not_found'=>'Tipo de licença não encontrado',
    'error_loading_leave_types'=>'Erro ao carregar tipos de licenças',
    'no_department_found'=>'Departamento não encontrado',
    'award_filter'=>'Filtro de Prêmios',
    'select_award'=>'Selecionar Prêmio',
    'award_type_not_found'=>'Tipo de prêmio não encontrado',
    'termination_filter'=>'Filtro de Terminação',
    'training_type_filter'=>'Filtro de Tipo de Treinamento',
    'asset_type_filter'=>'Filtro de Tipo de Ativo',
    'award_type_filter'=>'Filtro de Tipo de Prêmio',
    'termination_type_filter'=>'Filtro de Tipo de Terminação',
    'resignation_filter'=>'Filtro de Demissão',
    'promotion_filter'=>'Filtro de Promoção',
    'complaint_filter'=>'Filtro de Reclamação',
    'warning_filter'=>'Filtro de Aviso',
    'transfer_filter'=>'Filtro de Transferência',
    'trainer_filter'=>'Filtro de Treinador',
    'office_time_filter'=>'Filtro de Horário de Escritório',
    'leave_type_filter'=>'Filtro de Tipo de Licença',
    'client_filter'=>'Filtro de Cliente',
    'router_filter'=>'Filtro de Roteador',
    'project_not_found'=>'Projeto não encontrado',
    'error_loading_training_types'=>'Erro ao carregar tipos de treinamento',

    'post_filter'=>'Filtro de postagens',
    'event_filter'=>'Filtro de eventos',
    'training_filter'=>'Filtro de treinamento',
    'post_lists'=>'Listas de postagens',
    'tada_lists'=>'Listas Tada',
    'advance_salary_filter'=>'Filtro de salário adiantado',
    'log_filter'=>'Filtro de registro de presença',
    'advance_salary_lists'=>'Listas de salário adiantado',
    'logout_request_filter'=>'Filtro de solicitação de logout',
    'leave_approval_filter'=>'Filtro de aprovação de licença',
    'user_list'=>'Lista de usuários',
    'projects_not_found'=>'Projetos não encontrados',
    'attendance_logs'=>'Registros de presença',
    'attendance_type'=>'Tipo de presença',
    'identifier'=>'Identificador',
    'nfc_lists'=>'Listas NFC',
    'qr_lists'=>'Listas QR',
    'qr_filter'=>'Filtro QR',
    'nfc_filter'=>'Filtro NFC',
    'select_notice_receiver'=>'Selecionar receptor de notificação',
    'generated_salary_lists'=>'Listas de salários gerados',
    'employee_salaries'=>'Salários dos funcionários',
    'select_meeting_participants'=>'Selecionar participantes da reunião',
    'employee_filter'=>'Filtro de funcionários',
    'attendance_filter'=>'Filtro de presença',
    'notice_filter'=>'Filtro de notificações',
    'award_type_lists'=>'Listas de tipos de prêmios',
    'termination_type_lists'=>'Listas de tipos de rescisão',
    'holiday_lists'=>'Listas de feriados',
    'asset_lists'=>'Listas de ativos',
    'router_lists'=>'Listas de roteadores',
    'meeting_list'=>'Listas de reuniões',
    'app_qr'=>'QR do aplicativo',
    'digital_hr_dashboard'=>'Painel digital de RH',
    'training_type_list'=>'Lista de tipos de treinamento',
    'time_leave_list'=>'Listas de pedidos de licença de tempo',
    'support_list'=>'Listas de suporte',
    'role_list'=>'Listas de papéis',
    'asset_type_list'=>'Listas de tipos de ativos',
    'add_undertime'=>'Adicionar tempo insuficiente',
    'threshold_time'=>'Tempo limite',
    'ssf_rule'=>'Regra SSF',
    'upload_warning'=>'Por favor, envie pelo menos um documento quando o status for aprovado',

    'check_in_latitude'=>'Latitude de check-in',
    'check_in_longitude'=>'Longitude de check-in',
    'check_out_latitude'=>'Latitude de check-out',
    'check_out_longitude'=>'Longitude de check-out',
];
