<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Authentication Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines are used during authentication for various
    | messages that we need to display to the user. You are free to modify
    | these language lines according to your application's requirements.
    |
    */

    /** dashboard */
    'welcome' => 'Добро пожаловать в Панель Посещаемости',
    'total_employees' => 'Всего Сотрудников',
    'total_departments' => 'Всего Отделов',
    'total_holidays' => 'Всего Праздников',
    'paid_leaves' => 'Оплачиваемые Отпуска',
    'on_leave_today' => 'Сегодня в Отпуске',
    'pending_leave_requests' => 'Ожидающие Заявки на Отпуск',
    'total_check_in_today' => 'Всего Входов Сегодня',
    'total_check_out_today' => 'Всего Выходов Сегодня',
    'projects_detail' => 'Детали Проектов',
    'total_projects' => 'Всего Проектов',
    'pending_projects' => 'Ожидающие Проекты',
    'on_hold_projects' => 'Проекты на Удержании',
    'in_progress_projects' => 'Проекты в Работе',
    'finished_projects' => 'Завершенные Проекты',
    'cancelled_projects' => 'Отмененные Проекты',
    'top_clients' => 'Лучшие Клиенты',
    'task_details' => 'Детали Задачи',
    'recent_projects' => 'Недавние Проекты',
    'title' => 'Название',
    'date_start' => 'Дата Начала',
    'deadline' => 'Крайний Срок',
    'leader' => 'Руководитель',
    'completion' => 'Завершение',
    'priority' => 'Приоритет',
    'check_in_at' => 'Вход в',
    'check_out_at' => 'Выход в',
    'punch_in' => 'Отметиться',
    'punch_out' => 'Выйти',
    'no_records_found' => 'Записей не найдено!',
    'project_management' => 'Управление Проектами',
    'view_all_clients' => 'Посмотреть Всех Клиентов',
    'view_all_projects' => 'Посмотреть Все Проекты',
    'error_message' => 'Ошибка: Не удалось обработать запрос.',
    'success_message' => 'Успех: Действие успешно выполнено.',
    'name' => 'Имя',
    'email' => 'Электронная почта',
    'contact' => 'Контакт',
    'project' => 'Проект',
    'pending' => 'В ожидании',
    'on_hold' => 'На удержании',
    'in_progress' => 'В процессе',
    'completed' => 'Завершено',
    'cancelled' => 'Отменено',
    'search_menu' => 'Меню поиска',

    /** nav */
    'latest_notifications' => 'Последние Уведомления',
    'view_all' => 'Посмотреть все',
    'profile' => 'Профиль',
    'edit_profile' => 'Редактировать Профиль',
    'request_leave' => 'Запросить Отпуск',
    'log_out' => 'Выйти',
    'light_mode' => 'Светлый режим',
    'dark_mode' => 'Темный режим',

    /** menu */
    'dashboard' => 'Панель',
    'company_management' => 'Управление компанией',
    'company' => 'Компания',
    'branch' => 'Филиал',
    'department' => 'Отдел',
    'post' => 'Должность',
    'employee_management' => 'Управление сотрудниками',
    'employees' => 'Сотрудники',
    'logout_requests' => 'Запросы на выход',
    'attendance_section' => 'Секция посещаемости',
    'clients' => 'Клиенты',
    'task_management' => 'Управление задачами',
    'holidays' => 'Праздники',
    'notice' => 'Уведомление',
    'payroll_management' => 'Управление заработной платой',
    'payroll' => 'Заработная плата',
    'payroll_setting' => 'Настройка заработной платы',
    'advance_salary' => 'Авансовая зарплата',
    'employee_salary' => 'Зарплата сотрудника',
    'leave' => 'Отпуск',
    'team_meeting' => 'Совещание команды',
    'tada' => 'Тада',
    'shift_management' => 'Управление сменами',
    'office_time' => 'Рабочее время',
    'award_management' => 'Управление наградами',
    'award_types' => 'Типы наград',
    'awards' => 'Награды',
    'asset_management' => 'Управление активами',
    'asset_types' => 'Типы активов',
    'assets' => 'Активы',
    'content_management' => 'Управление контентом',
    'support' => 'Поддержка',
    'attendance_methods' => 'Методы посещаемости',
    'routers' => 'Маршрутизаторы',
    'qr' => 'QR',
    'nfc' => 'NFC',
    'settings' => 'Настройки',
    'roles_permissions' => 'Роли и разрешения',
    'general_settings' => 'Общие настройки',
    'app_settings' => 'Настройки приложения',
    'notifications' => 'Уведомления',
    'payment_currency' => 'Валюта платежа',
    'feature_control' => 'Управление функциями',
    'salary_component' => 'Компонент зарплаты',
    'salary_group' => 'Группа зарплаты',
    'salary_tds' => 'Налог на зарплату',
    'overtime' => 'Сверхурочные',
    'undertime' => 'Недоработка',
    'payment_method' => 'Способ оплаты',
    'leave_types' => 'Типы отпусков',
    'leave_request' => 'Запрос на отпуск',
    'time_leave_request' => 'Запрос на временной отпуск',

    /** company */
    'company_profile' => 'Профиль компании',
    'update_company' => 'Обновить компанию',
    'create_company' => 'Создать компанию',
    'company_name' => 'Название компании',
    'company_owner' => 'Владелец компании',
    'address' => 'Адрес',
    'email_address' => 'Электронный адрес',
    'phone_no' => 'Номер телефона',
    'website_url' => 'URL веб-сайта',
    'check_office_off_days' => 'Проверить выходные дни офиса',
    'upload_logo' => 'Загрузить логотип',
    'update' => 'Обновить',
    'save' => 'Сохранить',

    /** Branch */
    'title_branch' => 'Филиал',
    'branch_section' => 'Раздел филиалов',
    'branches' => 'Филиалы',
    'add_branch' => 'Добавить филиал',
    'branch_lists' => 'Списки филиалов',
    'search_by_branch_name' => 'Поиск по названию филиала',
    'filter' => 'Фильтр',
    'reset' => 'Сбросить',
    'phone' => 'Телефон',
    'total_employee' => 'Общее количество сотрудников',
    'action' => 'Действие',
    'are_you_sure_change_status' => 'Вы уверены, что хотите изменить статус?',
    'are_you_sure_delete_branch' => 'Вы уверены, что хотите удалить филиал?',
    'branch_create' => 'Создать филиал',
    'branch_update' => 'Обновить филиал',
    'branch_name' => 'Название филиала',
    'required_field' => 'Обязательное поле',
    'branch_head' => 'Глава филиала',
    'select_branch_head' => 'Выберите главу филиала',
    'phone_number' => 'Номер телефона',
    'branch_location_latitude' => 'Широта местоположения филиала',
    'enter_branch_location_latitude' => 'Введите широту местоположения филиала',
    'branch_location_longitude' => 'Долгота местоположения филиала',
    'enter_branch_location_longitude' => 'Введите долготу местоположения филиала',
    'status' => 'Статус',
    'select_status' => 'Выберите статус',
    'active' => 'Активный',
    'inactive' => 'Неактивный',
    'create' => 'Создать',

    /** Department */
    'department_section' => 'Раздел департаментов',
    'departments' => 'Департаменты',
    'add_department' => 'Добавить департамент',
    'department_lists' => 'Списки департаментов',
    'search_by_department_name' => 'Поиск по названию департамента',
    'select_branch' => 'Выберите филиал',
    'edit' => 'Редактировать',
    'delete' => 'Удалить',
    'are_you_sure_delete_department' => 'Вы уверены, что хотите удалить департамент?',
    'edit_department' => 'Редактировать департамент',
    'button_back' => 'Назад',
    'breadcrumb' => 'Навигационная цепочка',
    'update_department' => 'Обновить департамент',
    'create_department' => 'Создать департамент',
    'department_name' => 'Название департамента',
    'department_head' => 'Глава департамента',
    'select_department_head' => 'Выберите главу департамента',
    'create_update_department' => 'Создать/Обновить департамент',

    /** Post */
    'post_section' => 'Раздел должностей',
    'posts' => 'Должности',
    'add_post' => 'Добавить должность',
    'search_by_department' => 'Поиск по департаменту',
    'search_by_post_name' => 'Поиск по названию должности',
    'post_name' => 'Название должности',
    'post_empty' => 'Пустая должность',
    'edit_post_title' => 'Редактировать должность',
    'create_post_title' => 'Создать должность',
    'department_label' => 'Департамент',
    'post_name_label' => 'Название должности',
    'status_label' => 'Статус',
    'select_department' => 'Выберите департамент',
    'active_option' => 'Активный',
    'inactive_option' => 'Неактивный',
    'update_update_button' => 'Обновить должность',
    'change_status_confirmation' => 'Вы уверены, что хотите изменить статус?',
    'delete_post_confirmation' => 'Вы уверены, что хотите удалить должность?',
    'employee_list_title' => 'Список сотрудников',

    /** Employee List */
    'employees_title' => 'Сотрудники',
    'employees_action' => 'Списки',
    'add_employee' => 'Добавить сотрудника',
    'employee_section' => 'Раздел сотрудников',
    'employee_create' => 'Создать сотрудника',
    'employee_name' => 'Имя сотрудника',
    'employee_email' => 'Электронная почта сотрудника',
    'employee_phone' => 'Телефон сотрудника',
    'full_name' => 'Полное имя',
    'designation' => 'Должность',
    'role' => 'Роль',
    'shift' => 'Смена',
    'workplace' => 'Место работы',
    'is_active' => 'Активен',
    'edit_detail' => 'Редактировать детали',
    'delete_user' => 'Удалить пользователя',
    'change_password' => 'Изменить пароль',
    'force_logout' => 'Принудительный выход',
    'all_fields_required' => 'Все поля, отмеченные (<span style="color: red">*</span>), обязательны для заполнения',
    'personal_detail' => 'Личные данные',
    'employee_code' => 'Код сотрудника',
    'enter_name' => 'Введите имя',
    'enter_employee_address' => 'Введите адрес сотрудника',
    'enter_email' => 'Введите электронную почту',
    'dob' => 'Дата рождения',
    'gender' => 'Пол',
    'select_gender' => 'Выберите пол',
    'marital_status' => 'Семейное положение',
    'choose_marital_status' => 'Выберите семейное положение',
    'upload_avatar' => 'Загрузить аватар',
    'description' => 'Описание',
    'username' => 'Имя пользователя',
    'enter_username' => 'Введите имя пользователя',
    'password' => 'Пароль',
    'enter_password' => 'Введите пароль',
    'select_role' => 'Выберите роль',
    'company_detail' => 'Детали компании',
    'supervisor' => 'Руководитель',
    'employment_type' => 'Тип занятости',
    'select_employment_type' => 'Выберите тип занятости',
    'joining_date' => 'Дата присоединения',
    'enter_joining_date' => 'Введите дату присоединения',
    'workspace' => 'Рабочее место',
    'select_workspace' => 'Выберите рабочее место',
    'field' => 'Поле',
    'office' => 'Офис',
    'leave_detail' => 'Детали отпуска',
    'leave_allocated' => 'Отпуск выделен',
    'assigned_leaves' => 'Назначенные отпуска',
    'no_of_days' => 'Количество дней',
    'total_leave_days' => 'Общее количество дней отпуска',
    'bank_detail' => 'Банковские реквизиты',
    'bank_name' => 'Название банка',
    'bank_account_number' => 'Номер банковского счета',
    'account_holder_name' => 'Имя владельца счета',
    'bank_account_type' => 'Тип банковского счета',
    'select_account_type' => 'Выберите тип счета',
    'create_user' => 'Создать пользователя',
    'update_user' => 'Обновить пользователя',
    'new_password' => 'Новый пароль',
    'enter_new_password' => 'Введите новый пароль',
    'confirm_password' => 'Подтвердите пароль',
    'confirm_password_placeholder' => 'Подтвердите пароль',
    'submit' => 'Отправить',
    'user_change_password' => 'Изменить пароль пользователя',
    'confirm_delete_employee' => 'Вы уверены, что хотите удалить сотрудника?',
    'confirm_force_logout' => 'Вы уверены, что хотите принудительно выйти из системы?',
    'confirm_change_workplace' => 'Вы уверены, что хотите изменить место работы?',
    'select_supervisor' => 'Выберите руководителя',
    'select_office_time' => 'Выберите время офиса',
    'select_option' => 'Выберите вариант',
    'not_available' => 'Недоступен',

    /** logout requests */
    'logout_request_status' => 'Статус запроса на выход',
    'take_action' => 'Принять меры',
    'confirm_accept_logout_request' => 'Вы уверены, что хотите принять запрос на выход?',

    /** attendance */
    'attendance' => 'Посещаемость',
    'employee_attendance_lists' => 'Списки посещаемости сотрудников',
    'attendance_of_the_day' => 'Посещаемость за день',
    'date_placeholder_bs' => 'Год/Месяц/День',
    'csv_export' => 'Экспорт CSV',
    'attendance_status' => 'Статус посещаемости',
    'attendance_by' => 'Посещаемость по',
    'show_detail' => 'Показать детали',
    'show_checkin_location' => 'Показать местоположение регистрации',
    'show_checkout_location' => 'Показать местоположение выхода',
    'checkin' => 'Регистрация',
    'checkout' => 'Выход',
    'approved' => 'Одобрено',
    'rejected' => 'Отклонено',
    'self' => 'Самостоятельно',
    'admin' => 'Админ',
    'edit_attendance_time' => 'Редактировать время посещаемости',
    'employee_attendance_detail' => 'Детали посещаемости сотрудников',
    'attendance_of' => 'Посещаемость',
    'total_days_in_month' => 'Общее количество дней в месяце',
    'present_days' => 'Дни присутствия',
    'absent_days' => 'Дни отсутствия',
    'weekend_days' => 'Выходные дни',
    'holiday_days' => 'Праздничные дни',
    'leave_days' => 'Дни отпуска',
    'working_hours' => 'Рабочие часы',
    'worked_hours' => 'Отработанные часы',
    'attendance_details_of' => 'Детали посещаемости за :month',
    'all_month' => 'Весь месяц',
    'worked_hour' => 'Отработанные часы',
    'add_attendance_time' => 'Добавить время посещаемости',
    'confirm_change_attendance_status' => 'Вы уверены, что хотите изменить статус посещаемости?',
    'check_in' => 'Регистрация',
    'check_out' => 'Выход',
    'attendance_title' => 'Посещаемость',
    'attendance_action' => 'Детали посещаемости сотрудников',
    'filter_placeholder' => 'Год посещаемости пример: :min_year',
    'filter_button' => 'Фильтр',
    'csv_export_button' => 'Экспорт CSV',
    'reset_button' => 'Сброс',
    'total_days' => 'Общее количество дней в месяце',
    'attendance_details' => 'Детали посещаемости :monthName',
    'date' => 'Дата',
    'change_attendance_status' => 'Изменить статус посещаемости',
    'create_attendance' => 'Создать посещаемость',
    'admin_remark' => 'Замечание администратора',
    'edit_attendance' => 'Редактировать посещаемость',
    'admin_edit_remark' => 'Замечание администратора после редактирования',
    'confirm_check_in' => 'Вы уверены, что хотите зарегистрировать сотрудника?',
    'confirm_check_out' => 'Вы уверены, что хотите зарегистрировать выход сотрудника?',
    'edit_attendance_title' => 'Редактировать посещаемость (:name) :date время',
    'create_attendance_title' => 'Создать посещаемость (:name) :date время',
    'total_worked_hours' => 'Общее количество отработанных часов',
    'attendance_report' => 'Отчет о посещаемости',

    /** clients */
    'client_listing' => 'Список клиентов',
    'add_client' => 'Добавить клиента',
    'client_name' => 'Имя клиента',
    'client_email' => 'Email клиента',
    'edit_client_detail' => 'Редактировать данные клиента',
    'show_client_detail' => 'Показать данные клиента',
    'delete_client_detail' => 'Удалить данные клиента',
    'client_invoices' => 'Счета клиента',
    'client_detail' => 'Детали клиента:',
    'client_project_lists' => 'Списки проектов клиента:',
    'country' => 'Страна',
    'edit_client' => 'Редактировать клиента',
    'create_client' => 'Создать клиента',
    'client_section' => 'Раздел клиентов',
    'client_contact' => 'Контакт клиента',
    'client_address' => 'Адрес',
    'client_country' => 'Страна',
    'upload_profile' => 'Загрузить профиль клиента',
    'enter_client_name' => 'Введите имя клиента',
    'enter_client_email' => 'Введите email клиента',
    'enter_contact_number' => 'Введите контактный номер',
    'enter_client_address' => 'Введите адрес клиента',
    'enter_country' => 'Введите страну',
    'confirm_status_change' => 'Вы уверены, что хотите изменить статус?',
    'confirm_delete_client' => 'Вы уверены, что хотите удалить данные клиента?',

    /** Project management */
    'lists' => 'Списки',
    'create_project' => 'Создать проект',
    'project_filter' => 'Фильтр проектов',
    'search_by_project' => 'Поиск по проекту',
    'search_by_status' => 'Поиск по статусу',
    'search_by_priority' => 'Поиск по приоритету',
    'client' => 'Клиент',
    'all_tasks' => 'Все задачи',
    'completed_tasks' => 'Выполненные задачи',
    'days_left' => 'осталось дней',
    'team_member' => 'Член команды',
    'start_date' => 'Дата начала',
    'due_date' => 'Срок',
    'view' => 'Просмотр',
    'projects' => 'Проекты',
    'assign_employee' => 'Назначить сотрудника',
    'client_contact_number' => 'Контактный номер клиента',
    'upload_client_profile' => 'Загрузить профиль клиента',
    'project_name' => 'Название проекта',
    'project_start_date' => 'Дата начала проекта',
    'project_deadline' => 'Срок выполнения проекта',
    'project_status' => 'Статус проекта',
    'select_project_status' => 'Выберите статус проекта',
    'project_cost' => 'Стоимость проекта',
    'select_priority' => 'Выбрать приоритет',
    'estimated_hours' => 'Ожидаемые часы',
    'select_client' => 'Выбрать клиента',
    'upload_project_logo' => 'Загрузить логотип проекта',
    'uploaded_files_images' => 'Загруженные файлы и изображения',
    'no_project_file_uploaded' => 'Файл проекта не загружен',
    'update_project' => 'Обновить проект',
    'project_leader' => 'Руководитель проекта',
    'assign_member' => 'Назначить участника',
    'edit_project' => 'Редактировать проект',
    'project_document' => 'Документ проекта',
    'upload_documents' => 'Загрузить документы',
    'upload_project_attachments' => 'Загрузить вложения проекта',
    'show_project_detail' => 'Показать детали проекта',
    'upload_attachments' => 'Загрузить вложения',
    'project_attachments' => 'Вложения проекта',
    'uploaded_image_files' => 'Загруженные изображения',
    'no_project_image_found' => 'Изображения проекта не найдены',
    'uploaded_files' => 'Загруженные файлы',
    'no_project_files_found' => 'Файлы проекта не найдены',
    'project_tasks_lists' => 'Списки задач проекта',
    'project_summary' => 'Обзор проекта',
    'cost' => 'Стоимость:',
    'total_hours' => 'Всего часов:',
    'created' => 'Создан:',
    'remaining_days' => 'Оставшиеся дни:',
    'project_leaders' => 'Лидеры проекта',
    'update_leader' => 'Обновить лидера',
    'project_members' => 'Участники проекта',
    'update_member' => 'Обновить участника',
    'project_client_detail' => 'Детали клиента проекта',
    'delete_project_detail' => 'Вы уверены, что хотите удалить детали проекта?',
    'delete_project_document' => 'Вы уверены, что хотите удалить документ проекта?',
    'search_by_member' => 'Поиск по участнику',
    'add_employee_to_project' => 'Добавить сотрудника в проект',

    /** Task management */
    'tasks' => 'Задачи',
    'task_filter' => 'Фильтр задач',
    'search_by_task_name' => 'Поиск по названию задачи',
    'not_started' => 'Не начато',
    'create_tasks' => 'Создать задачи',
    'end_date' => 'Дата завершения',
    'task_name' => 'Название задачи',
    'enter_task_name' => 'Введите название задачи',
    'select_project' => 'Выбрать проект',
    'task_start_date' => 'Дата начала задачи',
    'task_start_time' => 'Время начала задачи',
    'task_end_date' => 'Дата окончания задачи',
    'task_end_time' => 'Время окончания задачи',
    'task_status' => 'Статус задачи',
    'select_task_status' => 'Выбрать статус задачи',
    'uploaded_files_and_images' => 'Загруженные файлы и изображения',
    'task_attachments' => 'Вложения задачи',
    'update_task' => 'Обновить задачу',
    'create_task' => 'Создать задачу',
    'mention' => 'Упоминание',
    'comment' => 'Комментарий',
    'close' => 'Закрыть',
    'write_comment' => 'Написать комментарий',
    'reply' => 'Ответить',
    'delete_confirm' => 'Вы уверены, что хотите удалить ":title"?',
    'task_member_placeholder' => 'Назначить участника задачи',
    'project_placeholder' => 'Выбрать проект',
    'project_filter_placeholder' => 'Поиск по проекту',
    'task_name_placeholder' => 'Поиск по названию задачи',
    'change_task_status_confirm' => 'Вы уверены, что хотите изменить статус задачи?',
    'change_status_confirm' => 'Вы уверены, что хотите изменить статус?',
    'delete_task_detail_confirm' => 'Вы уверены, что хотите удалить детали задачи?',
    'create_checklist_text' => 'Создать чеклист',
    'close_checklist_text' => 'Закрыть',
    'remove_checklist_text' => 'Удалить',
    'remove_checklist_title' => 'Удалить чеклист',
    'view_all_comments' => 'Просмотреть все комментарии',
    'comments' => 'Комментарии',
    'edit_task' => 'Редактировать задачу',
    'edit_task_detail' => 'Редактировать детали задачи',
    'show_task_detail' => 'Показать детали задачи',
    'task_edit' => 'Редактировать задачу',
    'create_checklist' => 'Создать чеклист',
    'upload_attachment' => 'Загрузить вложение',
    'total_checklist' => 'Всего чеклистов',
    'completed_checklist' => 'Завершенные чеклисты',
    'task_checklist_lists' => 'Список чеклистов задачи',
    'assigned_to' => 'Назначено',
    'create_task_checklist' => 'Создать чеклист задачи',
    'enter_checklist_title' => 'Введите название чеклиста',
    'select_member' => 'Выбрать участника',
    'add_more_checklist' => 'Добавить еще чеклист',
    'image' => 'Изображение',
    'file' => 'Файл',
    'edit_checklist' => 'Редактировать чеклист',
    'delete_checklist' => 'Удалить чеклист',
    'checklist' => 'Чеклист',
    'edit_task_checklist' => 'Редактировать чеклист задачи',
    'checklist_name' => 'Название чеклиста',
    'assign_task_checklist' => 'Назначить чеклист задачи',
    'task_summary' => 'Итоги задачи',
    'task_members' => 'Участники задачи',
    'task_attachment_title' => 'Вложение задачи',
    'upload_attachment_action' => 'Загрузить вложение',
    'upload_task_attachments' => 'Загрузить вложения задачи',
    'upload_task_attachments_text' => 'Загрузить вложения задачи',
    'choose_file_text' => 'Выбрать файл',

    /** Holiday */
    'holiday_section' => 'Секция праздников',
    'event' => 'Событие',
    'event_date' => 'Дата события',
    'is_public_holiday' => 'Является ли праздничным днем?',
    'confirm_delete_holiday' => 'Вы уверены, что хотите удалить детали праздника?',
    'holiday_detail_title' => 'Детали праздника',
    'holiday' => 'Праздник',
    'csv_import' => 'Импорт CSV',
    'import' => 'Импортировать',
    'holiday_detail_csv' => 'Детали праздника CSV',
    'holiday_csv_example' => 'Пример CSV праздника',
    'add_holiday' => 'Добавить праздник',
    'import_holiday_csv' => 'Импорт CSV праздника',
    'holiday_filter' => 'Фильтр праздника',
    'event_name' => 'Название события',
    'leave_requested_year' => 'Год запроса на отпуск',
    'holiday_detail' => 'Детали праздника',

    /** notice */
    'notices_section' => 'Раздел уведомлений',
    'notice_title' => 'Заголовок уведомления',
    'notice_description' => 'Описание уведомления',
    'notice_receiver' => 'Получатель уведомления',
    'send_notice' => 'Отправить уведомление',
    'all_employees' => 'Все сотрудники',
    'create_notice' => 'Создать уведомление',
    'edit_notice' => 'Редактировать уведомление',
    'notices' => 'Уведомления',
    'receiver' => 'Получатель',
    'published_from' => 'Опубликовано с',
    'publish_to' => 'Опубликовать до',
    'publish_date' => 'Дата публикации',
    'show_notice_content' => 'Показать содержимое уведомления',
    'delete_notice_detail' => 'Удалить детали уведомления',
    'notice_lists' => 'Список уведомлений',
    'confirm_change_notice_status' => 'Вы уверены, что хотите изменить статус уведомления?',
    'confirm_delete_notice' => 'Вы уверены, что хотите удалить уведомление?',
    'confirm_send_notice' => 'Вы уверены, что хотите отправить уведомление?',
    'notice_detail_modal_title' => 'Детали уведомления :title',


    /** payroll */
    'employee_payroll'=>'Зарплата сотрудника',
    'payroll_generate'=>'Создать зарплату',
    'payroll_create'=>'Создание зарплаты',
    'payroll_edit'=>'Редактировать зарплату',
    'select_year' => 'Выбрать год',
    'salary_cycle' => 'Зарплатный цикл',
    'salary_month' => 'Месяц зарплаты',
    'salary_week' => 'Неделя зарплаты',
    'select_week' => 'Выбрать неделю',
    'include_tada' => 'Включить TADA',
    'include_advance_salary' => 'Включить аванс',
    'use_attendance' => 'Использовать посещаемость',
    'generate' => 'Создать',
    'clear' => 'Очистить',
    'report' => 'Отчет:',
    'duration' => 'Продолжительность',
    'payroll_summary' => 'Итог зарплаты',
    'total_basic_salary' => 'Общая базовая зарплата:',
    'total_net_salary' => 'Общая чистая зарплата:',
    'total_allowance' => 'Общие пособия:',
    'total_deduction' => 'Общие вычеты:',
    'total_overtime' => 'Общее количество сверхурочных:',
    'total_undertime' => 'Общее количество недоработок:',
    'paid_by'=>'Оплачено',
    'net_salary'=>'Чистая зарплата',
    'paid_on'=>'Оплачено на',
    'pay_button' => 'Оплатить',
    'select_payment_method.'=>'Пожалуйста, выберите способ оплаты.',
    'confirm_delete_payroll'=>'Вы уверены, что хотите удалить зарплату сотрудника?',
    'confirm_generate_payroll'=>'Вы уверены, что хотите создать зарплату?',
    'confirm_change_cycle'=>'Вы уверены, что хотите изменить зарплатный цикл?',
    'payment_title' => 'Произвести оплату',
    'payment_method_placeholder' => 'Выберите способ оплаты',
    'payment_date' => 'Дата оплаты',
    'hourly_rate' => 'Почасовая ставка',
    'hourly' => 'Почасовая оплата',
    'working_hours_in_week' => 'Рабочие часы в неделю',
    'annual_salary' => 'Годовая зарплата (CTC)',
    'annual' => 'Годовая',
    'basic_salary' => 'Базовая зарплата',
    'fixed_allowance' => 'Фиксированные пособия',
    'total' => 'Итого',
    'net_total' => 'Чистый итог',
    'earnings' => 'Заработок',
    'deductions' => 'Вычеты',
    'create_salary'=>'Создать зарплату',
    'edit_salary'=>'Редактировать зарплату',
    'add_salary'=>'Добавить зарплату',
    'calculation_type'=>'Тип расчета',
    'monthly_amount'=>'Ежемесячная сумма',
    'annual_amount'=>'Годовая сумма',
    'salary_slip' => 'Расчетный лист',
    'edit_salary_slip' => 'Редактировать расчетный лист',
    'payslip' => 'Расчетный лист',
    'for_the_month_of' => 'за месяц',
    'from'=>'с',
    'to'=>'по',
    'employee_id'=>'ID сотрудника',
    'earning' => 'Заработок',
    'deduction' => 'Вычет',
    'actual_salary' => 'Фактическая зарплата',
    'total_earning'=>'Общий заработок',
    'actual_salary_formula' => '(Общий заработок - Общие вычеты)',
    'bonus' => 'Бонус',
    'taxable_salary' => 'Налогооблагаемая зарплата',
    'taxable_salary_formula' => '(Фактическая зарплата + Бонус)',
    'tax' => 'Налог',
    'salary_after_tax' => 'Зарплата после налога',
    'expenses_claim' => 'Заявка на расходы (TADA)',
    'absent' => 'Отсутствует',
    'absent_deduction_formula' => '((общая зарплата / общее количество дней) * дни отсутствия)',
    'net_salary_formula' => 'Чистая зарплата = (Фактическая зарплата - Аванс + TADA)',
    'monthly' => 'ежемесячно',
    'weekly' => 'еженедельно',
    'salary_increment' => 'Повышение зарплаты',
    'increment' => 'Повышение',
    'current_salary' => 'Текущая зарплата',
    'annual_increment_percent' => 'Годовое повышение %',
    'annual_increment_amount' => 'Сумма годового повышения',
    'revised_salary_label' => 'Пересмотренная зарплата',
    'fiscal_year_label' => 'Повышение на финансовый год',
    'applicable_from_label' => 'Действительно с (дата)',
    'applicable_to_label' => 'Действительно до (дата)',
    'remark' => 'Замечание',
    'fiscal_year' => 'Финансовый год',
    'select_fiscal_year' => 'Выберите финансовый год',
    'list'=>'Список',
    'employee_salary_filter'=>'Фильтр зарплаты сотрудников',
    'salary_review_history'=>'История пересмотра зарплаты',
    'increase_salary'=>'Повысить зарплату',
    'all'=>'Все',
    'employee_payslip'=>'Расчетный лист сотрудника',
    'salary_from'=>'Зарплата с',
    'salary_to'=>'Зарплата по',
    'unpaid_leave'=>'Неоплачиваемый отпуск',
    'paid_leave'=>'Оплачиваемый отпуск',
    'employee_gross_salary'=>'Грязная зарплата сотрудника',
    'salary_increment_log'=>'Журнал повышения зарплаты',
    'log'=>'Журнал',
    'salary_revised_on'=>'Зарплата пересмотрена на',
    'increment_by'=>'Повышение на',
    'increment_value'=>'Значение повышения',
    'old_salary'=>'Старая зарплата',
    'new_salary'=>'Новая зарплата',
    'date_to'=>'Дата до',
    'date_from'=>'Дата с',
    'salary_increment_remark'=>'Замечание по повышению зарплаты',
    'advance_salary_requests'=>'Запросы на аванс',
    'advance_salary_request_filter'=>'Фильтр запросов на аванс',
    'delete_confirmation'=>'Вы уверены, что хотите удалить?',
    'payslip_for_the_month_of'=>'Расчетный лист за месяц',
    'absent_deduction'=>'Вычет за отсутствие',

    /** Advance Salary */
    'is_paid' => 'Оплачено?',
    'released_on' => 'Выпущено',
    'requested_on' => 'Запрошено',
    'released_amount' => 'Выпущенная сумма',
    'requested_amount' => 'Запрошенная сумма',
    'search_by_month' => 'Поиск по месяцу',
    'search_by_employee_name' => 'Поиск по имени сотрудника',
    'advance_salary_detail' => 'Детали авансового оклада',
    'is_settled' => 'Урегулировано',
    'verified_by' => 'Проверено',
    'amount_released_date' => 'Дата выпуска суммы',
    'advance_requested_date' => 'Дата запроса аванса',
    'total_released_amount' => 'Общая выпущенная сумма',
    'total_request_amount' => 'Общая запрашиваемая сумма',
    'employee' => 'Сотрудник',
    'select_employee' => 'Выбрать сотрудника',
    'advance_salary_request_detail' => 'Детали запроса авансового оклада',
    'proof_of_advance_salary_payment' => 'Документальное подтверждение авансового платежа',
    'attachments' => 'Вложения',
    'processing' => 'В обработке',

    /** Tax report */
    'tax_report' => 'Налоговый отчет',
    'employee_tax_report' => 'Налоговый отчет по сотруднику',
    'tax_report_edit' => 'Редактирование налогового отчета',
    'tax_report_detail_of' => 'Детали налогового отчета по',
    'tax_report_detail' => 'Детали налогового отчета',
    'salary_sheet' => 'Платежная ведомость',
    'particular' => 'Особенность',
    'income' => 'Доход',
    'tax_data_not_available' => 'Налоговые данные недоступны для текущего семейного положения',
    'remain_tds_formula' => '(Общий долг по TDS / Количество остав',
    'remaining_month' => 'Оставшийся месяц',
    'tds_calculation_msg' => 'Расчет TDS для текущего месяца (Месяц расчета)',
    'total_due_tds' => 'Общий долг по TDS',
    'total_paid_tds' => 'Всего уплачено TDS',
    'total_payable_tds' => 'Всего к уплате TDS',
    'other_discount' => 'Другие скидки',
    'female_discount' => 'Скидка для женщин',
    'medical_claim' => 'Медицинская претензия',
    'less' => 'меньше',
    'less_tax_deduction' => 'меньше: Налоговый вычет',
    'tax_amount' => 'Сумма налога',
    'percent' => 'Процент',
    'tax_calculation_on_taxable_income' => 'Расчет налога на налогооблагаемый доход',
    'taxable_income' => 'Налогооблагаемый доход',
    'ssf_contribution' => 'Взнос SSF',
    'ssf_contribution_salary' => 'Взнос SSF из зарплаты',
    'total_retirement_contribution_allowed' => 'Максимально допустимый взнос на пенсионное обеспечение',
    'total_income' => 'Общий доход',
    'amount' => 'Сумма',
    'additional_information' => 'Дополнительная информация',
    'total_payable' => 'Всего к уплате',
    'tds_paid' => 'Уплачено TDS',
    'ssf_deduction' => 'Вычет SSF',
    'tax_report_generate' => 'Сгенерировать налоговый отчет',
    'print' => 'Печать',
    'gross_earnings' => 'Валовой доход',
    'tax_payable' => 'Налог к уплате',

    /** Payroll Setting  */
    'advance_salary_limit' => 'Лимит авансового оклада',
    'select_month' => 'Выберите месяц',
    'applicable_month' => 'Применимый месяц',
    'value' => 'Значение',
    'value_type' => 'Тип значения',
    'enter_bonus_type' => 'Введите тип бонуса',
    'salary_components' => 'Компоненты зарплаты',
    'add_bonus' => 'Добавить бонус',
    'max_daily_ot' => 'Максимум ежедневного сверхурочного времени',
    'assign_overtime_to_employee' => 'Назначить сверхурочные сотруднику',
    'overtime_pay_rate' => 'Ставка оплаты сверхурочных (в час)',
    'overtime_rate_percent' => 'Процент ставки сверхурочных (в час)',
    'placeholder_overtime_pay_rate' => 'Введите ставку оплаты сверхурочных',
    'placeholder_overtime_rate_percent' => 'Введите процент ставки сверхурочных',
    'rate_type' => 'Тип ставки',
    'select_rate_type' => 'Выберите тип ставки',
    'ot_valid_after_hour' => 'Сверхурочные действительны после ? часа',
    'placeholder_ot_valid_after_hour' => 'Введите часы, после которых сверхурочные действительны',
    'monthly_ot' => 'Максимум месячных сверхурочных часов',
    'placeholder_monthly_ot' => 'Введите максимум месячных сверхурочных часов',
    'weekly_ot' => 'Максимум недельных сверхурочных часов',
    'placeholder_weekly_ot' => 'Введите максимум недельных сверхурочных часов',
    'daily_ot' => 'Максимум дневных сверхурочных часов',
    'placeholder_daily_ot' => 'Введите максимум дневных сверхурочных часов',
    'pay_percent' => 'Процент/Ставка оплаты',
    'employee_count' => 'Количество сотрудников',
    'hour' => 'Час',
    'currency_setting' => 'Настройки валюты',
    'payroll_currency' => 'Валюта расчета заработной платы',
    'choose_payroll_currency' => 'Выберите валюту расчета заработной платы',
    'add_payment_method' => 'Добавить способ оплаты',
    'payment_method_name' => 'Название способа оплаты',
    'update_payment_method' => 'Обновить способ оплаты',
    'component_value' => 'Значение компонента',
    'component_type' => 'Тип компонента',
    'add_salary_component' => 'Добавить компонент зарплаты',
    'apply_for_all' => 'Применить ко всем',
    'component_value_annual' => 'Значение компонента (ежегодно)',
    'select_value_type' => 'Выберите тип значения',
    'select_component_type' => 'Выберите тип компонента',
    'enter_salary_component_name' => 'Введите название компонента зарплаты',
    'add_salary_group' => 'Добавить группу зарплаты',
    'delete_confirm_salary_group' => 'Вы уверены, что хотите удалить детали группы?',
    'assign_employee_to_group' => 'Назначить сотрудника в группу',
    'choose_salary_component' => 'Выберите компонент зарплаты',
    'assign_salary_components' => 'Назначить компоненты зарплаты',
    'enter_salary_group_name' => 'Введите название группы зарплаты',
    'add_more_tds_detail' => 'Добавить больше деталей TDS',
    'enter_tds_in_percent' => 'Введите TDS в процентах',
    'enter_annual_salary_to' => 'Введите годовую зарплату до',
    'enter_annual_salary_from' => 'Введите годовую зарплату от',
    'select_marital_status' => 'Выберите семейное положение',
    'create_salary_tds' => 'Создать TDS зарплаты',
    'update_salary_tds' => 'Обновить TDS зарплаты',
    'salary_tds_detail_for_single' => 'Детали TDS зарплаты для холостых',
    'add_salary_tds' => 'Добавить TDS зарплаты',
    'annual_salary_to' => 'Годовая зарплата до',
    'annual_salary_from' => 'Годовая зарплата от',
    'tds' => 'TDS (%)',
    'salary_tds_detail_for_married' => 'Детали TDS зарплаты для состоящих в браке',
    'ssf' => 'SSF',
    'employee_contribution' => 'Вклад сотрудника',
    'office_contribution' => 'Вклад офиса',
    'assign_undertime_to_employee' => 'Назначить время недоработки сотруднику',
    'enter_title' => 'Введите название',
    'undertime_after_minute' => 'Минуты после которых применяется недоработка',
    'placeholder_ut_after' => 'Введите часы, после которых применяется недоработка',
    'penalty_type' => 'Тип штрафа',
    'select_penalty_type' => 'Выберите тип штрафа',
    'penalty_percent' => 'Процент штрафа (в час)',
    'penalty_percent_placeholder' => 'Введите процент штрафа за недоработку',
    'penalty_rate' => 'Ставка штрафа (в час)',
    'penalty_rate_placeholder' => 'Введите ставку штрафа за недоработку',

    /** Leave */
    'leave_type_section' => 'Раздел типа отпуска',
    'select_leave_type' => 'Выберите тип отпуска',
    'leave_type' => 'Тип отпуска',
    'leave_allocated_days' => 'Выделенные дни отпуска',
    'allocated_days' => 'Выделенные дни',
    'is_paid_leave' => 'Это оплачиваемый отпуск',
    'leave_type_name' => 'Название типа отпуска',
    'leave_type_placeholder' => 'Введите тип отпуска',
    'add_leave_type' => 'Добавить тип отпуска',
    'type' => 'Тип',
    'edit_leave_type_detail' => 'Редактировать детали типа отпуска',
    'delete_leave_type' => 'Удалить тип отпуска',
    'delete_leave_confirmation' => 'Вы уверены, что хотите удалить тип отпуска?',
    'leave_request_section' => 'Раздел запроса на отпуск',
    'approve' => 'Одобрить',
    'reject' => 'Отклонить',
    'from_date' => 'С даты',
    'to_date' => 'По дату',
    'start_time' => 'Время начала',
    'end_time' => 'Время окончания',
    'reason' => 'Причина',
    'requested_for' => 'Запрошено для',
    'requested_by' => 'Запрошено кем',
    'requested_days' => 'Запрошенные дни',
    'requested_date' => 'Дата запроса',
    'all_status' => 'Все статусы',
    'all_leave_type' => 'Все типы отпуска',
    'leave_request_filter' => 'Фильтр запросов на отпуск',
    'create_leave_request' => 'Создать запрос на отпуск',
    'leave_reason' => 'Причина отпуска',
    'referred_by' => 'Рекомендовано',
    'leave_date' => 'Дата отпуска',
    'time_leave_request_filter' => 'Фильтр запроса на отпуск по времени',
    'create_time_leave_request' => 'Создать запрос на отпуск по времени',
    'time_leave_request_section' => 'Раздел запроса на отпуск по времени',
    'time_leave_status_update' => 'Обновление статуса отпуска по времени',

    /** Team Meeting */
    'team_meeting_section' => 'Раздел командного собрания',
    'update_and' => 'обновить и',
    'create_and' => 'Создать и',
    'send' => 'Отправить',
    'meeting_participator' => 'Участник собрания',
    'image_hint' => 'Рекомендуется изображение в альбомной ориентации',
    'meeting_description' => 'Описание собрания',
    'upload_image' => 'Загрузить изображение',
    'meeting_start_time' => 'Время начала собрания',
    'meeting_date' => 'Дата собрания',
    'meeting_venue' => 'Место проведения собрания',
    'enter_venue_name' => 'Введите название места',
    'enter_content_title' => 'Введите заголовок содержимого',
    'meeting_title' => 'Заголовок собрания',
    'delete_team_meeting_confirmation' => 'Вы уверены, что хотите удалить командное собрание?',
    'image_delete_confirmation' => 'Вы уверены, что хотите удалить изображение?',
    'create_team_meeting' => 'Создать командное собрание',
    'delete_team_meeting' => 'Удалить детали командного собрания',
    'edit_meeting_detail' => 'Редактировать детали собрания',
    'show_team_meeting' => 'Показать содержание командного собрания',
    'participators' => 'Участники',
    'participator' => 'Участник',
    'team_meeting_filter' => 'Фильтр командного собрания',
    'agenda' => 'Повестка дня',
    'creator' => 'Создатель',

    /** Tada */
    'tada_attachment' => 'Вложение Tada',
    'upload_tada_attachment' => 'Загрузить вложение Tada',
    'accepted' => 'Принято',
    'tada_status_change' => 'Вы уверены, что хотите изменить статус расчета Tada?',
    'delete_tada_confirm' => 'Вы уверены, что хотите удалить :title?',
    'uploaded_attachment' => 'Загруженное вложение',
    'no_attachment_file' => 'Нет файла вложения',
    'total_expense' => 'Общие расходы',
    'create_tada' => 'Создать Tada',
    'edit_tada' => 'Редактировать Tada',
    'tada_listing' => 'Список Tada',
    'tada_filter' => 'Фильтр Tada',
    'submitted_date' => 'Дата подачи',
    'expense' => 'Расходы',
    'tada_detail' => 'Детали Tada',
    'verified_date' => 'Дата проверки',
    'tada_summary' => 'Резюме Tada',
    'update_status' => 'Обновить статус',
    'category' => 'Категория',
    'select_category' => 'Выберите категорию',
    'opening_time' => 'Время открытия',
    'closing_time' => 'Время закрытия',
    'checkin_checkout_rule' => 'Правило регистрации/выхода',
    'early_check_in' => 'Ранняя регистрация',
    'check_in_before' => 'Можно зарегистрироваться до (в минутах)',
    'checkin_before' => 'Регистрация до',
    'enter_check_in_before' => 'Введите, сколько минут до регистрации можно',
    'early_check_out' => 'Ранний выезд',
    'check_out_before' => 'Можно выехать до (в минутах)',
    'checkout_before' => 'Выезд до',
    'enter_check_out_before' => 'Введите, сколько минут до выезда можно',
    'late_check_in' => 'Поздняя регистрация',
    'check_in_after' => 'Можно зарегистрироваться после (в минутах)',
    'checkin_after' => 'Регистрация после',
    'enter_check_in_after' => 'Введите, сколько минут после регистрации можно',
    'late_check_out' => 'Поздний выезд',
    'checkout_after' => 'Выезд после',
    'check_out_after' => 'Можно выехать после (в минутах)',
    'enter_check_out_after' => 'Введите, сколько минут после выезда можно',
    'enter_shift_name' => 'Введите название смены',
    'select_shift' => 'Выберите смену',
    'delete_office_time_confirm' => 'Вы уверены, что хотите удалить расписание офиса?',
    'office_time_detail' => 'Детали времени офиса',
    'office_schedule' => 'Расписание офиса',
    'add_office_time' => 'Добавить время офиса',

    /** Award Types */
    'award_distributed' => 'Награда Распределена',
    'add_award_types' => 'Добавить Типы Наград',
    'gift_item' => 'Подарочный предмет',
    'awarded_date' => 'Дата Награждения',

    /** Award */
    'award' => 'Награда',
    'award_name' => 'Название Награды',
    'select_award_type' => 'Выберите Тип Награды',
    'enter_gift_item' => 'Введите Подарочный Предмет',
    'award_base' => 'Основа Награды',
    'select_award_base' => 'Выберите Основание Награды',
    'awarded_by' => 'Награждено От',
    'enter_awarded_by' => 'Введите Награждено От',
    'award_description' => 'Описание Награды',
    'gift_description' => 'Описание Подарка',
    'reward_code' => 'Код Награды',
    'enter_reward_code' => 'Введите Код Награды',
    'add_award' => 'Добавить Награду',
    'attachment' => 'Вложение',
    'award_lists' => 'Списки Наград',

    /** Asset Types */
    'add_asset_types' => 'Добавить Типы Активов',
    'asset_item_count' => 'Количество Элементов Активов',
    'asset_type' => 'Тип Актива',
    'asset_name' => 'Название Актива',
    'purchased_date' => 'Дата Покупки',
    'is_working' => 'Работает',
    'is_available' => 'Доступен',
    'asset' => 'Актив',

    /** Assets */
    'select_asset_type' => 'Выберите Тип Актива',
    'assigned_date' => 'Дата Назначения',
    'is_available_for_employee' => 'Доступен для Сотрудника',
    'select_availability' => 'Выберите Доступность',
    'warranty_end_date' => 'Дата Окончания Гарантии',
    'warranty_available' => 'Гарантия Доступна',
    'select_warranty_availability' => 'Выберите Доступность Гарантии',
    'asset_serial_number' => 'Серийный Номер Актива',
    'enter_asset_serial_number' => 'Введите Серийный Номер Актива',
    'asset_code' => 'Код Актива',
    'enter_asset_code' => 'Введите Код Актива',
    'change_availability_status' => 'Вы уверены, что хотите изменить статус доступности?',
    'delete_asset_confirm' => 'Вы уверены, что хотите удалить :title?',
    'add_asset' => 'Добавить Актив',
    'asset_image' => 'Изображение Актива',
    'asset_assigned_employee' => 'Сотрудник, Назначенный к Активу',
    'assets_filter' => 'Фильтр Активов',
    'working_status' => 'Статус Работы',
    'availability_status' => 'Статус Доступности',
    'yes_available' => 'Да, Доступен',
    'notavailable' => 'Не Доступен',
    'purchased_from' => 'Куплен от',
    'purchased_to' => 'Куплен для',

    /** Content Management */
    'content_section' => 'Раздел контента',
    'content' => 'Контент',
    'content_type' => 'Тип контента',
    'content_title' => 'Название контента',
    'select_content_type' => 'Выберите тип контента',
    'delete_content_confirm' => 'Вы уверены, что хотите удалить содержимое статической страницы?',
    'company_static_content' => 'Статический контент компании',
    'add_content' => 'Добавить контент',

    /** Support */
    'delete_support_confirm' => 'Вы уверены, что хотите удалить :title?',
    'ticket_lists' => 'Списки заявок',
    'query_by' => 'Запрос от',
    'concerned_department' => 'Затронутый отдел',
    'unseen' => 'Не просмотрено',
    'read_status' => 'Статус прочтения',
    'seen' => 'Просмотрено',
    'query_status' => 'Статус запроса',
    'support_filter' => 'Фильтр поддержки',
    'query_lists' => 'Списки запросов',
    'department_support_requested_from' => 'Поддержка запрашивается из отдела',
    'department_support_requested_to' => 'Поддержка запрашивается в отдел',
    'change_query_status' => 'Изменить статус запроса',

    /** Router */
    'router_section' => 'Раздел роутера',
    'router_bssid' => 'BSSID роутера',
    'router' => 'Роутер',
    'router_detail' => 'Детали роутера',
    'add_router' => 'Добавить роутер',

    /** QR */
    'scan_me' => 'Сканируй меня',
    'attendance_qr' => 'QR посещаемости',
    'qr_image' => 'Изображение QR',
    'add_qr' => 'Добавить QR',
    'qr_section' => 'Раздел QR',

    /** NFC */
    'nfc_section' => 'Раздел NFC',
    'created_by' => 'Создано',

    /** Role and permission */
    'role_section' => 'Раздел ролей',
    'autorize_backend_login' => 'Авторизовать вход в админку',
    'role_name' => 'Название роли',
    'permissions' => 'Разрешения',
    'check_all' => 'Выбрать все',
    'module' => 'Модуль',
    'add_role' => 'Добавить роль',
    'assign_permissions' => 'Назначить разрешения',
    'confirm_role_deletion' => 'Вы уверены, что хотите удалить роль?',
    'can_login' => 'Может войти',
    'permission_setting' => 'Настройка разрешений',
    'assign' => 'Назначить',

    /** General Setting */
    'general_setting_section' => 'Раздел общих настроек',
    'general_setting' => 'Общие настройки',

    /** App Setting */
    'export_database_data' => 'Экспорт данных базы данных',
    'check_router_bssid' =>'Проверить BSSID роутера',

    /** Fiscal Years */
    'fiscal_years' => 'Финансовые годы',
    'year' => 'Год',
    'add_fiscal_year' => 'Добавить финансовый год',

    /** Notifications */
    'notification_section' => 'Раздел уведомлений',
    'confirm_notification_send' => 'Вы уверены, что хотите отправить уведомление?',
    'notification' => 'Уведомление',
    'published_date' => 'Дата публикации',
    'all_types' => 'Все типы',
    'notification_lists' => 'Списки уведомлений',
    'notified_member' => 'Уведомленный участник',
    'notification_title' => 'Заголовок уведомления',
    'notification_description' => 'Описание уведомления',
    'send_notification' => 'Отправить уведомление',
    'enter_notification_title' => 'Введите заголовок уведомления',

    /** feature control */
    'app_setting' => 'Настройки приложения',
    'sn' => 'Серийный номер',
    'group' => 'Группа',
    'export_table_data' => 'Экспорт данных таблицы',
    'leave_requests' => 'Запросы на отпуск',
    'employee_lists' => 'Списки сотрудников',
    'attendances' => 'Посещаемость',
    'confirm_change_status' => 'Вы уверены, что хотите изменить статус?',
    'yes' => 'Да',
    'no' => 'Нет',

    /** Api response */
    /** Auth Controller */
    'invalid_login_credentials'=>'Недействительные учетные данные!',
    'authenticated'=>'Аутентифицирован',
    'user_detail_not_found'=>'Данные пользователя не найдены',
    'partial_logout_successful'=>'Частичный выход выполнен успешно',
    /** Dashboard Controller */
    'data_found'=>'Данные найдены',
    /** AdvanceSalary Controller */
    'advance_salary_pending_error'=>'Невозможно запросить еще одну авансовую зарплату до урегулирования предыдущего запроса.',
    'data_updated_successfully'=>'Данные успешно обновлены',
    'user_updated_advance_salary_request' => ':name обновил данные запроса авансовой зарплаты',
    'data_created_successfully'=>'Данные успешно созданы',
    'advance_salary_request_alert'=>'Оповещение о запросе авансовой зарплаты',
    'user_submitted_advance_salary_request' => ':name подал запрос на авансовую зарплату в размере :amount',
    /** Attendance Api */
    'check_out_successful'=>'Выход выполнен успешно',
    'check_out_notification'=>'Уведомление о выходе',
    'check_in_successful'=>'Вход выполнен успешно',
    'check_in_notification'=>'Уведомление о входе',
    'not_checked_in_yet'=>'Еще не выполнен вход',
    'alert_multi_checkin_shift'=>'Извините! Сотрудник не может выполнить вход дважды за смену.',
    'checkout_alert_for_shift'=>'Сотрудник уже выполнил выход из смены',
    'alert_checkin'=>'Извините! Сотрудник не может выполнить вход дважды за день.',
    'checkout_alert'=>'Сотрудник уже выполнил выход сегодня',
    'attendance_alert_status'=>':status уже выполнено',
    'employee_checked_in' => ':name выполнил вход в :time',
    'employee_checked_out' => ':name выполнил выход в :time',
    'has_worked_for' => 'и проработал :time',
    'multi_checkout_warning'=>'Вы достигли максимального количества входов и выходов, разрешенных на сегодня.',
    'employee_checked_out_and_worked' => ':name выполнил выход в :check_out_time и проработал :worked_time',
    'invalid_attendance_type'=>'Недействительный тип посещаемости.',
    'invalid_qr'=>'Недействительный QR-код или QR-код не доступен',
    'invalid_nfc'=>'Недействительный NFC токен или NFC не доступен',
    'validation_failed'=>'Ошибка валидации',

    /** Leave Api Controller */
    'leave_request_cancelled' => 'Запрос на отпуск успешно отменен',
    'leave_request_cannot_be_cancelled' => 'Запрос на отпуск не может быть отменен после обновления из состояния ожидания.',
    'leave_request_notification' => 'Уведомление о запросе на отпуск',
    'leave_request_submitted' => ':name запросил отпуск с :start_time по :end_time на :issue_date. Причина: :reasons',
    'leave_request_submitted_successfully' => 'Запрос на отпуск успешно отправлен',
    'leave_request_cancelled_successfully' => 'Запрос на отпуск успешно отменен',
    'leave_request_submit' => ':name запросил :no_of_days день(ей) отпуска с :leave_from на :leave_requested_date. Причина: :reasons',

    /** NFC api Controller */
    'nfc_token_already_exist' => 'Токен NFC уже существует.',
    'nfc_added_successfully' => 'NFC успешно добавлен',

    /** Notification Api Controller */
    'updated_successfully' => 'Успешно обновлено',
    'successfully_sent_notification' => 'Уведомление успешно отправлено',
    'data_not_found' => 'Данные не найдены',
    'content_not_found' => 'Содержание не найдено',

    /** Support Api Controller */
    'support_notification' => 'Уведомление о поддержке',
    'support_request_submitted' => ':name запросил поддержку.',
    'query_submitted_successfully' => 'Запрос успешно отправлен',

    /** Tada Api Controller  */
    'attachment_detail_not_found' => 'Детали вложения не найдены',
    'cannot_delete_attachment_detail' => 'Невозможно удалить детали вложения после проверки',
    'upload_another_attachment_before_delete' => 'Пожалуйста, загрузите другое вложение перед удалением.',
    'attachment_deleted_successfully' => 'Вложение успешно удалено',
    'tada_update_alert' => 'Вы не можете обновить детали после проверки, пожалуйста, свяжитесь с администратором',
    'tada_notification' => ':name отправил новый TADA для :title',
    'tada_detail_notification' => ':name обновил детали отправленного TADA для :title',
    'tada_alert' => 'Предупреждение TADA',

    /** TaskDetailApi Controller */
    'status_changed_successfully' => 'Статус успешно изменен',
    'task_detail_not_found' => 'Детали задачи не найдены',

    /** TaskCheckListApi Controller */
    'status_updated_successfully' => 'Статус успешно обновлен',

    /** TaskCommentApi Controller */
    'comment_notification' => 'Уведомление о комментарии',
    'task_mention' => 'Вы упомянуты в задаче :task :type',
    'comment_reply' => 'Ответ на комментарий',
    'comment_reply_deleted_successfully' => 'Ответ на комментарий успешно удален',
    'comment_deleted_successfully' => 'Комментарий успешно удален',
    'comment_added_successfully' => 'Комментарий успешно добавлен',

    /** userProfile Api */
    'invalid_base64_image' => 'Значение Base64 не является допустимым изображением',
    'demo_version' => 'Это демоверсия. Пожалуйста, приобретите приложение для использования всех функций',
    'user_not_found' => 'Данные пользователя не найдены',
    'profile_updated' => 'Профиль успешно обновлен',
    'incorrect_current_password' => 'Неправильный текущий пароль',
    'new_password_same_as_old' => 'Новый пароль не может быть таким же, как старый пароль',
    'password_changed' => 'Пароль успешно изменен',

    /** leave_approval */
    'leave_approval'=>'Одобрение отпуска',
    'leave_approval_list'=>'Список одобрений отпуска',
    'add_leave_approval'=>'Добавить одобрение отпуска',
    'subject'=>'Тема',
    'related'=>'Связанный',
    'select_related'=>'Выбрать связанный',
    'max_days_to_sign'=>'Максимальное количество дней для подписания',
    'notification_recipient'=>'Получатель уведомления',
    'select_notification_recipient'=>'Выбрать получателя уведомления',
    'approval_process' =>'Процесс одобрения',
    'approver'=>'Утверждающий',
    'select_approver'=>'Выбрать утверждающего',
    'head_of_department'=>'Глава отдела',
    'specific_personnel'=>'Определенный персонал',
    'applicable_from'=>'Применимо с',

    /** Event Management */
    'event_section'=>'Раздел событий',
    'event_title'=>'Название события',
    'event_location'=>'Место события',
    'event_start_date'=>'Дата начала события',
    'event_start_time'=>'Время начала события',
    'event_end_date'=>'Дата окончания события',
    'event_end_time'=>'Время окончания события',
    'all_departments'=>'Все отделы',
    'delete_event_confirmation'=>'Вы уверены, что хотите удалить это событие?',
    'create_event'=>'Создать событие',
    'show_event'=>'Показать событие',
    'event_calendar'=>'Календарь событий',

    'admin_permission_msg' => 'Если этот параметр будет выбран, все шаги иерархии будут пропущены, и пользователи с этой ролью смогут просматривать и редактировать все отпуска. Оставьте этот параметр для специальных ролей, таких как HR',
    'coming_soon' => 'Вскоре',
    'assign_trainer_section' => 'Раздел назначения тренера',
    'assign_trainer' => 'Назначить тренера',

    'export_csv' => 'Экспорт CSV',

    /** Termination Management */
    'termination_types'=>'Типы увольнения',
    'select_termination_type'=>'Выберите тип увольнения',
    'termination'=>'Увольнение',
    'add_termination'=>'Добавить увольнение',
    'termination_list'=>'Список увольнений',
    'total_termination'=>'Общее количество увольнений',
    'termination_type'=>'Тип увольнения',
    'termination_management'=>'Управление увольнениями',
    'add_termination_types'=>'Добавить типы увольнения',
    'termination_date'=>'Дата увольнения',
    'notice_date'=>'Дата уведомления',

    /** Resignation Management */
    'resignation_types'=>'Типы отставки',
    'select_resignation_type'=>'Выберите тип отставки',
    'resignation'=>'Отставка',
    'add_resignation'=>'Добавить отставку',
    'resignation_list'=>'Список отставок',
    'total_resignation'=>'Общее количество отставок',
    'resignation_type'=>'Тип отставки',
    'resignation_management'=>'Управление отставками',
    'add_resignation_types'=>'Добавить типы отставки',
    'resignation_date'=>'Дата отставки',
    'last_date'=>'Последняя дата',
    'last_working_day'=>'Последний рабочий день',
    'resignation_notification' => 'Запрос на отставку',
    'resignation_submit' => ':name подал запрос на отставку :resignation_date, вступающий в силу с :last_working_day.',
    'resignation_submitted_successfully' => 'Отставка успешно подана',
    'resignation_fetched_successfully' => 'Отставка успешно получена',
    'resignation_exist_error' => 'Ваша отставка уже :status.',
    'document' => 'Документ',
    'venue' => 'Место',

    /** Warning Management */
    'select_warning_type'=>'Выберите тип предупреждения',
    'warning'=>'Предупреждение',
    'message'=>'Сообщение',
    'add_warning'=>'Добавить предупреждение',
    'warning_list'=>'Список предупреждений',
    'total_warning'=>'Общее количество предупреждений',
    'warning_type'=>'Тип предупреждения',
    'warning_management'=>'Управление предупреждениями',
    'add_warning_types'=>'Добавить типы предупреждений',
    'warning_date'=>'Дата предупреждения',
    'warning_notification' => 'Запрос на предупреждение',
    'warning_submit' => ':name подал ответ на предупреждение относительно :subject, выданное :date ',
    'warning_submitted_successfully' => 'Предупреждение успешно подано',
    'response_submitted_successfully' => 'Ваш ответ успешно записан',
    'warning_fetched_successfully' => 'Предупреждение успешно получено',
    'warning_exist_error' => 'Ваш ответ уже записан.',
    'response_section' => 'Раздел ответа',
    'response' => 'Ответ',

    /** Complaint Management */
    'select_complaint_type'=>'Выберите тип жалобы',
    'complaint'=>'Жалоба',
    'complaint_from'=>'Жалоба от',
    'add_complaint'=>'Добавить жалобу',
    'complaint_list'=>'Список жалоб',
    'total_complaint'=>'Общее количество жалоб',
    'complaint_type'=>'Тип жалобы',
    'complaint_management'=>'Управление жалобами',
    'add_complaint_types'=>'Добавить типы жалоб',
    'complaint_date'=>'Дата жалобы',
    'complaint_notification' => 'Запрос на жалобу',
    'complaint_submit' => 'Ответ на жалобу относительно :subject, выданную :date, был подан',
    'complaint_submitted_successfully' => 'Жалоба успешно подана',
    'complaint_fetched_successfully' => 'Жалоба успешно получена',
    'complaint_exist_error' => 'Ваш ответ уже записан.',
    'complain_to' => 'Пожаловаться на',

    'hr_admin_setup' => 'Настройка администратора HR',
    'edit_branch' => 'Редактировать филиал',
    'branch_head_error'=>'Выбранный пользователь уже является руководителем другого филиала, пожалуйста, выберите другого пользователя',
    'department_head_error'=>'Выбранный пользователь уже является руководителем другого отдела, пожалуйста, выберите другого пользователя',

    /** Promotion Management */
    'promotion'=>'Повышение',
    'add_promotion'=>'Добавить повышение',
    'promotion_list'=>'Список повышений',
    'promotion_section'=>'Раздел повышения',
    'total_promotion'=>'Общее количество повышений',
    'promotion_type'=>'Тип повышения',
    'promotion_management'=>'Управление повышениями',
    'add_promotion_types'=>'Добавить типы повышений',
    'promotion_date'=>'Дата повышения',
    'promotion_notification' => 'Запрос на повышение',
    'promotion_submitted_successfully' => 'Повышение успешно подано',
    'promotion_fetched_successfully' => 'Повышение успешно получено',

    'select_post' => 'Выберите должность',
    'old_post' => 'Старая должность',
    'new_post' => 'Новая должность',

    /** Transfer Management */
    'transfer'=>'Перевод',
    'transfer_details'=>'Детали перевода',
    'add_transfer'=>'Добавить перевод',
    'transfer_list'=>'Список переводов',
    'transfer_section'=>'Раздел перевода',
    'total_transfer'=>'Общее количество переводов',
    'transfer_type'=>'Тип перевода',
    'transfer_management'=>'Управление переводами',
    'add_transfer_types'=>'Добавить типы переводов',
    'transfer_date'=>'Дата перевода',
    'transfer_notification' => 'Запрос на перевод',
    'transfer_submitted_successfully' => 'Перевод успешно подан',
    'transfer_fetched_successfully' => 'Перевод успешно получен',
    'old_branch' => 'Старый филиал',
    'new_branch' => 'Новый филиал',
    'old_department' => 'Старый отдел',
    'new_department' => 'Новый отдел',

    /** theme color */
    'theme_color'=>'Цвет темы',
    'background_color'=>'Цвет фона',
    'primary_color'=>'Основной цвет',
    'hover_color'=>'Цвет при наведении',
    'dark_primary_color'=>'Темный основной цвет',
    'dark_hover_color'=>'Темный цвет при наведении',

    /** Admin Management */
    'users'=>'Пользователи',
    'user_section'=>'Раздел пользователя',
    'add_user'=>'Добавить пользователя',
    'user_management'=>'Управление пользователями',
    'user'=>'Пользователь',

    'office_time_not_found'=>'Время офиса не найдено',
    'asset_type_not_found'=>'Тип актива не найден',
    'employee_not_found'=>'Сотрудники не найдены',
    'error_loading_asset_types'=>'Ошибка загрузки типов активов',
    'error_loading_employees'=>'Ошибка загрузки сотрудников',
    'error_loading_termination_types'=>'Ошибка загрузки типов увольнения',
    'error_loading_department'=>'Ошибка загрузки отделов',
    'leave_type_not_found'=>'Тип отпуска не найден',
    'error_loading_leave_types'=>'Ошибка загрузки типов отпусков',
    'no_department_found'=>'Отдел не найден',
    'award_filter'=>'Фильтр наград',
    'select_award'=>'Выберите награду',
    'award_type_not_found'=>'Тип награды не найден',
    'termination_filter'=>'Фильтр увольнения',
    'training_type_filter'=>'Фильтр типов обучения',
    'asset_type_filter'=>'Фильтр типов активов',
    'award_type_filter'=>'Фильтр типов наград',
    'termination_type_filter'=>'Фильтр типов увольнения',
    'resignation_filter'=>'Фильтр отставок',
    'promotion_filter'=>'Фильтр повышений',
    'complaint_filter'=>'Фильтр жалоб',
    'warning_filter'=>'Фильтр предупреждений',
    'transfer_filter'=>'Фильтр переводов',
    'trainer_filter'=>'Фильтр тренеров',
    'office_time_filter'=>'Фильтр рабочего времени',
    'leave_type_filter'=>'Фильтр типов отпусков',
    'client_filter'=>'Фильтр клиентов',
    'router_filter'=>'Фильтр маршрутизаторов',
    'project_not_found'=>'Проект не найден',
    'error_loading_training_types'=>'Ошибка загрузки типов обучения',

    'post_filter'=>'Фильтр постов',
    'event_filter'=>'Фильтр событий',
    'training_filter'=>'Фильтр тренингов',
    'post_lists'=>'Списки постов',
    'tada_lists'=>'Списки Тада',
    'advance_salary_filter'=>'Фильтр авансовой зарплаты',
    'log_filter'=>'Фильтр журнала посещаемости',
    'advance_salary_lists'=>'Списки авансовой зарплаты',
    'logout_request_filter'=>'Фильтр запросов на выход',
    'leave_approval_filter'=>'Фильтр одобрения отпуска',
    'user_list'=>'Список пользователей',
    'projects_not_found'=>'Проекты не найдены',
    'attendance_logs'=>'Журналы посещаемости',
    'attendance_type'=>'Тип посещаемости',
    'identifier'=>'Идентификатор',
    'nfc_lists'=>'Списки NFC',
    'qr_lists'=>'Списки QR',
    'qr_filter'=>'Фильтр QR',
    'nfc_filter'=>'Фильтр NFC',
    'select_notice_receiver'=>'Выберите получателя уведомления',
    'generated_salary_lists'=>'Списки сгенерированных зарплат',
    'employee_salaries'=>'Зарплаты сотрудников',
    'select_meeting_participants'=>'Выберите участников собрания',
    'employee_filter'=>'Фильтр сотрудников',
    'attendance_filter'=>'Фильтр посещаемости',
    'notice_filter'=>'Фильтр уведомлений',
    'award_type_lists'=>'Списки типов наград',
    'termination_type_lists'=>'Списки типов увольнений',
    'holiday_lists'=>'Списки праздников',
    'asset_lists'=>'Списки активов',
    'router_lists'=>'Списки роутеров',
    'meeting_list'=>'Списки собраний',
    'app_qr'=>'QR приложения',
    'digital_hr_dashboard'=>'Цифровая панель HR',
    'training_type_list'=>'Список типов тренингов',
    'time_leave_list'=>'Списки запросов на отпуск по времени',
    'support_list'=>'Списки поддержки',
    'role_list'=>'Списки ролей',
    'asset_type_list'=>'Списки типов активов',
    'add_undertime'=>'Добавить недоработку',
    'threshold_time'=>'Пороговое время',
    'ssf_rule'=>'Правило SSF',
    'upload_warning'=>'Пожалуйста, загрузите хотя бы один документ, когда статус одобрен',

    'check_in_latitude'=>'Широта входа',
    'check_in_longitude'=>'Долгота входа',
    'check_out_latitude'=>'Широта выхода',
    'check_out_longitude'=>'Долгота выхода',
];
