@extends('layouts.master')

@section('title', __('index.employee_tax_report'))

@section('action', __('index.tax_report_detail'))

@section('main-content')
    <section class="content">
        @include('admin.section.flash_message')
        @include('admin.payroll.taxReport.common.breadcrumb')
    </section>

    <div class="card">
        <div class="card-header d-md-flex justify-content-md-between align-items-center pb-2 justify-content-center text-md-start text-center">
            <h6 class="card-title mb-2">{{ __('index.tax_report_detail_of') }} {{ $reportData->employee->name }} ({{ $reportData->fiscalYear->year }})</h6>
            <div class="edit-print mb-2">
                <a class="me-2" href="{{ route('admin.payroll.tax-report.print', $reportData->id) }}" target="_blank">
                    <i class="link-icon" data-feather="printer"></i>
                </a>
                <a href="{{ route('admin.payroll.tax-report.edit', $reportData->id) }}">
                    <i class="link-icon" data-feather="edit"></i>
                </a>
            </div>
        </div>
        <div class="card-body">
            <div class="salary-sheet">
                <div class="table-responsive mb-4">
                    <h5 class="text-lg-start text-center mb-3">{{ __('index.salary_sheet') }}</h5>
                    <table class="table table-bordered">
                        <thead class="thead-dark">
                        <tr>
                            <th colspan="2">{{ __('index.particular') }}</th>
                            <th>{{ __('index.total') }}</th>
                            @php
                                $isBsEnabled = \App\Helpers\AppHelper::ifDateInBsEnabled();

                                $monthData = json_decode($reportData->months, true) ?? [];
                                $totalMonth = count($monthData);
                                $firstDay = $reportData->fiscalYear->start_date;
                                $lastDay = $reportData->fiscalYear->end_date;
                                $startMonth =  (int)\App\Helpers\AppHelper::getMonthValue($firstDay) ;
                                $endMonth =  (int)\App\Helpers\AppHelper::getMonthValue($lastDay) ;
                                $allMonths = [];
                                $totalBonusTax = 0;
                                $totalBonusAmount = 0;
                                for ($i = 0; $i < 12; $i++) {
                                    $allMonths[] = (($startMonth + $i - 1) % 12) + 1;
                                }

                                $months = $isBsEnabled ? [
                                    1 => 'Baishakh', 2 => 'Jestha', 3 => 'Asar', 4 => 'Shrawan', 5 => 'Bhadra', 6 => 'Ashwin',
                                    7 => 'kartik', 8 => 'Mangsir', 9 => 'Poush', 10 => 'Magh', 11 => 'Falgun', 12 => 'Chaitra'
                                ] :[
                                    1 => 'January', 2 => 'February', 3 => 'March', 4 => 'April', 5 => 'May', 6 => 'June',
                                    7 => 'July', 8 => 'August', 9 => 'September', 10 => 'October', 11 => 'November', 12 => 'December'
                                ];
                                $monthlyTotals = array_fill(1, 12, 0);
                                $totalMonthlyDeduction = array_fill(1, 12, 0);
                                $monthlyTDS = array_fill(1, 12, 0);
                                $totalAnnualIncome = 0;
                                $totalAnnualDeduction = 0;
                                $totalTds = 0;

                                // Initialize monthly values from reportDetail
                                $monthlyBasicSalary = [];
                                $monthlyFixedAllowance = [];
                                $monthlySsfContribution = [];
                                $monthlySsfDeduction = [];

                                foreach ($reportData->reportDetail as $detail) {
                                    $month = $detail->month;
                                    $monthlyBasicSalary[$month] = $detail->basic_salary ?? 0;
                                    $monthlyFixedAllowance[$month] = $detail->fixed_allowance ?? 0;
                                    if($reportData->total_ssf_contribution >0){
                                        $monthlySsfContribution[$month] = $detail->ssf_contribution ?? 0;
                                        $monthlySsfDeduction[$month] = $detail->ssf_deduction ?? 0;
                                    }

                                }

                                    // Aggregate earning components by month and component name
                                    $earningComponentsByName = [];
                                    foreach ($reportData->componentDetail as $detail) {
                                        if ($detail->salaryComponent->component_type === 'earning') {
                                            $name = $detail->salaryComponent->name ?? 'Unknown Earning';
                                            $month = $detail->month;
                                            $earningComponentsByName[$name][$month] = $detail->amount ?? 0;
                                            if (in_array($month, $monthData)) {
                                                $monthlyTotals[$month] += $detail->amount ?? 0;
                                                $totalAnnualIncome += $detail->amount ?? 0;
                                            }
                                        }
                                    }

                                    // Aggregate deduction components by month and component name
                                    $deductionComponentsByName = [];
                                    foreach ($reportData->componentDetail as $detail) {
                                        if ($detail->salaryComponent->component_type === 'deductions') {
                                            $name = $detail->salaryComponent->name ?? 'Unknown Deduction';
                                            $month = $detail->month;
                                            $deductionComponentsByName[$name][$month] = $detail->amount ?? 0;
                                            if (in_array($month, $monthData)) {
                                                $totalMonthlyDeduction[$month] += $detail->amount ?? 0;
                                                $totalAnnualDeduction += $detail->amount ?? 0;
                                            }
                                        }
                                    }
                                  // Aggregate additional earning components by month and component name
                                    $additionalEarningComponentsByName = [];
                                    foreach ($reportData->additionalDetail as $detail) {
                                        if ($detail->salaryComponent->component_type === 'earning') {
                                            $name = $detail->salaryComponent->name ?? 'Unknown Earning';
                                            $month = $detail->month;
                                            $additionalEarningComponentsByName[$name][$month] = $detail->amount ?? 0;
                                            if (in_array($month, $monthData)) {
                                                $monthlyTotals[$month] += $detail->amount ?? 0;
                                                $totalAnnualIncome += $detail->amount ?? 0;
                                            }
                                        }
                                    }
                                    // additional components
                                    $additionalDeductionComponentsByName = [];
                                    foreach ($reportData->additionalDetail as $detail) {
                                        if ($detail->salaryComponent->component_type === 'deductions') {
                                            $name = $detail->salaryComponent->name ?? 'Unknown Deduction';
                                            $month = $detail->month;
                                            $additionalDeductionComponentsByName[$name][$month] = $detail->amount ?? 0;
                                            if (in_array($month, $monthData)) {
                                                $totalMonthlyDeduction[$month] += $detail->amount ?? 0;
                                                $totalAnnualDeduction += $detail->amount ?? 0;
                                            }
                                        }
                                    }

                                // Aggregate bonus details
                                $bonusComponentsByMonth = [];
                                foreach ($reportData->bonusDetail as $bonus) {
                                    $month = $bonus->month;
                                    if (in_array($month, $monthData)) {
                                        $name = $bonus->bonus->title ?? 'Bonus';
                                        $bonusComponentsByMonth[$name][$month] = $bonus->amount ?? 0;
                                        $monthlyTotals[$month] += $bonus->amount ?? 0;
                                        $totalAnnualIncome += $bonus->amount ?? 0;
                                        $totalBonusTax += $bonus->tax ?? 0;
                                        $totalBonusAmount += $bonus->amount ?? 0;

                                    }
                                }

                                // Aggregate TDS details
                                foreach ($reportData->tdsDetail as $tdsDetail) {
                                    $monthlyTDS[$tdsDetail->month] = $tdsDetail->amount;
                                }

                                $totalTds =  $reportData->total_payable_tds;
                                // Add totals from reportDetail
                                $totalAnnualIncome += $reportData->total_basic_salary + $reportData->total_allowance;
                                $totalAnnualDeduction += $reportData->total_ssf_deduction;
                            @endphp
                            @foreach($allMonths as $month)
                                <th>{{ $months[$month] }}</th>
                            @endforeach
                        </tr>
                        </thead>
                        <tbody>
                        <tr>
                            <th colspan="{{ 3 + count($allMonths) }}" class="bg-light">{{ __('index.income') }}</th>
                        </tr>
                        <tr>
                            <td></td>
                            <td>{{ __('index.basic_salary') }}</td>
                            <td>{{ $currency }} {{ number_format($reportData->total_basic_salary, 2) }}</td>
                            @foreach($allMonths as $month)
                                @php $showData = in_array($month, $monthData); @endphp
                                @if($showData)
                                    @php $monthlyTotals[$month] += $monthlyBasicSalary[$month] ?? 0; @endphp
                                    <td>{{ $currency }} {{ number_format($monthlyBasicSalary[$month] ?? 0, 2) }}</td>
                                @else
                                    <td></td>
                                @endif
                            @endforeach
                        </tr>
                        <tr>
                            <td></td>
                            <td>{{ __('index.fixed_allowance') }}</td>
                            <td>{{ $currency }} {{ number_format($reportData->total_allowance, 2) }}</td>
                            @foreach($allMonths as $month)
                                @php $showData = in_array($month, $monthData); @endphp
                                @if($showData)
                                    @php $monthlyTotals[$month] += $monthlyFixedAllowance[$month] ?? 0; @endphp
                                    <td>{{ $currency }} {{ number_format($monthlyFixedAllowance[$month] ?? 0, 2) }}</td>
                                @else
                                    <td></td>
                                @endif
                            @endforeach
                        </tr>
                        @foreach($earningComponentsByName as $name => $values)
                            <tr>
                                <td></td>
                                <td>{{ $name }}</td>
                                @php
                                    $isFixed = false;
                                    $annualAmount = 0;
                                    foreach ($reportData->componentDetail as $detail) {
                                        if ($detail->salaryComponent->component_type === 'earning' && $detail->salaryComponent->name === $name) {
                                            $isFixed = $detail->salaryComponent->value_type === 'fixed';
                                            if ($isFixed) {
                                                $annualAmount = $detail->salaryComponent->annual_component_value ?? 0;
                                            } else {
                                                $annualAmount = array_sum(array_intersect_key($values, array_flip($monthData)));
                                            }
                                            break;
                                        }
                                    }
                                    if (!$isFixed) {
                                        $annualAmount = array_sum(array_intersect_key($values, array_flip($monthData)));
                                    }
                                @endphp
                                <td>{{ $currency }} {{ number_format($annualAmount, 2) }}</td>
                                @foreach($allMonths as $month)
                                    @php $showData = in_array($month, $monthData); @endphp
                                    @if($showData)
                                        <td>{{ $currency }} {{ number_format($values[$month] ?? 0, 2) }}</td>
                                    @else
                                        <td></td>
                                    @endif
                                @endforeach
                            </tr>
                        @endforeach
                        @foreach($additionalEarningComponentsByName as $name => $values)
                            <tr>
                                <td></td>
                                <td>{{ $name }}</td>
                                @php
                                    $isFixed = false;
                                    $annualAmount = 0;
                                    foreach ($reportData->additionalDetail as $detail) {
                                        if ($detail->salaryComponent->component_type === 'earning' && $detail->salaryComponent->name === $name) {
                                            $isFixed = $detail->salaryComponent->value_type === 'fixed';
                                            if ($isFixed) {
                                                $annualAmount = $detail->salaryComponent->annual_component_value ?? 0;
                                            } else {
                                                $annualAmount = array_sum(array_intersect_key($values, array_flip($monthData)));
                                            }
                                            break;
                                        }
                                    }
                                    if (!$isFixed) {
                                        $annualAmount = array_sum(array_intersect_key($values, array_flip($monthData)));
                                    }
                                @endphp
                                <td>{{ $currency }} {{ number_format($annualAmount, 2) }}</td>
                                @foreach($allMonths as $month)
                                    @php $showData = in_array($month, $monthData); @endphp
                                    @if($showData)
                                        <td>{{ $currency }} {{ number_format($values[$month] ?? 0, 2) }}</td>
                                    @else
                                        <td></td>
                                    @endif
                                @endforeach
                            </tr>
                        @endforeach
                        @foreach($bonusComponentsByMonth as $name => $values)
                            <tr>
                                <td></td>
                                <td>{{ $name }}</td>
                                @php
                                    $annualAmount = array_sum(array_intersect_key($values, array_flip($monthData)));
                                @endphp
                                <td>{{ $currency }} {{ number_format($annualAmount, 2) }}</td>
                                @foreach($allMonths as $month)
                                    @php $showData = in_array($month, $monthData); @endphp
                                    @if($showData)
                                        <td>{{ $currency }} {{ number_format($values[$month] ?? 0, 2) }}</td>
                                    @else
                                        <td></td>
                                    @endif
                                @endforeach
                            </tr>
                        @endforeach
                        <tr class="highlight">
                            <th colspan="2">{{ __('index.total_earning') }}</th>
                            <th>{{ $currency }} {{ number_format($totalAnnualIncome, 2) }}</th>
                            @foreach($allMonths as $month)
                                @if(in_array($month, $monthData))
                                    <th>{{ $currency }} {{ number_format($monthlyTotals[$month], 2) }}</th>
                                @else
                                    <th></th>
                                @endif
                            @endforeach
                        </tr>
                        <tr>
                            <th colspan="{{ 3 + count($allMonths) }}" class="bg-light">{{ __('index.deductions') }}</th>
                        </tr>
                        @if($reportData->total_ssf_deduction >0)
                            <tr>
                                <td></td>
                                <td>{{ __('index.ssf_deduction') }} ({{ __('index.salary') }})</td>
                                <td>{{ $currency }} {{ number_format($reportData->total_ssf_deduction, 2) }}</td>
                                @foreach($allMonths as $month)
                                    @php $showData = in_array($month, $monthData); @endphp
                                    @if($showData)
                                        @php $totalMonthlyDeduction[$month] += $monthlySsfDeduction[$month] ?? 0; @endphp
                                        <td>{{ $currency }} {{ number_format($monthlySsfDeduction[$month] ?? 0, 2) }}</td>
                                    @else
                                        <td></td>
                                    @endif
                                @endforeach
                            </tr>
                        @endif
                        @foreach($deductionComponentsByName as $name => $values)
                            <tr>
                                <td></td>
                                <td>{{ $name }}</td>
                                @php
                                    $isFixed = false;
                                    $annualAmount = 0;
                                    foreach ($reportData->componentDetail as $detail) {
                                        if ($detail->salaryComponent->component_type === 'deductions' && $detail->salaryComponent->name === $name) {
                                            $isFixed = $detail->salaryComponent->value_type === 'fixed';
                                            if ($isFixed) {
                                                $annualAmount = $detail->salaryComponent->annual_component_value ?? 0;
                                            } else {
                                                $annualAmount = array_sum(array_intersect_key($values, array_flip($monthData)));
                                            }
                                            break;
                                        }
                                    }
                                    if (!$isFixed) {
                                        $annualAmount = array_sum(array_intersect_key($values, array_flip($monthData)));
                                    }
                                @endphp
                                <td>{{ $currency }} {{ number_format($annualAmount, 2) }}</td>
                                @foreach($allMonths as $month)
                                    @php $showData = in_array($month, $monthData); @endphp
                                    @if($showData)
                                        <td>{{ $currency }} {{ number_format($values[$month] ?? 0, 2) }}</td>
                                    @else
                                        <td></td>
                                    @endif
                                @endforeach
                            </tr>
                        @endforeach

                        @foreach($additionalDeductionComponentsByName as $name => $values)
                            <tr>
                                <td></td>
                                <td>{{ $name }}</td>
                                @php
                                    $isFixed = false;
                                    $annualAmount = 0;
                                    foreach ($reportData->additionalDetail as $detail) {
                                        if ($detail->salaryComponent->component_type === 'deductions' && $detail->salaryComponent->name === $name) {
                                            $isFixed = $detail->salaryComponent->value_type === 'fixed';
                                            if ($isFixed) {
                                                $annualAmount = $detail->salaryComponent->annual_component_value ?? 0;
                                            } else {
                                                $annualAmount = array_sum(array_intersect_key($values, array_flip($monthData)));
                                            }
                                            break;
                                        }
                                    }
                                    if (!$isFixed) {
                                        $annualAmount = array_sum(array_intersect_key($values, array_flip($monthData)));
                                    }
                                @endphp
                                <td>{{ $currency }} {{ number_format($annualAmount, 2) }}</td>
                                @foreach($allMonths as $month)
                                    @php $showData = in_array($month, $monthData); @endphp
                                    @if($showData)
                                        <td>{{ $currency }} {{ number_format($values[$month] ?? 0, 2) }}</td>
                                    @else
                                        <td></td>
                                    @endif
                                @endforeach
                            </tr>
                        @endforeach

                        <tr class="highlight">
                            <th colspan="2">{{ __('index.total_deduction') }}</th>
                            <th>{{ $currency }} {{ number_format($totalAnnualDeduction, 2) }}</th>
                            @foreach($allMonths as $month)
                                @if(in_array($month, $monthData))
                                    <th>{{ $currency }} {{ number_format($totalMonthlyDeduction[$month], 2) }}</th>
                                @else
                                    <th></th>
                                @endif
                            @endforeach
                        </tr>
                        <tr class="highlight">
                            <th colspan="2">{{ __('index.actual_salary') }}</th>
                            <th>{{ $currency }} {{ number_format($totalAnnualIncome - $totalBonusAmount - $totalAnnualDeduction, 2) }}</th>
                            @foreach($allMonths as $month)
                                @if(in_array($month, $monthData))
                                    <th>{{ $currency }} {{ number_format($monthlyTotals[$month] - $totalMonthlyDeduction[$month] , 2) }}</th>
                                @else
                                    <th></th>
                                @endif
                            @endforeach
                        </tr>
                        <tr>
                            <td colspan="2">Tds</td>
                            <td>{{ $currency }} {{ number_format($totalTds, 2) }}</td>
                            @foreach($allMonths as $month)
                                @if(in_array($month, $monthData))
                                    <td>{{ $monthlyTDS[$month] ? $currency . ' ' . number_format($monthlyTDS[$month], 2) : '' }}</td>
                                @else
                                    <td></td>
                                @endif
                            @endforeach
                        </tr>
                        <tr class="highlight">
                            <th colspan="2">{{ __('index.total_payable') }}</th>
                            @php $annualTotalPayable = $totalAnnualIncome - $totalAnnualDeduction - $totalTds; @endphp
                            <th>{{ $currency }} {{ number_format($annualTotalPayable, 2) }}</th>
                            @foreach($allMonths as $month)
                                @if(in_array($month, $monthData))
                                    @php $monthlyTotalPayable = $monthlyTotals[$month] - $totalMonthlyDeduction[$month] - ($monthlyTDS[$month] ?? 0); @endphp
                                    <th>{{ $currency }} {{ number_format($monthlyTotalPayable, 2) }}</th>
                                @else
                                    <th></th>
                                @endif
                            @endforeach
                        </tr>
                        </tbody>
                    </table>
                </div>

                <div class="table-responsive">
                    <h5 class="text-lg-start text-center mb-4">{{ __('index.additional_information') }} <span class="text-warning text-sm-start">(This is for office use only. it doesn't fall under taxable income. )</span></h5>
                    <table class="table table-bordered mb-4">
                        <thead class="thead-dark">
                        <tr>
                            <th colspan="2">{{ __('index.particular') }}</th>
                            <th>{{ __('index.total') }}</th>
                            @foreach($allMonths as $month)
                                <th>{{ $months[$month] }}</th>
                            @endforeach
                        </tr>

                        </thead>
                        <tbody>

                        @if($reportData->total_ssf_contribution >0)
                            <tr>
                                <td></td>
                                <td>{{ __('index.ssf_contribution') }} ({{ __('index.office') }})</td>
                                <td>{{ $currency }} {{ number_format($reportData->total_ssf_contribution, 2) }}</td>
                                @foreach($allMonths as $month)
                                    @php $showData = in_array($month, $monthData); @endphp
                                    @if($showData)
                                        @php $monthlyTotals[$month] += $monthlySsfContribution[$month] ?? 0; @endphp
                                        <td>{{ $currency }} {{ number_format($monthlySsfContribution[$month] ?? 0, 2) }}</td>
                                    @else
                                        <td></td>
                                    @endif
                                @endforeach
                            </tr>
                        @endif


                        </tbody>
                    </table>

                    @php $taxableIncome = $totalAnnualIncome - $totalAnnualDeduction - $totalBonusAmount; @endphp


                    @if (isset($taxData[$reportData->employee->marital_status]))
                        <h5 class="text-lg-start text-center mb-3">{{ __('index.tax_calculation_on_taxable_income') }} ({{ ucfirst($reportData->employee->marital_status) }})</h5>
                        <table class="table table-bordered">
                            <thead class="thead-dark">
                            <tr>
                                <th>{{ __('index.from') }}</th>
                                <th>{{ __('index.to') }}</th>
                                <th>{{ __('index.income') }}</th>
                                <th>{{ __('index.percent') }}</th>
                                <th>{{ __('index.tax_amount') }}</th>
                            </tr>
                            </thead>
                            <tbody id="tax-calculation-body">
                            @php
                                $remainingIncome = $taxableIncome;
                                $totalTax = 0;
                                $isFirstBracket = true;
                            @endphp
                            @foreach($taxData[$reportData->employee->marital_status] as $bracket)
                                @php
                                    $from = $bracket->annual_salary_from;
                                    $to = $bracket->annual_salary_to >= 1.0E+20 ? null : $bracket->annual_salary_to;
                                    $percent = $bracket->tds_in_percent;
                                    $bracketIncome = min(max($remainingIncome, 0), $to ? $to - $from : $remainingIncome);
                                    $taxAmount = $bracketIncome * ($percent / 100);
                                    if ($isFirstBracket && $reportData->total_ssf_deduction > 0) {
                                        $taxAmount = 0;
                                    }
                                    $totalTax += $taxAmount;
                                    $remainingIncome -= $bracketIncome;
                                    $isFirstBracket = false;
                                @endphp
                                <tr>
                                    <td>{{ $currency }} {{ number_format($from, 2) }}</td>
                                    <td>{{ $to ? $currency . ' ' . number_format($to, 2) : '' }}</td>
                                    <td>{{ $currency }} {{ number_format($bracketIncome, 2) }}</td>
                                    <td>{{ number_format($percent, 2) }}%</td>
                                    <td>{{ $currency }} {{ number_format($taxAmount, 2) }}</td>
                                </tr>
                            @endforeach

                            <tr class="highlight">
                                <td>{{ __('index.total') }}</td>
                                <td></td>
                                <td>{{ $currency }} {{ number_format($taxableIncome, 2) }}</td>
                                <td></td>
                                <td>{{ $currency }} {{ number_format($totalTax, 2) }}</td>
                            </tr>
                            @php

                                $totalTax += $totalBonusTax;
                                $taxDeduction = ($reportData->medical_claim ?? 0) + ($reportData->female_discount ?? 0) + ($reportData->other_discount ?? 0);
                            @endphp
                            <tr>
                                <td>{{ __('index.less_tax_deduction') }}</td>
                                <td>{{ __('index.medical_claim') }}</td>
                                <td></td>
                                <td></td>
                                <td>{{ $currency }} {{ number_format($reportData->medical_claim ?? 0, 2) }}</td>
                            </tr>
                            <tr>
                                <td></td>
                                <td>{{ __('index.female_discount') }}</td>
                                <td></td>
                                <td></td>
                                <td>{{ $currency }} {{ number_format($reportData->female_discount ?? 0, 2) }}</td>
                            </tr>
                            <tr>
                                <td></td>
                                <td>{{ __('index.other_discount') }}</td>
                                <td></td>
                                <td></td>
                                <td>{{ $currency }} {{ number_format($reportData->other_discount ?? 0, 2) }}</td>
                            </tr>
                            <tr>
                                <td>{{ __('index.total_payable_tds') }} (* with bonus tax)</td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td>{{ $currency }} {{ number_format($totalTax - $taxDeduction, 2) }}</td>
                            </tr>
                            <tr>
                                <td>{{ __('index.total_paid_tds') }}</td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td>{{ $currency }} {{ number_format($reportData->total_paid_tds ?? 0, 2) }}</td>
                            </tr>
                            <tr>
                                <td>{{ __('index.total_due_tds') }}</td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td id="dueTds">{{ $currency }} {{ number_format(($totalTax - $taxDeduction - ($reportData->total_paid_tds ?? 0)), 2) }}</td>
                            </tr>
                            </tbody>
                        </table>
                    @else
                        <p class="text-center">{{ __('index.tax_data_not_available') }} ({{ $reportData->employee->name }}).</p>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection


